function save_as_shipping_confirm(){
    if(!confirm(JS_CONFIRM_SAVE_AS_SHIPPING)){
        return false;
    }
    var total_sas_items = $('input[name="source_item_action[]"]:checked').length;
    if(total_sas_items < 1){
        return false;
    }
    $('#save_as_shipping_status_msg').remove();

    var sas_output_div = $('<div id="save_as_shipping_status_msg"><div id="process_status">Processing <span id="processing_current">1</span>/'+total_sas_items+'</div><div id="processing_current_status" style="font-size: 0.8em; color: #666;margin-top: 10px;"></div>');
    sas_output_div.dialog({
        title: 'Status',
        width: 'auto',
        height: 'auto',
        modal:true,
    });
    var sas_current_item_id = $('input[name="source_item_action[]"]:checked').first().val();
    save_as_shipping_stepwise(sas_current_item_id);
}

function remove_manual_weight( elm ){
    $(elm).parent().find('.weight_order_overwrite_link').css('text-decoration','underline');
    $(elm).parent().find('input#weight').remove();
    $(elm).parent().find('a#remove_manual_weight').remove();
}

$(function(){
    var select_weight_html = '<input id="weight" name="weight" size="8" maxlength="8" value="0" />'
    +'<a href="javascript:;" onclick="remove_manual_weight(this);" id="remove_manual_weight"><img  style="margin-left: 5px;margin-right: 5px;display: inline-block;" src="images/icons/cross.gif" border="0" title="Manuelle Eingabe verwerfen" /></a>';
    $('button.set_action, button.unset_action').css('cursor','pointer');
    $('.weight_order_overwrite_link').each(function(){
        $(this).on('click',function(){
            let default_weight = $(this).text();
            $(this).parent().find('input#weight').remove();
            $(this).parent().find('a#remove_manual_weight').remove();
            $(this).css('text-decoration','line-through');
            $(this).after(select_weight_html);
            $(this).parent().find('input#weight').val(default_weight).focus();
        });
    });
    $('table#shipping_items_table tbody tr td .full_address').each(function(){
       $(this).hide();
    });

    $('#shipping_item_order_pm').each(function(){
        if($(this).text() == 'Rechnung'){
            $(this).css('color','red');
        }
    });

    // MUSS BEI AJAX ADDRESS UPDATE IN DER orders_edit.php AUCH NOCHMAL
    // AUFGERUFEN WERDEN, DAMIT SICH DIE tooltips AKTUALISIEREN
    $( document ).tooltip({
      items: ".short_address",
      content: function() {
        var element = $( this );
        return element.next('.full_address').html();
      }
    });    
    $('input#save_as_shipping').each(function(){
        var source_id = $(this).data('source_id');
        var trSelector = 'table#shipping_items_table tbody tr.products[data-source_id="'+source_id+'"]';
        var thisButton = $(this);
        $(trSelector+' td .product .quantity').each(function(){
            if($(this).data('quantity_shipped') > 0 || $(this).data('in_shipping_quantity') > 0){
                thisButton.hide();
            }
        });
        $(this).on('click',function(){
            save_delivery(source_id,true);
        });
    });
    $('input#configure_part_delivery_button').each(function(){
        var source_id = $(this).data('source_id');
        var trSelector = 'table#shipping_items_table tbody tr.products[data-source_id="'+source_id+'"]';
        $(this).on('click',function(){
            
            //BOF neu
            var checkups = false;
            var params = '';
            switch($('tr[data-source_id="'+source_id+'"] select[name="shipper"]').val()){
                case 'DHL':
                    params += $('tr[data-source_id="'+source_id+'"] .additional_shipper_params').find('select, input').serialize();
                    if($('tr[data-source_id="'+source_id+'"]').find('input[id="weight"]').length==1){
                        var manual_weight = $('tr[data-source_id="'+source_id+'"]').find('input[id="weight"]').val();
                        manual_weight_float = parseFloat( manual_weight.replace(',','.'));
                        params += '&weight='+parseInt(manual_weight_float*1000);
                    }
                    checkups = true;
                    break;
            }
            var _oid = null;
            if(source_id.indexOf('orders_') > -1){
                checkups = true;
            }

            if(checkups){
                var dlg_title = $(this).val();
                let check_url = 'shipping.php?action=validate&id='+source_id;
                if(params != ''){
                    check_url += '&'+params;
                }
                //showPreloader();
                $.ajax({
                    url: check_url,
                    dataType: 'json',
                    success: function(json){
                        //hidePreloader();
                        $('tr[data-source_id="'+source_id+'"] .DHL_response_error').remove();
                        if(json.ACK=='Success'){
                            if(json.MSG_TITLE != ''){
                                let _ttle = stripHTML(json.MSG_TITLE);
                                let _msg = stripHTML(json.MSG);
                                alert(_ttle+"\n\n"+_msg);
                            }
                            part_delivery_dialog(dlg_title,source_id, trSelector);
                        }else{
                            if( json.type == 'DHL'){
                                alert(json.MSG_TITLE+' Error');
                                $('tr[data-source_id="'+source_id+'"] .additional_shipper_params').before(
                                    '<div class="DHL_response_error main"><img width="25" height="25" style="margin: 5px;" src="images/icons/warning.gif" align="left" />'+json.MSG+'</div>'
                                );
                            }else{
                                if(json.MSG != ''){
                                    let alertMSG = json.MSG;
                                    if(typeof(json.MSG_TITLE) != 'undefined'){
                                        alertMSG = json.MSG_TITLE+"\n"+alertMSG;
                                    }
                                    alert(alertMSG);
                                }
                            }
                            $('#save_as_shipping_status_msg').dialog('destroy');
                            return false;
                        }
                    },
                    error: function(xhr){
                        //hidePreloader();
                        $('#save_as_shipping_status_msg').dialog('destroy');
                        alert('Validation Request Error');
                    }
                });
            }else{
                part_delivery_dialog($(this).val(),source_id, trSelector);
            }
            //EOF neu
            
            
            
            
        /*    
            var _oid = null;
            if(source_id.indexOf('orders_') > -1){
                _oid = source_id.replace('orders_','');
            }
            if(_oid !== null){
                var dlg_title = $(this).val();
                showPreloader();
                $.ajax({
                    url: 'shipping.php?action=check_ebay_transaction_status&orders_id='+_oid,
                    dataType: 'json',
                    success: function(json){
                        hidePreloader();
                        if(json.ACK=='Success'){
                            part_delivery_dialog(dlg_title,source_id, trSelector);
                        }else{
                            $('#modal_window').dialog({
                                title: json.TITLE,
                                width: 'auto',
                                height: 'auto',
                                modal: true,
                            }).html('<div class="main">'+json.MSG+'</div>');
                            return false;
                        }
                    },
                    error: function(xhr){
                        hidePreloader();
                        alert('Cant check ebay transaction status for order '+source_id);
                    }
                });
            }else{
                part_delivery_dialog($(this).val(),source_id, trSelector);
            }
                */
        });
        
    });
    
    $('a#storage_filter_button').on('click',function(){
        var dlg_title = $(this).children('button').text();
        $('#modal_window').dialog({
            title: dlg_title,
            width: 'auto',
            height: 'auto',
            modal: true
        }).html(create_filter_div({
            'title': dlg_title,
            'select_name': 'storage_filter',
            'select_values': STORAGES_ARRAY,
            'select_default': STORAGE_FILTER
        }));
    });
    $('a#order_source_filter_button').on('click',function(){
        var dlg_title = $(this).children('button').text();
        $('#modal_window').dialog({
            title: dlg_title,
            width: 'auto',
            height: 'auto',
            modal: true
        }).html(create_filter_div({
            'title': dlg_title,
            'select_name': 'order_source_filter',
            'select_values': ORDER_SOURCES,
            'select_default': ORDER_SOURCE_FILTER
        }));
    });
    $('a#payment_method_filter_button').on('click',function(){
        var dlg_title = $(this).children('button').text();
        $('#modal_window').dialog({
            title: dlg_title,
            width: 'auto',
            height: 'auto',
            modal: true
        }).html(create_filter_div({
            'title': dlg_title,
            'select_name': 'payment_method_filter',
            'select_values': PAYMENT_METHODS,
            'select_default': PAYMENT_METHOD_FILTER
        }));
    });
    $('a#shipping_class_filter_button').on('click',function(){
        var dlg_title = $(this).children('button').text();
        $('#modal_window').dialog({
            title: dlg_title,
            width: 'auto',
            height: 'auto',
            modal: true
        }).html(create_filter_div({
            'title': dlg_title,
            'select_name': 'shipping_class_filter',
            'select_values': SHIPPING_CLASSES,
            'select_default': SHIPPING_CLASS_FILTER
        }));
    });
    $('a#customers_status_filter_button').on('click',function(){
        var dlg_title = $(this).children('button').text();
        $('#modal_window').dialog({
            title: dlg_title,
            width: 'auto',
            height: 'auto',
            modal: true
        }).html(create_filter_div({
            'title': dlg_title,
            'checkbox_name': 'customers_status',
            'checkbox_values': CUSTOMER_STATUSES,
            'checkbox_default': CUSTOMER_STATUS_FILTER
        }));
    });
    $('a#default_products_shipper_filter_button').on('click',function(){
        var dlg_title = $(this).children('button').text();
        $('#modal_window').dialog({
            title: dlg_title,
            width: 'auto',
            height: 'auto',
            modal: true
        }).html(create_filter_div({
            'title': dlg_title,
            'select_name': 'default_products_shipper',
            'select_values': VERSENDER_VALUES,
            'select_default': VERSENDER_FILTER
        }));
    });
    $('a#orders_not_de').on('click',function(){
        if($(this).children('button').hasClass('selected')){
            window.location.href='shipping.php';
            return true;
        }
        window.location.href='shipping.php?orders_not_de=1';
    });
    $('a#part_delivery_filter_button').on('click',function(){
        if($(this).children('button').hasClass('selected')){
            window.location.href='shipping.php';
            return true;
        }
        window.location.href='shipping.php?has_part_delivery=1';
    });

    $('a#sperrgut').on('click',function(){
        if($(this).children('button').hasClass('selected')){
            window.location.href='shipping.php';
            return true;
        }
        window.location.href='shipping.php?sperrgut=1';
    });


    $('table#shipping_items_table tr.source_details td.source_id #source_comments_icon').each(function(){
       $(this).on('click',function(){
           var src_id = $(this).closest('tr').data('source_id');
           var comment = $('table#shipping_items_table tr.source_details[data-source_id="'+src_id+'"] td.source_id .source_comments').text();
           var comment_input = '<textarea tabindex="1" class="shipping_comments" name="shipping_comments" autofocus="autofocus">'+comment+'</textarea>';
           $('#modal_window').dialog({
               modal: true,
               width: 'auto',
               height: 'auto',
               title: $(this).attr('title'),
           }).html( '<div class="main">'+comment_input+'<br /><input type="button" onClick="update_shipping_comments(\''+src_id+'\')" value="'+TEXT_UPDATE+'" class="ui-button ui-corner-all ui-state-default" /></div>' );
       });
    });
    $('table#shipping_items_table tr.source_details td.source_id a.unset_rueckstand').each(function(){
        $(this).on('click',function(){
            alert($(this).attr('id'));
        });
    });
    
    $('table#shipping_items_table tr.source_details td.source_id #source_actions button').each(function(){
        $(this).on('click',function(){
            switch($(this).attr('id')){
                case 'set_rueckstand':
                case 'unset_rueckstand':
                case 'unset_block_shipping':
                    if(!confirm($(this).attr('title')+'?')){
                        return false;
                    }
                    window.location.href = $(this).data('json_link')+'&referrer='+encodeURIComponent(window.location);
                    break;
                case 'set_block_shipping':
/* REKLA SELBES HANDLING - 2022/01/19
//                    if(SOURCE.indexOf('recla')>-1){
//                        if(!confirm($(this).attr('title')+'?')){
//                            return false;
//                        }
//                        window.location.href = $(this).data('json_link')+'&referrer='+encodeURIComponent(window.location);
//                        return true;
//                    }
*/
                    var dlg_title = $(this).attr('title');
                    $('#modal_window').dialog({
                        modal: true,
                        width: 'auto',
                        height: 'auto',
                        title: dlg_title,
                    }).load($(this).data('json_link'),function(){
                        $('form[name="set_block_shipping_confirm"]').append('<input type="hidden" name="referrer" value="'+encodeURIComponent(window.location)+'" />');
                    });
                    break;
            }
        });
    });
    $('button#delete_shipping').each(function(){
        $(this).on('click',function(){
            if(confirm($(this).attr('title')+'?')){
                var url_delete_shipping = 'shipping.php?'+getBaseURLWithNewParams({
                    'key': 'action',
                    'value': 'delete_shipping',
                    'exclude': 'id'
                })+'&id='+$(this).data('shippings_id');
                window.location.href = url_delete_shipping;
            }
        });
    });
    $('select[id="filter_shipper"]').on('change',function(){
        var url_filter_shipper = 'shipping.php?'+getBaseURLWithNewParams({
            'key': 'shipper',
            'value': $(this).val(),
        });
        window.location.href = url_filter_shipper;
    });
    
    $('table#shipping_items_table tbody td .substring').each(function(){
        let substr_length = $(this).data('length');
        let substr_text = $(this).text();
        if(substr_text.length > substr_length){
            $(this).attr('title',substr_text);
            substr_text = substr_text.substring(0,substr_length)+'...';
            $(this).text(substr_text);
        }
    });
    
    $('table#shipping_items_table tr.source_details td.source_id #errors').each(function(){
        var number_of_errors = $(this).children('li').length;
        var err_show_hide_link_text_show = (number_of_errors-1)+' weitere Fehler';
        var err_show_hide_link_text_hide = (number_of_errors-1)+' Fehler ausblenden';
        if(number_of_errors > 1){
            var err_show_hide_link = $('<div class="showMoreErrors" id="showhideerrors">'+err_show_hide_link_text_show+'</div>');
            
            $(this).append(err_show_hide_link);
        }
        var li_counter = 0;
        $(this).children('li').each(function(){
            if(li_counter > 0){
                $(this).toggle();
            }
            li_counter++;
        });
        if(number_of_errors > 1){
            $(this).on('click',function(){
                var li_counter2 = 0;
                $(this).children('li').each(function(){
                    if(li_counter2 > 0){
                        $(this).toggle();
                    }
                    li_counter2++;
                });
                if($(this).children('li').last().is(':visible')){
                    err_show_hide_link.text(err_show_hide_link_text_hide).addClass('hideMoreErrors').removeClass('showMoreErrors');
                }else{
                    err_show_hide_link.text(err_show_hide_link_text_show).removeClass('hideMoreErrors').addClass('showMoreErrors');
                }
            }).css('cursor','pointer');
        }
    });
    $('#page_menu_main_title a').removeAttr('style').css({'color':'#666','text-decoration':'none'});
    $('.properties_container .property').each(function(){
        if($(this).html() == ''){
            $(this).html('<span style="color: #666;">-</span>');
        }
    });
    $('a.select_all_source_items').each(function(){
        $(this).on('click',function(){
            $('input[name="source_item_action[]"]').prop('checked',true);
        });
    });
    $('a.unselect_all_source_items').each(function(){
        $(this).on('click',function(){
            $('input[name="source_item_action[]"]').prop('checked',false);
        });
    });
    $('select[name="items_action"]').each(function(){
        var sas_btn = $(this);
        $(this).on('change',function(){
            if($(this).val() == ''){
                $(this).val('');
                return false;
            }
            if(!$('input[name="source_item_action[]"]:checked').length){
                $(this).val('');
                return false;
            }
            switch($(this).val()){
                // im Versandabschluss
                case 'remove_from_shipping':
                    if(!confirm(JS_CONFIRM_DELETE_PACKAGES)){
                        $(this).val('');
                        return false;
                    }
                    $('input[name="source_item_action[]"]:checked').each(function(){
                        var shippings_id = $(this).val();
                        var url_delete_shipping = 'shipping.php?'+getBaseURLWithNewParams({
                            'key': 'action',
                            'value': 'delete_shipping',
                            'exclude': 'id'
                        })+'&id='+shippings_id+'&json=1';
                        $.ajax({
                            url: url_delete_shipping,
                            dataType: 'json',
                            success: function(json){
                                if(json.MSG != ''){
                                    alert(json.MSG);
                                    return false;
                                }
                                $('table#shipping_items_table tbody tr[data-source_id="'+shippings_id+'"]').remove();
                            },
                            error: function(xhr){
                                alert('Error: Cant delete shipping');
                            }
                        });
                    });
                    break;
                case 'unset_rueckstand':
                    var IDs = [];
                    $('input[name="source_item_action[]"]').each(function(){
                        if($(this).prop('checked') == true){
                            IDs.push(parseInt($(this).val().replace('rueckstand_','')));
                        }
                    });
                    if(IDs.length>0){
                        if(confirm(JS_CONFIRM_REALLY_UNSET_ARREAR)){
                            var url = 'shipping.php?action=unset_rueckstand&id[]='+IDs.join('&id[]=');
                            window.location.href=url;
                        }
                    }
                    return false;
                    break;
                case 'unblock_orders':
                    var IDs = [];
                    $('input[name="source_item_action[]"]').each(function(){
                        if($(this).prop('checked') == true){
                            IDs.push(parseInt($(this).val().replace('block_orders_','')));
                        }
                    });
                    if(IDs.length>0){
                        if(confirm(TEXT_VERSANDSPERRE_UNSET)){
                            var url = 'orders.php?action=set_unblock_shipping&referrer='+encodeURIComponent(window.location)+'&id[]='+IDs.join('&id[]=');
                            window.location.href=url;
                        }
                    }
                    return false;
                    break;
                case 'save_as_shipping':
                    save_as_shipping_confirm();
                    break;
                default:
                    if( $(this).val().indexOf('select:')>-1 ){
                        var shipper_parts = $(this).val().split('select:');
                        var shipper = shipper_parts[1];
                        var selectbox = $(this);
                        $('table#shipping_items_table tbody tr.products td.pakete select[name="shipper"]').each(function(){
                            $(this).val(shipper);
                            var source_id = $(this).parent().parent().parent().data('source_id');
                            var insert_into_div = $(this).parent().find('.additional_shipper_params');
                            load_additional_params_into_div(source_id, shipper, insert_into_div);
                        });
                        selectbox.val('');
                    }
                    break;
            }
        });
    });
    $('.additional_shipper_params').each(function(){
        var insert_into_div = $(this);
        var shipper = $(this).parent().find('select[name="shipper"]').val();
        var source_id = $(this).parent().parent().parent().data('source_id');
        // wird beim aufruf der seite abgearbeitet
        load_additional_params_into_div(source_id, shipper, insert_into_div);
    });
    
    $('select[name="shipper"]').each(function(){
        $(this).on('change',function(){
            var shipper = $(this).val();
            var source_id = $(this).parent().parent().parent().data('source_id');
            var insert_into_div = $(this).parent().find('.additional_shipper_params');
            load_additional_params_into_div(source_id, shipper, insert_into_div);
        });
    });
    
    $('a#shipping_address_edit').each(function(){
        $(this).on('click',function(){
            if($(this).data('orders_id') > 0){
                var _orders_id = $(this).data('orders_id');
                var _editlink = 'orders_edit.php?oID='+_orders_id+'&tab=info&action=ajax_address_edit&address_type=shipping&shipping_v2=1';
                var _title = _orders_id;
            }else{
                var _reclam_id = $(this).data('reclamations_id');
                var _editlink = 'reclamations.php?rID='+_reclam_id+'&action=ajax_address_edit&address_type=shipping&shipping_v2=1';
                var _title = 'R '+_reclam_id;
            }
            $('#modal_window').dialog({
                modal: true,
                width: 'auto',
                height: 'auto',
                title: $(this).attr('title')+' '+_title,
            }).load(_editlink);
        });
    });
    $('#import_easylog_file').click(function(){
            $('#easylog_import_container').show();
    });
    $('#import_gls_file').click(function(){
            $('#gls_import_container').show();
    });
    $('#import_ups_file').click(function(){
            $('#ups_import_container').show();
    });
    $('#import_dpd_file').click(function(){
            $('#dpd_import_container').show();
    });
    $('#import_hermesweb_file').click(function(){
            $('#hermesweb_import_container').show();
    });
    var customers_doubles = [];
    var diff_customers = [];
    $('table#shipping_items_table tbody tr.source_details').each(function(){
        var dc = 'C'+$(this).data('customers_id');
        if(diff_customers.indexOf( dc ) == -1){
                diff_customers.push( dc );
                customers_doubles[ dc ] = 0;
        }else{
                customers_doubles[ dc ]++;
        }
    });
    var double_cid_html = '';
    var double_counter = 0;
    for(double_cID in customers_doubles){
            if(customers_doubles[double_cID] == 0){
                    continue;
            }
            double_cid_html += '<div class="double_cid_id" id="'+double_cID.substring(1)+'"><a href="orders.php?cID='+double_cID.substring(1)+'" target="_blank">cID '+double_cID.substring(1)+'</a></div> <div class="double_cid_num">'+(customers_doubles[double_cID]+1)+CUSTOMER_DOUBLES_IN_SHIPPING_LIST_ITEM_TEXT+'</div><br clear="all" />';
            double_counter++;
    }
    if(double_cid_html != ''){
            $('table#shipping_items_table').before('<br /><img src="images/basicons/info22.png" align="left" class="toggle_double_cid" border="0" width="20" height="20" /><b>'+double_counter+CUSTOMER_DOUBLES_IN_SHIPPING_LIST_HEADER+'</b><br clear="all" /><div class="double_cid">'+double_cid_html+'</div>');
            $('img.toggle_double_cid').css('cursor','pointer').on('click',function(){
                    $('.double_cid').toggle();
            });
    }
});

function load_additional_params_into_div(source_id, shipper, insert_into_div){
        var url_configure_versender = 'shipping.php?'+getBaseURLWithNewParams({
            'key': 'action',
            'value': 'configure_versender'
        })+'&source_id='+source_id+'&shipper='+shipper+'&display=inline';
        $.ajax({
            url: url_configure_versender,
            success: function(html){
                if(html != ''){
                    insert_into_div.show();
                }else{
                    insert_into_div.hide();
                }
                insert_into_div.html(html);
                if(typeof insert_into_div.data('profile') == 'string'){
                    DHL_load_additional_params( insert_into_div, insert_into_div.data('profile'),source_id );
                }else{
                    DHL_load_additional_params( insert_into_div,'',source_id );
                }
            },
            error: function( xhr ){
                alert('Cant load additional params '+source_id+', '+shipper+', '+insert_into_div);
            }
        });
}

function update_shipping_comments(source_id){
    var comments = $('textarea[name="shipping_comments"]').val();
    var update_url = 'orders.php?action=set_shipping_comments&orders_id='+source_id+'&shipping_comments='+encodeURIComponent(comments);
    if(SOURCE.indexOf('recla')>-1){
        update_url = 'reclamations.php?action=set_shipping_comments&reclamations_id='+source_id+'&shipping_comments='+encodeURIComponent(comments);
    }
    $.ajax({
        url: update_url,
        success: function(response){
            $('table#shipping_items_table tr.source_details[data-source_id="'+source_id+'"] td.source_id .source_comments').html(response);
            $('#modal_window').dialog('destroy');
        },
        error: function(xhr){
            alert('Error: Cant update shipping comment');
        }
    })
}

function getBaseURLWithNewParams(params){
    const queryString = window.location.search;
    const urlParams = new URLSearchParams(queryString);
    var target_params = new Array();
    for(const prm of urlParams.entries()){
        if(prm[0] != params.key){
            if(params.hasOwnProperty('exclude') === false || params.exclude != prm[0]){
                target_params.push(prm[0]+'='+encodeURIComponent(prm[1]));
            }
        }
    }
    if(params.value !== null){
        var isarray_var = params.value;
        if(isarray_var.prop && isarray_var.prop.constructor === Array){
            for(i in params.value){
                target_params.push(params.key+'='+encodeURIComponent(params.value[i]));
            }
        }else{
            target_params.push(params.key+'='+encodeURIComponent(params.value));
        }
    }
    return target_params.join('&');
}

function save_part_delivery(source_id){
    var trSelector = 'table#shipping_items_table tbody tr.products[data-source_id="'+source_id+'"]';
    var get_params = new Array();
    get_params.push('source_id='+source_id);
    get_params.push('shipper='+$(trSelector+' fieldset select[name="shipper"]').val());
    get_params.push('anzahl_pakete='+$(trSelector+' fieldset input[name="anzahl_pakete"]').val());
    // DIE NORMALE WEIGHT EINGABE BEI WEIGHT_FROM_ORDER false
    if($('#configure_part_delivery input[name="weight"]').length > 0){
        var manual_weight = $('#configure_part_delivery input[name="weight"]').val();
        manual_weight_float = parseFloat( manual_weight.replace(',','.'));
        if(isNaN(manual_weight_float) || manual_weight_float < 0.01){
            alert('Invalid weight: '+manual_weight);
            return false;
        }
        get_params.push('weight='+parseFloat(manual_weight_float*10));
    }
    $(trSelector+' td .product').each(function(){
        get_params.push('qty['+$(this).data('id')+']='+$('select[name="qty['+$(this).data('id')+']"').val());
    });
    var _dhl_params = '';
    switch($('tr[data-source_id="'+source_id+'"] select[name="shipper"]').val()){
        case 'DHL':
            _dhl_params += '&'+$('tr[data-source_id="'+source_id+'"] .additional_shipper_params').find('select,input').serialize();
            /* DOPPELT - WIRD WEITER OBEN SCHON ABGEFANGEN
            if($('tr[data-source_id="'+source_id+'"]').find('input[id="weight"]').length==1){
                var manual_weight = $('tr[data-source_id="'+source_id+'"]').find('input[id="weight"]').val();
                manual_weight_float = parseFloat( manual_weight.replace(',','.'));
                _dhl_params += '&weight='+(manual_weight_float*10);
            }*/
            break;
        default:
            $(trSelector+' td.pakete .additional_shipper_params ul li select').each(function(){
                get_params.push($(this).attr('name')+'='+$(this).val());
            });
            break;
    }
    var url_save_part_delivery = 'shipping.php?'+getBaseURLWithNewParams({
        'key': 'action',
        'value': 'json_add_part_delivery'
    })+'&'+get_params.join('&')+_dhl_params;
    $.ajax({
        url: url_save_part_delivery,
        dataType: 'json',
        success: function(json){
            if(json.MSG){
                alert(json.MSG);
                return false;
            }
            window.location.href=BASEURL;
        },
        error: function(xhr){
            alert('Error: cant json add part delivery');
        }
    });
    $('#configure_part_delivery').dialog('destroy');
}
function stripHTML(str){
    str = str.replace('<br>',"\n");
    str = str.replace('<br />',"\n");
    return str.replace(/(<([^>]+)>)/gi, "");
}
function save_delivery(source_id, do_redirect){
    let errors = check_valid_parameter(source_id);
    if(errors != ''){
        alert(errors);
        $('#save_as_shipping_status_msg').dialog('destroy');
        return false;
    }
    var checkups = false;
    var params = '';
    switch($('tr[data-source_id="'+source_id+'"] select[name="shipper"]').val()){
        case 'DHL':
            params += $('tr[data-source_id="'+source_id+'"] .additional_shipper_params').find('select, input').serialize();
            if($('tr[data-source_id="'+source_id+'"]').find('input[id="weight"]').length==1){
                var manual_weight = $('tr[data-source_id="'+source_id+'"]').find('input[id="weight"]').val();
                manual_weight_float = parseFloat( manual_weight.replace(',','.'));
                if(isNaN(manual_weight_float) || manual_weight_float < 0.01){
                    alert('Invalid weight: '+$('tr[data-source_id="'+source_id+'"]').find('input[id="weight"]').val());
                    return false;
                }
                params += '&weight='+parseInt(manual_weight_float*1000);
            }
            checkups = true;
            break;
    }
    if(SOURCE == 'orders'){
        checkups = true;
    }
    if(checkups){
        let check_url = 'shipping.php?action=validate&id='+source_id;
        if(params != ''){
            check_url += '&'+params;
        }
        //showPreloader();
        $.ajax({
            url: check_url,
            dataType: 'json',
            success: function(json){
                //hidePreloader();
                $('tr[data-source_id="'+source_id+'"] .DHL_response_error').remove();
                if(json.ACK=='Success'){
                    if(json.MSG_TITLE != ''){
                        let _ttle = stripHTML(json.MSG_TITLE);
                        let _msg = stripHTML(json.MSG);
                        alert(_ttle+"\n\n"+_msg);
                    }
                    $('tr[data-source_id="'+source_id+'"]').hide();
                    save_delivery_process(source_id, do_redirect);
                }else{
                    if( json.type == 'DHL'){
                        alert(json.MSG_TITLE+' Error');
                        $('tr[data-source_id="'+source_id+'"] .additional_shipper_params').before(
                            '<div class="DHL_response_error main"><img width="25" height="25" style="margin: 5px;" src="images/icons/warning.gif" align="left" />'+json.MSG+'</div>'
                        );
                    }else{
                        if(json.MSG != ''){
                            let alertMSG = json.MSG;
                            if(typeof(json.MSG_TITLE) != 'undefined'){
                                alertMSG = json.MSG_TITLE+"\n"+alertMSG;
                            }
                            alert(alertMSG);
                        }
                    }
                    $('#save_as_shipping_status_msg').dialog('destroy');
                    return false;
                }
            },
            error: function(xhr){
                //hidePreloader();
                $('#save_as_shipping_status_msg').dialog('destroy');
            }
        });
    }else{
        save_delivery_process(source_id, do_redirect);
    }
}

function check_valid_parameter(source_id){
    var trSelector = 'table#shipping_items_table tbody tr.products[data-source_id="'+source_id+'"]';
    let _shipper = $(trSelector+' fieldset select[name="shipper"]').val();
    let WARNMELDUNG_PREFIX = "Fehlende Parameter, bitte korrigieren Sie die Angaben:\r\n";
    if( _shipper == 'undefined' || _shipper == ''){
        return WARNMELDUNG_PREFIX+'Shipper: '+_shipper+' ('+source_id+')';
    }
    if( SOURCE == 'undefined' || SOURCE == ''){
        return WARNMELDUNG_PREFIX+'Source: '+SOURCE+' ('+source_id+')';
    }
    let _anz_pakete = $(trSelector+' fieldset input[name="anzahl_pakete"]').val();
    if( _anz_pakete == 'undefined' || _anz_pakete < 1){
        return WARNMELDUNG_PREFIX+'Anz. Pakete: '+_anz_pakete+' ('+source_id+')';
    }
    
    let _weight = $(trSelector+' fieldset select[name="weight"]').val();
    if( _weight == 'undefined' || _weight < 0.001){
        return WARNMELDUNG_PREFIX+'Gewicht: '+_weight+' ('+source_id+')';
    }
    return '';
}

function save_delivery_process(source_id, do_redirect){
    var trSelector = 'table#shipping_items_table tbody tr.products[data-source_id="'+source_id+'"]';
    var get_params = new Array();
    get_params.push('source_id='+source_id);
    let _shipper = $(trSelector).find('select[name="shipper"]').val();
    get_params.push('shipper='+_shipper);
    get_params.push('source='+SOURCE);
    let _anz_pakete = $(trSelector+' fieldset input[name="anzahl_pakete"]').val();
    get_params.push('anzahl_pakete='+_anz_pakete);
    
    let _sel_weight = $(trSelector+' fieldset select[name="weight"]').val();
    if(typeof _sel_weight != 'undefined'){
        get_params.push('weight='+_sel_weight);
    }
    let _weight = $(trSelector+' fieldset input[name="weight"]').val();
    if(typeof _weight != 'undefined'){
        manual_weight_float = parseFloat( _weight.replace(',','.'));
        get_params.push('weight='+manual_weight_float*10);
    }
    $(trSelector).find('.additional_shipper_params select').each(function(){
        if($(this).val() != ''){
            get_params.push($(this).attr('name')+'='+encodeURIComponent($(this).val()));
        }
    });
    $(trSelector).find('.additional_shipper_params input').each(function(){
        var submit_item = false;
        switch($(this).attr('type')){
            case 'checkbox':
                let _chk = $(this).is(':checked');
                if(_chk === true){
                    get_params.push($(this).attr('name')+'='+encodeURIComponent($(this).val()));
                }
                break;
            case 'number':
                if($(this).val() > 0){
                    get_params.push($(this).attr('name')+'='+encodeURIComponent($(this).val()));
                }
                break;
            case 'date':
            case 'text':
            case 'hidden':
                if($(this).val() != ''){
                    get_params.push($(this).attr('name')+'='+encodeURIComponent($(this).val()));
                }
                break;
        }
    });
    
    var url_save_delivery = 'shipping.php?'+getBaseURLWithNewParams({
        'key': 'action',
        'value': 'json_add_delivery'
    })+'&'+get_params.join('&');
    $.ajax({
        url: url_save_delivery,
        dataType: 'json',
        success: function(json){
            if(json.MSG){
                alert(json.MSG);
                return false;
            }
            
            let versandabschluss_title = $('#page_menu_main_title a').text();
            var regExp = /\(([^)]+)\)/;
            var matches = regExp.exec(versandabschluss_title);
            $('#page_menu_main_title a').text( versandabschluss_title.replace('('+matches[1]+')','('+(parseInt(matches[1])+1)+')') );
            
            if(do_redirect){
                window.location.href=BASEURL;
            }else{
                // Multiaction
                $('table#shipping_items_table tbody tr[data-source_id="'+source_id+'"]').remove();
                if($('input[name="source_item_action[]"]:checked').length > 0){
                    var sas_current_item_id = $('input[name="source_item_action[]"]:checked').first().val();
                    save_as_shipping_stepwise(sas_current_item_id);
                }else{
                    $('#processing_current_status').html('Done!');
                    $('#save_as_shipping_status_msg').dialog('destroy');
                }
            }
        },
        error: function(xhr){
            alert('Error: cant json add delivery');
        }
    });
}
function filter_redirect(filter_var, action){
    if($('#filter_div select[name="'+filter_var+'"]').length){
        if(action == 'reset'){
            var filter_value = null;
        }else{
            var filter_value = $('#filter_div select[name="'+filter_var+'"]').val();
        }
    }else{
        filter_var += '[]';
        if(action == 'reset'){
            var filter_value = null;
        }else{
            var filter_value = new Array();
            // checkboxen
            $('#filter_div input[name="'+filter_var+'"]:checked').each(function(){
               filter_value.push($(this).val());
            });
        }
    }
    window.location.href='shipping.php?'+getBaseURLWithNewParams({
        'key': filter_var,
        'value': filter_value,
        'exclude': 'page'
    });
}
function create_filter_div(params){
    var filter_div = $('<div id="filter_div" class="main"><b>'+params.title+'</b></div>');
    var buttons_name = '';
    if(params.hasOwnProperty('select_name')){
        buttons_name += params.select_name;
        var filter_select = $('<select name="'+params.select_name+'"></select>');
        for(i in params.select_values){
            var opt = document.createElement('option');
            opt.value = params.select_values[i].id;
            opt.innerHTML = params.select_values[i].text;
            if(opt.value == params.select_default){
                opt.selected = true;
            }
            filter_select.append(opt);    
        }
        filter_div.append(filter_select);
    }else{
        buttons_name += params.checkbox_name;
        filter_div.append('<br />');
        for(i in params.checkbox_values){
            var chcked = false;
            for(j in params.checkbox_default){
                if(params.checkbox_default[j] == params.checkbox_values[i].id){
                    chcked = true;
                }
            }
            filter_div.append('<input type="checkbox" name="'+params.checkbox_name+'[]" value="'+params.checkbox_values[i].id+'" '+((chcked === true)?'checked="checked"':'')+'/>&nbsp;'+params.checkbox_values[i].text+'<br />');
        }
    }
    var submit_button = '<input style="margin-top: 10px;" type="button" onclick="filter_redirect(\''+buttons_name+'\',\'submit\')" class="ui-button ui-corner-all ui-state-default" value="'+TEXT_FILTER_VIEW+'" />';
    var reset_button = '<input style="margin-top: 10px;" type="button" onclick="filter_redirect(\''+buttons_name+'\',\'reset\')" class="ui-button ui-corner-all ui-state-error" value="'+TEXT_FILTER_DELETE+'" />';

    filter_div.append('<br />'+submit_button+reset_button);
    return filter_div;
}
function remove_manual_weight_part_delivery(){
    $('#configure_part_delivery input[name="weight"]').remove();
    $('#configure_part_delivery a#remove_manual_weight_part_delivery').remove();
}
function manual_edit_part_delivery_weight(elm){
    remove_manual_weight_part_delivery(elm);
    var default_w = $(elm).text();
    $(elm).css({'text-decoration':'line-through','color':'red'}).after(
            '<input type="text" size="8" maxlength="8" name="weight" value="'+default_w+'" />'
            +'<a href="javascript:;" onclick="remove_manual_weight_part_delivery();" id="remove_manual_weight_part_delivery"><img  style="margin-left: 5px;margin-right: 5px;display: inline-block;" src="images/icons/cross.gif" border="0" title="Manuelle Eingabe verwerfen" /></a>'
    );
}

function part_delivery_dialog(dlg_title,source_id, trSelector){
    $('#configure_part_delivery').dialog({
        title: dlg_title,
        width: 'auto',
        height: 'auto',
        modal: true,
        open: function(){
            var str = new Array();
            str.push($(trSelector+' fieldset label[for="shipper"]').text()+' <b>'+$(trSelector+' fieldset select[name="shipper"]').val()+'</b>');
            str.push($(trSelector+' fieldset label[for="anzahl_pakete"]').text()+' <b>'+$(trSelector+' fieldset input[name="anzahl_pakete"]').val()+'</b>');
            let weight;
            let manual_w = false;
            if(!$(trSelector+' fieldset select[name="weight"]').length && !$(trSelector+' fieldset input[name="weight"]').length){
                weight = $(trSelector+' fieldset label[for="weight"]').data('weight');
            }else{
                if($(trSelector+' fieldset input[name="weight"]').length){
                    let w = $(trSelector+' fieldset input[name="weight"]').val();
                    weight = parseFloat(w.replace(',','.'));
                    manual_w = true;
                }else{
                    weight = $(trSelector+' fieldset select[name="weight"] option:selected').text();
                }
            }
            var manual_weight_str = '';
            if(manual_w){
                manual_weight_str = '<input type="text" size="8" maxlength="8" name="weight" value="'+weight+'" />'
                    +'<a href="javascript:;" onclick="remove_manual_weight_part_delivery();" id="remove_manual_weight_part_delivery"><img  style="margin-left: 5px;margin-right: 5px;display: inline-block;" src="images/icons/cross.gif" border="0" title="Manuelle Eingabe verwerfen" /></a>';

            }
            str.push($(trSelector+' fieldset label[for="weight"]').text()+' <b id="part_delivery_weight" style="text-decoration: underline; cursor: pointer;" onclick="manual_edit_part_delivery_weight(this)">'+weight+'</b>'+manual_weight_str);


            $(trSelector+' td .product').each(function(){
                var inp = '<select onchange="calc_part_delivery_weight(\''+source_id+'\')" name="qty['+$(this).data('id')+']"><option value="0">0</option>';
                var qty = parseInt($(this).children('.quantity').data('quantity'));
                var in_shipping_quantity = 0;
                if($(this).children('.quantity').data('in_shipping_quantity') != ""){
                    in_shipping_quantity += parseInt($(this).children('.quantity').data('in_shipping_quantity'));
                }
                var qty_shipped = parseInt($(this).children('.quantity').data('quantity_shipped'))
                var available = qty-in_shipping_quantity-qty_shipped;
                for(var i=0;i<available;i++){
                    var selected = '';
                    if(i==(available-1)){
                        selected += ' selected="selected"';
                    }
                    inp += '<option value="'+(i+1)+'"'+selected+'>'+(i+1)+'</<option>';
                }
                inp += '</select>';
                str.push( inp+$(this).children('.name').text());
                // PROPERTIES ANZEIGEN
                if($(this).children('.op_properties').length){
                    str.push( '<div class="properties_container">'+$(this).children('.op_properties').html()+'</div>' ) ;
                }
                $(this).children('.properties_container').children('.property').each(function(){
                    var pval = $(this).text();
                    if(pval.indexOf('kg') > -1){
                        str.push(pval);
                    }
                });
            });
            str.push('<div id="additional_versender_input"></div>');
            str.push('<input type="button" id="save_part_delivery_shipping" class="ui-button ui-corner-all ui-state-default" onclick="save_part_delivery(\''+source_id+'\')" value="'+TEXT_SAVE+'" />');
            $('#select_part_delivery_products').html(str.join('<br />'));
        }
    });
    
}

function calc_part_delivery_weight( source_id ){
    var product_params = [];
    $('#select_part_delivery_products select[name^="qty["]').each(function(){
        const opID_parts = $(this).attr('name').split('[');
        const opID = opID_parts[1].replace(']','');
        product_params.push( 'opID['+opID+']='+$(this).val() );
    });
    $.ajax({
        url: 'shipping.php?action=calc_weight&id='+source_id+'&'+product_params.join('&'),
        dataType: 'json',
        success: function( json ){
            $('b#part_delivery_weight').text( json.WEIGHT );
            const fsk = (json.FSK18 === true) ? 1 : 0;
            const sperrgut = (json.SPERRGUT === true) ? 'BulkyGoods' : '';
            $('tr.products[data-source_id='+source_id+'] .additional_shipper_params select[name="versender_params[DHL][Altersnachweis]"]').val(fsk);
            $('tr.products[data-source_id='+source_id+'] .additional_shipper_params select[name="versender_params[DHL][Sperrgut]"]').val(sperrgut);
        },
        error: function( xhr ){
            alert('Cant calc part delivery order weight');
        }
    });
}

function save_as_shipping_stepwise(sas_current_item_id){
    var sas_current_item_parts = sas_current_item_id.split('_');
    var sas_current_item = '';
    if(sas_current_item_parts[0] == 'orders'){
        sas_current_item += 'order #'+sas_current_item_parts[1];
    }else{
        sas_current_item += 'reclamation #'+sas_current_item_parts[1];
    }
    $('#processing_current_status').html('save delivery '+sas_current_item+' ...');
    save_delivery(sas_current_item_id,false);
}

function DHL_load_additional_params( div, profile_name, parentDIVKey ){
    $(div).find('#DHL_extraparams_'+parentDIVKey).remove();
    let contentloadurl = $(div).find('select[name="versender_params[DHL][produkt]"]').data('contentloadurl');
    if(typeof contentloadurl == 'string'){
        $(div).find('select[name="versender_params[DHL][produkt]"]').after('<div id="DHL_extraparams_'+parentDIVKey+'"></div>');
        let produkt = $(div).find('select[name="versender_params[DHL][produkt]"]').val();
        let parentDIV = 'DHL_extraparams_'+parentDIVKey;
        contentloadurl += '&parent_div_id='+parentDIV;
        if(profile_name == ''){
            contentloadurl += '&dhl_produkt='+produkt;
        }else{
            contentloadurl += '&shipper_profile='+profile_name+'&dhl_produkt='+produkt;
        }
        
        $(div).find('#'+parentDIV).load(contentloadurl,function(){
            // DHL extra params fertig geladen
        });
    }
}

function DHL_change_produkt(elm){
    let div = $(elm).parent().parent().parent();
    DHL_load_additional_params( div,'','' );
}
