<?php
use UnzerSDK\Resources\TransactionTypes\Charge;
use UnzerSDK\Resources\PaymentTypes\Prepayment;
use UnzerSDK\Resources\TransactionTypes\AbstractTransactionType;
use UnzerSDK\Resources\TransactionTypes\Authorization;
include('includes/application_top.php');
require_once(DIR_FS_CATALOG.'includes/modules/payment/unzer.php');

try{
    $unzer = new UnzerSDK\Unzer(MODULE_PAYMENT_UNZER_PRIVATE_KEY,'de-DE');
}catch( Exception $e ){
	echo $e->getMessage();
}
$action = (isset($_GET['action']))?$_GET['action']:'';
switch($action){
    case 'update_status_allocation':
        $json = [];
        foreach($_GET['orders_status'] as $state=>$orders_status_id){
            $json[] = ['state'=>$state,'orders_status_id'=>$orders_status_id];
        }
        \unzer::create_status_allocation_file($json);
        die(json_encode([
            'MSG'=>UNZER_STATUS_ALLOCATION_FILE_CREATED
        ]));
        break;
    case 'status':
        $paymentID = $_GET['paymentID'];
        if(empty($paymentID)){
            die(json_encode([
                'MSG'=>UNZER_ERROR_NO_PAYMENT_ID_SUBMITTED
            ]));
        }
        try{
            $payment   = $unzer->fetchPayment($paymentID);
        }catch(Exception $e){
            die(json_encode([
                'MSG'=>$e->getMessage()
            ]));
        }
        $amount = $payment->getAmount();
        foreach(unzer::UNZER_PAYMENT_STATES as $ups){
            if($ups['state'] == $payment->getState()){
                $state_info = $ups;
            }
        }
        yes_db_perform('unzer_payments',[
            'unzer_state'=>$payment->getState(),
        ],'update',[
            'PaymentId'=>$paymentID,
        ]);
        die(json_encode([
            'MSG'=>'',
            'total'=>$amount->getTotal(),
            'charged'=>$amount->getCharged(),
            'canceled'=>$amount->getCanceled(),
            'remaining'=>$amount->getRemaining(),
            'currency'=>$amount->getCurrency(),
            'state'=>$payment->getState(),
            'state_info'=>$state_info,
            'orderId'=>$payment->getOrderId(),
            'invoiceId'=>$payment->getInvoiceId(),
        ]));
        break;
    case 'add_webhook':
        try{
            if(main::isDev(true)||main::isDev()){
                $url = 'https://yes-a177922.de';
            }else{
                $url = HTTPS_CATALOG_SERVER;
            }
            $webhook = $unzer->createWebhook(
              $url.'/callback/unzer.php',
              $_GET['event']
            );
            die(json_encode([
                'MSG'=>'',
                'id'=>$webhook->getId(),
                'event'=>$_GET['event'],
                'url'=>$url.'/callback/unzer.php'
            ]));
        }catch(Exception $e){
            die(json_encode([
                'MSG'=>$e->getMessage()
            ]));
        }
        die(json_encode([
            'MSG'=>''
        ]));
        break;
    case 'delete_webhook':
        try{
            $webhook = $unzer->deleteWebhook($_GET['id']);
        }catch(Exception $e){
            die(json_encode([
                'MSG'=>$e->getMessage()
            ]));
        }
        die(json_encode([
            'MSG'=>''
        ]));
        break;
}
$start = intval($_GET['start']??0);
$limit = 50;
$unzer_payments = yes_query(sprintf(
    "SELECT * FROM unzer_payments ORDER BY unzer_payments_id DESC LIMIT %d, %d",
    $start, $limit
));
$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" id="unzer_transactions"';
$trs = [[[
    'text'=>'ID',
    'th'=>true
],[
    'text'=>TEXT_ORDER,
    'th'=>true
],[
    'text'=>'Unzer Status',
    'th'=>true
]]];
foreach($unzer_payments as $up){
    $state = 'Unknown';
    foreach(\unzer::UNZER_PAYMENT_STATES as $ups){
        if($ups['state'] == $up['unzer_state']){
            $state = $ups['title'];
        }
    }
    $order = yes_query(sprintf(
        "SELECT o.date_purchased, o.orders_status, ot.value FROM %s o  JOIN %s ot ON ot.orders_id=o.orders_id WHERE o.orders_id=:orders_id AND ot.class='ot_total'",
        TABLE_ORDERS,TABLE_ORDERS_TOTAL
    ),[
        'orders_id'=>$up['orders_id'],
    ],true);
    
    $tds = [[
        'text'=>$up['PaymentId'],
        'params'=>'id="id" data-unzerpaymentsid="'.$up['unzer_payments_id'].'"'
    ],[
        'text'=>sprintf('<div id="order_details_div"><div id="order">%d</div><div id="date">%s</div><div id="price">%s</div><div id="status">%s</div></div>',
            $up['orders_id'],
            yes_date_short($order['date_purchased'],true),
            number_format($order['value'],2,',',''),
            xtc_get_orders_status_name($order['orders_status']),
        ),
    ],[
        'text'=>$state,
    ]];
    $trs[] = $tds;
}
$transactions_table = $table->tableBlock_draw($trs);

$webhooks = $unzer->fetchAllWebhooks();
$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" id="unzer_webhooks"';
$trs = [[[
    'text'=>'ID',
    'align'=>'left',
    'th'=>true
],[
    'text'=>'Event',
    'align'=>'left',
    'th'=>true
],[
    'text'=>'URL',
    'align'=>'left',
    'th'=>true
]]];
if(sizeOf($webhooks)){
    foreach($webhooks as $wh){

        $tds = [[
            'text'=>$wh->getId(),
            'align'=>'left',
            'params'=>'id="id"'
        ],[
            'text'=>$wh->getEvent(),
            'align'=>'left',
        ],[
            'text'=>$wh->getUrl(),
            'align'=>'left',
            'params'=>'id="url"'
        ]];
        $trs[] = $tds;
    }
}
$smarty = new yesSmarty();




$status_table = new tableBlock();
$status_table->table_parameters = 'class="yesListTable_minimal" id="unzer_states"';
$status_trs = [[[
    'text'=>'ID',
    'align'=>'left',
    'th'=>true
],[
    'text'=>'Status Name',
    'align'=>'left',
    'th'=>true
],[
    'text'=>'YES '.TEXT_ORDER.' Status',
    'align'=>'left',
    'th'=>true
]]];

foreach(\unzer::UNZER_PAYMENT_STATES as $upm){
    $default = \unzer::get_yes_orders_status_from_unzer_status($upm['state']);
    $status_tds = [[
        'text'=>$upm['state'],
        'align'=>'left',
        'params'=>'id="id"'
    ],[
        'text'=>sprintf('<span title="%s">%s</span>',$upm['description'],$upm['title']),
        'align'=>'left',
    ],[
        'text'=> xtc_draw_pull_down_menu('orders_status['.$upm['state'].']', xtc_get_orders_status(), $default),
        'align'=>'left',
        'params'=>'id="url"'
    ]];
    $status_trs[] = $status_tds;
}

$config_active = $_GET['conf']??'';
$btn_text = (empty($config_active))?'Configuration':'Transactions';
$btn_link = xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('conf')));
if(empty($config_active)){
    if(strpos($btn_link,'?') !== false){
        $sep = '&';
    }else{
        $sep = '?';
    }
    $btn_link .= $sep.'conf=1';
}
$menus = array(
    array('text'=>$btn_text,
        'link'=>$btn_link,
        'lbOn'=>false,
        'auth'=>true
    )
);

$smarty->assign([
    'CONFIG'=>$config_active,
    'HEADING_TITLE'=>'Unzer Administration',
    'ADDITIONAL_TITLE'=>'Aktiv: '.constant('MODULE_PAYMENT_UNZER_STATUS'),
    'PAGE_HEADING_MENU_BUTTONS'=>$menus,
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'WEBHOOKS'=>$table->tableBlock_draw($trs),
    'TRANSACTIONS'=>$transactions_table,
    'UNZER_ORDERS_STATUS_ALLOCATIONS'=>$status_table->tableBlock_draw($status_trs),
    'LINK_STATUS_UPDATE'=>xtc_href_link('unzer.php?action=unzer_status_allocation'),
]);
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->display('unzer.html');
include('includes/footer.php');
include('includes/application_bottom.php');
