<?php
include('includes/cron_application_top.php');
function msort($array, $id="id", $sort_ascending=true) {
	$temp_array = array();
	while(count($array)>0) {
	        $lowest_id = 0;
	        $index=0;
	        foreach ($array as $item) {
		        if (isset($item[$id])) {
                                if ($array[$lowest_id][$id]) {
			                if (strtolower($item[$id]) < strtolower($array[$lowest_id][$id])) {
				                $lowest_id = $index;
			                }
		                }
                        }
		        $index++;
	        }
	        $temp_array[] = $array[$lowest_id];
	        $array = array_merge(array_slice($array, 0,$lowest_id), array_slice($array, $lowest_id+1));
	}
	if ($sort_ascending) {
		return $temp_array;
	} else {
		return array_reverse($temp_array);
	}
}

function file_size_info($filesize) { 
	$bytes = array('KB', 'KB', 'MB', 'GB', 'TB'); # values are always displayed  
	if ($filesize < 1024) $filesize = 1; # in at least kilobytes. 
	for ($i = 0; $filesize > 1024; $i++) $filesize /= 1024; 
	$file_size_info['size'] = ceil($filesize); 
	$file_size_info['type'] = $bytes[$i]; 
	return $file_size_info; 
}

$tables_array = array();
$tables_query = xtc_db_query("SHOW table STATUS");
while($tables = xtc_db_fetch_array($tables_query)){
	$size = $tables['Data_length'] + $tables['Index_length'];
	$tables_array[] = array('Size'=>$size,'Name'=>$tables['Name'],'Rows'=>$tables['Rows']);
	$dbsize += $size;
}

$dbsize = file_size_info($dbsize); 
?>
<!DOCTYPE html>
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $_SESSION['language_charset']; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css.php">
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<!-- header //-->
<table border="0" width="100%">
<tr>
	<td class="main">
<?php
print "<h2>Datenbankgr&ouml;sse: {$dbsize['size']} {$dbsize['type']}</h2>"; 

$tables_array = msort($tables_array,'Size',false);
foreach($tables_array as $k=>$table){
	echo '<ul style="list-style-type:none;"><li style="float:left;font-weight:bold;">'.$table['Name'].'</li>';
	$tsize = file_size_info($table['Size']);
	echo '<li>&nbsp;'.$tsize['size'].' '.$tsize['type'].' ('.$table['Rows'].' Zeilen)</li></ul>';
}
?>

	</td>
</tr>
</table>
</body>
</html>
