<?php

/* -----------------------------------------------------------------------------------------
   $Id: advanced_search.php,v 1.16 2017/08/23 16:01:54 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(advanced_search.php,v 1.49 2003/02/13); www.oscommerce.com 
   (c) 2003	 nextcommerce (advanced_search.php,v 1.13 2003/08/21); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include ('includes/application_top.php');

if(defined('MODULE_OTHER_TURNSTILE_STATUS') and constant('MODULE_OTHER_TURNSTILE_STATUS') == 'True'){
    require_once(DIR_WS_MODULES.'other/turnstile.php');
    require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/other/turnstile.php');
    $turnstile = true;
    $turnstile_class = new \turnstile();
}

$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

// include needed functions
require_once (DIR_FS_INC.'xtc_get_categories.inc.php');
require_once (DIR_FS_INC.'xtc_get_manufacturers.inc.php');
require_once (DIR_FS_INC.'xtc_checkdate.inc.php');
require_once (DIR_FS_INC.'xtc_draw_checkbox_field.inc.php');
$tab_mode = false;
if(isset($_GET['tab'])){
	$tab_mode = true;
	$smarty->assign('tab_mode',1);
	$group_id = (int)xtc_db_input($_GET['group']);
}

if(!$tab_mode){
	$breadcrumb->add(NAVBAR_TITLE_ADVANCED_SEARCH, xtc_href_link(FILENAME_ADVANCED_SEARCH));
	require (DIR_WS_INCLUDES.'header.php');
}
if(!defined('DIR_FS_ADMIN')){
	define('DIR_FS_ADMIN',DIR_FS_CATALOG.'admin/');
}
if(!function_exists('xtc_draw_pull_down_menu')){
	require_once(DIR_FS_INC.'xtc_draw_pull_down_menu.inc.php');
}



// PRODUKTGRUPPEN
$group_select = array(0=>array('id'=>'','text'=>'Alle'));

$group = isset($_GET['group']) ? xtc_db_input($_GET['group']) : '';
$set = isset($_GET['set']) ? xtc_db_input($_GET['set']) : '';

$GH = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
$nosets = [];
if(!$tab_mode){
    foreach($GH->groups as $G){
        $group_characteristics[$G['groups_id']] = array();
        if($G['visible'] == 1){
            $group_select[] = array('id'=>$G['groups_id'],'text'=>$G['groups_title']);
        }
    }
}else{
    if($group>0){
            $set_select = array();
            foreach($GH->groups as $G){
                if($G['groups_id'] != $group){
                    continue;
                }
                foreach($G['characteristics'] as $gck=>$GC){
                    if($GC['visible'] == 0){
                        continue;
                    }
                    $set = array();
                    $set['title'] = $GC['description']['title'];
                    $sets = array('0'=>array('id'=>'','text'=>'Alle'));
                    if($GC['no_sets'] == 0){
                        foreach($GC['sets'] as $gcset){
                            $sets[] = array(
                                'id'=>$gcset['products_characteristic_set_id'],
                                'text'=>$gcset['description']['title'],
                            );
                        }
                    }else{
                        $nosets[] = array('id'=>$GC['products_characteristic_id'],'text'=>$GC['description']['title']);
                    }
                    if(sizeOf($sets)>1){
                        $set['sets'] = $sets;
                        $set_select[] = $set;
                    }
                }
                $smarty->assign('GROUP_CHARACTERISTICS',1);
                if(is_countable($nosets) and sizeOf($nosets)>1){
                        $smarty->assign('GROUP_CHARACTERISTICS_NOSETS',$nosets);
                }
                if(sizeOf($set_select)>0){
                        $smarty->assign('GROUP_CHARACTERISTICS_SETS',$set_select);
                }
                $smarty->assign('INPUT_GROUPS_ID',xtc_draw_hidden_field('groups_id',$group));
                $smarty->assign('GROUP_NAME',$G['groups_title']);
            }
    } // end if group > 0
}
if(SHOW_GROUPS_IN_ADVANCED_SEARCH == 'True'){
	$smarty->assign('GROUPS_ARRAY', $group_select);
}

$smarty->assign('FORM_ACTION', xtc_draw_form('advanced_search', xtc_href_link(FILENAME_ADVANCED_SEARCH_RESULT, '', 'NONSSL', false), 'get', 'onsubmit="return check_form(this);"'));

$smarty->assign('INPUT_KEYWORDS', xtc_draw_input_field('keywords', '', 'style="width: 100%"'));
$smarty->assign('HELP_LINK', 'javascript:popupWindow(\''.xtc_href_link(FILENAME_POPUP_SEARCH_HELP).'\')');
$smarty->assign('BUTTON_SUBMIT', xtc_image_submit('button_search.gif', IMAGE_BUTTON_SEARCH));

if( isset($_GET['tab']) and $_GET['tab'] == 1 and (!isset($_GET['group']) or $_GET['group'] == '0')){
	$smarty->assign('SELECT_CATEGORIES',xtc_draw_pull_down_menu('categories_id', xtc_get_categories(array (array ('id' => '', 'text' => TEXT_ALL_CATEGORIES)))));
	$smarty->assign('ENTRY_SUBCAT',xtc_draw_checkbox_field('inc_subcat', '1', true));
	$smarty->assign('SELECT_MANUFACTURERS',xtc_draw_pull_down_menu('manufacturers_id', xtc_get_manufacturers(array (array ('id' => '', 'text' => TEXT_ALL_MANUFACTURERS)))));
	$smarty->assign('SELECT_PFROM',xtc_draw_input_field('pfrom'));
	$smarty->assign('SELECT_PTO',xtc_draw_input_field('pto'));
}

$error = '';
$errorno = (isset($errorno)) ? (int)xtc_db_input($errorno):0;
if ($errorno > 0) {
	if ($errorno == 1) {
		$error .= str_replace('\n', '<br />', JS_AT_LEAST_ONE_INPUT);
	}
	if ($errorno  == 10) {
		$error .= str_replace('\n', '<br />', JS_INVALID_FROM_DATE);
	}
	if ($errorno == 100) {
		$error .= str_replace('\n', '<br />', JS_INVALID_TO_DATE);
	}
	if ($errorno == 1000) {
		$error .= str_replace('\n', '<br />', JS_TO_DATE_LESS_THAN_FROM_DATE);
	}
	if ($errorno  == 10000) {
		$error .= str_replace('\n', '<br />', JS_PRICE_FROM_MUST_BE_NUM);
	}
	if ($errorno  == 100000) {
		$error .= str_replace('\n', '<br />', JS_PRICE_TO_MUST_BE_NUM);
	}
	if ($errorno  == 1000000) {
		$error .= str_replace('\n', '<br />', JS_PRICE_TO_LESS_THAN_PRICE_FROM);
	}
	if ($errorno  == 10000000) {
		$error .= str_replace('\n', '<br />', JS_INVALID_KEYWORDS);
	}
}
if(isset($_GET['error_msg'])){
    $error .= $_GET['error_msg'];
}
$smarty->assign(array(
    'error'=>$error,
    'language'=>$_SESSION['language'],
    'FORM_END'=>'</form>',
    'GROUPS_ID'=>$group
));

$smarty->caching = 0;
$smarty->assign([
    'error'=>$error,
    'language', $_SESSION['language'],
    'YES_CAPTCHA'=>($turnstile)?$turnstile_class->create():''
]);
$main_content = $smarty->fetch(CURRENT_TEMPLATE.'/module/advanced_search.html');
$smarty->assign('main_content', $main_content);
if(!$tab_mode){
	$smarty->caching = 0;
	if (!defined('RM')){
		$smarty->load_filter('output', 'note');
    }
	$smarty->display(CURRENT_TEMPLATE.'/index.html');
	include ('includes/application_bottom.php');
}else{
    header('Content-Type: text/html; charset='.CHARSET);
    echo $main_content;
}
