<?php
/* checkout_paypal_ppp.php
.---------------------------------------------------------------------------.
|    Software: PayPal-Plus-Module                                           |
|     Version: 0.6beta                                                      |
|        Date: 2015-11-05                                                   |
| Description: shows the paypal-plus iframe by javascript                   |
|     Contact: info@andreas-guder.de                                        |
| ------------------------------------------------------------------------- |
|      Author: Andreas Guder                                                |
|     Contact: info@andreas-guder.de                                        |
| Copyright (c) 2015, Andreas Guder.                                        |
| ------------------------------------------------------------------------- |
|     License:  GNU Public License V2.0                                     |
|               http://www.gnu.org/licenses/gpl-2.0.html                    |
'--------------------------------------------------------------------------�'
*/

include('includes/application_top.php');
require_once('admin/includes/classes/class.storagequantity.php');

if (!defined('MODULE_PAYMENT_YES_PPP_STATUS') || constant('MODULE_PAYMENT_YES_PPP_STATUS') != 'True'){
  xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}
$tmp = preg_replace("'[\s]+'",'',$_SESSION['customers_status']['customers_status_payment_unallowed']);
$unallowed = explode(',', $tmp);
if (in_array('yes_ppp', $unallowed)){
    xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}
// create smarty elements
$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

// BOF - STOCK CHECK NEU
$any_out_of_stock = false;
$any_disabled = false;
if (STOCK_CHECK == 'true' or STOCK_ALLOW_CHECKOUT != 'true') {
    $same_products_qty = array();
    $products = $_SESSION['cart']->get_products();
    foreach($products as $p) {
        if(!isset($same_products_qty[ $p['id'] ])){
            $same_products_qty[ $p['id'] ] = 0;
        }
        $SQ = new products_quantity($p['id']);
        $qty_total = (defined('STOCK_CHECK_AVAILABLE_METHOD') and STOCK_CHECK_AVAILABLE_METHOD == 'True') ? $SQ->get_available1_qty() : $SQ->get_available2_qty();
        // QTY und PRODUCTS_STATUS PRUEFEN
        if($qty_total<($p['qty']+$same_products_qty[ $p['id'] ]) ){
            $any_out_of_stock = 1;
        }
        if(!$SQ->get_products_status() ){
            $any_disabled = 1;
        }
        $same_products_qty[ $p['id'] ] += $p['qty'];
    }
    // Out of Stock
    if (STOCK_CHECK == 'true' and $any_out_of_stock == 1) {
        xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
    }
    if ( STOCK_ALLOW_CHECKOUT != 'true' and $any_disabled ) {
        xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
    }
}
// EOF - STOCK CHECK NEU
 
$script_block = '';
$shipping_block = '';
if (isset($_GET['token']) and !empty($_GET['token'])){
  require_once DIR_WS_CLASSES.'order.php';
  $token = $_GET['token']; // das ist die Order-ID
  if(defined('MODULE_PAYMENT_YES_PPP_STATUS') and constant('MODULE_PAYMENT_YES_PPP_STATUS') == 'True'){
    $pp = new \YES4Trade\Model\paypal_api();
    $pp->saveOrderToken($token);
    if(isset($_GET['PayerID'])){
      $pp->savePayerID($_GET['PayerID']);
    }
    $_SESSION['payment'] = 'yes_ppp';
  }


  
  // Do Shipping-action, copied from checkout_shipping.php
  require_once (DIR_FS_INC.'xtc_count_shipping_modules.inc.php');
  if ($_SESSION['cart']->count_contents() < 1) {
    xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
  }
  //BOF - Dokuman - 2009-06-06 - checkout only if minimum order value is reached
  if ($_SESSION['cart']->show_total() > 0 ) {
    if ($_SESSION['cart']->show_total() < $_SESSION['customers_status']['customers_status_min_order'] ) {
      xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
    }
  }
  if (isset($_SESSION['customer_id']) && !empty($_SESSION['customer_id']))
  {
    if (!isset ($_SESSION['sendto'])) 
    {
      $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
    } 
    else 
    {
        $anz = \YES4Trade\Model\address_book::count_by_customers_id_and_address_book_id(
            (int) $_SESSION['customer_id'], (int) $_SESSION['sendto']
        );
        if ($anz != 1) {
            $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
            if (isset ($_SESSION['shipping'])){
                unset ($_SESSION['shipping']);
            }
        }
    }
  }
  
  $order = new order();
  if(empty($order->delivery['country']['id']))
    $order->delivery['country']['id'] = STORE_COUNTRY;
  if(empty($order->delivery['country']['iso_code_2']))
    $order->delivery['country']['iso_code_2'] = $_SESSION['delivery_zone'];
  if(empty($order->delivery['country_id']))
    $order->delivery['country_id'] = STORE_COUNTRY;
  include_once DIR_WS_LANGUAGES.$_SESSION['language'].'/modules/order_total/ot_shipping.php';
  
  if (empty($_SESSION['cartID']))
    $_SESSION['cartID'] = $_SESSION['cart']->cartID;
  if ($order->content_type == 'virtual' || ($order->content_type == 'virtual_weight') || ($_SESSION['cart']->count_contents_virtual() == 0))
  {
    // only virtual products, do nothing
    $_SESSION['shipping'] = array(
      'id' => 'free_free',
      'title' => FREE_SHIPPING_TITLE,
      'cost' => 0
    );
  }
  else
  {
    if (!defined('CHECK_CHEAPEST_SHIPPING_MODUL'))
      define ('CHECK_CHEAPEST_SHIPPING_MODUL', false); //true, false - default false
    
    $total_weight = $_SESSION['cart']->show_weight();
    $total_count = $_SESSION['cart']->count_contents();

    if ($order->delivery['country']['iso_code_2'] != '')
      $_SESSION['delivery_zone'] = $order->delivery['country']['iso_code_2'];
    
    // load all enabled shipping modules
    require_once DIR_WS_CLASSES.'shipping.php';
    $shipping_modules = new shipping;

    require_once DIR_WS_MODULES.'order_total/ot_shipping.php';
    $ot_shipping = new ot_shipping;
    $ot_shipping->process();

    // get all available shipping quotes
    $quotes = $shipping_modules->quote();
    if ((!isset ($_SESSION['shipping']) && CHECK_CHEAPEST_SHIPPING_MODUL) || (isset ($_SESSION['shipping']) && ($_SESSION['shipping'] == false) && (xtc_count_shipping_modules() > 1))) { //web28 - 2012-04-27 - pre-selection the cheapest shipping option
      $_SESSION['shipping'] = $shipping_modules->cheapest();
    }
    
    if (xtc_count_shipping_modules() > 0) 
    {
      $module_smarty = new yesSmarty;
      
      $showtax = $_SESSION['customers_status']['customers_status_show_price_tax'];
      $module_smarty->assign('FREE_SHIPPING', $free_shipping);
      # free shipping or not...
      if ($free_shipping == true) {
        $module_smarty->assign('FREE_SHIPPING_TITLE', FREE_SHIPPING_TITLE);
        $module_smarty->assign('FREE_SHIPPING_DESCRIPTION', sprintf(FREE_SHIPPING_DESCRIPTION, $xtPrice->xtcFormat($free_shipping_value_over, true, 0, true)).xtc_draw_hidden_field('shipping', 'free_free'));
        $module_smarty->assign('FREE_SHIPPING_ICON', $quotes[$i]['icon']);
        
        $_SESSION['shipping'] = array(
          'id' => 'free_free',
          'title' => FREE_SHIPPING_TITLE,
          'cost' => 0
        );
        
      } else {
        $radio_buttons = 0;
        $checked_one = false;
        #loop through installed shipping methods...
        for ($i = 0, $n = sizeof($quotes); $i < $n; $i ++) {
          if (!isset ($quotes[$i]['error'])) {
            for ($j = 0, $n2 = sizeof($quotes[$i]['methods']); $j < $n2; $j ++) {
              if (empty($_SESSION['shipping']))
              {
                $_SESSION['shipping'] = array(
                  'id' => $quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id'],
                  'title' => $quotes[$i]['module'] . ' (' . $quotes[$i]['methods'][$j]['title'] . ')',
                  'cost' => $quotes[$i]['methods'][$j]['cost']
                );
              }
              # set the radio button to be checked if it is the method chosen
              $quotes[$i]['methods'][$j]['radio_buttons'] = $radio_buttons;
              $checked = ((isset($_SESSION['shipping']) && $quotes[$i]['id'].'_'.$quotes[$i]['methods'][$j]['id'] == $_SESSION['shipping']['id']) ? true : false);
              if (($checked == true) || ($n == 1 && $n2 == 1)) {
                $checked_one = true;
                $quotes[$i]['methods'][$j]['checked'] = 1;
              }
              if (($n > 1) || ($n2 > 1)) {
                if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 || !isset($quotes[$i]['tax'])) {
                  $quotes[$i]['tax'] = 0;
                }
                $quotes[$i]['methods'][$j]['price'] = $xtPrice->xtcFormat(xtc_add_tax($quotes[$i]['methods'][$j]['cost'], $quotes[$i]['tax']), true, 0, true);						
                $quotes[$i]['methods'][$j]['radio_field'] = xtc_draw_radio_field('shipping', $quotes[$i]['id'].'_'.$quotes[$i]['methods'][$j]['id'], $checked, 'id="'.($i+1).'"');
              } else {
                if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0) {
                  $quotes[$i]['tax'] = 0;
                }
                $quotes[$i]['methods'][$j]['price'] = $xtPrice->xtcFormat(xtc_add_tax($quotes[$i]['methods'][$j]['cost'], isset($quotes[$i]['tax']) ? $quotes[$i]['tax'] : 0), true, 0, true).xtc_draw_hidden_field('shipping', $quotes[$i]['id'].'_'.$quotes[$i]['methods'][$j]['id']);
              }
              $radio_buttons ++;
            }
          }
        }
        
        if (!$checked_one)
        {
          $quotes[0]['methods'][0]['checked'] = 1;
          $_SESSION['shipping'] = $quotes[0]['id'].'_'.$quotes[0]['methods'][0]['id'];
        }
        $module_smarty->assign('module_content', $quotes);
      }
      
      $module_smarty->caching = 0;
      $shipping_block .= $module_smarty->fetch(CURRENT_TEMPLATE.'/module/checkout_shipping_block.html');
    }
    else
    {
      $_SESSION['shipping'] = array(
        'id' => 'free_free',
        'title' => FREE_SHIPPING_TITLE,
        'cost' => 0
      );
    }
  }
  
  $prev_shipping = '';
  if (!empty($_SESSION['shipping']))
    $prev_shipping = is_array($_SESSION['shipping']) ? $_SESSION['shipping']['id'] : $_SESSION['shipping'];
  $script_block = '
    function ppp_update_payment(data)
    {
      var prev = '.(empty($prev_shipping) ? 'null' : '"'.$prev_shipping.'"').';
      var conditions_checked = true;
      ';
    if (DISPLAY_CONDITIONS_ON_CHECKOUT) 
    {
      $script_block .= 'if (document.getElementById("conditions") && !document.getElementById("conditions").checked) {
        alert(unescape("' . xtc_js_lang(ERROR_CONDITIONS_NOT_ACCEPTED) . '"));
        return false;
      }';
    }
  $script_block .= '
      var rad = document.getElementsByName("shipping");
      for(var i = 0; i < rad.length; i++) 
      {
        if (rad[i].checked)
        {
          prev = rad[i].value;
          break;
        }
      }
      var xmlhttp = new XMLHttpRequest();
      xmlhttp.onreadystatechange = function() {
        if (xmlhttp.readyState == XMLHttpRequest.DONE ) {
          if(xmlhttp.status == 200 && xmlhttp.responseText.substring(0,2) == "ok")
          {
            PAYPAL.apps.PPP.doCheckout();
          }
          else 
            alert(xmlhttp.responseText);
          document.getElementById("ppplus").removeChild(document.getElementById("ppplayer"));
          document.getElementById("ppplus").removeChild(document.getElementById("ppplayertext"));
        }
      }
      
      var post_data = "";
      post_data += "shipping="+prev;
      post_data += pppThirdPartyPayment ? "&thrdprty=1" : "&thrdprty=0";
      if (document.getElementById("comments"))
        post_data += "&comments="+encodeURIComponent(document.getElementById("comments").value);
      if (document.getElementById("ppp_choose_state"))
        post_data += "&ppp_state="+encodeURIComponent(document.getElementById("ppp_choose_state")[document.getElementById("ppp_choose_state").selectedIndex].value);
      
      xmlhttp.open("POST", "paypal_ppp_ajax_requests.php?ppp_action=set_shipping&'.SID.'", true);
      xmlhttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
      xmlhttp.setRequestHeader("Content-length", post_data.length);
      xmlhttp.setRequestHeader("Pragma", "no-cache");
      xmlhttp.setRequestHeader("Cache-Control", "must-revalidate");
      xmlhttp.send(post_data);
      var div = document.getElementById("ppplus");
      div.style.position = "relative";
      var layer = document.createElement("DIV");
      layer.id = "ppplayer";
      div.appendChild(layer);
      layer.style.position = "absolute"; layer.style.zIndec = "1000"; layer.style.height = "100%"; layer.style.width = "100%";
      layer.style.top = 0; layer.style.left = 0; layer.style.backgroundColor = "#fff"; layer.style.opacity = "0.8";
      var layertext = document.createElement("DIV");
      layertext.id = "ppplayertext";
      div.appendChild(layertext);
      layertext.appendChild(document.createTextNode("'.TEXT_PLEASE_WAIT.'"));
      layertext.style.position = "absolute"; layertext.style.zIndex = "1001"; layertext.style.width = "100%"; 
      layertext.style.top = 0; layertext.style.left = 0; layertext.style.marginTop = "80px";
      layertext.style.textAlign = "center"; layertext.style.fontWeight = "bold"; layertext.style.fontSize = "2em"
    }
  ';

  $order = new order();
  if(empty($order->delivery['country']['id']))
    $order->delivery['country']['id'] = STORE_COUNTRY;
  if(empty($order->delivery['country']['iso_code_2']))
    $order->delivery['country']['iso_code_2'] = $_SESSION['delivery_zone'];
  if(empty($order->delivery['country_id']))
    $order->delivery['country_id'] = STORE_COUNTRY;
  
  require_once DIR_WS_CLASSES . 'order_total.php';
  $order_total_modules = new order_total();
  $order_total_modules->collect_posts();
  //$order_total_modules->process();
  
  include_once DIR_WS_LANGUAGES . $_SESSION['language'] . '/modules/payment/paypal_ppp.php';
  require_once DIR_FS_CATALOG.'includes/modules/payment/paypal_ppp.php';
  
  if (isset($_SESSION['agi_ppp']['ppp_payment_id']))
    $ppp_rest->delete_paypal_payment_ressource($_SESSION['agi_ppp']['ppp_payment_id']);
    
  $paypal_ppp = new paypal_ppp();
  $anonymus = false;
  if (MODULE_PAYMENT_PAYPAL_PPP_REPLACE_CHECKOUT=='True' || isset($_SESSION['agi_ppp']['express_checkout']) && $_SESSION['agi_ppp']['express_checkout'] === true)
    $anonymus = true;
  $show_countrystate_input = false;
  if (!$anonymus && !$_SESSION['agi_ppp']['express_checkout'])
  {
    if ($order->delivery['country_id'] != 81)
    {
      $_SESSION['agi_ppp']['ppp_delivery_country'] = $order->delivery['country_id'];
      if (empty($order->delivery['state']))
      {
        $tmp = xtc_db_fetch_array(xtc_db_query("SELECT COUNT(*) AS cont FROM `".TABLE_ZONES."` WHERE `zone_country_id`=".$order->delivery['country_id']));
        if ($tmp['cont'] > 0)
        {
          $show_countrystate_input = true;
          $anonymus = true;
        }
      }
    }
  }
  $response = $paypal_ppp->pre_confirmation_check($anonymus ? true : false);
  $_SESSION['agi_ppp']['ppp_patch_address'] = true;
  
  $body = json_decode($response['body']);
  $approval_url = '';
  foreach ($body->links as $row)
  {
    if ($row->rel == 'approval_url')
    {
      $approval_url = $row->href;
      break;
    }
  }
  $_SESSION['agi_ppp']['ppp_approval_url'] = $approval_url; // stammt vom Anlegen der Zahlung
  $_SESSION['agi_ppp']['ppp_payment_id'] = $body->id;
  
  if (isset($show_countrystate_input) && $show_countrystate_input == true)
  {
    $zones_array = array();
    $zones_query = xtc_db_query("SELECT `zone_name` FROM " . TABLE_ZONES . " WHERE `zone_country_id` = '" . (int)$order->delivery['country_id'] . "' ORDER BY `zone_name`");
    while ($zones_values = xtc_db_fetch_array($zones_query))
      $zones_array[] = array('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);
    $state_input = xtc_draw_pull_down_menu('ppp_state', $zones_array, '', 'id="ppp_choose_state"');
    $smarty->assign('INPUT_STATE',$state_input);
  }
  
  //check if display conditions on checkout page is true
  if (DISPLAY_CONDITIONS_ON_CHECKOUT == 'true')
  {
    $shop_content_data = $main->getContentData(3);

    $smarty->assign('AGB', '<div class="agbframe">' . $shop_content_data['content_text'] . '</div>');
    $smarty->assign('AGB_LINK', $main->getContentLink(3, MORE_INFO,'SSL'));
    $smarty->assign('AGB_checkbox', '<input type="checkbox" value="conditions" name="conditions" id="conditions" />');
  }
  
  $smarty->assign('COMMENTS', xtc_draw_textarea_field('comments', 'soft', '60', '5', isset($_SESSION['comments']) ? $_SESSION['comments'] : ''));
  $smarty->assign('SECOND_COLUMN', true);
}

$breadcrumb->add(NAVBAR_TITLE_CHECKOUT_PAYPAL_PPP, xtc_href_link(FILENAME_CHECKOUT_PAYPAL_PPP, '', 'SSL'));
require(DIR_WS_INCLUDES.'header.php');

$country_code = $ppp_rest->get_store_country_code(array_key_exists('customer_country_id', $_SESSION) ? $_SESSION['customer_country_id'] : 0);
$language_code = 'de_DE';
if (array_key_exists('language_code', $_SESSION))
{
  switch ($_SESSION['language_code'])
  {
    case 'de': $language_code = 'de_DE'; break;
    case 'fr': $language_code = 'fr_XC'; break;
    case 'en': $language_code = 'en_GB'; break;
    default: $language_code = 'en_US'; break;
  }
}
$smarty->assign('SHIPPING_BLOCK', $shipping_block);
$ppp_script = '';
$ppp_script .='
  <script src="https://www.paypalobjects.com/webstatic/ppplus/ppplus.min.js" type="text/javascript"></script>
  <script type="application/javascript"> <!--
    var pppThirdPartyPayment = false;
    var ppp = PAYPAL.apps.PPP({
    "approvalUrl": "'.$_SESSION['agi_ppp']['ppp_approval_url'].'",
    "placeholder": "ppplus",
    "preselection": "paypal",
    "mode": "'.(MODULE_PAYMENT_PAYPAL_PPP_MODE == 'live' ? 'live' : 'sandbox').'",
    "country": "'.$country_code.'",
    "language": "'.$language_code.'",
    "buttonLocation": "inside",
    "showPuiOnSandbox": "true",
    //"useraction": "continue",
    ';
if (!empty($script_block))
  $ppp_script .= '"onContinue": function(data) {ppp_update_payment(data)},';
if (isset($_GET['req']) && $_GET['req']=='express' && MODULE_PAYMENT_PAYPAL_PPP_REPLACE_CHECKOUT == 'True' && MODULE_PAYMENT_PAYPAL_PPP_PAYMENT_INCLUDE != '' && (!isset($_SESSION['agi_ppp']['express_checkout']) || isset($_SESSION['agi_ppp']['express_checkout']) && $_SESSION['agi_ppp']['express_checkout'] == false))
{
  $tmp = preg_replace('/\s/','',MODULE_PAYMENT_PAYPAL_PPP_PAYMENT_INCLUDE);
  $tmp = explode(',', MODULE_PAYMENT_PAYPAL_PPP_PAYMENT_INCLUDE);
  if (!empty($tmp))
  {
    $must_utf8_encode = strtolower($_SESSION['language_charset']) != 'utf-8' ? true : false;
    $include_payments = $tmp;
    require_once (DIR_WS_CLASSES . 'payment.php');
    $payment_modules = new payment;
    $selection = $payment_modules->selection();
    $ppp_icnlude_payments = array();
    foreach ($selection as $row)
    {
      if (in_array($row['id'], $include_payments))
      {
        if (isset($ot_payment) && is_object($ot_payment))
          $row['description'] = $ot_payment->get_module_cost($row).' '.$row['description'];
        
        $tname = agi_short_name(strip_tags(html_entity_decode($row['module'], ENT_COMPAT, $_SESSION['language_charset'])), 25);
        $tdesc = strip_tags(html_entity_decode($row['description'], ENT_COMPAT, $_SESSION['language_charset']));
        $payment = array(
          'redirectUrl' => html_entity_decode(xtc_href_link(FILENAME_CHECKOUT_CONFIRMATION, 'ppp_confirm=1&payment='.$row['id'], 'SSL')),
          'methodName'  => $must_utf8_encode ? utf8_encode($tname) : $tname,
          'description' => $must_utf8_encode ? utf8_encode($tdesc) : $tdesc,
        );
        $ppp_icnlude_payments[] = $payment;
      }
    }
    if (!empty($ppp_icnlude_payments))
    {
      $ppp_script .= '"thirdPartyPaymentMethods":'.json_encode($ppp_icnlude_payments).','.chr(10);
      $ppp_script .= '"onThirdPartyPaymentMethodDeselected": function(data) { pppThirdPartyPayment = false; },'.chr(10);
      $ppp_script .= '"onThirdPartyPaymentMethodSelected": function(data) { pppThirdPartyPayment = true; },'.chr(10);
    }
  }
}
$ppp_script .='
    });
';
if (!empty($script_block))
  $ppp_script .= $script_block;
$ppp_script .='
  --></script>
';

$smarty->assign('PPP_CODE', $ppp_script);

if($messageStack->size('checkout_paypal_ppp') > 0) {
  $smarty->assign('error', $messageStack->output('checkout_paypal_ppp'));
}

$smarty->caching = 0;
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('SHOPPING_CART', xtc_href_link(FILENAME_SHOPPING_CART));

$main_content = $smarty->fetch(CURRENT_TEMPLATE.'/module/checkout_paypal_ppp.html');
$smarty->assign('main_content', $main_content);
/*
if(!defined('RM')) {
  $smarty->load_filter('output', 'note');
}
*/
$smarty->display(CURRENT_TEMPLATE.'/index.html');
include('includes/application_bottom.php');
