<?php
/* -----------------------------------------------------------------------------------------
   $Id: checkout_success.php,v 1.37 2019/06/28 09:10:54 re511548 Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(checkout_success.php,v 1.48 2003/02/17); www.oscommerce.com 
   (c) 2003	 nextcommerce (checkout_success.php,v 1.14 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contribution:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org


   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
include( 'includes/application_top.php');
require_once(DIR_FS_INC.'yes_get_products_characteristics.inc.php');
require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
//ini_set('display_errors',true);
//error_reporting(E_ALL);
// BOF AGI PAYPAL-PPP CHECKOUT www.andreas-guder.de 1/1 
if (defined('MODULE_PAYMENT_PAYPAL_PPP_STATUS') && MODULE_PAYMENT_PAYPAL_PPP_STATUS == 'True'){
  include DIR_FS_CATALOG.'includes/modules/payment/paypal_ppp/hook_checkout_success.php';
}
// EOF AGI PAYPAL-PPP CHECKOUT www.andreas-guder.de 1/1
require_once('admin/includes/classes/class.storagequantity.php');
include( DIR_WS_CLASSES.'order.php' );
require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');

require_once(DIR_FS_INC . 'xtc_address_label.inc.php');
require_once(DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'changedatain.inc.php');
if(!function_exists('xtc_get_product_path')){
  include( DIR_FS_INC.'xtc_get_product_path.inc.php');
}
function xtc_output_generated_category_path($id, $from = 'category') {
    $calculated_category_path_string = '';
    $calculated_category_path = xtc_generate_category_path($id, $from);
    for ($i = 0, $n = sizeof($calculated_category_path); $i < $n; $i++) {
      for ($j = 0, $k = sizeof($calculated_category_path[$i]); $j < $k; $j++) {
        $calculated_category_path_string .= $calculated_category_path[$i][$j]['text'] . '&nbsp;&gt;&nbsp;';
      }
      $calculated_category_path_string = substr($calculated_category_path_string, 0, -16) . '<br>';
    }
    $calculated_category_path_string = substr($calculated_category_path_string, 0, -4);

    if (strlen($calculated_category_path_string) < 1) {
        $calculated_category_path_string = TEXT_TOP;
    }
    return $calculated_category_path_string;
}

function xtc_generate_category_path($id, $from = 'category', $categories_array = '', $index = 0) {
    if (!is_array($categories_array)) {
        $categories_array = array();
    }

    if ($from == 'product') {
        $categories_query = \YES4Trade\Model\products_to_categories::get_items_by_products_id((int)$id);
        foreach($categories_query as $categories) {
            if (intval($categories->categories_id) == 0) {
                $categories_array[$index][] = array(
                    'id' => '0', 
                    'text' => TEXT_TOP
                );
            } else {
                $category = yes_query(sprintf(
                    "select cd.categories_name, c.parent_id from %s c, %s cd where c.categories_id =:cat_id and c.categories_id = cd.categories_id and cd.language_id =:language_id",
                        TABLE_CATEGORIES,TABLE_CATEGORIES_DESCRIPTION
                    ),[
                        'cat_id'=> intval($categories->categories_id),
                        'language_id'=>intval($_SESSION['languages_id'])
                    ],
                    true
                );
                $categories_array[$index][] = array(
                    'id' => $categories->categories_id, 
                    'text' => $category['categories_name']
                );
                if ( intval($category['parent_id']) > 0){
                    $categories_array = xtc_generate_category_path(
                        $category['parent_id'], 
                        'category', 
                        $categories_array, 
                        $index
                    );
                }
                $categories_array[$index] = xtc_array_reverse($categories_array[$index]);
            }
            $index++;
        }
    } elseif ($from == 'category') {
        $category = yes_query(sprintf(
            "select cd.categories_name, c.parent_id from %s c, %s cd where c.categories_id =:cat_id and c.categories_id = cd.categories_id and cd.language_id =:language_id",
                TABLE_CATEGORIES,TABLE_CATEGORIES_DESCRIPTION
            ),[
                'cat_id'=>intval($id),
                'language_id'=> intval($_SESSION['languages_id'])
            ],
            true
        );
        $categories_array[$index][] = array(
            'id' => $id, 
            'text' => $category['categories_name']
        );
        if ( intval($category['parent_id']) > 0) {
            $categories_array = xtc_generate_category_path(
                $category['parent_id'], 
                'category', 
                $categories_array, 
                $index
            );
        }
    }

    return $categories_array;
}

$smarty = new yesSmarty;
// include boxes
$YesBoxes->load( $smarty, basename(__FILE__) );
  // include needed functions
  require_once(DIR_FS_INC . 'xtc_draw_checkbox_field.inc.php');
  require_once(DIR_FS_INC . 'xtc_draw_selection_field.inc.php');
  require_once(DIR_FS_INC . 'xtc_image_button.inc.php');

  // if the customer is not logged on, redirect them to the shopping cart page
  if (!isset($_SESSION['customer_id'])) {
	if($_SESSION['payment'] == 'yes_amazon_pay'){
	}
	xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
  }

  if (isset($_GET['action']) && ($_GET['action'] == 'update')) {
    $notify_string = 'action=notify&';
    $notify = $_POST['notify'];
    if (!is_array($notify)) $notify = array($notify);
    for ($i=0, $n=sizeof($notify); $i<$n; $i++) {
      $notify_string .= 'notify[]=' . $notify[$i] . '&';
    }
    if (strlen($notify_string) > 0) $notify_string = substr($notify_string, 0, -1);
    if ($_SESSION['account_type']!=1) {
    xtc_redirect(xtc_href_link(FILENAME_DEFAULT, $notify_string));
    } else {
    xtc_redirect(xtc_href_link(FILENAME_LOGOFF, $notify_string));
    }

}

$breadcrumb->add(NAVBAR_TITLE_1_CHECKOUT_SUCCESS);
$breadcrumb->add(NAVBAR_TITLE_2_CHECKOUT_SUCCESS);

$global = \YES4Trade\Model\customers_info::get_by_customers_info_id(
        intval($_SESSION['customer_id']),[
            'global_product_notifications'
        ]
);

$orders = yes_query(sprintf(
    "select orders_id,orders_status,customers_city,customers_state,customers_country,payment_class,comments from %s where customers_id =:customers_id order by date_purchased desc limit 1",
        TABLE_ORDERS
    ),['customers_id'=>(int)$_SESSION['customer_id']],
    true
);
$order = new order($orders['orders_id'],$xtPrice);
if(is_file('CheckoutByAmazon/amazon_checkout_success.php')){
    $last_order = $orders['orders_id'];
    $orders_status = $orders['orders_status'];
    include_once('CheckoutByAmazon/amazon_checkout_success.php');
}

if (intval($global->global_product_notifications) != 1) {
    $products_array = array();
    $products_query = yes_query(sprintf(
        "select products_id, products_name from %s where orders_id =:orders_id order by products_name",
            TABLE_ORDERS_PRODUCTS
        ),['orders_id'=>(int)$orders['orders_id']]
    );
    foreach($products_query as $products) {
        $products_array[] = array(
            'id' => $products['products_id'],
            'text' => $products['products_name']
        );
    }
}
  
$coupon_data = array();
if(isset( $_SESSION['cc_id'] ) and is_numeric($_SESSION['cc_id'])){
    $parameters = [
        'cc_id'=>$_SESSION['cc_id'],
        'languages_id'=>$_SESSION['languages_id']
    ];
    $coupon_query_raw = sprintf(
        "SELECT c.coupon_code,cd.coupon_name,coupon_description FROM %s c LEFT JOIN %s cd USING(coupon_id) WHERE c.coupon_id=:cc_id AND cd.language_id=:languages_id",
        TABLE_COUPONS,TABLE_COUPONS_DESCRIPTION
    );
    $coupon_data = yes_query($coupon_query_raw, $parameters,true);
}

$gtc_js = '';

require(DIR_WS_INCLUDES . 'header.php');
$notifications = '';
if (intval($global->global_product_notifications) != 1) {
    $notifications= '<p class="productsNotifications">';
    $products_displayed = array();
    for ($i=0, $n=sizeof($products_array); $i<$n; $i++) {
        if (!in_array($products_array[$i]['id'], $products_displayed)) {
            $notifications.=  xtc_draw_checkbox_field('notify[]', $products_array[$i]['id']) . ' ' . $products_array[$i]['text'] . '<br>';
            $products_displayed[] = $products_array[$i]['id'];
        }
    }

    $notifications.=  '</p>';
}

// KEIN PLAN OB $HPOUTPUT IRGENDWO VORHER GESETZT WIRD
// ICH WEISS NICHT WAS DAS IST UND WENN SIE NICHT GESETZT IST
// MACH ICH NEN LEEREN STRING DRAUS
$HPOUTPUT_WEISSNICHT_WARDRIN = (isset($HPOUTPUT))?$HPOUTPUT:'';
$smarty->assign(array(
    'NOTIFICATION_BLOCK'=>$notifications,
    'FORM_ACTION'=>xtc_draw_form('order', xtc_href_link(FILENAME_CHECKOUT_SUCCESS, 'action=update', 'SSL')),
    'BUTTON_CONTINUE'=>xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE),
    'BUTTON_PRINT'=>'<img src="'.'templates/'.CURRENT_TEMPLATE.'/buttons/' . $_SESSION['language'].'/button_print.gif" style="cursor:hand" onClick="window.open(\''
        . xtc_href_link(FILENAME_PRINT_ORDER,'oID='.$orders['orders_id'])
        .'\', \'popup\', \'toolbar=0, width=640, height=600\')">'
        . $HPOUTPUT_WEISSNICHT_WARDRIN,
));

 // GV Code Start
$gvc = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id(intval($_SESSION['customer_id']));
if($gvc !== null){
    if ((float)$gvc->amount > 0) {
        $smarty->assign('GV_SEND_LINK', xtc_href_link(FILENAME_GV_SEND));
    }
}
 // GV Code End
 // Google Conversion tracking
if (defined('GOOGLE_CONVERSION') and GOOGLE_CONVERSION == 'true') {
    $smarty->assign('google_tracking','true');
    $smarty->assign('tracking_code','
<noscript>
<a href="http://services.google.com/sitestats/'.GOOGLE_LANG.'.html" target=_blank>
<img height=27 width=135 border=0 src="http://www.googleadservices.com/pagead/conversion/'.GOOGLE_CONVERSION_ID.'/?hl='.GOOGLE_LANG.'">
</a>
</noscript>
    ');

 }
 // CALC NETTOSUM
 $netto_products = 0;
 $order_products = array();
 for($i=0;$i<sizeOf($order->products);$i++){
    $price = ($order->products[$i]['tax'] > 0) ? xtc_oe_get_price_o_tax($order->products[$i]['final_price'],$order->products[$i]['tax'],0) : $order->products[$i]['final_price'];
    $netto_products += $price;
    $order->products[$i]['characteristics'] = yes_get_products_characteristics(xtc_get_prid($order->products[$i]['id']));
    $order_products[] = $order->products[$i];
 }
 

$smarty->assign(array(
     'NETTO_PRODUCTS' => number_format($netto_products,2,'.',''),
     'PRODUCTS'=>$order_products
));
$smarty->assign('ORDERS_ID', $orders['orders_id']);


if (defined('DOWNLOAD_ENABLED') and DOWNLOAD_ENABLED == 'true')	{
    include(DIR_WS_MODULES . 'downloads.php');
}
$smarty->assign('language', $_SESSION['language']);
if(isset($payment_block)){
    $smarty->assign('PAYMENT_BLOCK',$payment_block);
}
$smarty->caching = 0;
$ot_total = 0;
foreach($order->totals as $total){
    switch($total['class']){
        case 'ot_total':
            $ot_total = $total['value'];
            break;
    }
}
$smarty->assign(array(
	'email_address'=>$order->customer['email_address'],
	'BRUTTO'=>$ot_total,
	'CURRENCY'=>$order->info['currency'],
	'PAYMENT_METHOD'=>$order->info['payment_method'],
	'CUSTOMERS_ID'=>$order->customer['id'],
	'COUPON_DATA'=>$coupon_data
));
$main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/checkout_success.html');
if($_SESSION['payment'] == 'yes_amazon_pay'){
    require_once(DIR_FS_CATALOG.'includes'.DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.'payment'.DIRECTORY_SEPARATOR.'yes_amazon_pay.php');
    $yap = new yes_amazon_pay();
    $main_content .= $yap->getLogoutJavascript();
}

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');
