<?php
/* -----------------------------------------------------------------------------------------
   $Id: create_account.php,v 1.39 2020/02/11 13:02:49 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(create_account.php,v 1.63 2003/05/28); www.oscommerce.com
   (c) 2003  nextcommerce (create_account.php,v 1.27 2003/08/24); www.nextcommerce.org 

   Released under the GNU General Public License 
   -----------------------------------------------------------------------------------------
   Third Party contribution:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org


   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

/**
 * remove:
 * ACCOUNT_COMPANY_VAT_GROUP
 * DEFAULT_CUSTOMERS_VAT_STATUS_ID_LOCAL
 * ACCOUNT_VAT_BLOCK_ERROR
 * DEFAULT_CUSTOMERS_VAT_STATUS_ID
 * 
 * ADD config.ebayapi: YES_CREATE_ACCOUNT_V2 True
 */

require_once(DIR_WS_CLASSES.'yesCaptcha.php');
$captcha_lang = (isset($_SESSION['language']) and $_SESSION['language'] == 'english') ? 'english' : 'german';
$captcha = new yesTextCaptcha($captcha_lang);
if(defined('MODULE_OTHER_TURNSTILE_STATUS') and constant('MODULE_OTHER_TURNSTILE_STATUS') == 'True'){
    require_once(DIR_WS_MODULES.'other/turnstile.php');
    require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/other/turnstile.php');
    $turnstile = true;
    $turnstile_class = new \turnstile();
}

$dob = false;
$process = false;
if (isset($_POST['action']) && ($_POST['action'] == 'process')) {
    $_SESSION['last_post_create_account'] = $_POST;
    // BOF - FIRST: CAPTCHA CHECK
    if(!$turnstile){
        $msg = $captcha->check(false); // false = _POST
        
        if(isset($_POST['captcha_result'])){
            $captcha_success = ($msg == $captcha->lng['captcha_incorrect']) ? false : true;
        }else{
            if(!isset($_SESSION['vvcode']) or empty($_SESSION['vvcode']) or !isset($_POST['vvcode']) or empty($_POST['vvcode'])){
            $captcha_success = false;    		
            }else{
                $captcha_success = $_POST['vvcode'] == $_SESSION['vvcode'];
            }
        }
    }else{
        $captcha_success = false;
        if($turnstile_class->verify()){
            $captcha_success = true;
        }
    }
    
    if(!$captcha_success){
        // error report hier einbauen
        $messageStack->add_session('create_account',($turnstile)?TEXT_CAPTCHA_FAILED:ERROR_CAPTCHA);
        xtc_redirect(xtc_href_link('create_account.php',xtc_get_all_get_params()));
    }
    // EOF - FIRST: CAPTCHA CHECK
    
    $error = false;
    $process = true;
    $customers_status_array = xtc_get_customers_statuses();
    $display_cs = [];
    foreach($customers_status_array as $cs){
        $cs_allow = true;
        switch($cs['id']){
            case 0:
            case 1:
                $cs_allow = false;
                break;
        }
        if(!$cs_allow){
            continue; // gast und admin nicht auswaehlbar
        }
        switch($cs['csa_public']){
            case 1:
                $display_cs[] = ['id'=>$cs['id'],
                    'text'=>$cs['text'],
                    'description'=>(!empty($cs['customers_status_description']))?$cs['customers_status_description']:'Es wurde keine Beschreibung für Kundengruppe '.$cs['text'].' hinterlegt.',
                ];
                break;
        }
    }
    $account_type = intval($_GET['account_type'] ?? 0);
    
    if(sizeOf($display_cs) and $account_type == 0){
        $messageStack->add('create_account', MSG_ERROR_NO_ACCOUNT_TYPE_SELECTION);
        $error = true;
    }
    $vat_check = (ACCOUNT_COMPANY_VAT_CHECK == 'true') ? true : false;
    if($account_type>0){
        if(intval(DEFAULT_CUSTOMERS_STATUS_ID) == $account_type){
            $vat_check = false;
        }
    }
    if(sizeOf($display_cs)){
        $customer_group = $account_type;
        $cs_exists = false;
        foreach($display_cs as $cs){
            if(intval($cs['id']) == $customer_group){
                $cs_exists = true;
            }
        }
        if(!$cs_exists){
            $messageStack->add('create_account', 'Unbekannte / falsche Kundengruppe');
            $error = true;
        }
    }else{
        $customer_group = intval(DEFAULT_CUSTOMERS_STATUS_ID);
    }
    // WENN $vat_check AUF TRUE IST, DANN HAT DER KUNDE GEWAEHLT DAS ER KEIN
    // PRIVATKUNDE SONDERN EIN FIRMENKUNDE IST
    
    if ($vat_check){
        $vat = trim($_POST['vat']??'');
        try{
            if(!yes_check_vat_id($vat)){
                $messageStack->add('create_account', ENTRY_VAT_ERROR);
                $error = true;
            }
        }catch( Exception $e){
                $messageStack->add('create_account', $e->getMessage());
                $error = true;
        }
    }
    
    if (ACCOUNT_GENDER == 'true') {
        $gender = xtc_db_input($_POST['gender']);
    }
    $firstname = xtc_db_input($_POST['firstname']);
    $lastname = xtc_db_input($_POST['lastname']);
    
    if (isset($_REQUEST['dob']) and !empty($_REQUEST['dob'])){
	$dob = xtc_db_input($_POST['dob']);
    }
    
    $email_address = xtc_db_input($_POST['email_address']);
    if (ACCOUNT_COMPANY == 'true' or $vat_check) {
        $company = xtc_db_input($_POST['company']);
    }
    $street_address = xtc_db_input($_POST['street_address']);
    if (ACCOUNT_SUBURB == 'true') {
        $suburb = xtc_db_input($_POST['suburb']);
    }
    $postcode = xtc_db_input($_POST['postcode']);
    $city = xtc_db_input($_POST['city']);
    $zone_id = (int)xtc_db_input($_POST['zone_id']);
    if (ACCOUNT_STATE == 'true') {
        $state = xtc_db_input($_POST['state']);
    }
    $country = (int)xtc_db_input($_POST['country']);
    $telephone = xtc_db_input($_POST['telephone']);
    $fax = xtc_db_input($_POST['fax']);
    $newsletter = xtc_db_input($_POST['newsletter']);
    
    $guest_account = false;
    if(!isset($_POST['guest_account']) or $_POST['guest_account'] != 'guest' ){
        $password = xtc_db_input($_POST['password']);
        $confirmation = xtc_db_input($_POST['confirmation']);
    }else{
        $password = xtc_create_password(8);
        $guest_account = true;
    }

    if (ACCOUNT_GENDER == 'true') {
        if ( ($gender != 'm') && ($gender != 'f') ) {
            $error = true;
            $messageStack->add('create_account', ENTRY_GENDER_ERROR);
        }
    }

    if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
        $error = true;
        $messageStack->add('create_account', ENTRY_FIRST_NAME_ERROR);
    }

    if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
        $error = true;
        $messageStack->add('create_account', ENTRY_LAST_NAME_ERROR);
    }

    if (ACCOUNT_DOB == 'true' and ENTRY_DOB_MIN_LENGTH > 0) {
        if (DateTime::createFromFormat('Y-m-d', $dob) === false) {
            $error = true;
            $messageStack->add('create_account', ENTRY_DATE_OF_BIRTH_ERROR);
        }
    }
    if(ACCOUNT_DOB != 'true' and !empty($dob)){
        if (DateTime::createFromFormat('Y-m-d', $dob) === false) {
            $error = true;
            $messageStack->add('create_account', ENTRY_DATE_OF_BIRTH_ERROR);
        }
    }
        
    if(isset($_REQUEST['check_privacy']) and $_REQUEST['check_privacy'] == 1){
        if(!isset($_REQUEST['privacy']) or $_REQUEST['privacy'] != '1'){
            $error = true;
            $messageStack->add('create_account', ENTRY_PRIVACY_ERROR);
        }
    }

    if (strlen($email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {
        $error = true;
        $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_ERROR);
    } elseif (xtc_validate_email($email_address) == false) {
        $error = true;
        $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_CHECK_ERROR);
    } else {
        if(!$guest_account){
            $check_email = yes_query(sprintf(
                "select count(*) as total from %s where customers_email_address =:email AND customers_status != 1",
                    TABLE_CUSTOMERS
                ),['email'=>$email_address],
                true
            );
            if ($check_email['total'] > 0) {
                $error = true;
                $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_ERROR_EXISTS);
            }
        }
    }

    if (strlen($street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
        $error = true;
        $messageStack->add('create_account', ENTRY_STREET_ADDRESS_ERROR);
    }

    if (strlen($postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
        $error = true;
        $messageStack->add('create_account', ENTRY_POST_CODE_ERROR);
    }

    if (strlen($city) < ENTRY_CITY_MIN_LENGTH) {
        $error = true;
        $messageStack->add('create_account', ENTRY_CITY_ERROR);
    }

    if (is_numeric($country) == false) {
        $error = true;
        $messageStack->add('create_account', ENTRY_COUNTRY_ERROR);
    }

    if (ACCOUNT_STATE == 'true') {
        $zone_id = 0;
        $check = yes_query(sprintf(
            "select count(*) as total from %s where zone_country_id =:country",
                TABLE_ZONES
            ),['country'=> $country],true
        );
        $entry_state_has_zones = (isset($check['total']) and intval($check['total']) > 0);
        if ($entry_state_has_zones == true) {
            $zone_query = yes_query(sprintf(
                    "select distinct zone_id from %s where zone_country_id =:country and (zone_name like :zone_name or zone_code like :zone_code)",
                    TABLE_ZONES,
                ),['country'=>$country,'zone_name'=>$state . "%",'zone_code'=>"%" . $state . "%"]
            );
            
            if(is_countable($zone_query) and sizeOf($zone_query) > 1) {
                $zone_query = yes_query(sprintf(
                        "select distinct zone_id from %s where zone_country_id =:country and zone_name =:zone_name",
                        TABLE_ZONES
                    ),['country'=>$country,'zone_name'=>$state]
                );
            }
            if (is_countable($zone_query) and sizeOf($zone_query) >= 1) {
                $zone = current($zone_query);
                $zone_id = $zone['zone_id'];
            } else {
                $error = true;
                $messageStack->add('create_account', ENTRY_STATE_ERROR_SELECT);
            }
        } else {
            if (strlen($state) < ENTRY_STATE_MIN_LENGTH) {
                $error = true;
                $messageStack->add('create_account', ENTRY_STATE_ERROR);
            }
        }
    }

    if (strlen($telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
        $error = true;
        $messageStack->add('create_account', ENTRY_TELEPHONE_NUMBER_ERROR);
    }

    if(!$guest_account){
        if (strlen($password) < ENTRY_PASSWORD_MIN_LENGTH) {
            $error = true;
            $messageStack->add('create_account', ENTRY_PASSWORD_ERROR);
        } elseif ($password != $confirmation) {
            $error = true;
            $messageStack->add('create_account', ENTRY_PASSWORD_ERROR_NOT_MATCHING);
        }
    }
    if(isset($_POST['newsletter']) and $_POST['newsletter'] == '1'){
        $newsletter = '1';
    }else{
        $newsletter = '0';
    }
    
    if ($error == false) {
        $_SESSION['last_post_create_account'] = null;
        unset($_SESSION['last_post_create_account']);
	if(!isset($customer_group)){
            $customers_status = DEFAULT_CUSTOMERS_STATUS_ID;
	}else{
            $customers_status = $customer_group;
	}
    if($guest_account === true){
        $customers_status = 1;
    }
	if($customers_status == '' or $customers_status == 0){
            $customers_status = 1; // WORKAROUND - NIEMALS ADMIN!
	}
      	$sql_data_array = array(
            'customers_vat_id' => $vat,
            'customers_vat_id_status' => intval($customers_vat_id_status),
            'customers_status' => intval($customers_status),
            'customers_firstname' => $firstname,
            'customers_lastname' => $lastname,
            'customers_email_address' => $email_address,
            'customers_telephone' => $telephone,
            'customers_fax' => $fax,
            'customers_newsletter' => $newsletter,
            'customers_password' => xtc_encrypt_password($password),
            'account_type'=>($guest_account)?1:0,
        );

	if (ACCOUNT_GENDER == 'true') {
            $sql_data_array['customers_gender'] = $gender;
        }
        
	if($dob != ''){
            $sql_data_array['customers_dob'] = $dob;
	}else{
	    $sql_data_array['customers_dob'] = '';
	}
        $new = new \YES4Trade\Model\customers($sql_data_array);
        $user_id = intval($new->create());
        
        $_SESSION['customer_id'] = $user_id;
        // LOGGING FUER SUCHE NACH DER STELLE WO ADMIN USER BEI
        // SHOPKAUF ERZEUGT WIRD - TICKET 2921
        $new = new \YES4Trade\Model\customers_memo([
            'customers_id'=>$user_id,
            'memo_date'=>date('Y-m-d H:i:s'),
            'memo_title'=>'Erzeugt mit customers_status='.$customers_status,
            'memo_text'=>'create account',
            'poster_id'=>0
        ]);
        $new->create();
      
        // BOF - customers_email_alias
        yes_remove_customers_email_alias($email_address, $user_id);
        // EOF - customers_email_alias
      
        xtc_write_user_info($user_id);
        
        $sql_data_array = array(
            'customers_id' => (int)$_SESSION['customer_id'],
            'entry_firstname' => $firstname,
            'entry_lastname' => $lastname,
            'entry_street_address' => $street_address,
            'entry_postcode' => $postcode,
            'entry_city' => $city,
            'entry_country_id' => (int)$country
        );

        if (ACCOUNT_GENDER == 'true') {
            $sql_data_array['entry_gender'] = $gender;
        }
        if (ACCOUNT_COMPANY == 'true') {
            $sql_data_array['entry_company'] = $company;
        }
        if (ACCOUNT_SUBURB == 'true') {
            $sql_data_array['entry_suburb'] = $suburb;
        }
        if (ACCOUNT_STATE == 'true') {
            if ($zone_id > 0) {
                $sql_data_array['entry_zone_id'] = (int)$zone_id;
                $sql_data_array['entry_state'] = '';
            } else {
                $sql_data_array['entry_zone_id'] = 0;
                $sql_data_array['entry_state'] = $state;
            }
        }
        $new = new \YES4Trade\Model\address_book($sql_data_array);
        $address_id = $new->create();
        
        $upd = new \YES4Trade\Model\customers([
            'customers_id'=>(int)$_SESSION['customer_id'],
            'customers_default_address_id'=>intval($address_id)
        ]);
        $upd->update();
        
        $new = new \YES4Trade\Model\customers_info([
            'customers_info_id'=>intval($_SESSION['customer_id']),
            'customers_info_number_of_logons'=>0, 
            'customers_info_date_account_created'=>date('Y-m-d H:i:s')
        ]);
        $new->create();
        
      
        // history
        $new = new \YES4Trade\Model\customers_memo([
            'customers_id'=>(int)$_SESSION['customer_id'],
            'memo_date'=>date('Y-m-d H:i:s'),
            'memo_title'=>'User angelegt',
            'memo_text'=>'Im Shop registriert.',
            'poster_id'=>0
        ]);
        $new->create();
        
      
        if (SESSION_RECREATE == 'True') {
            xtc_session_recreate();
        }

        $_SESSION['customer_first_name'] = $firstname;
        $_SESSION['customer_last_name'] = $lastname;
        $_SESSION['customer_default_address_id'] = $address_id;
        $_SESSION['customer_country_id'] = $country;
        $_SESSION['customer_zone_id'] = $zone_id;

        // restore cart contents
        $_SESSION['cart']->restore_contents();

        // build the message content
        $name = $firstname . ' ' . $lastname;


        // load data into array
        $module_content = array();
        $module_content = array(
            'MAIL_NAME' => $name,
            'CID' => $_SESSION['customer_id'],
            'MAIL_REPLY_ADDRESS' => EMAIL_SUPPORT_REPLY_ADDRESS,
            'MAIL_GENDER'=>$gender
        );

        // assign data to smarty
	$smarty = new yesSmarty;
        $smarty->assign('language', $_SESSION['language']);
        $smarty->assign('logo_path',HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
        $smarty->assign('content', $module_content);
        $smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
        $smarty->caching = false;
        
        // GV Code Start
        // ICW - CREDIT CLASS CODE BLOCK ADDED  ******************************************************* BEGIN
        if (NEW_SIGNUP_GIFT_VOUCHER_AMOUNT > 0) {
            $coupon_code = create_coupon_code();
            $new = new \YES4Trade\Model\coupons([
                'coupon_code'=>$coupon_code, 
                'coupon_type'=>'G', 
                'coupon_amount'=>(float)NEW_SIGNUP_GIFT_VOUCHER_AMOUNT, 
                'date_created'=>date('Y-m-d H:i:s')
            ]);
            $insert_id = $new->create();
            
            $new = new \YES4Trade\Model\coupon_email_track([
                'coupon_id'=>intval($insert_id), 
                'customer_id_sent'=>intval($_SESSION['customer_id']), 
                'sent_firstname'=>$firstname, 
                'sent_lastname'=>$lastname, 
                'emailed_to'=>$email_address, 
                'date_sent'=>date('Y-m-d H:i:s')
            ]);
            $new->create();
            $smarty->assign('SEND_GIFT','true');
            $smarty->assign('GIFT_AMMOUNT',$xtPrice->xtcFormat(NEW_SIGNUP_GIFT_VOUCHER_AMOUNT,true));
            $smarty->assign('GIFT_CODE',$coupon_code);
            $smarty->assign('GIFT_LINK',xtc_href_link(FILENAME_GV_REDEEM, 'gv_no=' . $coupon_code,'NONSSL', false));
        }
        if (NEW_SIGNUP_DISCOUNT_COUPON != '') {
            $coupon_code = NEW_SIGNUP_DISCOUNT_COUPON;
            $coupon = \YES4Trade\Model\coupons::get_by_coupon_code($coupon_code);
            $coupon_id = $coupon->coupon_id;
            
            $new = new \YES4Trade\Model\coupon_email_track([
                'coupon_id'=>intval($coupon_id), 
                'customer_id_sent'=>intval($_SESSION['customer_id']), 
                'sent_firstname'=>$firstname, 
                'sent_lastname'=>$lastname, 
                'emailed_to'=>$email_address, 
                'date_sent'=>date('Y-m-d H:i:s')
            ]);
            $new->create();
            $smarty->assign('SEND_COUPON','true');
            $coupon_desc = \YES4Trade\Model\coupons_description::get_by_coupon_id_and_language_id(
                intval($coupon_id),
                intval($_SESSION['languages_id']),
                ['coupon_description']
            );
            $smarty->assign('COUPON_DESC',$coupon_desc->coupon_description);
            $smarty->assign('COUPON_CODE',$coupon->coupon_code);
        }
            
        $smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
        $smarty->assign('STORE_NAME',STORE_NAME);

        if ($newsletter == 1) {
            require_once (DIR_WS_CLASSES.'class.newsletter.php');
            $newsletter = new newsletter;
            $newsletter->AddUserAuto($email_address);
	}
        
        // bof not guest
        if(!$guest_account){
            if(!main::isDev(true)){
                $smarty->caching = 0;
                $html_mail = $smarty->fetch(CURRENT_TEMPLATE . '/mail/'.$_SESSION['language'].'/create_account_mail.html');
                $smarty->caching = 0;
                $txt_mail = $smarty->fetch(CURRENT_TEMPLATE . '/mail/'.$_SESSION['language'].'/create_account_mail.txt');
                xtc_php_mail(EMAIL_SUPPORT_ADDRESS,EMAIL_SUPPORT_NAME,$email_address , $name , EMAIL_SUPPORT_FORWARDING_STRING, EMAIL_SUPPORT_REPLY_ADDRESS, EMAIL_SUPPORT_REPLY_ADDRESS_NAME, '', '', EMAIL_SUPPORT_SUBJECT, $html_mail, $txt_mail);
            }
        }
        if (!isset($mail_error)) {
            if(PAGE_AFTER_REGISTRATION > 0){
                xtc_redirect(xtc_href_link('shop_content.php', 'coID='.PAGE_AFTER_REGISTRATION, 'NONSSL'));
            }else{
                //BURAK - ANWEISUNG VOM 24.02.14, FUER ALLE KUNDEN - IMMER AUF WARENKORB NACH REGISTRATION
                //BURAK - NEUE ANWEISUNG VOM 27.10.17, WIEDER REIN - AUSSERDEM NEUER WERT -1
                if (PAGE_AFTER_REGISTRATION == -1 and isset($_SESSION['cart']) and $_SESSION['cart']->count_contents() > 0){
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING));
                }
                xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART, '', 'SSL'));
            }
        }else{
            if(!isset($_POST['guest'])){
                echo $mail_error;
            }
        }
    }
}

/**
 * Holt default value fuer ein Input Feld, wenn nach dem Submit die Daten
 * nochmal angezeigt werden müssen weil ein Fehler auftrat.
 * Dann ist $_SESSION['last_post_create_account'] gefuellt
 * 
 * @param string$key
 */
function gv( string $key ){
    if(isset($_SESSION['last_post_create_account']) && isset($_SESSION['last_post_create_account'][$key])){
        return $_SESSION['last_post_create_account'][$key];
    }
    return '';
}

$breadcrumb->add(NAVBAR_TITLE_CREATE_ACCOUNT, xtc_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'));
require(DIR_WS_INCLUDES . 'header.php');
if ($messageStack->size('create_account') > 0) {
    $smarty->assign('error',$messageStack->output('create_account'));
}

$smarty->assign('FORM_ACTION',xtc_draw_form('create_account', xtc_href_link(FILENAME_CREATE_ACCOUNT, xtc_get_all_get_params(), 'SSL'), 'post', 'onSubmit="return check_form(\'create_account\');"') . xtc_draw_hidden_field('action', 'process'));
$config_vars = $smarty->configLoad('lang/german/lang_german.conf','create_account');

if (ACCOUNT_GENDER == 'true') {
    $smarty->assign(array(
	'gender'=>'1',
	'INPUT_GENDER_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'gender',
	    'label'=>ENTRY_GENDER,
	    'type'=>'radio',
	    'required'=>true,
	    'required_text'=>ENTRY_GENDER_TEXT,
	    'values'=>array(
		array(
		    'label'=>MALE,
		    'value'=>'m',
                    'checked'=>((gv('gender') == 'm')?true:false),
		),
		array(
		    'label'=>FEMALE,
		    'value'=>'f',
                    'checked'=>((gv('gender') == 'f')?true:false),
		)
	    )
	)),
	'INPUT_MALE'=>xtc_draw_radio_field('gender', 'm',((gv('gender') == 'm')?true:false)),
	'INPUT_FEMALE'=>xtc_draw_radio_field('gender', 'f',((gv('gender') == 'f')?true:false)).(xtc_not_null(ENTRY_GENDER_TEXT) ? '<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>': '')
    ));
} else {
    $smarty->assign('gender','0');
}
$allow_guest_account = true;
$show_company = (ACCOUNT_COMPANY == 'true') ? true : false;
$required_company = true;
if(isset($_GET['account_type']) and $_GET['account_type']>0){
    if(DEFAULT_CUSTOMERS_STATUS_ID == $_GET['account_type']){
        $show_company = true;
        $required_company = false;
    }else{
        $allow_guest_account = false;
    }
}
if ($show_company) {
    $smarty->assign(array(
	'company'=>'1',
	'INPUT_COMPANY'=>xtc_draw_input_field('company',gv('company'))
            . '&nbsp;' . (xtc_not_null(ENTRY_COMPANY_TEXT) ? '<span class="inputRequirement">' . ENTRY_COMPANY_TEXT . '</span>': ''),
	'INPUT_COMPANY_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'company',
	    'label'=>ENTRY_COMPANY,
	    'type'=>'text',
	    'required'=>$required_company,
	    'minlength'=>ENTRY_COMPANY_MIN_LENGTH,
	    'maxlength'=>64,
            'placeholder'=>$config_vars->config_vars['placeholder_company'],
	    'required_text'=>ENTRY_COMPANY_TEXT,
            'value'=>gv('company')
	))
    ));
}  else {
    $smarty->assign('company','0');
}

$show_vat = (ACCOUNT_COMPANY_VAT_CHECK == 'true') ? true : false;
if(isset($_GET['account_type']) and $_GET['account_type']>0){
    if(DEFAULT_CUSTOMERS_STATUS_ID == $_GET['account_type']){
        $show_vat = false;
    }
}
if ($show_vat) {
    $smarty->assign(array(
	'vat'=>'1',
	'INPUT_VAT'=>xtc_draw_input_field('vat',gv('vat')) . '&nbsp;' . (xtc_not_null(ENTRY_VAT_TEXT) ? '<span class="inputRequirement">' . ENTRY_VAT_TEXT . '</span>': ''),
	'INPUT_VAT_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'vat',
	    'label'=>ENTRY_VAT_ID,
	    'type'=>'text',
	    'required'=>$show_vat,
	    'maxlength'=>20,
	    'minlength'=>1,
            'placeholder'=>$config_vars->config_vars['placeholder_vat'],
	    'required_text'=>ENTRY_VAT_TEXT,
            'value'=>gv('vat')
	))
    ));
}  else {
    $smarty->assign('vat','0');
}



$dob_str = (ACCOUNT_DOB == 'true' and xtc_not_null(ENTRY_DATE_OF_BIRTH_TEXT)) ? '&nbsp;<span class="inputRequirement">' . ENTRY_DATE_OF_BIRTH_TEXT . '</span>': '';
if (isset($_POST['country'])){
	$selected_country = (int)xtc_db_input($_POST['country']);
}else{
	$selected_country = STORE_COUNTRY;
}
$countries_array = xtc_get_countries();
$countries = array();
foreach($countries_array as $c){
    $countries[] = array('id'=>$c['countries_id'],'name'=>xtc_db_prepare_input($c['countries_name']));
}
$smarty->assign(array(
    'INPUT_FIRSTNAME'=>xtc_draw_input_field('firstname',gv('firstname')) . '&nbsp;' . (xtc_not_null(ENTRY_FIRST_NAME_TEXT) ? '<span class="inputRequirement">' . ENTRY_FIRST_NAME_TEXT . '</span>': ''),
    'INPUT_FIRSTNAME_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'firstname',
	'label'=>ENTRY_FIRST_NAME,
	'type'=>'text',
	'required'=>((defined('ENTRY_FIRST_NAME_MIN_LENGTH') and ENTRY_FIRST_NAME_MIN_LENGTH > 0) ? true : false),
	'minlength'=>ENTRY_FIRST_NAME_MIN_LENGTH,
	'maxlength'=>64,
	'placeholder'=>$config_vars->config_vars['placeholder_firstname'],
	'required_text'=>ENTRY_FIRST_NAME_TEXT,
        'value'=>gv('firstname')
    )),
    'INPUT_LASTNAME'=>xtc_draw_input_field('lastname',gv('lastname')) . '&nbsp;' . (xtc_not_null(ENTRY_LAST_NAME_TEXT) ? '<span class="inputRequirement">' . ENTRY_LAST_NAME_TEXT . '</span>': ''),
    'INPUT_LASTNAME_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'lastname',
	'label'=>ENTRY_LAST_NAME,
	'type'=>'text',
	'required'=>((defined('ENTRY_LAST_NAME_MIN_LENGTH') and ENTRY_LAST_NAME_MIN_LENGTH > 0) ? true : false),
	'minlength'=>ENTRY_LAST_NAME_MIN_LENGTH,
	'maxlength'=>64,
	'placeholder'=>$config_vars->config_vars['placeholder_lastname'],
	'required_text'=>ENTRY_LAST_NAME_TEXT,
        'value'=>gv('lastname')
    )),
    'birthdate'=>'1',
    'INPUT_DOB'=>xtc_draw_input_field('dob',gv('dob')).$dob_str,
    'INPUT_DOB_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'dob',
	'label'=>ENTRY_DATE_OF_BIRTH,
	'type'=>'date',
	'required'=>((ACCOUNT_DOB == 'true') ? true : false),
	'maxlength'=>10,
	'minlength'=>ENTRY_DOB_MIN_LENGTH,
	'placeholder'=>$config_vars->config_vars['placeholder_dob'],
        'value'=>gv('dob'),
    )),
    'INPUT_EMAIL'=>xtc_draw_input_field('email_address',gv('email_address')) . '&nbsp;' . (xtc_not_null(ENTRY_EMAIL_ADDRESS_TEXT) ? '<span class="inputRequirement">' . ENTRY_EMAIL_ADDRESS_TEXT . '</span>': ''),
    'INPUT_EMAIL_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'email_address',
	'label'=>ENTRY_EMAIL_ADDRESS,
	'type'=>'email',
	'required'=>true,
	'maxlength'=>255,
	'minlength'=>ENTRY_EMAIL_ADDRESS_MIN_LENGTH,
	'placeholder'=>$config_vars->config_vars['placeholder_email'],
	'required_text'=>ENTRY_EMAIL_ADDRESS_TEXT,
        'value'=>gv('email_address')
    )),
    'INPUT_STREET'=>xtc_draw_input_field('street_address',gv('street_address')) . '&nbsp;' . (xtc_not_null(ENTRY_STREET_ADDRESS_TEXT) ? '<span class="inputRequirement">' . ENTRY_STREET_ADDRESS_TEXT . '</span>': ''),
    'INPUT_STREET_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'street_address',
	'label'=>ENTRY_STREET_ADDRESS,
	'type'=>'text',
	'required'=>true,
	'maxlength'=>128,
	'minlength'=>ENTRY_STREET_ADDRESS_MIN_LENGTH,
	'placeholder'=>$config_vars->config_vars['placeholder_street'],
	'required_text'=>ENTRY_STREET_ADDRESS_TEXT,
        'value'=>gv('street_address')
    )),
    'INPUT_CODE'=>xtc_draw_input_field('postcode') . '&nbsp;' . (xtc_not_null(ENTRY_POST_CODE_TEXT) ? '<span class="inputRequirement">' . ENTRY_POST_CODE_TEXT . '</span>': ''),
    'INPUT_CODE_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'postcode',
	'label'=>ENTRY_POST_CODE,
	'type'=>'text',
	'required'=>true,
	'maxlength'=>16,
	'minlength'=>ENTRY_POSTCODE_MIN_LENGTH,
	'placeholder'=>$config_vars->config_vars['placeholder_postcode'],
	'required_text'=>ENTRY_POST_CODE_TEXT,
        'value'=>gv('postcode')
    )),
    'INPUT_CITY'=>xtc_draw_input_field('city') . '&nbsp;' . (xtc_not_null(ENTRY_CITY_TEXT) ? '<span class="inputRequirement">' . ENTRY_CITY_TEXT . '</span>': ''),
    'INPUT_CITY_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'city',
	'label'=>ENTRY_CITY,
	'type'=>'text',
	'required'=>true,
	'maxlength'=>128,
	'minlength'=>ENTRY_CITY_MIN_LENGTH,
	'placeholder'=>$config_vars->config_vars['placeholder_city'],
	'required_text'=>ENTRY_CITY_TEXT,
        'value'=>gv('city')
    )),
    'SELECT_COUNTRY'=>xtc_get_country_list('country', $selected_country) . '&nbsp;' . (xtc_not_null(ENTRY_COUNTRY_TEXT) ? '<span class="inputRequirement">' . ENTRY_COUNTRY_TEXT . '</span>': ''),
    'INPUT_COUNTRY_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'country',
	'label'=>ENTRY_COUNTRY,
	'type'=>'select',
	'required'=>true,
	'default_value'=>$selected_country,
	'options'=>  $countries,
	'required_text'=>ENTRY_COUNTRY_TEXT
    )),
    'INPUT_TEL'=>xtc_draw_input_field('telephone') . '&nbsp;' . ((ENTRY_TELEPHONE_MIN_LENGTH>0) ? '<span class="inputRequirement">' . ENTRY_TELEPHONE_NUMBER_TEXT . '</span>': ''),
    'INPUT_TEL_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'telephone',
	'label'=>ENTRY_TELEPHONE_NUMBER,
	'type'=>'tel',
	'required'=>(ENTRY_TELEPHONE_MIN_LENGTH>0)?true:false,
	'minlength'=>ENTRY_TELEPHONE_MIN_LENGTH,
	'maxlength'=>32,
	'placeholder'=>(defined('ENTRY_TELEPHONE_PLACEHOLDER') and ENTRY_TELEPHONE_PLACEHOLDER != '') ? ENTRY_TELEPHONE_PLACEHOLDER : '',
	'required_text'=>ENTRY_TELEPHONE_NUMBER_TEXT,
        'value'=>gv('telephone')
    )),
    'INPUT_FAX'=>xtc_draw_input_field('fax') . '&nbsp;' . (xtc_not_null(ENTRY_FAX_NUMBER_TEXT) ? '<span class="inputRequirement">' . ENTRY_FAX_NUMBER_TEXT . '</span>': ''),
    'INPUT_FAX_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'fax',
	'label'=>ENTRY_FAX_NUMBER,
	'type'=>'tel',
	'required'=>false,
	'maxlength'=>32,
	'placeholder'=>(defined('ENTRY_FAX_NUMBER_PLACEHOLDER') and ENTRY_FAX_NUMBER_PLACEHOLDER != '') ? ENTRY_FAX_NUMBER_PLACEHOLDER : '',
	'required_text'=>ENTRY_FAX_NUMBER_TEXT,
        'value'=>gv('fax')
    )),
    'CHECKBOX_NEWSLETTER'=>xtc_draw_checkbox_field('newsletter', '1') . '&nbsp;' . (xtc_not_null(ENTRY_NEWSLETTER_TEXT) ? '<span class="inputRequirement">' . ENTRY_NEWSLETTER_TEXT . '</span>': ''),
    'INPUT_NEWSLETTER_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'newsletter',
	'label'=>ENTRY_NEWSLETTER,
	'type'=>'checkbox',
	'required'=>false,
	'value'=>'1',
        'checked'=>(gv('newsletter')=='1')?true:false
    )),
    'INPUT_PASSWORD'=>xtc_draw_password_field('password') . '&nbsp;' . (xtc_not_null(ENTRY_PASSWORD_TEXT) ? '<span class="inputRequirement">' . ENTRY_PASSWORD_TEXT . '</span>': ''),
    'INPUT_PASSWORD_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'password',
	'label'=>ENTRY_PASSWORD,
	'type'=>'password',
	'required'=>true,
	'required_text'=>ENTRY_PASSWORD_TEXT,
        'value'=>gv('password')
    )),
    'INPUT_GUEST_ACCOUNT_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'guest_account',
	'label'=>$config_vars->config_vars['guest_account_intro'],
	'type'=>'select',
        'options'=>[
            ['id'=>'','name'=>$config_vars->config_vars['guest_account_register']],
            ['id'=>'guest','name'=>$config_vars->config_vars['guest_account_noregister']]
        ],
        'default_value'=>gv('guest_account')
    )),
    'INPUT_CONFIRMATION'=>xtc_draw_password_field('confirmation') . '&nbsp;' . (xtc_not_null(ENTRY_PASSWORD_CONFIRMATION_TEXT) ? '<span class="inputRequirement">' . ENTRY_PASSWORD_CONFIRMATION_TEXT . '</span>': ''),
    'INPUT_CONFIRMATION_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'confirmation',
	'label'=>ENTRY_PASSWORD_CONFIRMATION,
	'type'=>'password',
	'required'=>true,
	'required_text'=>ENTRY_PASSWORD_CONFIRMATION_TEXT,
        'value'=>gv('confirmation')
    ))
));

if (ACCOUNT_SUBURB == 'true') {
    $smarty->assign(array(
	'suburb'=>'1',
	'INPUT_SUBURB'=>xtc_draw_input_field('suburb') . '&nbsp;' . (xtc_not_null(ENTRY_SUBURB_TEXT) ? '<span class="inputRequirement">' . ENTRY_SUBURB_TEXT . '</span>': ''),
	'INPUT_SUBURB_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'suburb',
	    'label'=>ENTRY_SUBURB,
	    'type'=>'text',
	    'required'=>false,
	    'maxlength'=>128,
            'placeholder'=>$config_vars->config_vars['placeholder_suburb'],
	    'required_text'=>ENTRY_SUBURB_TEXT
	))
    ));
} else {
    $smarty->assign('suburb','0');
}

if (ACCOUNT_STATE == 'true') {
    $zones_array = array();
    if ($process == true) {
	if ($entry_state_has_zones == true) {
	    $zones_query = yes_query(sprintf(
            "select zone_name from %s where zone_country_id =:country order by zone_name",
                TABLE_ZONES
            ),['country'=>(int)$country]
        );
	    foreach($zones_query as $zones_values) {
	        $zones_array[] = array(
                'id' => $zones_values['zone_name'], 
                'text' => $zones_values['zone_name']
            );
	    }
	    $state_input= xtc_draw_pull_down_menu('state', $zones_array);
	} else {
	    $state_input= xtc_draw_input_field('state');
	}
    } else {
	$state_input= xtc_draw_input_field('state');
    }
    if (xtc_not_null(ENTRY_STATE_TEXT)) 
	$state_input.= '&nbsp;<span class="inputRequirement">' . ENTRY_STATE_TEXT;
    $smarty->assign(array(
	'state'=>'1',
	'INPUT_STATE'=>$state_input,
	'INPUT_STATE_ARRAY'=>((sizeOf($zones_array)) ? 
	    yes_input_field::get_html(array(
		'name'=>'state',
		'label'=>ENTRY_STATE,
		'type'=>'select',
		'required'=>(ENTRY_STATE_MIN_LENGTH > 0) ? true : false,
		'options'=>$zones_array,
		'required_text'=>ENTRY_STATE_TEXT
	    )) : yes_input_field::get_html(array(
		'name'=>'state',
		'label'=>ENTRY_STATE,
		'type'=>'text',
		'required'=>(ENTRY_STATE_MIN_LENGTH > 0) ? true : false,
		'maxlength'=>128,
		'minlength'=>ENTRY_STATE_MIN_LENGTH,
		'placeholder'=>(defined('ENTRY_SUBURB_PLACEHOLDER') and ENTRY_SUBURB_PLACEHOLDER != '') ? ENTRY_SUBURB_PLACEHOLDER : '',
		'required_text'=>ENTRY_STATE_TEXT
	    ))
	)
    ));
} else {
	$smarty->assign('state','0');
}

$shop_content_data = yes_get_shop_content(2, $_SESSION['languages_id'],true);
if (isset($shop_content_data['content_file']) and $shop_content_data['content_file']!=''){
    $privacy= '<iframe SRC="'.$shop_content_data['content_file'].'" width="100%" height="300">';
    $privacy.= '</iframe>';
    $privacy_raw = $privacy;
} else {
    $privacy= '<textarea name="blabla" cols="60" rows="10" readonly="readonly">'.  $shop_content_data['content_text'].'</textarea>';
    $privacy_raw = $shop_content_data['content_text'];
}
$smarty->caching = 0;
$smarty->assign(array(
    'PRIVACY'=>$privacy,
    'PRIVACY_RAW'=>$privacy_raw,
    'PRIVACY_checkbox'=>'<input type="checkbox" id="privacy" name="privacy" value="1" '.((gv('privacy')==1)?'checked="checked"':"").'>',
    'language'=>$_SESSION['language'],
    'FORM_END'=>'</form>',
    'BUTTON_SUBMIT'=>xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE),
    'VVIMG'=>(!$turnstile)?'<img src="' . main::get_url_with_random_params(FILENAME_DISPLAY_VVCODES) . '" />':'',
    'INPUT_VVCODE'=>xtc_draw_input_field('vvcode','','size="6" maxlenght="6"',false,'',false),
    'ERROR_CAPTCHA'=>ERROR_CAPTCHA,
    'GUEST_ACCOUNT_SELECT'=>$allow_guest_account,
    'YES_CAPTCHA'=>($turnstile)?$turnstile_class->create():$captcha->create(),
));
$main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/create_account.html');
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');
