<?php
include('includes/application_top.php');
/*
xtc_db_query("TRUNCATE orders");
xtc_db_query("TRUNCATE orders_products");
xtc_db_query("TRUNCATE orders_status_history");
xtc_db_query("TRUNCATE ebay_auctions");
xtc_db_query("TRUNCATE ebay_auctions_variations");
xtc_db_query("UPDATE products SET in_auction=0");
exit;
*/
require_once(DIR_FS_CATALOG.'admin/includes/classes/class.ebay.php');
require_once(DIR_FS_CATALOG.'admin/includes/classes/class.storagequantity.php');
require_once(DIR_FS_CATALOG.'admin/includes/classes/class.basics.php');
require_once(DIR_FS_INC.'xtc_collis.inc.php');
require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_ServiceProxy.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/GetMyeBaySellingRequestType.php';
function getTimeLeftDate($date){
	$d = substr($date,1,strlen($date));
	$tpos = strpos($d,'T');
	$hpos = strpos($d,'H');
	$mpos = strpos($d,'M');
	if(substr($d,0,1) == 'T'){
		$days = 0;
	}else{
		$days = substr($d,0,$tpos-1);
	}
	$hlen = $hpos-$tpos-1;
	$mlen = $mpos-$hpos-1;
	$hours = substr($d,$tpos+1,$hlen);
	$minutes = substr($d,$hpos+1,$mlen);
	$endTime = date('Y-m-d H:i:s',time()+(60*$minutes)+(60*60*$hours)+(60*60*24*$days));
	return $endTime;
}
function _process1($items,$user){
	global $unknown;
	$array = array();
	foreach($items as $item){
		$endTime = (isset($item->ListingDetails->EndTime)) ? $item->ListingDetails->EndTime : '';
		$auctionPrice = 0;
		$binPrice = 0;
		if($item->ListingType == 'Chinese'){
			$auctionPrice = $item->StartPrice->value;
		}else{
			$auctionPrice = $item->BuyItNowPrice->value;
		}

		$products_id_query = xtc_db_query(sprintf(
			"SELECT products_id, products_image FROM products WHERE afterbuy_unique_id='%s'",
			$item->SKU
		));
		$products_id = 0;
		$picture = '';
		$import = false;
		if($item->ListingDuration == 'GTC'){
			$duration = 0;
			$endTime = 'now()';
		}else{
			$parts = explode('_',$item->ListingDuration);
			$duration = $parts[1];
			$endTime = getTimeLeftDate();
		}
		if(xtc_db_num_rows($products_id_query)){
			$product = xtc_db_fetch_array($products_id_query);
			$products_id = $product['products_id'];
			$picture = $product['products_image'];
			$import = true;
		}
		if($item->Variations){
			foreach($item->Variations->Variation as $variation){
				if($picture == ''){
					$vproducts_id_query = xtc_db_query(sprintf(
						"SELECT products_id, products_image FROM products WHERE afterbuy_unique_id='%s'",
						$variation->SKU
					));
					if(xtc_db_num_rows($vproducts_id_query)){
						$vproduct = xtc_db_fetch_array($vproducts_id_query);
						$picture = $vproduct['products_image'];
						$import = true;
					}
				}
			}
		}
		if(!$import){
			$unknown++;
			continue;
		}
		$insert_sql_array = array(
			'ebay_id'=>$item->ItemID,
			'products_id'=>$products_id,
			'start_time'=>$item->ListingDetails->StartTime,
			'end_time'=>$endTime,
			'title'=>$item->Title,
			'type'=>$item->ListingType,
			'auctionprice'=>$auctionPrice,
			'buyitnowprice'=>$binPrice,
			'picture'=>$picture,
			'duration'=>$duration,
			'quantity'=>$item->Quantity,
			'current_auctionprice'=>$item->SellingStatus->CurrentPrice->value,
			'quantity_sold'=>(int)$item->SellingStatus->QuantitySold,
			'status'=>0,
			'vat'=>1,
			'site'=>'Germany',
			'country'=>'DE',
			'user'=>$user,
			'sku'=>$item->SKU
		);
		xtc_db_perform('ebay_auctions',$insert_sql_array);
		$auctions_id = xtc_db_insert_id();
		if($products_id > 0){
			xtc_db_query(sprintf(
				"UPDATE products SET in_auction=in_auction+%s WHERE products_id='%s'",
				$item->Quantity,$products_id
			));
		}
		if($item->Variations){
			foreach($item->Variations->Variation as $variation){
				$vproducts_id = 0;
				$vpicture = '';
				$vproducts_id_query = xtc_db_query(sprintf(
					"SELECT products_id, products_image FROM products WHERE afterbuy_unique_id='%s'",
					$variation->SKU
				));
				if(xtc_db_num_rows($vproducts_id_query)){
					$vproduct = xtc_db_fetch_array($vproducts_id_query);
					$vproducts_id = $vproduct['products_id'];
					$vpicture = $vproduct['products_image'];
					$insert_sql_array = array(
						'products_id'=>$vproducts_id,
						'quantity'=>$variation->Quantity,
						'sku'=>$variation->SKU,
						'ebay_auctions_id'=>$auctions_id,
						'quantity_sold'=>$variation->SellingStatus->QuantitySold,
						'price'=>$variation->StartPrice->value
					);
					xtc_db_perform('ebay_auctions_variations',$insert_sql_array);
					if($vproducts_id > 0){
						xtc_db_query(sprintf(
							"UPDATE products SET in_auction=in_auction+%s WHERE products_id='%s'",
							$variation->Quantity,$vproducts_id
						));
					}
				}
			}
		}
	}
}
$unknown = 0;
$q = xtc_db_query("SELECT user FROM ebay_auth WHERE environment='production'");
while($r = xtc_db_fetch_array($q)){
	$user[] = $r['user'];
}
if(!sizeOf($user))
	die('No active user');
$EBAYAPI = new ebayAPI();

$auctions = array();
for($uid = 0;$uid<sizeOf($user);$uid++){
	echo "PROCESSING USER ".$user[$uid]."\r\n";
	$page = 1;
	$session = new EbatNs_Session(ABS_PATH_TO_PHPAPI.'config/ebay.config.php');
	$session->setRequestToken( $EBAYAPI->getToken($user[$uid]) );
	$session->setSiteID(77);
	$cs = new EbatNs_ServiceProxy($session);
	$req = new GetMyeBaySellingRequestType();
	$AL = new ItemListCustomizationType;
	$AL->setInclude(true);
	$P = new PaginationType;
	$P->setEntriesPerPage(200);
	$P->setPageNumber($page);
	$AL->setPagination($P);
	$req->setActiveList($AL);
	$req->HideVariations = 'false';
	//$req->setOutputSelector('Item.ListingDetails');
	$res = $cs->GetMyeBaySelling($req);
	$auctions = array_merge($auctions,_process1($res->ActiveList->ItemArray,$user[$uid]));
	for($i=1;$i<$res->ActiveList->PaginationResult->TotalNumberOfPages;$i++){
		$req = new GetMyeBaySellingRequestType();
		$AL = new ItemListCustomizationType;
		$AL->setInclude(true);
		$P = new PaginationType;
		$P->setPageNumber($i+1);
		$AL->setPagination($P);
		$req->setActiveList($AL);
		$res = $cs->GetMyeBaySelling($req);
		$auctions = array_merge($auctions,_process1($res->ActiveList->ItemArray,$user[$uid]));
	}
}
die("\r\n\r\nDONE ".sizeOf($auctions)." - $unknown unknown Auctions\r\n");

