<?php
/**
 * TESTUSER_2ndseller
 * yes2ndseller@web.de:YESPOWER-01
 */

use DTS\eBaySDK\Trading\Types\PaginationType;
use SellingPartnerApi\Model\CatalogItemsV20201201\Pagination;

if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
	die('unauthorized http call');
}
ini_set('memory_limit','1200M');
include('includes/application_top.php');
require_once('includes/classes/product.php');
require_once('admin/includes/classes/class.ebay.php');
require_once('admin/includes/classes/class.storagequantity.php');
require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');
require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
require_once(DIR_FS_INC.'xtc_get_products_name.inc.php');
require_once('lang/german/modules/order_total/ot_total.php');
require_once('lang/german/modules/order_total/ot_subtotal.php');
require_once('lang/german/modules/order_total/ot_shipping.php');
require_once('lang/german/modules/order_total/ot_tax.php');
require_once(DIR_FS_INC.'yes_products_calc_in_auction_quantity.inc.php');
require_once(DIR_FS_INC.'yes_get_shop_content.inc.php');
require_once(DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
date_default_timezone_set('Europe/Berlin');
$check_constants = ['EBAY_ADDRESS_FORMAT_ID','EBAY_CUSTOMERS_STATUS','EBAY_DEFAULT_GENDER','EBAY_CUSTOMERS_STATUS_NAME','EBAY_CUSTOMERS_STATUS'];
$EBAYAPI = new ebayAPI;
$smarty = new yesSmarty;

foreach($check_constants as $c){
    if(!defined($c)){
        throw new Exception($c.' is not defined.');
    }
    if($c == 'EBAY_DEFAULT_GENDER' && empty(constant($c))){
        printf("check constant %s: success but empty value\n", $c);
    }else{
        if(empty(constant($c))){
            throw new Exception($c.' is empty.');
        }else{
            printf("check constant %s: success (Value: %s)\n",$c,constant($c));
        }
    }
}
$check_functions = ['xtc_encrypt_password','yes_get_country_id_from_iso2','yes_remove_customers_email_alias','xtc_get_lang_path_from_ebay_site','xtc_get_country_name'];
foreach($check_functions as $f){
    if(!function_exists($f)){
    	switch($f){
    		case 'yes_remove_customers_email_alias':
			require_once(DIR_FS_INC.'yes_customers_email_alias_functions.inc.php');
			break;
		default:
			if(!is_file(DIR_FS_INC.$f.'.inc.php')){
			    throw new Exception('Function '.$f.' has no file in inc/');
			}
			require_once(DIR_FS_INC.$f.'.inc.php');
	}
    }
}

if(!function_exists('xtc_get_product_collies')){
    require_once(DIR_FS_INC.'xtc_collies.inc.php');
}
function _xtc_get_ebay_users(){
    $env = (main::isDev(true) or EBAY_TESTMODE == 1) ? 'sandbox' : 'production';
    $user_array = array();
    $user_query = xtc_db_query("SELECT user FROM ebay_auth WHERE environment='".$env."'");
    while($user = xtc_db_fetch_array($user_query)){
        $user_array[] = array('id'=>$user['user'],'text'=>$user['user']);
    }
    return $user_array;
}

function debug($str){
    printf("[Debug] %s\n",$str);
}

/**
 * Beispiel: revise(2,1,100);
 * Zur Auktion mit der id 2 wird die angebotene Menge der pID 1 auf 100 gesetzt
 * wird eine SKU mitgegeben handelt es sich um Varianten
 * 
 * @global ebayAPI $EBAYAPI
 * @param int $ebay_auctions_id
 * @param int $revise_qty
 * @param string $sku
 * @return array (code -3: revise qty falsch, code -2: api error, code -1: products stock error
 */
function revise(int $ebay_auctions_id, int $revise_qty, $sku = Null, $debug = false){
    global $EBAYAPI;
    $ea = new ebay_auction($ebay_auctions_id);
    $new_itemtype = new \stdClass();
    $new_itemtype->ItemID = $ea->ebay_id;
    if($sku != Null){
        $Variations = new \stdClass();
        $Variation = new \stdClass();
        $Variation->SKU = $sku;
        $Variation->Quantity = (int)$revise_qty;
        $Variations->Variation[] = $Variation;
        $new_itemtype->Variations = $Variations;
        if($debug){
            debug(sprintf('Revise Variation Auction %s / SKU %s to quantity %d',
                    $new_itemtype->ItemID, $Variation->SKU, $Variation->Quantity
            ));
        }else{
            $status_message = $EBAYAPI->revise_variation_auction($ebay_auctions_id,$new_itemtype);
        }
    }else{
        $new_itemtype->Quantity = $revise_qty;
        if($debug){
            debug(sprintf('Revise Auction %s to quantity %d',
                    $new_itemtype->ItemID, $new_itemtype->Quantity
            ));
        }else{
            $status_message = $EBAYAPI->revise_auction($ebay_auctions_id,$new_itemtype,'Item.Quantity');
        }
    }
    return $status_message;
}


function _is_dummy_pid( int $products_id ){
    if(defined('EBAY_DEFAULT_DUMMY_PRODUCTS_ID') and EBAY_DEFAULT_DUMMY_PRODUCTS_ID > 0 and (!defined('EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU') or EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU != 'true')){
        return ($products_id == EBAY_DEFAULT_DUMMY_PRODUCTS_ID);
    }
    return false;
}
/*
$ec = new \YES4Trade\Model\ebaycalls();
$res = $ec->tradingQuery('testuser_mario2020',
    'EndFixedPriceItem',
    intval(constant('EBAY_SITE')),
    [
        'ItemID'=>'110588278786',
        'EndingReason'=>'Incorrect'
    ]
);
print_r($res);exit;*/

$sandbox = (main::isDev(true) or EBAY_TESTMODE == 1);
$debug = false;
$rec_array = main::get_notice_recipients('ebayapi_cart');




$ebay_users = _xtc_get_ebay_users();
if(!sizeOf($ebay_users)){
    die(sprintf(
        "### Fuer den eBay %s-Modus wurde kein Seller hinterlegt.###\n",
	(main::isDev(true) or EBAY_TESTMODE == 1) ? 'sandbox' : 'production'
    ));
}

$ebay_debug = false;
$import_abonded = \YES4Trade\Model\ebay_order_add_import::get();
for($i=0;$i<sizeOf($ebay_users);$i++){
    $site_id = $EBAYAPI->get_site_id_from_name(constant('EBAY_SITE'));
    if(ebayApi::oauth2_refreshtoken_exists($ebay_users[$i]['id'])){
        if(!ebayApi::oauth2_usertoken_exists($ebay_users[$i]['id']) or ebayApi::get_oauth2_usertoken_lifetime($ebay_users[$i]['id']) < 1){
            try{
                ebayApi::refresh_oauth2_usertoken($ebay_users[$i]['id']);
            }catch(Exception $e){
                $api_error = 'refresh_oauth2_usertoken() for seller '.$ebay_users[$i]['id'].'  '.$e->getMessage();
            }
        }
    }else{
        echo $ebay_users[$i]['id']." has no refresh token saved\n\n";
        continue;
    }

    $ebaycaller = new \YES4Trade\Model\ebaycalls();
    $import_abonded_seller_array = [];
    if(isset($import_abonded[$ebay_users[$i]['id']]) and is_countable($import_abonded[$ebay_users[$i]['id']]) and sizeOf($import_abonded[$ebay_users[$i]['id']])>0){
        // wir begrenzen auf 40
        $import_abonded_seller_array = array_slice($import_abonded[$ebay_users[$i]['id']], 0, 40);
        $OrderIDArray = [];
        foreach($import_abonded_seller_array as $OrderID){
            $OrderIDArray[] = ['OrderID'=>$OrderID];
        }
        $req_params = [
            'Pagination'=>[
                'EntriesPerPage'=>200,
                'PageNumber'=>1
            ],
            'OrderIDArray'=>$OrderIDArray
        ];
    }else{
        $req_params = [
            'Pagination'=>[
                'EntriesPerPage'=>200,
                'PageNumber'=>1
            ],
            'NumberOfDays'=>3
        ];
    }
    

    $res = $ebaycaller->tradingQuery(
        $ebay_users[$i]['id'], 
        'GetOrders',
        $site_id,
        $req_params
    );
    
    if($res->Ack != 'Success'){
        printf("\n\nFEHLERHAFTES RESPONSE GetOrders FUER SELLER %s / SITE ID %d\n\n",
                $ebay_users[$i]['id'], $site_id
        );
        $error_str = '';
        foreach($res->Errors as $err){
            $error_str .= sprintf("[%s] ErrorCode %d %s\n\n",
                    $err->ErrorClassification,
                    $err->ErrorCode,
                    $err->LongMessage
            );
        }
        if(!empty($error_str)){
            echo $error_str;
        }
        if(sizeOf($import_abonded_seller_array)){
            yes_mail_debug('Manueller eBay Import Fehler: '
                .print_r($res->Errors,true)
                ."\n\n\nEventuell in admin/importdata/ die Datei EBAY_ORDER_ADD_IMPORT.json loeschen.",
                true,'Manueller eBay Import Problem.'
            );
            \YES4Trade\Model\ebay_order_add_import::delete_processed($import_abonded_seller_array, $ebay_users[$i]['id']);
            yes_write_notice('Manueller eBay Order Import fehlgeschlagen',
                "Folgende eBay Order sollten eingelesen werden: "
                .implode(', ',$import_abonded_seller_array)
                ."\n\nSeller: ".$ebay_users[$i]['id']
                ."\n\neBay Fehler: ".$error_str,
                0,
                $rec_array
            );

        }
    }else{
        if(sizeOf($import_abonded_seller_array)){
            \YES4Trade\Model\ebay_order_add_import::delete_processed($import_abonded_seller_array, $ebay_users[$i]['id']);
        }
        printf("\n\n### Results for Seller %s / SiteID %s ###\n\n",$ebay_users[$i]['id'],$site_id);
        printf("Version: %s | OrdersPerPage: %d | PageNumber: %d | ReturnedOrderCountActual: %d\n",
                $res->Version, $res->OrdersPerPage, $res->PageNumber, $res->ReturnedOrderCountActual
        );
        $order_array = $res->OrderArray->Order ?? [];
        if(!is_array($order_array)){
            $order_array = [$order_array];
        }
        foreach($order_array as $Order){
		    $trans_array = $Order->TransactionArray->Transaction ?? [];
		    if(!is_array($trans_array)){
		        $trans_array = [$trans_array];
		    }
            printf("Processing eBay order #%s Order Status %s / CheckoutStatus %s and has %d Transactions\n",
                    $Order->OrderID,$Order->OrderStatus,
                    $Order->CheckoutStatus->Status,
                    sizeOf($trans_array)
            );
            if($Order->CheckoutStatus->Status == 'Cancelled'){
                    if(\YES4Trade\Model\ebay_order_reservation::isInstalled()){
                        $reservationIdDeleted = [];
                        foreach($trans_array as $Transaction){
                            $reservationId = isset($Transaction->InventoryReservationID) ? (string)$Transaction->InventoryReservationID : null;
                            if($reservationId !== null){
                                if(in_array($reservationId,$reservationIdDeleted)){
                                    continue;
                                }
                                $eor = new \YES4Trade\Model\ebay_order_reservation($ebay_users[$i]['id'], $reservationId);
                                $eor->delete();
                                $reservationIdDeleted[] = $reservationId;
                            }
                        }
                        // ALLE RAUSSCHMEISSEN DENN CHECKOUTSTATUS IST NICHT INCOMPLETE
                    }
                    printf("eBay Checkout Status: %s - nichts machen.\n",
                        $Order->CheckoutStatus->Status
                    );
                    continue;
            } // end cancelled
            if($Order->CheckoutStatus->Status == 'Incomplete'){
                    printf("eBay Checkout Status: %s - noch warten\n",
                        $Order->CheckoutStatus->Status
                    );
                    foreach($trans_array as $Transaction){
                        $reservationId = isset($Transaction->InventoryReservationID) ? (string)$Transaction->InventoryReservationID : null;
                        if($reservationId === null){
                            yes_mail_debug("Checkout Incomplete ohne InventoryReservationID\nOrder Obj: ".print_r($Order,true),false,'Missing InventoryReservationID');
                            continue;
                        }
                        $tmp_check_pID = $EBAYAPI->get_products_id_from_transaction( $Transaction );
                        $tmp_qty = (int)$Transaction->QuantityPurchased;
                        if(\YES4Trade\Model\ebay_order_reservation::isInstalled()){
                            $eor = new \YES4Trade\Model\ebay_order_reservation($ebay_users[$i]['id'], $reservationId);
                            if(!$eor->exists($tmp_check_pID)){
                                $eor->add($tmp_check_pID, $tmp_qty);
                            }
                        }
                    }
                    continue;
            } // end incomplete

            if(\YES4Trade\Model\ebay_order_reservation::isInstalled()){
                    $reservationIdDeleted = [];
                    foreach($trans_array as $Transaction){
                        $reservationId = isset($Transaction->InventoryReservationID) ? (string)$Transaction->InventoryReservationID : null;
                        if($reservationId === null){
                            continue;
                        }
                        if(in_array($reservationId,$reservationIdDeleted)){
                            continue;
                        }
                        $eor = new \YES4Trade\Model\ebay_order_reservation($ebay_users[$i]['id'], $reservationId);
                        // ALLE RAUSSCHMEISSEN DENN CHECKOUTSTATUS IST NICHT INCOMPLETE
                        $eor->delete();
                        $reservationIdDeleted[] = $reservationId;
                    }
            } // end eooos installed
            $exists_query = xtc_db_query(sprintf(
                    "SELECT ebay_orders_id FROM ebay_orders WHERE OrderID='%s'",
                    $Order->OrderID
            ));
            if(xtc_db_num_rows($exists_query)){
                printf("eBay Order %s exists.\n",$Order->OrderID);
                continue;
            }
                

            $Order->BuyerUserID; // Buyer
            $Order->SellerUserID; // seller
            $qty_check_av1 = true;
            $unique_p = [];
            foreach($trans_array as $Transaction){
                    // BOF - WENN KEIN BESTAND - NICHT ANLEGEN 2024/09
                    $check_pID = $EBAYAPI->get_products_id_from_transaction( $Transaction );
                    if(!isset($unique_p[ $check_pID ])){
                        $unique_p[$check_pID] = 0;
                    }
                    $unique_p[$check_pID] += (int)$Transaction->QuantityPurchased;
                    
                    // EOF - WENN KEIN BESTAND - NICHT ANLEGEN 2024/09
                    $email_address = $Transaction->Buyer->Email;
                    $firstname = $Transaction->Buyer->UserFirstName;
                    $lastname = $Transaction->Buyer->UserLastName;
                    $ebay_id = $Transaction->Item->ItemID;
            }
            if(constant('STOCK_CHECK') !== 'false'){
                    foreach($unique_p as $pID => $qty){
                        $SQ = new products_quantity($pID);
                        $products_stock = $SQ->get_available1_qty();
                        if($qty > $products_stock){
                            $qty_check_av1 = false;
                            printf(
                                "eBay Order #%s Seller %s V1 der pID %d nicht ausreichend (gekauft %d / V1 %d).\n",
                                $Order->OrderID,$ebay_users[$i]['id'],$pID,$qty,$products_stock
                            );
                        }
                    }
            }
            if(!$qty_check_av1){
                    // kein Bestand - in ebay_orders_oos einfuegen
                    if($debug){
                        debug('V1 nicht ausreichend');
                    }else{
                        if(\YES4Trade\Model\ebay_orders_oos::get_ebay_orders_oos_id_from_OrderID( $Order->OrderID, $ebay_users[$i]['id'] )>0){
                            // EINTRAG BEREITS VORHANDEN
                            printf(
                                "Eintrag in ebay_orders_oos fuer eBay Order #%s Seller %s bereits gespeichert.\n",
                                $Order->OrderID,$ebay_users[$i]['id']
                            );
                        }else{
                            // EINTRAG ERZEUGEN
                            $eooosID = \YES4Trade\Model\ebay_orders_oos::create($Order->OrderID, $ebay_users[$i]['id'] );
                            printf(
                                "Eintrag in ebay_orders_oos fuer eBay Order #%s Seller %s gespeichert.\n",
                                $Order->OrderID,$ebay_users[$i]['id']
                            );
                        }
                    }
                    continue;
            }else{ // eof !$qty_check_av1
                    if($debug){
                        debug('V1 vorhanden - ebay_orders_oos::delete_if_exists()');
                    }else{
                        \YES4Trade\Model\ebay_orders_oos::delete_if_exists($Order->OrderID, $ebay_users[$i]['id'] );
                    }
            }
                
                
            $is_registered = false;
            // sql erweitert um customers_ebay_userid
            // das brauchen wir um zu checken ob der registrierte kunde
            // seinen ebay usernamen geaendert hat und wir diesen aktualisieren
            // muessen - 2024/06
            $query = xtc_db_query(sprintf(
                    "SELECT customers_id,customers_ebay_userid FROM %s WHERE customers_email_address='%s'",
                    TABLE_CUSTOMERS,$email_address
            ));
            if(!xtc_db_num_rows($query)){
                    $insert_sql_array = [
                        'customers_status'=>EBAY_CUSTOMERS_STATUS,
                        'customers_gender'=>EBAY_DEFAULT_GENDER,
                        'customers_firstname'=>"$firstname",
                        'customers_lastname'=>"$lastname",
                        'customers_email_address'=>$email_address,
                        'customers_default_address_id'=>0,
                        'customers_password'=>xtc_encrypt_password($EBAYAPI->generatePassword()),
                        'account_type'=>0,
                        'customers_ebay_userid'=>$Order->BuyerUserID,
                        'customers_date_added'=>'now()',
                    ];
                    if($debug){
                        $cID = 99999999;
                        debug('create new customer - test cID='.$cID);
                    }else{
                        yes_db_perform(TABLE_CUSTOMERS,$insert_sql_array);
                        $cID = xtc_db_insert_id();
                    }
                    
                    $insert_sql_array = [
                        'customers_id'=>(int)$cID,
                        'entry_gender'=>EBAY_DEFAULT_GENDER,
                        'entry_company'=>'',
                        'entry_firstname'=>$firstname,
                        'entry_lastname'=>$lastname,
                        'entry_street_address'=>is_scalar($Order->ShippingAddress->Street1 ?? null) ? $Order->ShippingAddress->Street1 : '',
                        'entry_suburb'=>is_scalar($Order->ShippingAddress->Street2 ?? null) ? $Order->ShippingAddress->Street2 : '',
                        'entry_postcode'=>is_scalar($Order->ShippingAddress->PostalCode ?? null) ? $Order->ShippingAddress->PostalCode : '',
                        'entry_city'=>is_scalar($Order->ShippingAddress->CityName ?? null) ? $Order->ShippingAddress->CityName : '',
                        'entry_state'=>is_scalar($Order->ShippingAddress->StateOrProvince ?? null) ? $Order->ShippingAddress->StateOrProvince : '',
                        'entry_country_id'=> (int)yes_get_country_id_from_iso2($Order->ShippingAddress->Country),
                        'address_date_added'=>date('Y-m-d H:i:s'),
                    ];
                    if($debug){
                        $abID = 88888888;
                        debug('create new address_book entry - test abID='.$abID);
                    }else{
                        $new = new \YES4Trade\Model\address_book($insert_sql_array);
                        $abID = $new->create();
                    }

                    $update_sql_array = [
                        'customers_default_address_id'=>$abID,
                    ];
                    if($debug){
                        debug('allocate new abID '.$abID.' to the new customer cID='.$cID);
                    }else{
                        yes_db_perform(TABLE_CUSTOMERS,$update_sql_array,'update',[
                            'customers_id'=>intval($cID)
                        ]);
                    }
                    
                    // ------------------------------------------------------------
                    // KUNDENHISTORIEN EINTRAG IN customers_info UND customers_memo
                    // ------------------------------------------------------------
                    $customers_info_sql_array = array(
                            'customers_info_id' => intval($cID),
                            'customers_info_date_account_created'=>date('Y-m-d H:i:s')
                    );
                    if($debug){
                        debug('create customer: write customer_info');
                    }else{
                        $new = new \YES4Trade\Model\customers_info($customers_info_sql_array);
                        $new->create();
                    }

                    $new = new \YES4Trade\Model\customers_memo([
                        'customers_id'=>(int)$cID,
                        'memo_date'=>date('Y-m-d H:i:s'),
                        'memo_title'=>'User angelegt',
                        'memo_text'=>'Durch Ebay Order '.$Order->OrderID.' vom System angelegt.',
                        'poster_id'=>0
                    ]);
                    if($debug){
                        debug('create customer: write customers_memo');
                    }else{
                        $new->create();
                    }
                        
                    if($debug){
                        debug(sprintf("yes_remove_customers_email_alias(%s, %d)",
                            $email_address, $cID
                        ));
                    }else{
                        yes_remove_customers_email_alias($email_address, $cID);
                    }
            }else{ // end if customer not exists
	            $is_registered = true;
                $record = xtc_db_fetch_array($query);
                $cID = $record['customers_id'];
                    
                // registrierter Kunde hat anderen buyer usernamen
                // diesen aktualisieren wir hier
                if($record['customers_ebay_userid'] != $Order->BuyerUserID){
                    $update_sql_array = array(
                        'customers_ebay_userid'=>$Order->BuyerUserID,
                        'customers_id'=>intval($cID)
                    );
                    if($debug){
                        debug('customers update different buyer username');
                    }else{
                        $upd = new \YES4Trade\Model\customers($update_sql_array);
                        $upd->update();
                    }
                    $new = new \YES4Trade\Model\customers_memo([
                        'customers_id'=>(int)$cID,
                        'memo_date'=>date('Y-m-d H:i:s'),
                        'memo_title'=>'eBay User Update',
                        'memo_text'=>'Durch eBay Order '.$Order->OrderID.' eBay Username von "'.$record['customers_ebay_userid'].'" in "'.$Order->BuyerUserID.'" aktualisiert.',
                        'poster_id'=>0
                    ]);
                    if($debug){
                        debug('customers memo about different buyer username');
                    }else{
                        $new->create();
                    }
                }
            } // end customer exists
            $orders_status = ORDERS_STATUS_BEZAHLT;
		    if(strtolower($Order->CheckoutStatus->PaymentMethod) == 'cashondelivery' or strtolower($Order->CheckoutStatus->PaymentMethod) == 'cod'){
                    $orders_status = ORDERS_STATUS_UPSELLING;
            }
            $SSO = $Order->ShippingDetails->ShippingServiceOptions;
            
            $comments_visible = '';
            $checkout_msg = '';
            if($Order->BuyerCheckoutMessage !== null and !empty($Order->BuyerCheckoutMessage)){
                $comments_visible .= $Order->BuyerCheckoutMessage;
            }
            if($Order->BuyerMessage !== null and !empty($Order->BuyerMessage)){
                $comments_visible .= $Order->BuyerMessage;
            }
                
            // 
            // BOF - PAYMENT Transaction ID bei PayPal Bezahlart speichern
            // 
            $payment_transaction_id = '';
            if($Order->CheckoutStatus->PaymentInstrument == 'PayPal'){
                $payment_transaction_id = $Order->MonetaryDetails->Payments->Payment->ReferenceID;
            }
            // 
            // EOF - PAYMENT Transaction ID bei PayPal Bezahlart speichern
            // 
            $phone = is_scalar($Order->ShippingAddress->Phone ?? null) ? $Order->ShippingAddress->Phone : '';
            if($phone == 'Invalid Request'){
                $phone = '';
            }
            $sm = $Order->ShippingDetails->ShippingServiceOptions->ShippingService;
            if($sm === null){
                $sm = $Order->ShippingDetails->InternationalShippingServiceOption->ShippingService;
            }
            if($sm == null){
                $sm = 'unknown';
            }
            $new_order_sql = [
                'customers_id'=>$cID,
                'ebay_id'=>$ebay_id,
                'customers_status'=>EBAY_CUSTOMERS_STATUS,
                'customers_status_name'=>EBAY_CUSTOMERS_STATUS_NAME,
                'customers_status_image'=>'ebay_status.gif',
                'payment_method'=>$Order->CheckoutStatus->PaymentMethod,
                'comments'=>'',
                'customers_email_address'=>$email_address,
                'customers_telephone'=>$phone,
                'date_purchased'=>'now()',
                'date_payment'=>'now()',
// KLAEREN OB orders_status NUR BEI COD NICHT AUF BEZAHLT GEHT
                'orders_status'=>$orders_status,
                'currency'=>constant('DEFAULT_CURRENCY'),
                'currency_value'=>1,
                'account_type'=>0,
                'payment_class'=>'eBay Payment',
                'shipping_method'=>$sm,
                'shipping_class'=>$EBAYAPI->get_shipping_class($sm),
                'language'=>'german',
                'is_parent'=>'n',
                'source'=>'ebay',
                'ebay_plus'=>($Order->ContainseBayPlusTransaction === true)?1:0,
                'comments_visible'=>$comments_visible,
                'payment_transaction_id'=>$payment_transaction_id??'',
            ];
            $delivery_country_id = yes_get_country_id_from_iso2($Order->ShippingAddress->Country);
            $address_country = xtc_get_country_name($delivery_country_id);
            if($address_country === null or $address_country === false or empty($address_country)){
                yes_mail_debug("Kann kein Land ermitteln.\n\n".print_r($Order,true));
            }
            $address_base = [
                'name'=>(string)$Order->ShippingAddress->Name,
                'street_address'=>is_scalar($Order->ShippingAddress->Street1 ?? null) ? $Order->ShippingAddress->Street1 : '',
                'suburb'=>is_scalar($Order->ShippingAddress->Street2 ?? null) ? $Order->ShippingAddress->Street2 : '',
                'city'=>is_scalar($Order->ShippingAddress->CityName ?? null) ? $Order->ShippingAddress->CityName : '',
                'state'=>is_scalar($Order->ShippingAddress->StateOrProvince ?? null) ? $Order->ShippingAddress->StateOrProvince : '',
                'country'=>$address_country, /// nicht den country name von ebay verwenden 2025/05
                'postcode'=>is_scalar($Order->ShippingAddress->PostalCode ?? null) ? $Order->ShippingAddress->PostalCode : '',
                'address_format_id'=>EBAY_ADDRESS_FORMAT_ID,
            ];
                
            //
            // BOF - DUMMY DATEN LOCAL DEV TEST
            //
            if(main::isDev(true) and empty($address_base['name'])){
                $address_base = [
                    'name'=>'Dennis Dummy',
                    'street_address'=>'Culinstrasse 1',
                    'suburb'=>'Oberster Stock',
                    'city'=>'Hamburg',
                    'state'=>'Hamburg',
                    //'country'=>$Order->ShippingAddress->Country, // => DE
                    'country'=>'Germany',
                    'postcode'=>'22111',
                    'address_format_id'=>EBAY_ADDRESS_FORMAT_ID,
                ];
            }
            //
            // EOF - DUMMY DATEN LOCAL DEV TEST
            //
            foreach($address_base as $ak=>$av){
                $new_order_sql['customers_'.$ak] = $av;
                $new_order_sql['billing_'.$ak] = $av;
                $new_order_sql['delivery_'.$ak] = $av;
            }
            if($debug){
                $oID = 77777777;
                debug('create new order - oID='.$oID);
            }else{
                try{
                    yes_db_perform(TABLE_ORDERS,$new_order_sql);
                }catch(Exception $e){
                    yes_mail_debug($e->getMessage()."\n\n".print_r($new_order_sql,true));
                    die($e->getMessage());
                }
                $oID = xtc_db_insert_id();
            }
            if($new_order_sql['ebay_plus'] == 1){
                if($debug){
                    debug(sprintf('save order comment to order %d history about ebay plus',
                            $oID
                    ));
                }else{
                    order::add_history_static($oID, $orders_status, false,
                        'eBay Plus Auftrag'
                    );
                }
            }

            if(!empty($comments_visible)){
                if($debug){
                    debug(sprintf('save ebay_comment to order %d history and write notice',
                            $comments_visible, $oID
                    ));
                }else{
                    order::add_history_static($oID, $orders_status, false,
                        'eBay Kunde Kommentar: '.$comments_visible
                    );
                    yes_write_notice('eBay K&auml;ufer Nachricht Re-Nr '.$oID,$comments_visible,0,$rec_array);
                }
            }
            $insert_sql_array = [
                'OrderID'=>$Order->OrderID,
                'OrderStatus'=>$Order->OrderStatus, 	
                'date_added'=>date('Y-m-d H:i:s'),
                'processed'=>'1',
                'ebay_id'=>$ebay_id,
                'user'=>$Order->SellerUserID,
                'orders_id'=>intval($oID),  
            ];
            if($debug){
                debug('create ebay_orders entry for OrderID='.$Order->OrderID.', OrderStatus='.$Order->OrderStatus.', user='.$Order->SellerUserID);
                $new_eoID = 979797;
            }else{
                $new_eoID = yes_db_perform('ebay_orders',$insert_sql_array);
            }
            $tax_array = [];
            $ebay_id_array = []; // es koennen mehrere Auktionen enthalten sein

	    $shipCosts = $Order->ShippingServiceSelected->ShippingServiceCost??0;

        // eBayCollectAndRemitTax entscheidet (true = keine tax)
        $use_tax = true; // IST MWST ENTHALTEN? ZB SCHWEIZ NEIN

        foreach($trans_array as $tnr=>$Transaction){
                    $variation = false;
                    $sku = '';
                    $transaction_pID = $EBAYAPI->get_products_id_from_transaction( $Transaction );
                    $use_dummy_pid = _is_dummy_pid($transaction_pID);
                    if(!in_array($Transaction->Item->ItemID,$ebay_id_array)){
                    	$ebay_id_array[] = $Transaction->Item->ItemID;
                    }
                    
                    if(gettype($Transaction->Variation) !== 'NULL'){
                        $sku = $Transaction->Variation->SKU;
                        $title = $Transaction->Variation->VariationTitle;
                        $variation = true;
                    }else{
                        $sku = $Transaction->Item->SKU;
                        $title = $Transaction->Item->Title;
                        
                    }
                    $check_pid_query = xtc_db_query(sprintf(
                            "SELECT products_id,products_model,products_tax_class_id FROM products WHERE products_id='%d'",
                            $transaction_pID
                    ));
                    $yes_product_data = xtc_db_fetch_array($check_pid_query);
                    printf("\t[eBay ID %s] %s SKU %s (pID %s): %s\n",
                        $Transaction->Item->ItemID,
                        (($variation === true)?'Variante ':''),
                        $sku, 
                        (($use_dummy_pid===true)?'Dummy '.$transaction_pID:$transaction_pID),
                        $title
                    );
                    
                    //
                    // BOF - default_shipper
                    //
                    if(is_countable($trans_array) and sizeOf($trans_array) == 1 and $Transaction->QuantityPurchased == 1){
                        $default_shipper = \YES4Trade\Model\shipper_profiles::get_products_id_value($transaction_pID);
                        if(!empty($default_shipper)){
                            $update_sql_array = [
                                'versender'=>$default_shipper,
                            ];
                            if($debug){
                                debug(sprintf('update order %d: set versender=%s',
                                        $oID, $default_shipper
                                ));
                            }else{
                                yes_db_perform(TABLE_ORDERS,$update_sql_array,'update',[
                                    'orders_id'=>intval($oID)
                                ]);
                            }
                            if($debug){
                                debug(sprintf(
                                    'write order %d history about the default_shipper %s',
                                    $oID, $default_shipper
                                ));
                            }else{
                                order::add_history_static($oID, $orders_status, 
                                    false, 
                                    'Transaktion hat 1 Artikel mit Menge 1, setze Default Versender auf: '.$default_shipper
                                );
                            }
                        }
                    }
                    //
                    // EOF - default_shipper
                    //

                    //
                    // BOF - Bei Bezahlart Paypal die Payment TransactionID mitspeichern
                    //
                    if(!$order_create_history_added){
                        $add_order_history = "Ebay-Auktion ".$Transaction->Item->ItemID."/Transaction ".$Transaction->TransactionID." zur Bestellung hinzugefuegt.";
                        if($Order->CheckoutStatus->PaymentInstrument == 'PayPal'){
                            $add_order_history .= " Paypal Transaction ID: ".$Order->MonetaryDetails->Payments->Payment->ReferenceID;
                        }
                        $order_history_sql_array = array(
                            'orders_id' => $oID,
                            'orders_status_id' => $orders_status,
                            'date_added' => 'now()',
                            'customer_notified' => 0,
                            'comments' => $add_order_history
                        );
                        if($debug){
                            debug(sprintf(
                                    'write order %d history about paypal txnid %s',
                                    $oID,
                                    $Order->MonetaryDetails->Payments->Payment->ReferenceID
                            ));
                        }else{
                            yes_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history_sql_array);
                        }
                    }
                    //
                    // EOF - Bei Bezahlart Paypal die Payment TransactionID mitspeichern
                    //
                    $checkoutmessage_saved = (!empty($comments_visible))?1:0;
                    $transCreationDate_obj = new \DateTime($Transaction->CreatedDate);
                    $insert_sql_array = [
                        'transactionid'=>$Transaction->TransactionID,
                        'ebayid'=>$Transaction->Item->ItemID,
                        'products_id'=>$transaction_pID,
                        'orders_id'=>$oID,
                        'email'=>$Transaction->Buyer->Email,
                        'fullname'=>$Order->ShippingAddress->Name,
                        'street1'=>is_scalar($Order->ShippingAddress->Street1 ?? null) ? $Order->ShippingAddress->Street1 : '',
                        'street2'=>is_scalar($Order->ShippingAddress->Street2 ?? null) ? $Order->ShippingAddress->Street2 : '',
                        'zip'=>is_scalar($Order->ShippingAddress->PostalCode ?? null) ? $Order->ShippingAddress->PostalCode : '',
                        'city'=>is_scalar($Order->ShippingAddress->CityName ?? null) ? $Order->ShippingAddress->CityName : '',
                        'userid'=>$Order->BuyerUserID,
                        'paymentmethod'=>$Order->CheckoutStatus->PaymentMethod,
                        'shippinghandlingcosts'=>(float)$shipCosts,
                        'amountpaid'=>(float)$Order->AmountPaid,
                        'quantitypurchased'=>(int)$Transaction->QuantityPurchased,
                        'transactionprice'=>(float)$Transaction->TransactionPrice,
                        'transactiondate'=>$transCreationDate_obj->format('Y-m-d H:i:s'),
                        'STATUS'=>1,
                        'site'=>$Transaction->Item->Site,
                        'currency_value'=>1,
                        'seller'=>$Order->SellerUserID,
                        'checkoutstatus'=>$Order->CheckoutStatus->Status,
                        'checkoutmessage_saved'=>$checkoutmessage_saved,
                    ];
                    if($debug){
                        debug('create ebay_transaction entry');
                    }else{
                        try{
                            yes_db_perform('ebay_transactions',$insert_sql_array);
                        }catch(Exception $e){
                            yes_mail_debug(print_r($insert_sql_array,true),false,'ebay transaction error');
                            exit;
                        }
                    }
                    if($debug){
                        debug('update ebay_orders with orders_id');
                    }else{
                        $update_sql_array = [
                            'orders_id'=>intval($oID)
                        ];
                        yes_db_perform('ebay_orders',$update_sql_array,'update',[
                            'ebay_orders_id'=>$new_eoID
                        ]);
                    }
                    
                    
                    //
                    // BOF - Tax Rate ermitteln
                    //
                    if($Transaction->Buyer->VATStatus == 'VATTax'){
	                    if((string)$Transaction->eBayCollectAndRemitTax == 'false'){
                            $tax_class_id = yes_eu_oss_get_products_tax_class_id($transaction_pID, $delivery_country_id);
                            $tax = xtc_get_tax_rate($tax_class_id, $delivery_country_id);
                        }else{
                            $tax = 0;
                            $use_tax = false;
                        }
                    }else{
                        // EU-OSS 2021/07
                        if(defined('EBAY_DEFAULT_DUMMY_PRODUCTS_ID') and EBAY_DEFAULT_DUMMY_PRODUCTS_ID > 0){
                            $tax_class_id = yes_eu_oss_get_products_tax_class_id(EBAY_DEFAULT_DUMMY_PRODUCTS_ID, $delivery_country_id);
                            $tax = xtc_get_tax_rate($tax_class_id, $delivery_country_id);
                        }elseif(defined('EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU') and EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU == 'true'){
                            $tax_class_id = yes_eu_oss_get_products_tax_class_id($transaction_pID, $delivery_country_id);
                            $tax = xtc_get_tax_rate($tax_class_id, $delivery_country_id);
                        }else{
                            $tax = 0;
                        }
                    }
                    
                    if(!isset($tax_array[ "$tax" ])){
                        $tax_array[ "$tax" ] = 0;
                    }
                    $final_price = (float) intval($Transaction->QuantityPurchased) * floatval($Transaction->TransactionPrice);
                    $products_price = floatval($Transaction->TransactionPrice);
                    $products_quantity = intval($Transaction->QuantityPurchased);
                    if($use_tax === true){
                        $_taxval = $final_price-($final_price/((100+$tax)/100) );
                        $tax_array[ "$tax" ] += $_taxval;
                    }else{
                        $_taxval = 0;
                    }
                    //
                    // EOF - Tax Rate ermitteln
                    //
                    
                    //
                    // BOF - STAFFELPREISE_ALS_VARIANTEN
                    //
                    $yes_auction_exists = false;
                    $ea_obj = \YES4Trade\Model\ebay_auctions::get_by_ebay_id((string)$Transaction->Item->ItemID,[
                        'id'
                    ]);
                    if($ea_obj !== null){
                        $ea = new ebay_auction($ea_obj->id);
                        $yes_auction_exists = true;
                    }
                    $staffelpreis_qty = 0;
                    if($variation === true && $yes_auction_exists === true){
                        if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
                            if($ea->has_staffelpreise()){
                                $staffelpreis_qty = $ea->get_staffelpreis_quantity_from_sku($Transaction->Variation->SKU);
                                $products_price = $final_price / $staffelpreis_qty;
                                $products_quantity = $products_quantity * $staffelpreis_qty;
                            }
                        }
                    }
                    if($yes_auction_exists){
                        $revise_qty = $ea->quantity+$products_quantity;
                    }
                    //
                    // EOF - STAFFELPREISE_ALS_VARIANTEN
                    //
                    if(!$use_dummy_pid){
                        $title = xtc_get_products_name($transaction_pID);
                    }

                    $orders_products_array = [
                        'orders_id'=>$oID,
                        'products_id' => $transaction_pID,
                        'products_model' => $yes_product_data['products_model'],
                        'products_name'=>$title,
                        'products_price'=>$products_price,
                        'final_price'=>$final_price,
                        'products_tax'=>(float)$tax,
                        'products_quantity' => $products_quantity,
                        'allow_tax'=>$use_tax, // 2025/08 war vorher immer true
                        'date_added' => 'now()',
                    ];
                    if($debug){
                        $orders_products_id = 66666666;
                        debug(sprintf(
                                'insert orders_products oID %d, pID %d and set dummy opID %d',
                                $oID, $transaction_pID,$orders_products_id
                        ));
                    }else{
                        yes_db_perform(TABLE_ORDERS_PRODUCTS, $orders_products_array);
                        $order_products_id = xtc_db_insert_id();
                    }

                    if($use_dummy_pid or $transaction_pID == 0){
                            return true;
                    }
                    if($debug){
                        debug(sprintf(
                            'yes_update_products_in_auction_quantity() pID %d, qty %d for ebay_id %s',
                            $transaction_pID, -$products_quantity, $ebay_id
                        ));
                    }else{
                        yes_update_products_in_auction_quantity(
                            $transaction_pID,
                            -$products_quantity,
                            sprintf('eBay: Abverkauf Auktion %s: %s Stk',$ebay_id,$products_quantity)
                        );
                    }

                    if(!$use_dummy_pid){
                        $collies = xtc_get_product_collies($transaction_pID);
                    }
                    // 
                    // EOF - SERIENNUMMERNHANDLING
                    // 
                    
                    // -------------------------------------------
                    // VERKAUFTE-PRODUKTE-COUNTER IN products HOCHSETZEN
                    // -------------------------------------------
                    if($transaction_pID > 0){
                        if($debug){
                            debug(sprintf(
                                'update products_ordered for pID %d +%d',
                                $transaction_pID, $products_quantity
                            ));
                        }else{
                            xtc_db_query(sprintf(
                                "update %s set products_ordered = products_ordered + %d where products_id = '%d'",
                                TABLE_PRODUCTS,
                                $products_quantity,
                                $transaction_pID
                            ));
                        }
                    }

                    //
                    // BOF - Auktion Status aendern
                    //

                    $ebaycaller = new \YES4Trade\Model\ebaycalls();
                    $reqParams = [
                        'ItemID'=>$Transaction->Item->ItemID,
                        'OutputSelector'=>['Item.ListingType','Item.Quantity','Item.SellingStatus', 'Item.Variations']
                    ];
                    $resItem = $ebaycaller->tradingQuery(
                        $ebay_users[$i]['id'], 
                        'GetItem',
                        $site_id,
                        $reqParams
                    );
                    $ebay_variation_array = $resItem->Item->Variations->Variation ?? [];
                    if(!is_array($ebay_variation_array)){
                        $ebay_variation_array = [$ebay_variation_array];
                    }
                    
                    // BOF - Auktionsdaten aktualisieren                    
                    if($variation){
                        foreach($ebay_variation_array as $Variation){
                            $current_variation_quantity = (int)$Variation->Quantity - (int)$Variation->SellingStatus->QuantitySold;
                            if($debug){
                                debug(sprintf(
                                    '-- AUSGEFUEHRT WIRD ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku() SKU %s, quantity %d',
                                    $sku,$current_variation_quantity
                                ));
                            }else{
                                \YES4Trade\Model\ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku([
                                    'quantity'=>$current_variation_quantity,
                                    'quantity_sold'=>(int)$Variation->SellingStatus->QuantitySold,
                                    'sku'=>$sku,
                                    'ebay_auctions_id'=>intval($ea->id)
                                ]);
                            }
                        }
                    }else{
                        $current_quantity = (int)$resItem->Item->Quantity - (int)$resItem->Item->SellingStatus->QuantitySold;
                        $update_sql_array = [
                            'quantity'=>$current_quantity,
                        ];
                        if($debug){
                            debug(sprintf(
                                'ebay_auctions.quantity update to ebay value %d',
                                $current_quantity
                            ));
                        }else{
                            \YES4Trade\Model\ebay_auctions::update_ebay_auction([
                                'quantity'=>intval($current_quantity),
                                'id'=>intval($ea->id)
                            ]);
                        }
                    }
                    // EOF - Auktionsdaten aktualisieren                    
                    
                    $auction_active = true;
                    switch($resItem->Item->SellingStatus->ListingStatus){
                        case 'Active':
                            break;
                        case 'Ended':
                        case 'Completed':
                            $auction_active = false;
                            if($yes_auction_exists){
                                if($debug){
                                    debug('set end auction for ebay_auctions.id='.$ea->id);
                                }else{
                                    $EBAYAPI->set_end_auction( $ea->id );
                                }
                            }
                            break;
                        default:
                            $message = sprintf("eBay ID %s hat den Status %s dieser wird nicht im cronjob beruecksichtigt.\n\nItem.SellingStatus: %s",
                                    $Transaction->Item->ItemID,
                                    $resItem->Item->SellingStatus->ListingStatus,
                                    print_r($resItem->Item->SellingStatus,true)
                            );
                            if(main::isDev(true)){
                                echo $message."\n";
                            }
                            yes_mail_debug($message);
                            break;
                    }
                    //
                    // EOF - Auktion Status aendern
                    // 
                    
                    //
                    // BOF - Revise
                    // 
                    if($auction_active === true && $yes_auction_exists === true && $ea->revise == 'to_qty'){
                        
                        $allow_revise = true;
                        $SQ = new products_quantity($transaction_pID);
                        $products_stock = $SQ->get_available1_qty();
                        $quantity_sold_variation = 0;
                        if($variation === true){
                            foreach($ebay_variation_array as $Variation){
                                if($Variation->SKU == $sku){
                                    $current_ebay_variation_qty = (int) $Variation->Quantity;
                                    $quantity_sold_variation = (int) $Variation->SellingStatus->QuantitySold;
                                }
                            }
                            $new_ebay_variation_qty = $current_ebay_variation_qty + intval($Transaction->QuantityPurchased) - $quantity_sold_variation;
                            
                            $bestandscheck_qty = $new_ebay_variation_qty;
                            if($staffelpreis_qty > 0){
                                $bestandscheck_qty = $bestandscheck_qty * $staffelpreis_qty;
                            }
                            
                            if( STOCK_CHECK == 'true' ){
                                // $products_quantity ist bei Varianten Staffeln schon
                                // hochgerechnet auf tatsaechliche menge
                                if( $products_stock < 1 or $products_stock < $bestandscheck_qty){
                                    printf("\n\tKEIN Revise da STOCK_CHECK aktiv und products_stock=%d < Einstellmenge %d",
                                            $products_stock, $bestandscheck_qty
                                    );
                                    $allow_revise = false;
                                }
                            }
                            if($allow_revise){
                                $res = revise($ea->id,$new_ebay_variation_qty, $sku);
                                if(empty($res)){
                                    $stfl_history = '';
                                    if($staffelpreis_qty > 0){
                                        $stfl_history = '(Staffelpreis Variante '.$staffelpreis_qty.'x)';
                                    }
                                    if($debug){
                                        debug(sprintf(
                                                "yes_add_products_history() %d: %s",
                                                $transaction_pID,
                                                sprintf("Revise Auktion %s SKU %s bei Anlage Auftrag %d: %d Stk. %s",
                                                    $ebay_id, $sku, $oID,
                                                    $bestandscheck_qty, $stfl_history
                                                )
                                        ));
                                    }else{
                                        product::add_history_static(intval($transaction_pID),
                                            sprintf("Revise Auktion %s SKU %s bei Anlage Auftrag %d: %d Stk. %s",
                                                $ebay_id, $sku, $oID,
                                                $bestandscheck_qty, $stfl_history
                                            )
                                        );
                                    }
                                    printf("\tRevise %s / Variation SKU %s (pID %d) to quantity %d\n",
                                        $ebay_id,$sku, $transaction_pID,
                                        $new_ebay_variation_qty
                                    );
                                    if($debug){
                                        debug(sprintf(
                                            '-- AUSGEFUEHRT WIRD ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku() SKU %s / quantity: %d',
                                            $sku, $new_ebay_variation_qty
                                        ));
                                    }else{
                                        \YES4Trade\Model\ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku([
                                            'quantity'=>intval($new_ebay_variation_qty),
                                            'ebay_auctions_id'=>intval($ea->id),
                                            'sku'=>$sku
                                        ]);
                                    }
                                }else{
                                    $message = sprintf("Revise %s / Variation SKU %s (pID %d) to quantity %d - Error: %s\n",
                                        $ebay_id,$sku, $transaction_pID,
                                        $new_ebay_variation_qty,
                                        $res
                                    );
                                    if($debug){
                                        debug('revise variation failed, write notice');
                                    }else{
                                        yes_write_notice('eBay Revise Error Auftrag '.$oID, 
                                            $message, 
                                            0, $rec_array
                                        );
                                    }
                                    printf("\tFAILED: %s\n",
                                        $message
                                    );
                                }
                            }
                        }else{
                            $new_ebay_qty = (int)$Transaction->QuantityPurchased + (int)$resItem->Item->Quantity - (int)$resItem->Item->SellingStatus->QuantitySold;
                            $bestandscheck_qty = $new_ebay_qty;
                            if( STOCK_CHECK == 'true' ){

                                if( $products_stock < 1 or $products_stock < $bestandscheck_qty){
                                    printf("\n\tKEIN Revise da STOCK_CHECK aktiv und products_stock=%d < Einstellmenge %d",
                                            $products_stock, $bestandscheck_qty
                                    );
                                    $allow_revise = false;
                                }
                            }
                            if($allow_revise === true){
                                $res = revise($ea->id,$new_ebay_qty);
                                if(empty($res)){
                                    if($debug){
                                        debug(sprintf(
                                            "yes_add_products_history() %d: %s",
                                            $transaction_pID,
                                            sprintf("Revise Auktion %s bei Anlage Auftrag %d: %d Stk.",
                                                $ebay_id, $oID,
                                                $bestandscheck_qty
                                            )
                                        ));
                                    }else{
                                        product::add_history_static(intval($transaction_pID),
                                            sprintf("Revise Auktion %s bei Anlage Auftrag %d: %d Stk.",
                                                $ebay_id, $oID,
                                                $bestandscheck_qty
                                            )
                                        );
                                    }
                                    printf("\tRevise %s to quantity %d (old qty %d + purchased %d - quantity_sold %d)\n",
                                        $ea->id,$new_ebay_qty,
                                        (int)$resItem->Item->Quantity,
                                        (int)$Transaction->QuantityPurchased,
                                        (int)$resItem->Item->SellingStatus->QuantitySold
                                    );
                                    $update_sql_array = [
                                        'quantity'=>$new_ebay_qty,
                                    ];
                                    if($debug){
                                        debug(sprintf(
                                            'update ebay auction to quantity=%d',
                                            $sku, $new_ebay_qty
                                        ));
                                    }else{
                                        \YES4Trade\Model\ebay_auctions::update_ebay_auction([
                                            'quantity'=>intval($new_ebay_qty),
                                            'id'=>intval($ea->id)
                                        ]);
                                    }
                                }else{
                                    $message = sprintf("Revise %s / pID %d to quantity %d - Error: %s\n",
                                        $ebay_id,$transaction_pID,
                                        $new_ebay_variation_qty,
                                        $res
                                    );
                                    if($debug){
                                        debug('revise failed, write notice');
                                    }else{
                                        yes_write_notice('eBay Revise Error Auftrag '.$oID, 
                                            $message, 
                                            0, $rec_array
                                        );
                                    }
                                    printf("\tFAILED: %s\n",
                                        $message
                                    );
                                }
                            }
                        }
                    }
            //
            // EOF - Revise
            // 

            if($yes_auction_exists && $transaction_pID > 0 and defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
                if($debug){
                    debug(sprintf(
                        'add pID %d to yes_end_auction_add (quantity %d)',
                        $transaction_pID,(int)$Transaction->QuantityPurchased
                    ));
                }else{
                    yes_end_auction_add($transaction_pID,(int)$Transaction->QuantityPurchased);
                }
            }

            // in_auction updaten
            $calculated_in_auction = yes_products_calc_in_auction_quantity($transaction_pID);
            if($debug){
                debug(sprintf(
                    'yes_update_products_in_auction_quantity() pID %d / %d Stk: %s',
                    $transaction_pID,$calculated_in_auction,
                    "Aktueller in_auction Wert: ".$calculated_in_auction
                ));
            }else{
                yes_update_products_in_auction_quantity($transaction_pID, 
                    $calculated_in_auction, 
                    "Aktueller in_auction Wert: ".$calculated_in_auction,
                    true
                );
            }
            $insert_sql_array = [
                'ebay_orders_id'=>$new_eoID,
                'transaction_id'=>$Transaction->TransactionID,
                'ebay_id'=>$ebay_id,
                'products_id'=>$transaction_pID
            ];

            if($debug){
                debug('create ebay_orders_items entry for OrderID='.$Order->OrderID.', OrderStatus='.$Order->OrderStatus.', user='.$Order->SellerUserID.', transaction_id='.$Transaction->TransactionID);
            }else{
                yes_db_perform('ebay_orders_items',$insert_sql_array);
            }
                    
        } // end foreach order transactions


        $insert_sql_array = [
            'orders_id'=>$oID,
            'title'=>MODULE_ORDER_TOTAL_SUBTOTAL_TITLE,
            'text'=>number_format($Order->Subtotal,2,',','').' '.constant('DEFAULT_CURRENCY'),
            'value'=>(float)$Order->Subtotal,
            'class'=>'ot_subtotal',
            'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER
        ];
        if($debug){
            debug('add ot subtotal='.(float)$Order->Subtotal);
        }else{
            yes_db_perform(TABLE_ORDERS_TOTAL, $insert_sql_array);
        }
                
        $insert_sql_array = [
            'orders_id'=>$oID,
            'title'=>MODULE_ORDER_TOTAL_SHIPPING_TITLE,
            'text'=>number_format($shipCosts,2,',','').' '.constant('DEFAULT_CURRENCY'),
            'value'=>(float)$shipCosts,
            'class'=>'ot_shipping',
            'sort_order'=>MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER
        ];
        if($debug){
            debug('add ot shipping='.(float)$shipCosts);
        }else{
            yes_db_perform(TABLE_ORDERS_TOTAL, $insert_sql_array);
        }
        if($use_tax === true) {
            $highest_tax = 0;
            foreach($tax_array as $tax_rate=>$tax_amount){
                if($tax_amount >= $highest_tax){
                    $use_tax_rate = $tax_rate;
                    $highest_tax = $tax_amount;
                }
            }

            $_taxval = $shipCosts-($shipCosts / ((100 + $use_tax_rate)/100));

            $tax_array[ "$use_tax_rate" ] += $_taxval;
                    
            foreach($tax_array as $tax_rate => $tax_value){
                $insert_sql_array = [
                    'orders_id'=>$oID,
                    'title'=>MODULE_ORDER_TOTAL_TAX_TITLE.' '.$tax_rate.'%',
                    'text'=>number_format($tax_value,2,',','').' '.constant('DEFAULT_CURRENCY'),
                    'value'=>(float)$tax_value,
                    'class'=>'ot_tax',
                    'sort_order'=>MODULE_ORDER_TOTAL_TAX_SORT_ORDER,
                    'tax_rate_percent'=>(float)$tax_rate
                ];
                if($debug){
                    debug('add ot tax '.$tax_rate.'%='.(float)$tax_value);
                }else{
                    yes_db_perform(TABLE_ORDERS_TOTAL, $insert_sql_array);
                }
            }
            $order_total_amount = (float)$Order->Total;
        }else{
            $order_total_amount = (float)$Order->Subtotal+(float)$shipCosts;
        }
                
        $insert_sql_array = [
            'orders_id'=>$oID,
            'title'=>MODULE_ORDER_TOTAL_TOTAL_TITLE,
            'text'=>number_format($order_total_amount,2,',','').' '.constant('DEFAULT_CURRENCY'),
            'value'=>(float)$order_total_amount,
            'class'=>'ot_total',
            'sort_order'=>MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER
        ];
        if($debug){
            debug('add ot total ='.(float)$order_total_amount);
        }else{
            yes_db_perform(TABLE_ORDERS_TOTAL, $insert_sql_array);
        }
                
        if($debug){
            debug(sprintf('order %d save_real_shippingcosts()',
                    $oID
            ));
        }else{
            $order = new order($oID, $xtPrice);
            $order->save_real_shipping_cost();
        }
		if(defined('EBAY_CHECKOUT_SEND_EMAIL') and EBAY_CHECKOUT_SEND_EMAIL == 'True'){
			$insert_id = $oID;
			$ebay_site = [
				'user'=>$Order->SellerUserID,
				'site'=>EBAY_SITE
			];
			$transaction = [
				'customer_id'=>$cID,
				'ebay_id'=>implode(', ',$ebay_id_array),
				'ebay_user'=>$Order->BuyerUserID, // kaeufer
				'password'=>'',
			];
			$auction_data = $et->auction_data_copy;
			// $is_registered wird weiter oben gesetzt
                        if($debug){
                            debug('send email to buyer');
                        }else{
                            include('ebay_send_order.php');
                        }
                }
                echo "\n\n------------------------------------\n\n";
        } // end foreach orders
    }
}