<?php
/* -----------------------------------------------------------------------------------------
   $Id: gv_send.php,v 1.4 2020/03/09 06:55:31 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project (earlier name of osCommerce)
   (c) 2002-2003 osCommerce (gv_send.php,v 1.1.2.3 2003/05/12); www.oscommerce.com

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contribution:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org


   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/


require('includes/application_top.php');


// GUTSCHEINE VERSENDEN AN EINE EMAIL ADRESSE
if (!defined('ACTIVATE_GIFT_SYSTEM') or ACTIVATE_GIFT_SYSTEM!='true') {
    xtc_redirect(FILENAME_DEFAULT);
}
if (!isset($_SESSION['customer_id'])) {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}

require('includes/classes/http_client.php');

require_once(DIR_FS_INC . 'xtc_draw_textarea_field.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_email.inc.php');
require_once(DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');


$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );


if (($_POST['back_x']) || ($_POST['back_y'])) {
    $_GET['action'] = '';
}
$action = $_GET['action'] ?? '';
if ($action == 'send') {
    $error = false;
    if (!xtc_validate_email(trim($_POST['email']))) {
        $error = true;
        $error_email = ERROR_ENTRY_EMAIL_ADDRESS_CHECK;
    }
    $customer_amount = 0;
    $gvc = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id((int) $_SESSION['customer_id']);
    if($gvc !== null){
        $customer_amount = (float)$gvc->amount;
    }
    $gv_amount = (float)trim($_POST['amount']);
    $_matches = [];
    if (ereg('[^0-9/.]', $gv_amount,$_matches)) {
        $error = true;
        $error_amount = ERROR_ENTRY_AMOUNT_CHECK; 
    }
    if ($gv_amount > $customer_amount or $gv_amount == 0) {
        $error = true; 
        $error_amount = ERROR_ENTRY_AMOUNT_CHECK_GUTHABEN;
    } 
}
if ($action == 'process') {
    $id1 = create_coupon_code($mail['customers_email_address']);
    $gvc = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id(intval($_SESSION['customer_id']));
    $new_amount = 0;
    if($gvc !== null){
        $new_amount = (float)$gvc->amount - (float)$_POST['amount'];
    }
    if ($new_amount < 0) {
        $error= true;
        $error_amount = ERROR_ENTRY_AMOUNT_CHECK; 
        $_GET['action'] = 'send';
    } else {
        $upd = new \YES4Trade\Model\coupon_gv_customer([
            'amount' => $new_amount,
            'customer_id'=>(int)$_SESSION['customer_id']
        ]);
        $upd->update();
        $cust = \YES4Trade\Model\customers::get_by_customers_id($_SESSION['customer_id']);
        
        $new = new \YES4Trade\Model\coupons([
            'coupon_type'=>'G', 
            'coupon_code'=>$id1, 
            'date_created'=>date('Y-m-d H:i:s'), 
            'coupon_amount'=> (float)$_POST['amount']
        ]);
        $insert_id = $new->create();
        
        $new = new \YES4Trade\Model\coupon_email_track([
            'coupon_id'=>intval($insert_id), 
            'customer_id_sent'=>intval($_SESSION['customer_id']), 
            'sent_firstname'=>$cust->customers_firstname, 
            'sent_lastname'=>$cust->customers_lastname, 
            'emailed_to'=>$_POST['email'], 
            'date_sent'=>date('Y-m-d H:i:s')
        ]);
        $new->create();

        $gv_email_subject = sprintf(EMAIL_GV_TEXT_SUBJECT, stripslashes($_POST['send_name']));

        $smarty->assign('language', $_SESSION['language']);
        $smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
        $smarty->assign('logo_path',HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
        $smarty->assign('GIFT_LINK',xtc_href_link(FILENAME_GV_REDEEM, 'gv_no=' . $id1,'NONSSL',false));
        $smarty->assign('AMMOUNT',$xtPrice->xtcFormat((float)$_POST['amount'],true));
        $smarty->assign('GIFT_CODE',$id1);
        $smarty->assign('MESSAGE',$_POST['message']);
        $smarty->assign('NAME',$_POST['to_name']);
        $smarty->assign('FROM_NAME',$_POST['send_name']);

        $smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);

        // dont allow cache
        $smarty->caching = false;

        $html_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/send_gift_to_friend.html');
        $txt_mail=$smarty->fetch(CURRENT_TEMPLATE.'/mail/'.$_SESSION['language'].'/send_gift_to_friend.txt');


        // send mail
        xtc_php_mail(
            EMAIL_BILLING_ADDRESS,
            EMAIL_BILLING_NAME,
            $_POST['email'],
            $_POST['to_name'],
            '',
            EMAIL_BILLING_REPLY_ADDRESS,
            EMAIL_BILLING_REPLY_ADDRESS_NAME,
            '',
            '',
            $gv_email_subject,
            $html_mail,
            $txt_mail
        );
    }
    xtc_redirect(FILENAME_ACCOUNT);
}
$breadcrumb->add(NAVBAR_GV_SEND);

 
require(DIR_WS_INCLUDES . 'header.php');

if ($action == 'send' && !$error) {
    $smarty->assign('action', 'send');
    // validate entries
    $gv_amount = (float) $gv_amount;
    $cust = \YES4Trade\Model\customers::get_by_customers_id($_SESSION['customer_id']);
    $send_name = $cust->customers_firstname . ' ' . $cust->customers_lastname;
    $smarty->assign('FORM_ACTION', '<form action="'.xtc_href_link(FILENAME_GV_SEND, 'action=process', 'NONSSL').'" method="post">');
    $smarty->assign('MAIN_MESSAGE', sprintf(MAIN_MESSAGE, 
        $xtPrice->xtcFormat($_POST['amount'],true), 
        stripslashes($_POST['to_name']), 
        $_POST['email'], 
        stripslashes($_POST['to_name']), 
        $xtPrice->xtcFormat($_POST['amount'],true), 
        $send_name
    ));
    if ($_POST['message']) {
        $smarty->assign('PERSONAL_MESSAGE', sprintf(PERSONAL_MESSAGE, $cust->customers_firstname));
        $smarty->assign('POST_MESSAGE', stripslashes($_POST['message']));
    }
    $smarty->assign('HIDDEN_FIELDS', 
        xtc_draw_hidden_field('send_name', $send_name) 
        . xtc_draw_hidden_field('to_name', stripslashes($_POST['to_name'])) 
        . xtc_draw_hidden_field('email', $_POST['email']) 
        . xtc_draw_hidden_field('amount', $gv_amount) 
        . xtc_draw_hidden_field('message', stripslashes($_POST['message']))
    );
    $smarty->assign('LINK_BACK', xtc_image_submit('button_back.gif', IMAGE_BUTTON_BACK, 'name=back') . '</a>');
    $smarty->assign('LINK_SUBMIT', xtc_image_submit('button_send.gif', IMAGE_BUTTON_CONTINUE));
} elseif ($action=='' || $error) {
    $smarty->assign('action', '');
    $smarty->assign('FORM_ACTION', '<form action="'.xtc_href_link(FILENAME_GV_SEND, 'action=send', 'NONSSL') . '" method="post">');
    $smarty->assign('LINK_SEND', xtc_href_link(FILENAME_GV_SEND, 'action=send', 'NONSSL'));
    $smarty->assign('INPUT_TO_NAME', xtc_draw_input_field('to_name', stripslashes($_POST['to_name'])));
    $smarty->assign('INPUT_EMAIL', xtc_draw_input_field('email', $_POST['email']));
    $smarty->assign('ERROR_EMAIL', $error_email);
    $smarty->assign('INPUT_AMOUNT', xtc_draw_input_field('amount', $_POST['amount'], '', '', false));
    $smarty->assign('ERROR_AMOUNT', $error_amount);
    $smarty->assign('TEXTAREA_MESSAGE', xtc_draw_textarea_field('message', 'soft', 50, 15, 
            stripslashes($_POST['message'])
        )
    );
    $smarty->assign('LINK_SUBMIT', xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE));
}
$smarty->assign('language', $_SESSION['language']);
$smarty->caching = 0;
$main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/gv_send.html');

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');

