<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_check_categories_status.inc.php,v 1.2 2008/05/26 09:23:45 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/



function xtc_check_categories_status($categories_id) {
    global $InstanceCache;
    if (intval($categories_id)<1) {
        return 0;
    }
    $cache_key = 'shop_categories_status_'.$categories_id;
    $cache_group = 'categories';
    $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);
    $CachedString = $InstanceCache->getItem($key); // cache group
    if (!$CachedString->isHit()) {
        $parameters = ['categories_id'=>intval($categories_id)];
        $categorie_query_raw = sprintf("SELECT parent_id, categories_status FROM %s WHERE categories_id =:categories_id",
            TABLE_CATEGORIES
        );
        $categorie_data = yes_query($categorie_query_raw, $parameters,true);
        $CachedString->set($categorie_data)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }else{
        $categorie_data = $CachedString->get();
    }
    if (intval($categorie_data['categories_status'])==0) {
        return 1;
    }
    if (intval($categorie_data['parent_id'])!=0) {
        if (xtc_check_categories_status($categorie_data['parent_id'])>=1) {
            return 1;
        }
    }
    return 0;    	
}
