<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_get_categories.inc.php,v 1.3 2014/11/17 08:25:14 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com
   (c) 2003	 nextcommerce (xtc_get_categories.inc.php,v 1.3 2003/08/13); www.nextcommerce.org 

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
function xtc_get_categories($categories_array = '', $parent_id = '0', $indent = '',$only_ebayapi_cart=false) {
    global $InstanceCache;
    if (!is_countable($categories_array)) {
        $categories_array = [];
    }
    $categories_query_cart = ($only_ebayapi_cart !== false) ? " and ebayapi_cart='1'" : '';

    $cache_key = 'shop.all.categories.parent'.$parent_id.'-ec'.(($only_ebayapi_cart!==false)?'1':'0');
    $cache_group = 'categories';
    $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

    $CachedString = $InstanceCache->getItem($key); // cache group
    if (!$CachedString->isHit()) {
        $categories_query = yes_query(sprintf(
            "select c.categories_id, cd.categories_name from %s c left join %s cd using(categories_id) where parent_id =:parent_id and c.categories_status != 0 and cd.language_id=:language_id %s",
                TABLE_CATEGORIES, TABLE_CATEGORIES_DESCRIPTION, $categories_query_cart
            ),[
                'parent_id'=> intval($parent_id),
                'language_id'=>intval($_SESSION['languages_id'])
            ]
        );
        $CachedString->set($categories_query)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }else{
        $categories_query = $CachedString->get();
    }
    if(!sizeOf($categories_query)){
       return $categories_array;
    }
    foreach($categories_query as $categories) {
        $categories_array[] = array(
            'id' => $categories['categories_id'],
            'text' => $indent . $categories['categories_name']
        );
        if ($categories['categories_id'] != $parent_id) {
            $categories_array = xtc_get_categories($categories_array,
                $categories['categories_id'], 
                $indent . '&nbsp;&nbsp;',
                $only_ebayapi_cart
            );
        }
    }
    return $categories_array;
}
