<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_get_currencies_values.inc.php,v 1.1 2006/05/03 07:11:49 web2 Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2003	 nextcommerce (xtc_get_currencies_values.inc.php,v 1.1 2003/08/213); www.nextcommerce.org
   
   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/


function xtc_get_currencies_values(string $code) {
    global $InstanceCache;
    if(empty($code)){
        $code = (defined('DEFAULT_CURRENCY'))?DEFAULT_CURRENCY:'EUR';
    }
    $key = 'currencies_values_'.$code;
    $CachedString = $InstanceCache->getItem($key);
    if (!$CachedString->isHit()) {
        $currencie_data = yes_query(sprintf(
            "select * from %s where code =:code",
                TABLE_CURRENCIES
            ),['code'=>$code],
            true
        );
        $CachedString->set($currencie_data)->expiresAfter(0)->addTag('shop');//currencies_values_*
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        return $currencie_data;
    }
    return $CachedString->get();
}