<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_get_download.inc.php,v 1.2 2017/07/06 06:26:27 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   by Mario Zanier <webmaster@zanier.at>
   based on:
   (c) 2003	 nextcommerce (xtc_get_download.inc.php,v 1.4 2003/08/25); www.nextcommerce.org
   
   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
// safe download function, file get renamed bevor sending to browser!!
function xtc_get_download($content_id) {
    $item = \YES4Trade\Model\products_content::get_by_content_id($content_id);
    if($item == null or empty($item->content_file)){
        xtc_redirect(xtc_href_link('index.php'));
    }
    $item->content_read = $item->content_read+1;
    $item->update();
    // original filename
    $is_in_media = false;
    if(strpos($item->content_file,'/')>0){
        $new_filename = DIR_FS_CATALOG.$item->content_file;
    }else{
        $is_in_media = true;
        $filename = DIR_FS_CATALOG.'media/products/'.$item->content_file;
        $backup_filename = DIR_FS_CATALOG.'media/products/backup/'.$item->content_file;
        $orign_hash_id=md5_file($filename);
        clearstatcache();
        // create new filename with timestamp
        $timestamp=str_replace('.','',microtime());
        $timestamp=str_replace(' ','',$timestamp);
        $new_filename=DIR_FS_CATALOG.'media/products/'.$timestamp.strstr($item->content_file,'.');
        rename($filename,$new_filename);
    }
    if (file_exists($new_filename)) {
        header("Content-type: application/force-download");
        header("Content-Disposition: attachment; filename=".$new_filename);
        @readfile($new_filename);	
        if($is_in_media){
            // rename file to original name
            rename($new_filename,$filename);
            $new_hash_id=md5_file($filename);
            clearstatcache();	

            // check hash id of file again, if not same, get backup!
            if ($new_hash_id!=$orign_hash_id) {
                copy($backup_filename,$filename);
            }
        }
    }
}