<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_get_product_path.inc.php,v 1.7 2012/06/16 07:56:11 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce 
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_get_product_path.inc.php,v 1.3 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
// Construct a category path to the product
// TABLES: products_to_categories
function xtc_get_product_path($products_id,$current_category=false) {
    $cPath = '';

    $status_sql = " and p.products_status = '1' ";
    
    // IM ADMINBEREICH STATUS EGAL
    if(preg_match('/\/admin\//',$_SERVER['PHP_SELF'])){
    	$status_sql = '';
    }
    if(!$current_category){
        $parameters = [
            'products_id'=>(int)$products_id,
        ];
        $category_query_raw = sprintf(
            "select p2c.categories_id from %s p, %s p2c where p.products_id =:products_id %s and p.products_id = p2c.products_id limit 1",
            TABLE_PRODUCTS,TABLE_PRODUCTS_TO_CATEGORIES,$status_sql
        );

        $category_query = yes_query($category_query_raw,
            $parameters
        );
        $num = sizeOf($category_query);
        if ($num>0) {
            $category = current($category_query);
            $current_category = $category['categories_id'];
        }
    }
    if($current_category){
        $categories = array();
        xtc_get_parent_categories($categories, $current_category);
        $categories = array_reverse($categories);

        $cPath = implode('_', $categories);
        if (xtc_not_null($cPath)) {
            $cPath .= '_';
        }
        $cPath .= $category['categories_id'];
    }
    return $cPath;
}

