<?php
function xtc_get_reclamation_packingslip_html_for_pdf($reclamation,$smarty,$template,$lagerplaetze = false){
	require_once(DIR_WS_CLASSES.'product.php');
	$smarty->assign('address_label_customer',xtc_address_format($reclamation->customer['format_id'], $reclamation->customer, 1, '', '<br>'));
	$smarty->assign('address_label_shipping',xtc_address_format($reclamation->delivery['format_id'], $reclamation->delivery, 1, '', '<br>'));
	$smarty->assign('csID',$reclamation->customer['csID']);

	if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
		$img_path = xtc_generate_packingslip_barcode('R'.$reclamation->info['id'],\main::get_exportdata_path());
		$smarty->assign('BARCODE','<img src="'.HTTP_SERVER.'admin/exportdata/BARCODE_'.$img_path.'" border="0">'); // funktioniert spaeter mit .htaccess rule
	}
	$ebay_seller = xtc_get_orders_ebay_seller($reclamation->info['orders_id']);
	if($ebay_seller != ''){
		$smarty->assign('EBAY_SELLER_DATA',xtc_get_ebay_seller_data($ebay_seller));
		$smarty->assign('EBAY_ID',$reclamation->info['ebay_id']);
	}
	$reclamation_data = array();
	$reclamation->products = xtc_db_prepare_input($reclamation->products);
	for($i=0;$i<sizeOf($reclamation->products);$i++){
		$product = new product($reclamation->products[$i]['id']);
		$product_colli_array = array();
		$collies = xtc_get_product_collies($reclamation->products[$i]['id']);
		if(sizeOf($collies)){
		    foreach($collies as $collie){
			$colli_product = new product($collie['collie_products_id']);
			$weight = xtc_get_ext_products_weight($collie['collie_products_id']);
			$weight_total = $weight*$reclamation->products[$i]['qty']*$collie['quantity'];
			$product_colli_array[] = array(
			    'PRODUCTS_ID'=>$collie['collie_products_id'],
			    'PRODUCTS_NAME'=>xtc_db_prepare_input($colli_product->info['products_name']),
			    'PRODUCTS_MODEL'=>xtc_db_prepare_input($colli_product->info['products_model']),
			    'PRODUCTS_EAN'=>xtc_db_prepare_input($colli_product->info['products_ean']),
			    'PRODUCTS_STORAGES'=>$colli_product->get_storages(),
			    'PRODUCTS_WEIGHT'=>$weight,
			    'PRODUCTS_WEIGHT_TOTAL'=>$weight_total
			);
		    }
		}
		// LAGERPLAETZE
		$storage_str = '';
		if($lagerplaetze){
			$transfer_places = $reclamation->get_transferred_places($reclamation_data_values['products_id'],'Abholung');
			if(sizeOf($transfer_places)){
				foreach($transfer_places as $tp){
				    $tp = xtc_db_prepare_input($tp);
				    $storage_str .= sprintf('<br />Lager &raquo;%s&laquo; / Lagerplatz &raquo;%s&laquo;: %s Stk.',
					    $tp['name'],$tp['storage_place'],$tp['quantity']
				    );
				}
			}
		}
		
		$reclamation_data[]=array(
		    'PRODUCTS_ID'=>$reclamation->products[$i]['id'],
		    'PRODUCTS_STORAGES_STR'=>$storage_str,
		    'PRODUCTS_STORAGES'=>$product->get_storages(),
		    'PRODUCTS_MODEL' => $reclamation->products[$i]['model'],
		    'PRODUCTS_EAN' => $product->info['products_ean'],
		    'PRODUCTS_NAME' => $reclamation->products[$i]['name'],
		    'PRODUCTS_QTY' => $reclamation->products[$i]['qty'],
		    'COLLIES'=>$product_colli_array
		);
	}
	// assign language to template for caching
	$smarty->assign('STORE', nl2br(STORE_NAME_ADDRESS));
	$smarty->assign('STORE_WRAP', STORE_WRAP);
	$smarty->assign('BANK', MODULE_PAYMENT_MONEYORDER_PAYTO);
	
	$smarty->assign('language', $_SESSION['language']);
	$smarty->assign('logo_path',HTTP_SERVER.'templates/'.CURRENT_TEMPLATE.'/img/');
	
	$smarty->assign('rID',$reclamation->info['id']);
	$smarty->assign('oID',$reclamation->info['orders_id']);
	
	$smarty->assign('DATE',xtc_date_short($reclamation->info['date_created']));
	$smarty->assign('order_data', $reclamation_data);
	$pdf_html=$smarty->fetch($template);
	return $pdf_html;
}
?>
