<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_get_tax_rate.inc.php,v 1.4 2014/07/16 14:16:47 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_get_tax_rate.inc.php,v 1.3 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

function xtc_get_tax_rate($class_id, $country_id = -1, $zone_id = -1, $debug = false) {
    global $InstanceCache;
    if($debug === true){
        printf('<li>xtc_get_tax_rate(): class_id %s, $country_id %s, $zone_id %s',
            $class_id, $country_id, $zone_id
        );
    }
    if ( ($country_id == -1) && ($zone_id == -1) ) {
        // aus dem shop admin heraus, dieses define findet nur in der
        // admin/includes/application und -cron_application_top.php statt
        $admin = defined('ORDERS_EDIT_TAX_STATUS');
        if (!isset($_SESSION['customer_id']) or $admin) {
            $country_id = yes_get_store_country_id();
            $zone_id = yes_get_store_zone_id();
        } else {
            $country_id = $_SESSION['customer_country_id'];
            $zone_id = $_SESSION['customer_zone_id'];
        }
    }
    $key = 'tax_rates_'.$country_id.'_'.$zone_id.'_'.$class_id;
    if($debug === true){
        echo 'xtc_get_tax_rate: cache key '.$key;
    }
    $CachedString = $InstanceCache->getItem($key);
    if (!$CachedString->isHit()) {
        $tax_query = yes_query(sprintf(
            "select sum(tax_rate) as tax_rate from %s tr left join %s za on (tr.tax_zone_id = za.geo_zone_id) left join %s tz on (tz.geo_zone_id = tr.tax_zone_id) "
           ." where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id =:country_id) and (za.zone_id is null or za.zone_id = '0' or za.zone_id =:zone_id) and tr.tax_class_id =:class_id group by tr.tax_priority",
                TABLE_TAX_RATES,TABLE_ZONES_TO_GEO_ZONES,TABLE_GEO_ZONES,
            ),[
                'country_id'=>$country_id,
                'zone_id'=>$zone_id,
                'class_id'=>$class_id
            ]
        );
        if (sizeOf($tax_query)) {
            $tax_multiplier = 1.0;
            foreach($tax_query as $tax) {
                $tax_multiplier *= 1.0 + ($tax['tax_rate'] / 100);
            }
            $return = ($tax_multiplier - 1.0) * 100;
        } else {
            $return = 0;
        }
        $CachedString->set($return)->expiresAfter(0)->addTag('shop');//tax_rates_*
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }else{
        $return = $CachedString->get();
    }
    return $return;
}
