<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_validate_email.inc.php,v 1.4 2017/02/08 09:40:40 cvs Exp $

   modified eCommerce Shopsoftware
   http://www.modified-shop.org

   Copyright (c) 2009 - 2013 [www.modified-shop.org]
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(validations.php,v 1.11 2003/02/11); www.oscommerce.com
   (c) 2003 nextcommerce (xtc_validate_email.inc.php,v 1.5 2003/08/14); www.nextcommerce.org
   (c) 2003 XT-Commerce (xtc_validate_email.inc.php 899 2005-04-29)
   (c) 2010 osCommerce (validations.php)

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

  ////////////////////////////////////////////////////////////////////////////////////////////////
  //
  // Function    : xtc_validate_email
  //
  // Arguments   : email   email address to be checked
  //
  // Return      : true  - valid email address
  //               false - invalid email address
  //
  // Description : function for validating email address that conforms to RFC 822 specs
  //
  //              This function will first attempt to validate the Email address using the filter
  //              extension for performance. If this extension is not available it will
  //              fall back to a regex based validator which doesn't validate all RFC822
  //              addresses but catches 99.9% of them. The regex is based on the code found at
  //              http://www.regular-expressions.info/email.html
  //
  //              Optional validation for validating the domain name is also valid is supplied
  //              and can be enabled using the administration tool.
  //
  // Sample Valid Addresses:
  //
  //    first.last@host.com
  //    firstlast@host.to
  //    first-last@host.com
  //    first_last@host.com
  //
  // Invalid Addresses:
  //
  //    first last@host.com
  //    first@last@host.com
  //
  ////////////////////////////////////////////////////////////////////////////////////////////////

  function xtc_validate_email($email) {
//      $valid_tld = '|com|org|net|edu|gov|mil|biz|info|mobi|name|aero|asia|jobs|museum|cat|coop|int|post|tel|travel|xxx|arpa|bitnet|example|invalid|local|localhost|nato|root|test|uucp|onion|academy|accountant|accountants|cloud|active|actor|adult|agency|airforce|apartments|app|archi|army|associates|attorney|auction|audio|autos|band|bar|bargains|beer|best|bid|bike|bingo|bio|black|blackfriday|blog|blue|boo|boutique|build|builders|business|buzz|cab|camera|camp|cancerresearch|capital|cards|care|career|careers|cash|casino|catering|center|ceo|channel|chat|cheap|christmas|church|city|claims|cleaning|click|clinic|clothing|club|coach|codes|coffee|college|community|company|computer|condos|construction|consulting|contractors|cooking|cool|coop|country|coupons|credit|reditcard|cricket|cruises|dad|dance|date|dating|day|deals|degree|delivery|democrat|dental|dentist|design|diamonds|diet|digital|direct|directory|discount|dog|domains|download|eat|education|email|energy|engineer|engineering|equipment|esq|estate|events|exchange|expert|exposed|express|fail|faith|family|fans|farm|fashion|pid|finance|financial|fish|fishing|fit|fitness|flights|florist|flowers|fly|foo|football|forsale|foundation|fund|furniture|fyi|gallery|garden|gift|gifts|gives|glass|global|gold|golf|gop|graphics|green|gripe|guide|guitars|guru|healthcare|help|here|hiphop|hiv|hockey|holdings|holiday|homes|horse|host|hosting|house|how|info|ing|ink|institute|insure|international|jewelry|kim|kitchen|land|lawyer|lease|legal|lgbt|life|lighting|limited|limo|link|loan|loans|lol|lotto|love|luxe|luxury|management|market|marketing|markets|mba|media|meet|meme|memorial|men|menu|moe|money|mortgage|motorcycles|mov|movie|navy|network|new|news|ngo|ninja|one|ong|onl|online|ooo|organic|partners|parts|party|pharmacy|photo|photography|photos|physio|pics|pictures|feedback|pink|pizza|place|plumbing|plus|poker|porn|post|press|pro|productions|prof|properties|property|qpon|acing|recipes|red|rehab|ren|rent|rentals|repair|report|republican|rest|review|reviews|rich|rip|rocks|rodeo|rsvp|run|sale|school|science|services|sex|sexy|shoes|show|singles|site|soccer|social|software|solar|solutions|space|studio|style|sucks|supplies|supply|support|surf|surgery|systems|tattoo|tax|taxi|team|tech|technology|tel|tennis|theater|tips|tires|today|tools|top|tours|town|toys|trade|training|travel|university|vacations|vet|video|villas|vision|vodka|vote|voting|voyage|wang|watch|webcam|website|wed|wedding|whoswho|wiki|win|wine|work|works|world|wtf|xyz|yoga|zone|maison|abogado|gratis|futbol|juegos|soy|tienda|uno|viajes|haus|immobilien|jetzt|kaufen|reise|reisen|schule|versicherung|desi|shiksha|casa|cafe|immo|moda|voto|bank|enterprises|industries|ltda|pub|realtor|reit|restaurant|sarl|ventures|capetown|durban|joburg|krd|nagoya|okinawa|ryukyu|taipei|tatar|tokyo|yokohama|alsace|amsterdam|barcelona|bayern|berlin|brussels|budapest|bzh|cologne|corsica|cymru|eus|frl|gal|gent|hamburg|irish|koeln|london|madrid|moscow|nrw|paris|ruhr|saarland|scot|tirol|vlaanderen|wales|wien|zuerich|miami|nyc|quebec|vegas|kiwi|melbourne|sydney|lat|rio|allfinanz|android|aquarelle|axa|barclays|barclaycard|bloomberg|bmw|bnl|bnpparibas|cal|caravan|cern|chrome|citic|crs|cuisinella|dnp|dvag|emerck|everbank|firmdale|flsmidth|frogans|gbiz|gle|globo|gmail|gmo|gmx|google|hsbc|ibm|kred|lacaixa|latrobe|lds|mango|minimonash|mormon|neustar|nexus|nhk|nico|nra|otsuka|ovh|piaget|pohl|praxi|prod|pwc|sandvikcoromant|sca|scb|schmidt|sohu|spiegel|suzuki|tui|uol|williamhill|wme|wtc|yandex|youtube|gmbh|ads|how|soy|shop|hotel|hotels|ping|srl|baby|mls|dot|reality|salon|spot|buy|zip';

    //BOF - web28 - 2011-07-31 - SQL nullbyte injection fix 16.02.2011
    if (strpos($email,"\0")!== false) {return false;}
    if (strpos($email,"\x00")!== false) {return false;}
    if (strpos($email,"\u0000")!== false) {return false;}
    if (strpos($email,"\000")!== false) {return false;}
    //EOF - web28 - 2011-07-31 - SQL nullbyte injection fix 16.02.2011

    $email = trim($email);
    $valid_address = false;
    if (strlen($email) > 255) {
      $valid_address = false;    
    } else {
      if ( substr_count( $email, '@' ) > 1 ) {
        $valid_address = false;
      }     
      
      //web28 - 2011-07-28 - new $regex see http://www.regular-expressions.info/email.html      
      //$regex = "/^[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+(?:[A-Z]{2}".$valid_tld.")$/i";
      //$valid_address = preg_match($regex, $email);      
	if(filter_var($email, FILTER_VALIDATE_EMAIL))
	{
		$valid_address = true;
	}
    }
    
    if ($valid_address && ENTRY_EMAIL_ADDRESS_CHECK == 'true') {
      $domain = explode('@', $email);
      if (!checkdnsrr($domain[1], "MX") && !checkdnsrr($domain[1], "A")) {
        $valid_address = false;
      }
    }    
    return $valid_address;
  }
?>
