<?php
/**
 * Ermittelt alle laufenden Auktionen (auch Varianten) der pID und traegt den
 * Preis und die eBay Daten in die Tabelle ebay_auctions_price_revise ein.
 * Dabei wird geprueft ob bereits ein Eintrag zur pID, ebay_id, ebay_auctions_id
 * vorhanden ist.
 * @param INT $pID
 * @param FLOAT $price
 * @return int Anzahl eingefuegter revise Datensaetze
 */
function yes_add_price_revise_for_products_auctions($pID,$price,$is_special = 0){
	$auctions = array();
	$query = xtc_db_query(sprintf(
		"SELECT id, ebay_id FROM ebay_auctions WHERE status=0 AND products_id='%s'",
		$pID
	));
	while($record = xtc_db_fetch_array($query)){
		$auctions[] = array(
			'ebay_auctions_id'=>$record['id'],
			'ebay_id'=>$record['ebay_id'],
			'ebay_auctions_id'=>$record['id'],
			'price'=>$price,
			'products_id'=>$pID
		);
	}
	
	$query = xtc_db_query(sprintf(
		"SELECT ea.id, ea.ebay_id FROM ebay_auctions_variations eav LEFT JOIN ebay_auctions ea ON ea.id=eav.ebay_auctions_id WHERE ea.status=0 AND eav.products_id='%s'",
		$pID
	));
	while($record = xtc_db_fetch_array($query)){
		$auctions[] = array(
			'ebay_auctions_id'=>$record['id'],
			'ebay_id'=>$record['ebay_id'],
			'ebay_auctions_id'=>$record['id'],
			'price'=>$price,
			'products_id'=>$pID
		);
	}
	if(!sizeOf($auctions))
		return 0;
	$added = 0;
	xtc_db_query(sprintf(
		"DELETE FROM ebay_auctions_price_revise_auctions WHERE products_id='%s'",
		$pID
	));
	$query = xtc_db_query(sprintf(
		"SELECT ebay_auctions_price_revise_id FROM ebay_auctions_price_revise WHERE products_id='%s'",
		$auction['products_id']
	));
	if(!xtc_db_num_rows($query)){
		$insert_sql_array = array(
			'products_id'=>$pID,
			'price'=>$price
		);
		xtc_db_perform('ebay_auctions_price_revise',$insert_sql_array);
		foreach($auctions as $auction){
			$insert_sql_array = array(
				'products_id'=>$pID,
				'ebay_auctions_id'=>$auction['ebay_auctions_id'],
				'date_added'=>'now()',
				'is_special'=>$is_special
			);
			xtc_db_perform('ebay_auctions_price_revise_auctions',$insert_sql_array);
			$added++;
		}
	}
	return $added;
}
