<?php
function yes_check_vat_id(string $vat_id){
    if(strlen(trim($vat_id))<5){
        return false;
    }
    $vatid = preg_replace("/[^a-zA-Z0-9]]/", "", $vat_id); // remove non alphanum characters
    $country = substr($vatid, 0, 2);
    $eu_countries = [
        'AT', 'BE', 'BG', 'CY', 'CZ', 'DE', 'DK', 'EE', 'ES', 'FI', 'FR', 'GR', 'HR', 'HU',
        'IE', 'IT', 'LT', 'LU', 'LV', 'MT', 'NL', 'PL', 'PT', 'RO', 'SE', 'SI', 'SK'
    ];
    $vat_live_check = (!defined('ACCOUNT_COMPANY_VAT_LIVE_CHECK') or ACCOUNT_COMPANY_VAT_LIVE_CHECK == 'false') ? false : true;
    if(!in_array(strtoupper($country),$eu_countries) or !$vat_live_check ){
        return true;
    }
    try {
        // a valid vat id consists of an alpha country code and up to 12 alphanumeric characters
        $vatidRegex = "/^[a-z]{2}[a-z0-9]{0,12}$/i";
        if (preg_match($vatidRegex, $vatid) !== 1) {
            return false;
        }
        
        //$options = array('trace' => 1,'encoding' => CHARSET);
        $wsdlurl = "https://ec.europa.eu/taxation_customs/vies/checkVatService.wsdl";
        $client = new \SoapClient($wsdlurl);

        // using checkVatApprox() as it tends to return a bit more information than checkVat()
        $params = [
            'countryCode' => substr($vatid, 0, 2),
            'vatNumber' => substr($vatid, 2),
        ];
        $result = $client->checkVatApprox($params);

        if ($result->valid) {
            return true;
        }

    } catch (\Exception $exception) {
        throw new \Exception(CHECK_VATID_ERROR_SERVICE_UNAVAILABLE);
    }    
    return false;
}