<?php
if(!function_exists('xtc_get_vpe_name')){
    require_once(DIR_FS_INC.'xtc_get_vpe_name.inc.php');
}
function yes_get_products_vpe_string($xtPrice,$products_id,$price){
    $string = '';
    $query = yes_query(
        "SELECT products_vpe, products_vpe_status, products_vpe_base_measure,products_vpe_value FROM products WHERE products_id=:products_id",
        ['products_id'=>(int)$products_id]
    );
    if(!sizeOf($query)){
        return $string;
    }
    $record = current($query);
    if((float)$price === 0 or (float)$record['products_vpe_status'] < 0.01 or (float)$record['products_vpe_value'] < 0.01 or $record['products_vpe'] == 0){
        return $string;
    }
    // tax class als 0 uebergeben
    if((float)$record['products_vpe_base_measure'] > 0){
        $vpe = $price / $record['products_vpe_value'] * $record['products_vpe_base_measure'];
        $string = $xtPrice->xtcFormat($vpe, true, 0) . TXT_PER . ' '.number_format($record['products_vpe_base_measure'],2,',','.').' '.xtc_get_vpe_name($record['products_vpe']);
    }else{
        $vpe = $price * (1 / $record['products_vpe_value']);
        $string = $xtPrice->xtcFormat($vpe, true, 0) . TXT_PER . ' '.xtc_get_vpe_name($record['products_vpe']);
    }
    return $string;
}
