<?php
/* -----------------------------------------------------------------------------------------
   $Id: application_top_callback.php,v 1.6 2019/02/08 17:09:45 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(application_top.php,v 1.273 2003/05/19); www.oscommerce.com
   (c) 2003	 nextcommerce (application_top.php,v 1.54 2003/08/25); www.nextcommerce.org 

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contribution:
   Add A Quickie v1.0 Autor  Harald Ponce de Leon
    
   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

use phpFastCache\CacheManager;
define('YES_SQL_EMPTY_DATE','0000-00-00 00:00:00');
// start the timer for the page parse time log
define('PAGE_PARSE_START_TIME', microtime());
// set the level of error reporting
error_reporting(E_ALL & ~E_NOTICE);
//  error_reporting(E_ALL);

// Set the local configuration parameters - mainly for developers - if exists else the mainconfigure
if (file_exists('../../includes/local/configure.php')) {
  include('../../includes/local/configure.php');
} else {
  include('../../includes/configure.php');
}
require_once(DIR_FS_CATALOG.'includes/classes/phpfastcache/src/autoload.php');
define('YES_PHPFASTCACHE_METHOD','files');
define('YES_PHPFASTCACHE_TAG_NEW_ORDERS','new_orders');
define('YES_PHPFASTCACHE_STATS_EXPIRE',60*60*24);
require_once(DIR_FS_CATALOG. 'admin/includes/classes/ACK.php');


  
  // define the project version
  define('PROJECT_VERSION', 'xt:Commerce v3.0.4 SP2');

  // set the type of request (secure or not)
  $request_type = (getenv('HTTPS') == '1' || getenv('HTTPS') == 'on') ? 'SSL' : 'NONSSL';

  // set php_self in the local scope
  $PHP_SELF = $_SERVER['PHP_SELF'];

  // include the list of project filenames
  require(DIR_WS_INCLUDES . 'filenames.php');

  // include the list of project database tables
  require(DIR_WS_INCLUDES . 'database_tables.php');
  require(DIR_WS_INCLUDES . 'classes/main.php');
  
$secure_path = main::get_secure_path();
$fc_config = array(
    "path" => $secure_path.DIRECTORY_SEPARATOR.'fastcache'
);

if(!is_dir($fc_config['path'])){
    mkdir($fc_config['path']) or die('Cant create fastcache dir');
    chmod($fc_config['path'],0777) or die('Cant give write access to fastcache dir');
}
// Setup File Path on your config files
CacheManager::setDefaultConfig($fc_config);
$InstanceCache = CacheManager::getInstance(YES_PHPFASTCACHE_METHOD);
require_once(DIR_WS_CLASSES.'YES4Trade/autoload.php');


  // Store DB-Querys in a Log File
  define('STORE_DB_TRANSACTIONS', 'false');

  // include used functions
  require_once(DIR_FS_INC . 'xtc_db_connect.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_close.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_error.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_perform.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_query.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_fetch_array.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_num_rows.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_data_seek.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_insert_id.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_free_result.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_fetch_fields.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_output.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_input.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_prepare_input.inc.php');
  
  require_once (DIR_FS_INC.'xtc_href_link.inc.php');
require_once (DIR_FS_INC.'xtc_draw_separator.inc.php');
require_once (DIR_FS_INC.'xtc_php_mail.inc.php');

//require_once (DIR_FS_INC.'xtc_product_link.inc.php');
//require_once (DIR_FS_INC.'xtc_category_link.inc.php');
//require_once (DIR_FS_INC.'xtc_manufacturer_link.inc.php');

// html functions
require_once (DIR_FS_INC.'xtc_draw_checkbox_field.inc.php');
require_once (DIR_FS_INC.'xtc_draw_form.inc.php');
require_once (DIR_FS_INC.'xtc_draw_hidden_field.inc.php');
require_once (DIR_FS_INC.'xtc_draw_input_field.inc.php');
require_once (DIR_FS_INC.'xtc_draw_password_field.inc.php');
require_once (DIR_FS_INC.'xtc_draw_pull_down_menu.inc.php');
require_once (DIR_FS_INC.'xtc_draw_radio_field.inc.php');
require_once (DIR_FS_INC.'xtc_draw_selection_field.inc.php');
require_once (DIR_FS_INC.'xtc_draw_separator.inc.php');
require_once (DIR_FS_INC.'xtc_draw_textarea_field.inc.php');
require_once (DIR_FS_INC.'xtc_image_button.inc.php');

require_once (DIR_FS_INC.'xtc_not_null.inc.php');
require_once (DIR_FS_INC.'xtc_update_whos_online.inc.php');
require_once (DIR_FS_INC.'xtc_activate_banners.inc.php');
require_once (DIR_FS_INC.'xtc_expire_banners.inc.php');
require_once (DIR_FS_INC.'xtc_expire_specials.inc.php');
require_once (DIR_FS_INC.'xtc_parse_category_path.inc.php');
require_once (DIR_FS_INC.'xtc_get_product_path.inc.php');

//require_once (DIR_FS_INC.'xtc_get_category_path.inc.php');

require_once (DIR_FS_INC.'xtc_get_parent_categories.inc.php');
require_once (DIR_FS_INC.'xtc_redirect.inc.php');
require_once (DIR_FS_INC.'xtc_get_uprid.inc.php');
require_once (DIR_FS_INC.'xtc_get_all_get_params.inc.php');
require_once (DIR_FS_INC.'xtc_has_product_attributes.inc.php');
require_once (DIR_FS_INC.'xtc_image.inc.php');
require_once (DIR_FS_INC.'xtc_check_stock_attributes.inc.php');
require_once (DIR_FS_INC.'xtc_currency_exists.inc.php');
require_once (DIR_FS_INC.'xtc_remove_non_numeric.inc.php');
require_once (DIR_FS_INC.'xtc_get_ip_address.inc.php');
require_once (DIR_FS_INC.'xtc_setcookie.inc.php');
require_once (DIR_FS_INC.'xtc_check_agent.inc.php');
require_once (DIR_FS_INC.'xtc_count_cart.inc.php');
require_once (DIR_FS_INC.'xtc_get_qty.inc.php');
require_once (DIR_FS_INC.'create_coupon_code.inc.php');
require_once (DIR_FS_INC.'xtc_gv_account_update.inc.php');
require_once (DIR_FS_INC.'xtc_get_tax_rate_from_desc.inc.php');
require_once (DIR_FS_INC.'xtc_get_tax_rate.inc.php');
require_once (DIR_FS_INC.'xtc_add_tax.inc.php');
require_once (DIR_FS_INC.'xtc_cleanName.inc.php');
require_once (DIR_FS_INC.'xtc_calculate_tax.inc.php');
require_once (DIR_FS_INC.'xtc_input_validation.inc.php');
require_once(DIR_FS_INC.'yes_get_products_properties_values_from_shopping_cart_id.inc.php');
require_once(DIR_FS_INC . 'yes_eu_oss.inc.php');
//require_once (DIR_FS_INC.'xtc_js_lang.php');


  // modification for new graduated system


  // make a connection to the database... now
  xtc_db_connect() or die('Unable to connect to database server!');

$key = 'configuration';
$CachedString = $InstanceCache->getItem($key);
if (!$CachedString->isHit()) {
    $configurations = [];
    $configuration_query = xtc_db_query(sprintf(
        "select configuration_key as ckey, configuration_value as cvalue from %s",
        TABLE_CONFIGURATION
    ));
    while ($configuration = xtc_db_fetch_array($configuration_query)) {
        $configurations[] = ['key'=>$configuration['ckey'], 'value'=>$configuration['cvalue']];
    }
    $CachedString->set($configurations)->expiresAfter(0)->addTag('shop');//in seconds, also accepts Datetime
    $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
    $configurations = $CachedString->get();
}
foreach($configurations as $cconf){
    define($cconf['key'], $cconf['value']);
}
  
  
  
  // if gzip_compression is enabled, start to buffer the output
  if ( (GZIP_COMPRESSION == 'true') && ($ext_zlib_loaded = extension_loaded('zlib')) && (PHP_VERSION >= '4') ) {
    if (($ini_zlib_output_compression = (int)ini_get('zlib.output_compression')) < 1) {
      ob_start('ob_gzhandler');
    } else {
      ini_set('zlib.output_compression_level', GZIP_LEVEL);
    }
  }

    // Include Template Engine
//  require(DIR_WS_CLASSES . 'Smarty_2.6.14/Smarty.class.php');

// EOF - Tomcraft - 2009-10-03 - Paypal Express Modul
  require (DIR_WS_FUNCTIONS.'sessions.php');
// EOF - Tomcraft - 2009-10-03 - Paypal Express Modul
function yes_get_store_country_id(){
    if (!isset($_SESSION['customer_id'])) {
        return STORE_COUNTRY;
    }
    if(isset($_SESSION['customer_country_id'])){
        return $_SESSION['customer_country_id'];
    }
    if(!isset($_SESSION['customer_default_address_id'])){
        return STORE_COUNTRY;
    }
    $query = xtc_db_query(sprintf(
            "SELECT entry_country_id FROM %s WHERE address_book_id='%d'",
            TABLE_ADDRESS_BOOK, $_SESSION['customer_default_address_id']
    ));
    $record = xtc_db_fetch_array($query);
    return $record['entry_country_id'];
}

function yes_mail($body, $recipient = 'm.aspeleiter@yes-websolutions.de', $subject = Null){
    $subject = ($subject === Null) ? 'YESDebug '.STORE_NAME : $subject;
    mail($recipient, $subject, $body, 'From: '.EMAIL_SUPPORT_ADDRESS,'-f '.EMAIL_SUPPORT_ADDRESS);   
}

function yes_get_store_zone_id(){
    if (!isset($_SESSION['customer_id'])) {
        return STORE_ZONE;
    }
    return $_SESSION['customer_zone_id'];
}
