function YesOrder(orders_id,orders_type,select_set_status){
	this.orders_id = orders_id;
	this.orders_type = orders_type;
	this.get_products_qty = getProductsQty;
	this.get_dom = getDOM;
	this.get_product = getProduct;
	this.get_product_colli_num = getProductColliNum;
	this.get_product_colli = getProductColli;
	this.get_field_name = getFieldName;
	this.radiofield_selected = radiofieldSelected;
	this.ms_get_total = msGetTotal;
	this.check_selected_input_value = checkSelectedInputValue;
	this.check_order = checkOrder;
	this.error_msg = new Array();
	this.add_error_msg = addErrorMsg;
	this.select_set_status = select_set_status;
	this.get_select_set = getSelectSet;
	this.get_select_set_ssm_qty = getSelectSetSsmQty;
	this.check_address_fields = checkAddressFields;
	this.address_check = true;
	this.reset_errors = resetErrors;
	this.get_dom_element_value = getDOMElementValue;

	function getDOM(){
		return ( document.forms['check_auctions'] );
	}
	
	function getDOMElementValue(element_id){
		dom = this.get_dom();
		return (dom.elements[element_id].value);
	}

	/* qty purchased */
	function getProductsQty(){
		return (parseInt( this.get_dom_element_value('products_qty'+this.orders_id+'['+this.get_product()+']')));
	}
	/* item purchased */
	function getProduct(){
		return ( this.get_dom_element_value('pR'+this.orders_id ) );
	}

	/* how many collis in purchased item */
	function getProductColliNum(){
		return ( parseInt(this.get_dom_element_value('pc_num'+this.orders_id+'['+this.get_product()+']')));
	}

	/* get the pID of a colli in purchased item */
	function getProductColli(collinr,nr){
		return ( this.get_dom_element_value('pc'+this.orders_id+'['+this.get_product()+']['+collinr+']['+nr+']')) ;
	}

	/* is select set */
	function getSelectSet(){
		return ( this.get_dom_element_value('select_set'+this.orders_id));
	}

	/* multiselect qty */
	function getSelectSetSsmQty(){
		return ( this.get_dom_element_value('ssm'+this.orders_id));
	}

	/* rewrite long field names from schema */
	function getFieldName(schema,nr,collinr){
		// *o* order, *p* product, *n* nr, *cp* colliproductsid
		var field = schema;
		field = field.replace('*o*',this.orders_id);
		field = field.replace('*p*',this.get_product());
		if(nr>=0){
			field = field.replace('*n*',nr);
		}
		if(collinr>=0){
			field = field.replace('*pc*',this.get_product_colli(collinr,nr));
		}
		return field;
	}
	
	/* check if one of a radio-form-element is checked */
	function radiofieldSelected(fieldname){
		var dom = this.get_dom();
		if(dom.elements[fieldname].length > 0){
			len = dom.elements[fieldname].length;
			for(var i=0;i<len;i++){
				if(dom.elements[fieldname][i].checked){
					return (true);
				}
			}
		}else{
			if(dom.elements[fieldname].checked){
				return (true);
			}
		}
		return (false);
	}

	/* get the selected qty from a multiselect products - you can exclude a field for calculating availables */
	function msGetTotal(nr,exclude_nr){
		dom = this.get_dom();
		var total_selected = 0;
		var pcnum = this.get_product_colli_num();
		for(var pci=0;pci<pcnum;pci++){
			if(exclude_nr != pci){
				var schema = this.get_field_name('pid[*o*][*p*][*pc*][*n*]',nr,pci);
				if(!dom.elements[schema])
					alert(schema);
				total_selected += parseInt(dom.elements[schema].value);
			}
		}
		return (total_selected);
	}

	/* check and calculate multiselect-products form qty */
	function checkSelectedInputValue(pci,nr){
		dom = this.get_dom();
		var schema = this.get_field_name('pid[*o*][*p*][*pc*][*n*]',nr,pci);
		var selected_pc_qty = parseInt(dom.elements[schema].value);
		var other_pc_qty = this.ms_get_total(nr,pci);
		var selected_total = other_pc_qty+selected_pc_qty;
		if(selected_total > this.get_select_set_ssm_qty() ){
			var check_str = M_ERROR_QTY_CHECK;
			check_str = check_str.replace('*o*',this.orders_id);
			check_str = check_str.replace('*tq*',this.get_select_set_ssm_qty() );
			if(this.get_products_qty() > 1)
				check_str = ORDER_POSITION.replace('*nr*',(nr+1))+check_str;
			alert(check_str);
			dom.elements[schema].value = 0;
		}
		return selected_total;
	}

	function addErrorMsg(err,nr){
		if(this.get_products_qty() > 1)
			err = 'Position '+(nr+1)+': '+err;
		this.error_msg[ this.error_msg.length ] = err;
	}
	function resetErrors(){
		this.error_msg = new Array();
	}

	function checkAddressFields(){
		dom = this.get_dom();
		var fields = new Array('dName','bName','dStreet','bStreet','dZip','bZip','dCity','bCity','dCountryId','bCountryId');
		var flen = fields.length;
		if(dom.elements['source_from_first['+this.orders_id+']'] && dom.elements['source_from_first['+this.orders_id+']'].value == 1){
			this.address_check = false;
		}
		if(this.address_check){
			var msg = '';
			for(var i=0;i<flen;i++){
				var el_name = fields[i]+'['+this.orders_id+']';
				var error_title = field_keys[i];
				if(!dom.elements[el_name])
					alert(el_name);
				if(dom.elements[el_name].value.length == 0)
					msg = msg + error_title + ', ';
			}
			if(msg.length > 0){
				sublen = msg.length - 2;
				msg = msg.substring(0,sublen);
				this.add_error_msg(TEXT_NEEDED+': '+msg);
			}
		}
	}
	function checkOrder(){
		this.reset_errors();
		// ADDRESS CHECK
		this.check_address_fields();
	}
}

function YesOrderCheck(gendercheck){
	var has_errors = false;
	for(var i=0;i<checkOrders.length;i++){
		o=checkOrders[i];
		o.check_order();
		if(o.error_msg.length > 0){
			has_errors = true;
			var alertMSG = ALERT_ORDER_NUMBER_ERROR+o.orders_id+"\r\n";
			for(var el=0;el<o.error_msg.length;el++){
				alertMSG += o.error_msg[el]+"\r\n"
			}
			alert(alertMSG);
		}
	}
	if(gendercheck){
		if(!document.forms['check_auctions'].elements['gender'] || (document.forms['check_auctions'].elements['gender'].value != 'f' || document.forms['check_auctions'].elements['gender'].value != 'm')){
			one_choosen = false;
			g = document.forms['check_auctions'].elements['gender'];
			for(i=0;i<g.length;i++){
				if(g[i].checked){
					one_choosen = true;
				}
			}
			if(!one_choosen){
				has_errors = true;
				alert(get_gender_error_msg());
			}
		}
	}
	if(!has_errors)
		document.forms['check_auctions'].submit();
	return false;
}
function check_ms(o,pci,nr){
	o.check_selected_input_value(pci,nr);
	update_left_qty('qty_left'+o.orders_id+'['+nr+']',o.ms_get_total(nr,-1));
}
function set_left_qty(o,nr){
	update_left_qty('qty_left'+o.orders_id+'['+nr+']',o.ms_get_total(nr,-1));
}
function update_left_qty(lay,leftValue){
	$(lay).innerHTML = leftValue;
}

function updateWMTT(e) {
	YESbubbleX = (document.all) ? window.event.x + document.body.scrollLeft : e.pageX;
	YESbubbleY = (document.all) ? window.event.y + document.body.scrollTop  : e.pageY;
}

function _toggle(szDivID){
  if (document.layers) { // NN4+
    if (document.layers[szDivID].visibility == 'visible') {
      document.layers[szDivID].visibility = "hide";
      document.layers[szDivID].display = "none";
      document.layers[szDivID+"SD"].fontWeight = "normal";
    } else {
      document.layers[szDivID].visibility = "show";
      document.layers[szDivID].display = "inline";
//      document.layers[szDivID+"SD"].fontWeight = "bold";
    }
  } else if (document.getElementById) { // gecko(NN6) + IE 5+
    var obj = document.getElementById(szDivID);
    var objSD = document.getElementById(szDivID+"SD");

    if (obj.style.visibility == 'visible') {
      obj.style.visibility = "hidden";
      obj.style.display = "none";
	  if(objSD)
		objSD.style.fontWeight = "normal";
    } else {
      obj.style.visibility = "visible";
      obj.style.display = "inline";
	  if(objSD)
	      objSD.style.fontWeight = "bold";
    }
  } else if (document.all) { // IE 4
    if (document.all[szDivID].style.visibility == 'visible') {
      document.all[szDivID].style.visibility = "hidden";
      document.all[szDivID].style.display = "none";
//      document.all[szDivID+"SD"].style.fontWeight = "normal";
    } else {
      document.all[szDivID].style.visibility = "visible";
      document.all[szDivID].style.display = "inline";
//      document.all[szDivID+"SD"].style.fontWeight = "bold";
    }
  }
}

function bubblegum(bild,mode){
	$('YESbubbleIMG').innerHTML = '<img id="bubbleimgsrc" src="'+bild+'" style="max-width:140px;max-height:90px;" border="0">';
	if(mode == 1){	
		$('YESbubble').style.left = YESbubbleX;
		$('YESbubble').style.top = YESbubbleY;
		
		//$('YESbubble').show();
	}else{
		//$('YESbubble').hide();
	}
	_toggle("YESbubble");
}
function myOnload(){
	//alert($("YESbubble").toString());
}
function popImg(imgID){
	if(openP){
		openP.close();
		openP = false;
	}
	w = imgID.width + 10;
	h = imgID.height + 10;
	p = window.open(imgID.src,'Popup','width='+w+',height='+h+'scrollbars=yes,resizable=yes,top=150,left=150');
	openP = p;
	openP.focus();
}

function toggleBox(szDivID) {
  var orderreg = szDivID.split('auction');
  toggle_oneforall(orderreg[1]);
  _toggle(szDivID);
}
function toggle_oneforall(order){
	var dom = document.forms['check_auctions'];
	var form_len = dom.length;
	var reg_str = "source_from_first["+order+"]";
	var valid = false;
	var checked = false;
	var selected_element = 0;
	for(i=0;i<form_len;i++){
		el_name = dom.elements[i].name;
		if(el_name == reg_str){
			valid = true;
			checked = dom.elements[i].checked;
			selected_element = i;
		}
	}
	if(valid && checked){
		yes = confirm(TEXT_UNSELECT_ONEFORALL);
		if(yes){
			dom.elements[selected_element].checked = false;
		}
	}
}

