<?php
define('SIZE_MEMO_X', '50');
define('SIZE_MEMO_Y', '5');

function  imd_oe_customer_infos($customers_id) {
    $customer = yes_query(
        "select a.entry_country_id, a.entry_zone_id from " . TABLE_CUSTOMERS . " c, " . TABLE_ADDRESS_BOOK . " a where c.customers_id  =:customers_id and c.customers_id = a.customers_id and c.customers_default_address_id = a.address_book_id",
        ['customers_id'=> $customers_id],
        true
    );
    $customer_info_array = array(
        'country_id' => $customer['entry_country_id'],
        'zone_id' => $customer['entry_zone_id']
    );
    return $customer_info_array;
}

function imd_get_prid($uprid) {
    $pieces = explode('{', $uprid);
    if (is_numeric($pieces[0])) {
        return $pieces[0];
    } else {
        return false;
    }
}


function imd_get_uprid($prid, $params) {
    if (is_numeric($prid)) {
        $uprid = $prid;
    } else {
        $uprid = imd_get_prid($prid);
        if (!is_numeric($uprid)) {
            return false;
        }
    }
    return $uprid;
}

function imd_get_vpe_name($vpeID) {
    $vpe = yes_query(
        "SELECT products_vpe_name FROM " . TABLE_PRODUCTS_VPE . " WHERE language_id=:language_id and products_vpe_id=:vpe_id",
        [
            'language_id'=>(int)$_SESSION['languages_id'],
            'vpe_id'=>(int)$vpeID
        ],true
    );
    return $vpe['products_vpe_name'];
}
   
   
function imd_draw_hidden_field($name, $value = '', $parameters = '') {
    $field = '<input type="hidden" name="' . imd_parse_input_field_data($name, array('"' => '&quot;')) . '" value="';
    if (imd_not_null($value)) {
        $field .= imd_parse_input_field_data($value, array('"' => '&quot;'));
    } else {
        $field .= imd_parse_input_field_data($GLOBALS[$name], array('"' => '&quot;'));
    }
    if (imd_not_null($parameters)) {
        $field .= ' ' . $parameters;
    }
    $field .= '" />';
    return $field;
}
  
function imd_href_link($page = '', $parameters = '', $connection = 'NONSSL', $add_session_id = true, $search_engine_safe = true) {
      return xtc_href_link($page, $parameters, $connection, $add_session_id, $search_engine_safe);
}

function imd_href_link_admin($page = '', $parameters = '', $connection = 'NONSSL', $add_session_id = true, $search_engine_safe = true) {
    global $request_type, $session_started, $http_domain, $https_domain;

    if (!imd_not_null($page)) {
      die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><b>Error!</b></font><br /><br /><b>Unable to determine the page link!<br /><br />');
    }

    if ($connection == 'NONSSL') {
        $link = HTTP_SERVER . DIR_WS_CATALOG;
    } elseif ($connection == 'SSL') {
        if (ENABLE_SSL == true) {
            $link = HTTPS_SERVER . DIR_WS_CATALOG;
        } else {
            $link = HTTP_SERVER . DIR_WS_CATALOG;
        }
    } else {
        die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><b>Error!</b></font><br /><br /><b>Unable to determine connection method on a link!<br /><br />Known methods: NONSSL SSL</b><br /><br />');
    }

    if (imd_not_null($parameters)) {
        $link .= $page . '?' . $parameters;
        $separator = '&';
    } else {
        $link .= $page;
        $separator = '?';
    }

    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) {
        $link = substr($link, 0, -1);
    }

// Add the session ID when moving from different HTTP and HTTPS servers, or when SID is defined
    if ( ($add_session_id == true) && ($session_started == true) && (SESSION_FORCE_COOKIE_USE == 'False') ) {
        if (defined('SID') && imd_not_null(SID)) {
            $sid = SID;
        } elseif ( ( ($request_type == 'NONSSL') && ($connection == 'SSL') && (ENABLE_SSL == true) ) || ( ($request_type == 'SSL') && ($connection == 'NONSSL') ) ) {
            if ($http_domain != $https_domain) {
                $sid = session_name() . '=' . session_id();
            }
        }
    }
    if ($truncate_session_id) {
        $sid=NULL;
    }
    if (isset($sid)) {
      $link .= $separator . $sid;
    }
    return $link;
}
  

function imd_product_link($pID, $name='') {
    return 'products_id='.$pID;
}


function imd_draw_textarea_field($name, $wrap, $width, $height, $text = '', $parameters = '', $reinsert_value = true) {
    $field = '<textarea name="' . imd_parse_input_field_data($name, array('"' => '&quot;')) . '" id="' . imd_parse_input_field_data($name, array('"' => '&quot;')) . '" cols="' . imd_parse_input_field_data($width, array('"' => '&quot;')) . '" rows="' . imd_parse_input_field_data($height, array('"' => '&quot;')) . '"';
    if (imd_not_null($parameters)) {
        $field .= ' ' . $parameters;
    }
    $field .= '>';
    if ( (isset($GLOBALS[$name])) && ($reinsert_value == true) ) {
        $field .= $GLOBALS[$name];
    } elseif (imd_not_null($text)) {
        $field .= $text;
    }
    $field .= '</textarea>';
    return $field;
}


function imd_get_all_get_params($exclude_array = '') {
    global $InputFilter;

    if (!is_array($exclude_array)) {
        $exclude_array = array();
    }

    $get_url = '';
    if (is_array($_GET) && (sizeof($_GET) > 0)) {
        reset($_GET);
        // php8 bugfix
        //while (list($key, $value) = each($_GET)) {
        foreach($_GET as $key => $value) {
            if ( (strlen($value) > 0) && ($key != imd_session_name()) && ($key != 'error') && ($key != 'cPath') && (!in_array($key, $exclude_array)) && ($key != 'x') && ($key != 'y') ) {
                $key =rawurlencode(stripslashes($key));
                $value=rawurlencode(stripslashes($value));          
                $get_url .= $key . '=' . $value . '&';
            }
        }
    }
    return $get_url;
}
  
  
function imd_image_button($image, $alt = '', $parameters = '') {
    return imd_image('templates/'.CURRENT_TEMPLATE.'/buttons/' . $_SESSION['language'] . '/'. $image, $alt, '', '', $parameters);
} 
  
function imd_get_qty($products_id)  {
     if (strpos($products_id,'{'))  {
        $act_id=substr($products_id,0,strpos($products_id,'{'));
    } else {
        $act_id=$products_id;
    }
    return $_SESSION['actual_content'][$act_id]['qty'];
}


function imd_parse_input_field_data($data, $parse) {
      // php8 bugfix
    if(gettype($data) === 'NULL'){
        return '';
    }
    return strtr(trim($data), $parse);
}
  
function imd_not_null($value) {
    if (is_array($value)) {
      if (sizeof($value) > 0) {
        return true;
      } else {
        return false;
      }
    } else {
      if (($value != '') && ($value != 'NULL') && (strlen(trim($value)) > 0)) {
        return true;
      } else {
        return false;
      }
    }
}
  
 function imd_cleanName($name) {
    $search_array=array('�','�','�','�','�','�','&auml;','&Auml;','&ouml;','&Ouml;','&uuml;','&Uuml;');
    $replace_array=array('ae','Ae','oe','Oe','ue','Ue','ae','Ae','oe','Oe','ue','Ue');
    $name=str_replace($search_array,$replace_array,$name);   	
    $replace_param='/[^a-zA-Z0-9]/';
    $name=preg_replace($replace_param,'-',$name);    
    return $name;
 }
 
 
function imd_image($src, $alt = '', $width = '', $height = '', $parameters = '') {
    if ( (empty($src) || ($src == DIR_WS_IMAGES) || ( $src == DIR_WS_THUMBNAIL_IMAGES))) {
        return false;
    }

    // alt is added to the img tag even if it is null to prevent browsers from outputting
    // the image filename as default
    $image = '<img src="' . imd_parse_input_field_data($src, array('"' => '&quot;')) . '" alt="' . imd_parse_input_field_data($alt, array('"' => '&quot;')) . '"';

    if (imd_not_null($alt)) {
      $image .= ' title=" ' . imd_parse_input_field_data($alt, array('"' => '&quot;')) . ' "';
    }

    if ( (CONFIG_CALCULATE_IMAGE_SIZE == 'true') && (empty($width) || empty($height)) ) {
      if ($image_size = @getimagesize($src)) {
        if (empty($width) && imd_not_null($height)) {
          $ratio = $height / $image_size[1];
          $width = $image_size[0] * $ratio;
        } elseif (imd_not_null($width) && empty($height)) {
          $ratio = $width / $image_size[0];
          $height = $image_size[1] * $ratio;
        } elseif (empty($width) && empty($height)) {
          $width = $image_size[0];
          $height = $image_size[1];
        }
      } elseif (IMAGE_REQUIRED == 'false') {
        return false;
      }
    }

    if (imd_not_null($width) && imd_not_null($height)) {
      $image .= ' width="' . imd_parse_input_field_data($width, array('"' => '&quot;')) . '" height="' . imd_parse_input_field_data($height, array('"' => '&quot;')) . '"';
    }

    if (imd_not_null($parameters)) {
        $image .= ' ' . $parameters;
    }

    $image .= ' />';
    return $image;
}    
  
  
  
function imd_session_name($name = '') {
    if (!empty($name)) {
        return session_name($name);
    }
    return session_name();
}


class imdPrice_closed {
	var $currencies, $cStatus, $actualGroup, $actualCurr, $TAX, $SHIPPING, $showFrom_Attributes,$content_type;
  
	function __construct($currency, $cGroup) {
            global $InstanceCache;
		$this->currencies = array ();
		$this->cStatus = array ();
		$this->actualGroup = $cGroup;
		$this->actualCurr = $currency;
		$this->TAX = array ();
		$this->SHIPPING = array();
		$this->showFrom_Attributes = true;

		// select Currencies
                $currencies_array = main::get_currencies();
		foreach($currencies_array as $currencies) {
                    $this->currencies[$currencies['code']] = array ('title' => $currencies['title'], 'symbol_left' => $currencies['symbol_left'], 'symbol_right' => $currencies['symbol_right'], 'decimal_point' => $currencies['decimal_point'], 'thousands_point' => $currencies['thousands_point'], 'decimal_places' => $currencies['decimal_places'], 'value' => $currencies['value']);
		}
		$customers_status_value = main::get_customers_status($this->actualGroup,$_SESSION['languages_id']);
		$this->cStatus = array ('customers_status_id' => $this->actualGroup, 'customers_status_name' => $customers_status_value['customers_status_name'], 'customers_status_image' => $customers_status_value['customers_status_image'], 'customers_status_public' => $customers_status_value['customers_status_public'], 'customers_status_discount' => $customers_status_value['customers_status_discount'], 'customers_status_ot_discount_flag' => $customers_status_value['customers_status_ot_discount_flag'], 'customers_status_ot_discount' => $customers_status_value['customers_status_ot_discount'], 'customers_status_graduated_prices' => $customers_status_value['customers_status_graduated_prices'], 'customers_status_show_price' => $customers_status_value['customers_status_show_price'], 'customers_status_show_price_tax' => $customers_status_value['customers_status_show_price_tax'], 'customers_status_add_tax_ot' => $customers_status_value['customers_status_add_tax_ot'], 'customers_status_payment_unallowed' => $customers_status_value['customers_status_payment_unallowed'], 'customers_status_shipping_unallowed' => $customers_status_value['customers_status_shipping_unallowed'], 'customers_status_discount_attributes' => $customers_status_value['customers_status_discount_attributes'], 'customers_fsk18' => $customers_status_value['customers_fsk18'], 'customers_fsk18_display' => $customers_status_value['customers_fsk18_display']);

		// prefetch tax rates for standard zone
                
                $key = 'wishlist_taxclasses';
                $CachedString = $InstanceCache->getItem($key);
                if (!$CachedString->isHit()) {
                    $tax_classes_raw = [];
                    $zones_query = xtDBquery("SELECT tax_class_id as class FROM ".TABLE_TAX_CLASS);
                    while ($zones_data = xtc_db_fetch_array($zones_query,true)) {
                        $tax_classes_raw[] = $zones_data;
                    }
                    $CachedString->set($tax_classes_raw)->expiresAfter(YES_CACHE_LIFETIME_LONG)->addTag('shop');//wishlist_taxclasses
                    $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
                }else{
                    $tax_classes_raw = $CachedString->get();
                }
                
                foreach( $tax_classes_raw as $zones_data ){
                    // calculate tax based on shipping or deliverey country (for downloads)
                    if (isset($_SESSION['billto']) && isset($_SESSION['sendto'])) {
                        $tax_address_query = xtc_db_query(sprintf(
                            "select ab.entry_country_id, ab.entry_zone_id from %s ab left join %s z on (ab.entry_zone_id = z.zone_id) where ab.customers_id = '%d' and ab.address_book_id = '%d'",
                            TABLE_ADDRESS_BOOK,
                            TABLE_ZONES,
                            $_SESSION['customer_id'],
                            ($this->content_type == 'virtual' ? $_SESSION['billto'] : $_SESSION['sendto'])
                        ));
                        $tax_address = xtc_db_fetch_array($tax_address_query);
                        $this->TAX[$zones_data['class']]=$this->imd_tax_rate($zones_data['class'],$tax_address['entry_country_id'], $tax_address['entry_zone_id']);				
                    } else {
                        $this->TAX[$zones_data['class']]=$this->imd_tax_rate($zones_data['class']);		
                    }
		}
				
	}
  
  
	// get products Price
	function imdp_GetPrice($pID, $format = true, $qty=0, $tax_class=Null, $pPrice=0, $vpeStatus = 0, $cedit_id = 0) {

			// check if group is allowed to see prices
	if ($this->cStatus['customers_status_show_price'] == '0')
			return $this->imd_disp_note($vpeStatus, $vpeStatus);

		// get Tax rate
		if ($cedit_id != 0) {
			$cinfo = imd_oe_customer_infos($cedit_id);
			$products_tax = $this->imd_tax_rate($tax_class, $cinfo['country_id'], $cinfo['zone_id']);
		} else {
			$products_tax = $this->TAX[$tax_class];
		}

		if ($this->cStatus['customers_status_show_price_tax'] == '0'){
			$products_tax = 0;
        }

		// add taxes
		$pPrice = $this->imd_add_tax(floatval($pPrice), floatval($products_tax));

		// check specialprice
		if ($sPrice = $this->imd_chk_special($pID))
			return $this->imd_format_spec($pID, $this->imd_add_tax($sPrice, $products_tax), $pPrice, $format, $vpeStatus);

		// check graduated
		if ($this->cStatus['customers_status_graduated_prices'] == '1') {
			if ($sPrice = $this->imd_get_grad_price($pID, $qty))
				return $this->imd_format_spec_grad($pID, $this->imd_add_tax($sPrice, $products_tax), $pPrice, $format, $vpeStatus, $pID);
		} else {
			// check Group Price
			if ($sPrice = $this->imd_get_group_price($pID, 1))
				return $this->imd_format_spec_grad($pID, $this->imd_add_tax($sPrice, $products_tax), $pPrice, $format, $vpeStatus, $pID);
		}

		// check Product Discount
		if ($discount = $this->imd_ChkDiscount($pID))
			return $this->imd_format_spec_discount($pID, $discount, $pPrice, $format, $vpeStatus);

		return $this->imd_format($pPrice, $format, 0, false, $vpeStatus, $pID);

	}

	function imdPprice($pID) {
		$pData = yes_query(
                    "SELECT products_price FROM ".TABLE_PRODUCTS." WHERE products_id=:products_id",
                    ['products_id'=>(int)$pID],
                    true
                );
		return $pData['products_price'];


	}

	function imd_add_tax(float $price, float $tax) {
		$price = $price + $price / 100 * $tax;
		$price = $this->imd_calc_currency($price);
		return round($price, $this->currencies[$this->actualCurr]['decimal_places']);
	}

	function imd_ChkDiscount($pID) {

		// check if group got discount
		if ($this->cStatus['customers_status_discount'] != '0.00') {

                    $dData = yes_query(
                        "SELECT products_discount_allowed FROM ".TABLE_PRODUCTS." WHERE products_id =:products_id",
                        ['products_id'=>(int)$pID],
                        true
                    );

			$discount = $dData['products_discount_allowed'];
			if ($this->cStatus['customers_status_discount'] < $discount)
				$discount = $this->cStatus['customers_status_discount'];
			if ($discount == '0.00')
				return false;
			return $discount;

		}
		return false;
	}

	function imd_get_grad_price($pID, $qty) {
            if (defined('GRADUATED_ASSIGN') and GRADUATED_ASSIGN == 'true'){
                if (imd_get_qty($pID) > $qty){
                    $qty = imd_get_qty($pID);
                }
            }
            $group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                $this->actualGroup, $pID
            );
            foreach($group_prices_items as $GPI){
                if($GPI->quantity<=$qty){
                    $GPI_qty = $GPI;
                }
            }
            $sPrice = $GPI_qty->personal_offer;
            if ($sPrice <> 0){
                return $sPrice;
            }
            return;
	}

	function imd_get_group_price($pID, $qty) {
            $group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                $this->actualGroup, $pID
            );
            foreach($group_prices_items as $GPI){
                if($GPI->quantity<=$qty){
                    $GPI_qty = $GPI;
                }
            }
            $sPrice = $GPI_qty->personal_offer;
            if ($sPrice <> 0){
                return $sPrice;
            }
            return;
	}
	/**
	 * Calculates the Scale-Prices of the Attibutes
	 * 
	 * @author Damian Gawenda <info@damiangawenda.com>
	 * @package scalepriceoption_module
	 */
	function calculate_optionscale($org_price, $scale_price, $att_quantity){
		if(!$scale_price) return $org_price;
		$scale_prices = explode(',',$scale_price);
		for($i=0;$i<sizeof($scale_prices);$i++){
			$scaleprice[] = explode(':',$scale_prices[$i]);
		}
		for($j=0;$j<sizeof($scaleprice);$j++){
			if($att_quantity >= $scaleprice[$j][0] && ($att_quantity < $scaleprice[$j+1][0] || !$scaleprice[$j+1])){
				return $scaleprice[$j][1];
			}
		}
		return $org_price;
	}

// attrmod end ------------------------

	function imd_disp_note($vpeStatus, $check_vpeStatus = 0) {
		if ($check_vpeStatus == 1)
			return array ('formated' => NOT_ALLOWED_TO_SEE_PRICES, 'plain' => 0);
		return NOT_ALLOWED_TO_SEE_PRICES;
	}

	function imd_chk_special($pID) {
		$product = yes_query("select specials_new_products_price from ".TABLE_SPECIALS." where products_id =:products_id and status=1",
                    ['products_id'=>(int)$pID],
                    true
                );
		return $product['specials_new_products_price'];

	}

	function imd_calc_currency($price) {
		return $this->currencies[$this->actualCurr]['value'] * $price;
	}

	function calcTax($price, $tax) {
		return $price * $tax / 100;
	}



	function imd_remove_tax($price, $tax) {
		$price = ($price / (($tax +100) / 100));
		return $price;
	}

	/*
	*
	*    Format Functions
	*
	*
	*
	*/

	function imd_format($price, $format, $tax_class = 0, $curr = false, $vpeStatus = 0, $pID = 0) {

		if ($curr)
			$price = $this->imd_calc_currency($price);

		if ($tax_class != 0) {
			$products_tax = $this->TAX[$tax_class];
			if ($this->cStatus['customers_status_show_price_tax'] == '0')
				$products_tax = '';
			$price = $this->imd_add_tax($price, $products_tax);
		}

		if ($format) {
			$Pprice = number_format($price, $this->currencies[$this->actualCurr]['decimal_places'], $this->currencies[$this->actualCurr]['decimal_point'], $this->currencies[$this->actualCurr]['thousands_point']);
			$Pprice = $this->currencies[$this->actualCurr]['symbol_left'].' '.$Pprice.' '.$this->currencies[$this->actualCurr]['symbol_right'];
			if ($vpeStatus == 0) {
				return $Pprice;
			} else {
				return array ('formated' => $Pprice, 'plain' => $price);
			}
		} else {

			return round($price, $this->currencies[$this->actualCurr]['decimal_places']);

		}

	}

	function imd_format_spec_discount($pID, $discount, $pPrice, $format, $vpeStatus = 0) {
		$sPrice = $pPrice - ($pPrice / 100) * $discount;
		if ($format) {
			$price = '<span class="productOldPrice">'.INSTEAD.$this->imd_format($pPrice, $format).'</span><br />'.ONLY.$this->imd_format($sPrice, $format).'<br />'.YOU_SAVE.$discount.'%';
			if ($vpeStatus == 0) {
				return $price;
			} else {
				return array ('formated' => $price, 'plain' => $sPrice);
			}
		} else {
			return round($sPrice, $this->currencies[$this->actualCurr]['decimal_places']);
		}
	}

	function imd_format_spec($pID, $sPrice, $pPrice, $format, $vpeStatus = 0) {
		if ($format) {
			$price = '<span class="productOldPrice">'.INSTEAD.$this->imd_format($pPrice, $format).'</span><br />'.ONLY.$this->imd_format($sPrice, $format);
			if ($vpeStatus == 0) {
				return $price;
			} else {
				return array ('formated' => $price, 'plain' => $sPrice);
			}
		} else {
			return round($sPrice, $this->currencies[$this->actualCurr]['decimal_places']);
		}
	}

	function imd_format_spec_grad($pID, $sPrice, $pPrice, $format, $vpeStatus = 0, $_pID = 0) {
		if ($pPrice == 0)
			return $this->imd_format($sPrice, $format, 0, false, $vpeStatus);
		if ($discount = $this->imd_ChkDiscount($pID))
			$sPrice -= $sPrice / 100 * $discount;
		if ($format) {
			if ($sPrice != $pPrice) {
				$price = '<span class="productOldPrice">'.MSRP.$this->imd_format($pPrice, $format).'</span><br />'.YOUR_PRICE.$this->imd_format($sPrice, $format);
			} else {
				$price = FROM.$this->imd_format($sPrice, $format);
			}
			if ($vpeStatus == 0) {
				return $price;
			} else {
				return array ('formated' => $price, 'plain' => $sPrice);
			}
		} else {
			return round($sPrice, $this->currencies[$this->actualCurr]['decimal_places']);
		}
	}

    function get_decimal_places($code) {
            return $this->currencies[$this->actualCurr]['decimal_places'];
    }
    
    function imd_tax_rate($class_id, $country_id = -1, $zone_id = -1) {
        return xtc_get_tax_rate($class_id, $country_id, $zone_id);
    }  
  
        
}  // class imdPrice_closed
   
 


















// ------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------
// ------------------------------------------------------------------------------------------
   



class Wishlist
{
    var $customers_id;
    var $products_id;
    var $current_date;
    var $quantity;
    var $products;
    var $badstrings;
    var $search_array;
    var $xtPrice;
		
    function __construct(){
        // BUGFIX php8
        if(!isset($customers_id)){
            $customers_id = (isset($_SESSION['customer_id'])) ? $_SESSION['customer_id'] : 0;
        }
        if(!isset($products_id)){
            $products_id = 0;
        }
        $this->xtPrice = new imdPrice_closed($_SESSION['currency'], $_SESSION['customers_status']['customers_status_id']);
        $this->customers_id 	= $customers_id;
        $this->products_id 		= $products_id;
        $this->current_date 	= date("Y-m-d H:i:s");
        $this->quantity			= 1;
        $this->products			= $products = array();
        $this->badstrings		= $badstrings = array("'");
        $this->search_array		= $search_array = array();
        if(!isset($_SESSION['wishlist_cache'])){
            $_SESSION['wishlist_cache'] = [
                'customers_id'=>-1,
                'wcid'=>0,
                'products'=>[]
            ];
        }
    }
		
    function AddToWishlist($customers_id, $products_id, $attributes = ''){
        $check_cust = $this->CheckCustomers($customers_id);
        if($check_cust['id'] < 1){
            $new = new \YES4Trade\Model\wishlist_customers([
                'customers_id'=>intval($customers_id),
                'create_date'=>$this->current_date
            ]);
            $check_cust['id'] = intval($new->create());
            $_SESSION['wishlist_cache']['customers_id'] = $customers_id;
            $_SESSION['wishlist_cache']['wcid'] = $check_cust['id'];
	    }
        $check_prod = $this->CheckProducts( imd_get_uprid($products_id, $attributes)  , $customers_id);
	    if($check_prod !== false){
            $current_wp = \YES4Trade\Model\wishlist_products::get_by_id(intval($check_prod));
            $upd = new \YES4Trade\Model\wishlist_products([
                'id'=>intval($check_prod),
                'quantity'=>intval($current_wp->quantity)+1
            ]);
            $upd->update();
	    }else{
            $new = new \YES4Trade\Model\wishlist_products([
                'wishlist_customers_id'=>intval($check_cust['id']),
                'products_id'=>intval($products_id),
                'quantity'=>intval($this->quantity),
                'create_date'=>$this->current_date
            ]);
            $new->create();
	    }
    }
    
    /**
     * Gibt es einen Eintrag zum Kunden in wishlist_customers?
     * Gibt ein array zurueck (id, customers_id)
     * Existiert kein Eintrag sind id und customers_id 0
     * 
     * @param int $customers_id
     * 
     * @return array
     */
    public function CheckCustomers($customers_id):array {
        if($_SESSION['wishlist_cache']['customers_id'] == -1){
            $wc = \YES4Trade\Model\wishlist_customers::get_by_customers_id(intval($customers_id),['id','customers_id']);
            if($wc !== null){
                $wcid = $wc->id;
                $cid = $wc->customers_id;
            }else{
                $wcid = 0;
                $cid = 0;
            }
            $_SESSION['wishlist_cache']['customers_id'] = $cid;
            $_SESSION['wishlist_cache']['wcid'] = $wcid;
            return array(
                'id' => $wcid, 
                'customers_id' => $cid
            );
        }else{
            return array(
                'id' => $_SESSION['wishlist_cache']['wcid'],
                'customers_id' => $_SESSION['wishlist_cache']['customers_id']
            );
        }
    }
	
    
    /**
     * Prueft ob es in der Wishlist eines Kunden einen EIntrag zur products_id gibt
     * Gibt die id des wishlist_products Eintrags zurueck wenn vorhanden
     * Gibt false zurueck wenn Artikel nicht enthalten ist
     * @param int $products_id
     * @param int $customers_id
     * 
     * @return int|false
     */
    function CheckProducts($products_id, $customers_id){
        $products_id = imd_get_prid($products_id);
        $wish_cust_id = $this->CheckCustomers($customers_id);
        if(intval($wish_cust_id['id'])>0){
            $wish_cust_id = intval($wish_cust_id['id']);
            $products = \YES4Trade\Model\wishlist_products::get_by_wishlist_customers_id($wish_cust_id,[
                'id', 'products_id'
            ]);
            foreach($products as $p){
                if(intval($p->products_id) == intval($products_id)){
                    return intval($p->id);
                }
            }
        }
        return false;
    }
		
    // listet alle Artikeln auf um Memo, Wunschgrad einzugeben
    function ShowWishList(){
	    global $main;
	    if(!isset($_SESSION['customer_id'])){
            return;
        }
        $select_products_query = xtc_db_query(
            "SELECT 
                wc.id AS wc_id, 
                DATE_FORMAT(wp.create_date, '%d.%M %Y') create_date, 
                DATE_FORMAT(wp.create_date, '%d.%m.%Y') create_date2, 
                wp.id AS wp_id, 
                wp.products_id,
                wp.memo AS p_memo,
                wp.quantity, 
                wp.wishstatus, 
                wp.ordered,
                p.products_image, 
                p.products_price, 
                p.products_status, 
                p.products_vpe, 
                p.products_vpe_status,
                p.products_shippingtime,
                p.products_vpe_value,
                p.products_image,
                pd.products_name, 
                pd.products_short_description 
            FROM ".TABLE_WISHLIST_CUSTOMERS." wc
                JOIN ".TABLE_WISHLIST_PRODUCTS." wp ON wc.id=wp.wishlist_customers_id
                JOIN ".TABLE_PRODUCTS." p ON p.products_id=wp.products_id
                JOIN ".TABLE_PRODUCTS_DESCRIPTION." pd ON pd.products_id=p.products_id
            WHERE 
                wc.customers_id = '".intval($_SESSION['customer_id'])."' 
                AND pd.language_id = '".intval($_SESSION['languages_id'])."' 
            ORDER BY wp.id ASC"
        );
        $a = 0;
        $b = 0;
        $products=array();
        $_sp = [];
        while($select_products = xtc_db_fetch_array($select_products_query)){
            $_sp[] = $select_products;
        }
        foreach($_sp as $select_products){
            $product = new \product($select_products['products_id']);
            $products[$a]['INFO'] = $product->buildDataArray($product->data);
            
            $image = DIR_WS_POPUP_IMAGES.$select_products['products_image'];
            $vpe 	= '';
            $addcart = '';
          
            $price = $this->xtPrice->imdp_GetPrice($select_products['products_id'], $format = true, 1, $products[$a]['INFO']['PRODUCTS_TAX_CLASS_ID'], $select_products['products_price'], 1);
            if($select_products['products_image'] != '') {
                $image = DIR_WS_THUMBNAIL_IMAGES . $select_products['products_image'];
            }
            if($select_products['products_vpe_status'] == 1 && $select_products['products_vpe_value'] != 0.0 && $price['plain'] > 0){
                $vpe = $this->xtPrice->imd_format($price['plain'] * (1 / $select_products['products_vpe_value']), true) . TXT_PER . imd_get_vpe_name($select_products['products_vpe']);
            }
            $tocart = imd_draw_hidden_field('wish_ids[]', $select_products['wp_id']);
            $products_link = imd_href_link(FILENAME_PRODUCT_INFO, imd_product_link($select_products['products_id'],$select_products['products_name']));
            $p_memo	= imd_draw_textarea_field('p_memo[]', 'soft', '30', '3', $select_products['p_memo']);
            $delete = '<a href="'.imd_href_link(FILENAME_WISHLIST, 'action=wishlist&DELproducts_id='.$select_products['products_id'].'&'.imd_get_all_get_params(array ('action')), 'NONSSL').'">'.imd_image_button('button_delete.gif', '1 x '.$select_products['products_name']).'</a>';
            $tax_rate = $this->xtPrice->TAX[$products[$a]['INFO']['PRODUCTS_TAX_CLASS_ID']];
            if ($tax_rate > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] != 0) {
                $tax_info = sprintf(TAX_INFO_INCL, $tax_rate.' %');
            }
            if ($tax_rate > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] == 0) {
                $tax_info = sprintf(TAX_INFO_EXCL, $tax_rate.' %');
            }
					
            $ship_info = "";
            if (defined('SHOW_SHIPPING') and SHOW_SHIPPING=='true') {
                $ship_info= ' '.SHIPPING_EXCL.'<script language="javascript">document.write(\'<a onFocus="if(this.blur)this.blur()" href="javascript:newWin=void(window.open(\\\''.imd_href_link(FILENAME_POPUP_CONTENT, 'coID='.SHIPPING_INFOS).'\\\', \\\'popup\\\', \\\'toolbar=0, scrollbars=yes, resizable=yes, height=400, width=400\\\'))">'.SHIPPING_COSTS.'</a>\');</script><noscript><a href="'.imd_href_link(FILENAME_POPUP_CONTENT, 'coID='.SHIPPING_INFOS).'"target="_blank">'.SHIPPING_COSTS.'</a></noscript>';
            }

					
            $products[$a] = array(
                'wc_id'							=> $select_products['wc_id'],
                'create_date'					=> $this->datestring( $select_products['create_date2'] ),
                'c_memo'						=> $select_products['c_memo'],
                'p_memo'						=> $p_memo,
                'memo_text'=>$select_products['p_memo'],
                'wp_id'							=> $select_products['wp_id'],
                'products_id'					=> $select_products['products_id'],
                'quantity'						=> $select_products['quantity'],
                'wishstatus'					=> $select_products['wishstatus'],
                'ordered'						=> $select_products['ordered'],
                'products_image'				=> $image,
                'products_price'				=> $price['formated'],
                'products_status' 				=> $select_products['products_status'],
                'products_vpe'					=> $vpe,
                'products_name'					=> $select_products['products_name'],
                'products_link'					=> $products_link,
                'products_short_description'	=> $select_products['products_short_description'],
                'SHIPPING_LINK' => $ship_info,
                'TAX_INFO' => $tax_info,
                'tocart_ids'					=> $tocart,
        //	'addcart'						=> imd_draw_hidden_field('products_id', $select_products['products_id']),
                //'addcart_qty'					=> imd_draw_hidden_field('products_qty', 1),
                'delete'						=> $delete,
                'ATTRIB'						=> ''
            );
            
            if (ACTIVATE_SHIPPING_STATUS == 'true') {
                $products[$a]['SHIPPING_NAME']  = $main->getShippingStatusName($select_products['products_shippingtime']);
                $products[$a]['SHIPPING_IMAGE'] = $main->getShippingStatusImage($select_products['products_shippingtime']);
            }
            
            $products[$a]['delete'] = '<a href="'.imd_href_link(FILENAME_WISHLIST, 'action=wishlist&DELproducts_id='.imd_get_uprid($select_products['products_id'], $merker).'&'.imd_get_all_get_params(array ('action')), 'NONSSL').'">'.imd_image_button('button_delete.gif', '1 x '.$select_products['products_name']).'</a>';
            $products[$a]['products_iduprid'] = imd_draw_hidden_field('products_iduprid[]', imd_get_uprid($select_products['products_id'], $merker));
            $group_price_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                $_SESSION['customers_status']['customers_status_id'], $select_products['products_id']
            );
            $staffel = array(); 
            foreach( $group_price_items as $GPI ) {
                if( $GPI->quantity == 1 ) {
                    continue;
                }
                $staffel[] = array(
                    'quantity' => $GPI->quantity,
                    'price'    => $this->xtPrice->imd_format($GPI->personal_offer, true)
                );           
            }
            $products[$a]['staffel'] = $staffel;
            $a++;
	} // end first query
	if( (WISHLIST_AUTO!='true') ) {
	  return $products;
	}
	$select_best_products_query = xtc_db_query(
        "SELECT 
              p.products_status, 
              p.products_vpe, 
              p.products_vpe_value, 
              p.products_vpe_status, 
              p.products_shippingtime,
              pd.products_short_description, 
              p.products_price, 
              p.products_image, 
              op.products_id, 
              op.products_name, 
              count(op.products_name) as total  
	    FROM ".TABLE_ORDERS." o
			JOIN ".TABLE_ORDERS_PRODUCTS." op ON o.orders_id=op.orders_id
            JOIN ".TABLE_PRODUCTS." p ON op.products_id=p.products_id
			JOIN ".TABLE_PRODUCTS_DESCRIPTION." pd ON pd.products_id=p.products_id
	    WHERE 
            o.customers_id = '".intval($_SESSION['customer_id'])."' 
		    AND pd.language_id = '".intval($_SESSION['languages_id'])."' 
        group by op.products_name 
        order by total desc limit 5"
        );
        $_sbp = [];
	    while($select_best_products = xtc_db_fetch_array($select_best_products_query)){
            $_sbp[] = $select_best_products;
        }
        foreach($_sbp as $select_best_products){
            // Art. die schon regul�r auf MZ stehen m�ssen nicht nochmal gelistet werden
            if( $this->CheckProducts($select_best_products['products_id'], (int)$_SESSION['customer_id'] )!='' ) {
                continue;
            } 

            $image 	= '';
            $vpe 	= '';
            $addcart = '';
            $country_id = yes_get_store_country_id();
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                $select_best_products['products_id'], $country_id
            );
            $price = $this->xtPrice->imdp_GetPrice($select_best_products['products_id'], $format = true, 1, $products_tax_class_id, $select_best_products['products_price'], 1);
            if($select_best_products['products_image'] != '') $image = DIR_WS_THUMBNAIL_IMAGES . $select_best_products['products_image'];
            if($select_best_products['products_vpe_status'] == 1 && $select_best_products['products_vpe_value'] != 0.0 && $price['plain'] > 0){
                $vpe = $this->xtPrice->imd_format($price['plain'] * (1 / $select_best_products['products_vpe_value']), true) . TXT_PER . imd_get_vpe_name($select_best_products['products_vpe']);
            }

            $tocart = imd_draw_hidden_field('wish_ids[]', $select_products['wp_id']);
            $products_link = imd_href_link(FILENAME_PRODUCT_INFO, imd_product_link($select_best_products['products_id'],$select_best_products['products_name']));
            $p_memo	= '';
            $delete = '[DAS IST NUR EIN VORSCHLAG - DIE LETZTEN 5 Artikel DIE DER KUNDE KAUFTE - IST NICHT IM MERKZETTEL]';
            $tax_rate = $this->xtPrice->TAX[$products_tax_class_id];
            if ($tax_rate > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] != 0) {
                $tax_info = sprintf(TAX_INFO_INCL, $tax_rate.' %');
            }
            if ($tax_rate > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] == 0) {
                $tax_info = sprintf(TAX_INFO_EXCL, $tax_rate.' %');
            }

            $ship_info = "";
            if (defined('SHOW_SHIPPING') and SHOW_SHIPPING=='true') {
                $ship_info= ' '.SHIPPING_EXCL.'<script type="text/javascript">document.write(\'<a onFocus="if(this.blur)this.blur()" href="javascript:newWin=void(window.open(\\\''.imd_href_link(FILENAME_POPUP_CONTENT, 'coID='.SHIPPING_INFOS).'\\\', \\\'popup\\\', \\\'toolbar=0, scrollbars=yes, resizable=yes, height=400, width=400\\\'))">'.SHIPPING_COSTS.'</a>\');</script><noscript><a href="'.imd_href_link(FILENAME_POPUP_CONTENT, 'coID='.SHIPPING_INFOS).'"target="_blank">'.SHIPPING_COSTS.'</a></noscript>';
            }

            $products[$a] = array(
                'wc_id'							=> '',
                'create_date'					=> '',
                'c_memo'						=> '',
                'p_memo'						=> $p_memo,
                'wp_id'							=> '',
                'products_id'					=> $select_best_products['products_id'],
                'quantity'						=> '1',
                'wishstatus'					=> $select_best_products['wishstatus'],
                'ordered'						=> $select_best_products['ordered'],
                'products_image'				=> $image,
                'products_price'				=> $price['formated'],
                'products_status' 				=> $select_best_products['products_status'],
                'products_vpe'					=> $vpe,
                'products_name'					=> $select_best_products['products_name'],
                'products_link'					=> $products_link,
                'products_short_description'	=> $select_best_products['products_short_description'],
                'SHIPPING_LINK' => $ship_info,
                'TAX_INFO' => $tax_info,

                'tocart_ids'					=> $tocart,
                'addcart'						=> imd_draw_hidden_field('products_id', $select_best_products['products_id']),
//		'addcart_qty'					=> imd_draw_hidden_field('products_qty', 1),
                'delete'						=> $delete,
                'ATTRIB'						=> ''); 

            if (ACTIVATE_SHIPPING_STATUS == 'true') {
                $products[$a]['SHIPPING_NAME']  = $main->getShippingStatusName($select_best_products['products_shippingtime']);
                $products[$a]['SHIPPING_IMAGE'] = $main->getShippingStatusImage($select_best_products['products_shippingtime']);
            }

            $a++;
        } // eof best products
        return $products;
    } // eof function
    
    
    
    function UpdateWishProducts($products_array){
        if(is_countable($products_array)){
            $p_count = count($products_array);
            for($p = 0; $p < $p_count; $p++){
                $id = $this->CheckProducts(
                    $products_array[$p]['products_iduprid'], 
                    $_SESSION['customer_id']
                );
                if($id === false){
                    continue;
                }
                $memo = strip_tags($products_array[$p]['p_memo']);
                $memo = str_replace($this->badstrings, "", $memo);
                $upd = new \YES4Trade\Model\wishlist_products([
                    'id'=>intval($id),
                    'memo'=>$memo
                ]);
                $upd->update();
            }
        }
    }
		
    // Artikel aus der Wunschliste entfernen
    function DelWishProduct($customers_id, $products_id){
        $check_cust = $this->CheckCustomers($customers_id);
        if(empty($check_cust['id'])){
            return;
        }
        $wishlist_products_id = $this->CheckProducts( $products_id  , $customers_id );
        if($wishlist_products_id === false){
            return;
        }
        \YES4Trade\Model\wishlist_products::delete($wishlist_products_id);
    }
    
    		
    function get_optarr( $prid_str ) {
        $n=preg_match_all('/\{([0-9]+)\}([0-9]+)/', $prid_str, $erg);
        $id=array();
        for( $i=0; $i<$n; $i++) {
            $id[$erg[1][$i]] = $erg[2][$i];
        }
        return $id;      
    }
    
    
    function datestring( $date_dmy ) {   // date: "25.06.2007"
        global $month_names;
        preg_match('/([0-9]*).([0-9]*).([0-9]*)/', $date_dmy, $erg);
        $d=$erg[1];
        $m=$month_names[$erg[2]-1];
        $y=$erg[3];
        return "$d. $m $y";
    }
}
