<?php
use Smarty\Smarty;

class yesSmarty extends Smarty {
  /* constructor */
  function __construct() {
        parent::__construct();

        $this->setTemplateDir(array(DIR_FS_CATALOG.'/templates/',DIR_FS_CATALOG.'/admin/templates/'));
        $this->setCompileDir(DIR_FS_CATALOG.'/templates_c/');
        $this->setConfigDir(DIR_FS_CATALOG.'/lang/');
        $this->setCacheDir(DIR_FS_CATALOG.'/cache/');
        $this->setErrorReporting(E_ERROR & ~E_DEPRECATED);

        $this->caching = Smarty::CACHING_OFF;
        $this->cache_lifetime = 0;

        $lang = $_SESSION['language']??'german';
        if(is_file(DIR_FS_CATALOG.'lang/'.$lang.'/admin/uebergang_translation.conf')){
          $this->configLoad(DIR_FS_CATALOG.'lang/'.$lang.'/admin/uebergang_translation.conf');
        }
      	$this->assign('language', $_SESSION['language']??'german');
        $this->registerPlugin('function', 'var_dump', function ($params, $template) {
          $var = $params['var'] ?? '';
          var_dump($var);
        });
        $this->registerPlugin('function', 'strpos', function ($params, $template) {
          $haystack = $params['haystack'] ?? '';
          $needle = $params['needle'] ?? '';
          if(strpos($needle, '|')!==false){
            $list = explode('|',$needle);
            foreach($list as $ndl){
              if(strpos($haystack, $ndl) !== false){
                return '1';
              }
            }
            return '0';
          }
          return strpos($haystack, $needle);
        });

        $plugins_dir = DIR_FS_CATALOG.'includes/smarty_plugins/';
        $files = scandir($plugins_dir);
        foreach($files as $f){
          if(strpos($f,'function') !== 0){
            continue;
          }
          require_once($plugins_dir.$f);
          $parts = explode('.', $f);
          $func = $parts[1];
          $this->registerPlugin('function', $func, 'smarty_function_'.$func);
          
        }
        $this->registerPlugin('modifier', 'strstr', 'strstr');
  }

  // ueberbleibsel aus alten smarty klassen
  public function clear_all_assign(){
      $this->clearAllAssign();
  }
  public function is_cached($template='',$cache_id='',$compile_id=0){
	return $this->isCached($template,$cache_id,$compile_id);
  }
  public function load_filter($type,$name){
    // wird eigentlich nur fuer das komische output note verwendet
    //return true;
    return $this->registerPlugin($type, $name, 'smarty_outputfilter_note');
//	  return $this->loadFilter($type,$name);
  }
}

function smarty_outputfilter_note($tpl_output, &$smarty) {
	if(defined('NO_XTC_FOOTER') and constant('NO_XTC_FOOTER') == 1){
		return $tpl_output;
	}

    $cop='
    <div id="copyrightxtc">
                         <a href="http://www.yes4trade.de" target="_blank" >YES4trade</a> by <a href="http://www.yes-websolutions.de" target="_blank">yes websolutions</a>
                         <br />eCommerce Shop Engine &copy; 2004 <a href="http://www.xt-commerce.com" target="new">xt:Commerce</a>
    </div>';
    $tpl_output .=$cop;
    return $tpl_output;

}
