<?php
/* -----------------------------------------------------------------------------------------
   $Id: main.php,v 1.18 2020/08/06 17:10:28 ssh-511548-cvs Exp $ 

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2005 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(Coding Standards); www.oscommerce.com 

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
 
 class main {
 	var $SHIPPING, $STOCKS_TRAFFIC;
 	function __construct() {
 		$this->SHIPPING = array();
		if(!isset($_SESSION)){
			$_SESSION = array();
		}
		if(!isset($_SESSION['languages_id'])){
                    $_SESSION['languages_id'] = 2;
                }
		$shipping_status_array = \YES4Trade\Model\shipping_status::get_list($_SESSION['languages_id']);
                foreach($shipping_status_array as $status_data){
                    $this->SHIPPING[$status_data['shipping_status_id']] = array(
                        'name'=>$status_data['shipping_status_name'],
                        'image'=>$status_data['shipping_status_image']
                    );
                }
		if (defined('ACTIVATE_STOCKS_TRAFFIC') && ACTIVATE_STOCKS_TRAFFIC=='true') {
			$this->STOCKS_TRAFFIC = array();
			$status_query=xtc_db_query("SELECT
                                     *
                                     FROM ".TABLE_STOCKS_TRAFFIC."
                                     where language_id = '".(int)$_SESSION['languages_id']."' order by stocks_traffic_percentage ASC",true);
			if(xtc_db_num_rows($status_query)){
				while($status_data = xtc_db_fetch_array($status_query)) {
					$this->STOCKS_TRAFFIC[]=array('percentage'=>$status_data['stocks_traffic_percentage'],'name'=>$status_data['stocks_traffic_name'],'image'=>$status_data['stocks_traffic_image']);
				}
			}
		}
	}
 	
 	function getShippingStatusName($id) {
 		return $this->SHIPPING[$id]['name'];
 	}
 	
 	function getShippingStatusImage($id) {
 		if (isset($this->SHIPPING[$id]) and $this->SHIPPING[$id]['image']) {
 		return 'admin/images/icons/'.$this->SHIPPING[$id]['image'];
 		} else {
 			return;
 		}
 	}
 	
 	function getShippingLink($pID = false) {
		if($pID)
			return ' '.SHIPPING_EXCL.'&nbsp;<a href="javascript:versand(\''.$pID.'\');">'.SHIPPING_COSTS.'</a>';
		else
			return ' '.SHIPPING_EXCL.'&nbsp;<script type="text/javascript">document.write(\'<a href="javascript:newWin=void(window.open(\\\''.xtc_href_link(FILENAME_POPUP_CONTENT, 'coID='.SHIPPING_INFOS).'\\\', \\\'popup\\\', \\\'toolbar=0, scrollbars=yes, resizable=yes, height=400, width=400\\\'))">'.SHIPPING_COSTS.'</a>\');</script><noscript><a href="'.xtc_href_link(FILENAME_POPUP_CONTENT, 'coID='.SHIPPING_INFOS).'"target="_blank">'.SHIPPING_COSTS.'</a></noscript>';
	}

	function getTaxNotice() {

		// no prices
		if ($_SESSION['customers_status']['customers_status_show_price'] == 0)
			return;

		if ($_SESSION['customers_status']['customers_status_show_price_tax'] != 0) {
			return TAX_INFO_INCL_GLOBAL;
		}
		// excl tax + tax at checkout
		if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
			return TAX_INFO_ADD_GLOBAL;
		}
		// excl tax
		if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 0) {
			return TAX_INFO_EXCL_GLOBAL;
		}
		
		return;
	}
	
	function getTaxInfo($tax_rate) {
		
		// price incl tax
        if ($tax_rate > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] != 0) {
            $tax_info = sprintf(TAX_INFO_INCL, $tax_rate.'%');
        }
        // excl tax + tax at checkout
        if ($tax_rate > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
            $tax_info = sprintf(TAX_INFO_ADD, $tax_rate.'%');
        }
        // excl tax
        if ($tax_rate > 0 && $_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 0) {
            $tax_info = sprintf(TAX_INFO_EXCL, $tax_rate.'%');
        }
		return $tax_info??'';
	}
	
	function getShippingNotice() {
		if (defined('SHOW_SHIPPING') and SHOW_SHIPPING == 'true') {
			return ' '.SHIPPING_EXCL.'<a href="'.xtc_href_link(FILENAME_CONTENT, 'coID='.SHIPPING_INFOS).'">'.SHIPPING_COSTS.'</a>';
		}
		return;
	}
	
	function getContentLink($coID,$text) {
        if(defined('FILENAME_POPUP_CONTENT')){
            $link = xtc_href_link(FILENAME_POPUP_CONTENT, 'coID='.$coID);
        }else{
            $link = xtc_href_link('shop_content.php', 'coID='.$coID);
        }
            
		return '<script type="text/javascript">document.write(\'<a href="javascript:newWin=void(window.open(\\\''.
                        $link.
                        '\\\', \\\'popup\\\', \\\'toolbar=0, scrollbars=yes, resizable=yes, height=400, width=400\\\'))"><font color="#ff0000">'.$text.'</font></a>\');</script><noscript><a href="'.
                        $link.
                        '" target="_blank"><font color="#ff0000">'.
                        $text.
                        '</font></a></noscript>';
	}
 	
    /**
     * Gibt den Pfad zu secure_files/ zurueck, mit endendem /
     * @return string
     */
    public static function get_secure_path(){
        $secure_path = YES_SYSTEM_HOME_DIRECTORY.'secure_files'.DIRECTORY_SEPARATOR;
        if(!is_dir($secure_path)){
            die('YES Configuration error: Missing secure path');
        }
        return $secure_path;
    }

    /**
     * Gibt den Pfad zu importdata/ zurueck, mit endendem /
     * @return string
     */
    public static function get_importdata_path():string{
        //$path = YES_SYSTEM_HOME_DIRECTORY.'importdata'.DIRECTORY_SEPARATOR;
        $conn = '';
        if(substr(constant('DIR_FS_ADMIN'),-1) !== DIRECTORY_SEPARATOR){
            $conn = DIRECTORY_SEPARATOR;
        }
        $path = DIR_FS_ADMIN.$conn.'importdata/';
        if(!is_dir($path)){
            die('YES Configuration error: Missing importdata path');
        }
        return $path;
    }

    /**
     * Gibt den Pfad zu exportdata/ zurueck, mit endendem /
     * @return string
     */
    public static function get_exportdata_path():string{
        if(main::isDev(true)){
            return str_replace('secure_files','data/exportdata',self::get_secure_path());
        }
        $conn = '';
        if(substr(constant('DIR_FS_ADMIN'),-1) !== DIRECTORY_SEPARATOR){
            $conn = DIRECTORY_SEPARATOR;
        }
        $path = DIR_FS_ADMIN.$conn.'exportdata/';
        if(!is_dir($path)){
            die('YES Configuration error: Missing exportdata path');
        }
        return $path;
    }
    
    public static function get_shipping_graduation_groups(){
        $array = array();
        $query = xtc_db_query(
                "SELECT shipping_graduation_groups_id, title FROM shipping_graduation_groups ORDER BY shipping_graduation_groups_id"
        );
        while($record = xtc_db_fetch_array($query)){
            $array[] = array(
                'id'=>$record['shipping_graduation_groups_id'],
                'text'=>xtc_db_prepare_input($record['title'])
            );
        }
        return $array;
    }
    public static function get_shipping_graduation_groups_countries($shipping_graduation_groups_id){
        $array = array();
        if($shipping_graduation_groups_id == 9999){
            return $array;
        }
        $query = yes_query(
                "SELECT c.countries_name FROM shipping_graduation_countries sgc LEFT JOIN countries c ON c.countries_id=sgc.country_id WHERE sgc.shipping_graduation_groups_id=:id",
                ['id'=>$shipping_graduation_groups_id]
        );
        foreach($query as $record){
            $array[] = xtc_db_prepare_input($record['countries_name']);
        }
        return $array;
    }
    
    public static function get_shipping_graduation_groups_id_by_countries_id($countries_id){
        $query = yes_query(
                "SELECT shipping_graduation_groups_id FROM shipping_graduation_countries WHERE country_id=:country_id",
                ['country_id'=>(int)$countries_id]
        );
        if(!sizeOf($query)){
            return 999999; // ALLE ANDEREN
        }
        $record = current($query);
        return $record['shipping_graduation_groups_id'];
    }
    
    // BOF - YES Versandkosten Berechnung
    /**
     * Ermittelt den shipping_extra_charge Wert aus products_shipping_extra_charge
     * basierend auf der products_id und optional der shipping_graduation_groups_id
     * Wird keine shipping_graduation_groups_id vorgebenen, dann wird basierend
     * auf der STORE_COUNTRY (ist eine ID) Einstellung die entsprechende Laenderzuordnung 
     * ermittelt
     * @param type $products_id
     * @param type $shipping_graduation_groups_id
     * @return int
     */
    public static function get_product_shipping_extra_charges($products_id, $shipping_graduation_groups_id = null){
        if($shipping_graduation_groups_id === null){
            $shipping_graduation_groups_id = self::get_shipping_graduation_groups_id_by_countries_id(STORE_COUNTRY);
        }
        $query = yes_query(
                "SELECT shipping_extra_charge FROM products_shipping_extra_charge WHERE products_id=:products_id AND shipping_graduation_groups_id=:groups_id",
                [
                    'products_id'=>$products_id, 
                    'groups_id'=>$shipping_graduation_groups_id
                ]
        );
        if(!sizeOf($query)){
            return 0;
        }
        $record = current($query);
        return $record['shipping_extra_charge'];
    }
    
    /**
     * Holt den DB Wert fuer 'weight_calc' aus den Laendergruppen Zuweisungen
     * fuer eine bestimmte Laendergruppe
     * @param int $group_id
     * @return bool
     */
    public static function get_weight_calc($group_id){
      $groups = yes_query(
        "SELECT weight_calc FROM shipping_graduation_groups WHERE shipping_graduation_groups_id=:groups_id",
        ['groups_id'=>$group_id],
        true
      );
      return $groups['weight_calc'];
    }
    
    /**
     * OBSOLETE - WIRD DURCH DAS LAENDERGRUPPENBASIERTE
     * SHIPPING EXTRA CHARGE HANDLING ERSETZT
     * @param int $products_id
     * @return float
     */
    public static function get_shipping_extra_charge($products_id){
            $extra_charge = yes_query("SELECT shipping_extra_charge FROM products WHERE products_id=:products_id",
                ['products_id'=>$products_id],
                true
            );
            return $extra_charge['shipping_extra_charge'];
    }
     
    /**
     * Berechnet den YES basierten Versandkostenpreis basierend auf Grundversand-
     * kostenwert, Laendergruppe, Gewicht, pID und Brutton/Netto Vorgabe
     * @param float $shipping
     * @param int $group_id
     * @param float $pweight
     * @param int $pID
     * @param bool $brutto
     * @return float
     */
    public static function calc_yes_modul($shipping,$group_id,$pweight,$pID,$brutto = false){
        if(self::get_weight_calc($group_id) == 1){
                $extra_charge = self::get_shipping_extra_charge($pID);
                $extra_charge_plus = self::get_product_shipping_extra_charges($pID, $group_id);
                $qty = 1; // gesamtgewicht basierend auf 1 stk

                $grad_query = xtc_db_query("select shipping_graduation_id from shipping_graduation WHERE value=1");
                $grad = xtc_db_fetch_array($grad_query);
                $gID = $grad['shipping_graduation_id'];

                $weight_query = xtc_db_query("select * from shipping_graduation_weights order by weight DESC");
                while ($weight = xtc_db_fetch_array($weight_query)) {
                        if((float)$pweight <= (float)$weight['weight']){
                                $wID = $weight['shipping_graduation_weights_id'];
                        }
                }

                $grad = yes_query(
                    "SELECT grad_value FROM shipping_graduation_values WHERE shipping_graduation_weights_id=:weight_id and shipping_graduation_groups_id=:group_id and shipping_graduation_id=:grad_id",
                    [
                        'weight_id'=>$wID,
                        'group_id'=>$group_id,
                        'grad_id'=>$gID
                    ],
                    true
                );
                $shipping = $grad['grad_value']+$extra_charge;
        }
        if(!$brutto){
                return ($shipping + MODULE_SHIPPING_YES_HANDLING);
        }else{
                $tax_rate = xtc_get_tax_rate(MODULE_SHIPPING_YES_TAX_CLASS);
                return ($shipping + MODULE_SHIPPING_YES_HANDLING)*(($tax_rate+100)/100);
        }
    }
    
    /**
     * Ermittelt die Laender einer Gruppe basierend auf der Laendergruppen ID
     * Wenn das Flag not_ship in der Laendergruppenzuweisung auf 1 gesetzt ist
     * wird ein leeres Array zurueckgegeben
     * @param int $gID
     * @return array
     */
    public static function get_group_countries($gID){
            $array = array();
            $not_ship = yes_query(
                "SELECT not_ship FROM shipping_graduation_groups WHERE shipping_graduation_groups_id=:groups_id",
                ['groups_id'=>$gID],
                true
            );
            if($not_ship['not_ship'] == 0){
                    if($gID != '999999'){
                            $countries_query = yes_query(
                                "SELECT c.countries_name FROM countries c,shipping_graduation_countries sgc WHERE sgc.country_id=c.countries_id AND sgc.shipping_graduation_groups_id=:groups_id",
                                ['groups_id'=>$gID]
                            );
                            foreach($countries_query as $countries){
                                    $array[] = $countries['countries_name'];
                            }
                    }else{
                            $array[] = 'Alle weiteren';
                    }
            }
            return $array;
    }
    
    /**
     * Ermittelt aus der Tabelle 'shipping_graduation_products' ob ein Artikel 
     * erweiterte Versandkosten enthaelt - basierend auf einer products_id
     * @param int $products_id
     * @return bool
     */
    public static function get_ext_shipping_costs_status($products_id){
        $ext_ship_query = yes_query(
            "SELECT sg.value FROM shipping_graduation_products sp,shipping_graduation sg WHERE sp.products_id=:products_id and sg.shipping_graduation_id=sp.graduation_id",
                ['products_id'=>(int)$products_id],
        );
        $ext_costs_active = (sizeOf($ext_ship_query) > 0) ? true : false;
        return $ext_costs_active;
    }

    /**
     * Ermittelt die Erweiterten Versandkosten basierend auf einer products_id
     * Dabei werden alle Werte aus shipping_graduation_products sowie der
     * zugehoerige value aus shipping_graduation als Array zurueckgegeben
     * @param int $products_id
     * @return array
     */
    public static function get_ext_shipping_costs(int $products_id, int $qty = 1){
        if($qty > 1){
            // WIR MUESSEN SCHAUEN OB ES MENGENSTAFFELUNGEN GIBT UND DIE PASSENDE
            // MENGE ERMITTELN
            $query = yes_query(
                    "SELECT value FROM shipping_graduation WHERE value <= :qty ORDER BY value DESC LIMIT 1",
                    ['qty'=>$qty]
            );
            if(sizeOf($query)){
                $record = current($query);
                $qty = $record['value'];
            }
        }
            $ext_ship_query = yes_query(
                "SELECT sp.*,sg.value as qty FROM shipping_graduation_products sp,shipping_graduation sg WHERE sp.products_id=:products_id and sg.shipping_graduation_id=sp.graduation_id and sg.value=:qty",
                ['products_id'=>(int)$products_id,'qty'=>$qty]
            );
            $ext_costs = array();
            foreach($ext_ship_query as $ext_ship){
                $ext_costs[ $ext_ship['shipping_graduation_groups_id'] ][ $ext_ship['qty'] ] = $ext_ship['value'];
            }
            return $ext_costs;
    }
    // EOF - YES Versandkosten Berechnung

    public static function get_admin_access_values(){
        global $InstanceCache;
        $key = 'admin_access';
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $values = [];
            $query = xtc_db_query(
                    "SELECT * FROM admin_access"
            );
            while($record = xtc_db_fetch_array($query)){
                $values[] = $record;
            }
            $CachedString->set($values)->expiresAfter(0);//admin_access
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $values = $CachedString->get();
        }
        return $values;
    }    
    /**
     * Gibt ein Array der Admin customers_id wieder, die in der Tabelle
     * admin_access einen Wert von 1 beim uebergebenen $admin_access_field haben
     * @param string $admin_access_field
     * @return array
     */
    public static function get_notice_recipients( $admin_access_field ){
        $notice_users = array();
        foreach(self::get_admin_access_values() as $ada){
            if($ada[ $admin_access_field ] != 1){
                continue;
            }
            $kasse_user = (defined('KASSE_USER') and KASSE_USER > 0) ? KASSE_USER : 0;
            switch($ada['customers_id']){
                case 1:
                case 'groups':
                case $kasse_user:
                    break;
                default:
                    $notice_users[] = $ada['customers_id'];
                    break;
            }
        }
        return $notice_users;
    }
    
    // UM CACHING ZU VERHINDERN, EINFACH AN EINE URL EIN PAAR PARAMETER ANHAENGEN
    public static function get_url_with_random_params($url){
        $connector = (strstr($url,'?')) ? '&' : '?';
        $url .= sprintf('%snocache=%s',$connector,xtc_rand());
        return $url;
    }
    
    public static function isDev($isLocal = false){
        if($isLocal === true){
            return (strpos(HTTP_SERVER,'localhost')>-1)?true:false;
        }
        if(strpos(HTTP_SERVER,'localhost') > -1 or strpos(HTTP_SERVER,'yes-a177922.de') > -1){
            return true;
        }
        return false;
    }
    
    public static function yes_debug_log($content=''){
        $secure_path = self::get_secure_path();
        $logfile = $secure_path.'debug.log';
        $log = sprintf("-- DEBUG date %s --\r\n%s\r\n\r\n",
                date('Y-m-d H:i:s'),
                $content
        );
        if(!is_file($logfile)){
            touch($logfile);
        }
        file_put_contents($logfile, $log);
    }
    
    public static function get_distributors_with_external_stock(){
        // gibt derzeit nur einen
        return (defined('MODULE_OTHER_HTG_STATUS') and MODULE_OTHER_HTG_STATUS == 'True') ? [MODULE_OTHER_HTG_DISTRIBUTOR_ID] : [];
    }
    
    public static function hasDistributorExternalStock(int $distributor_id){
        if(defined('MODULE_OTHER_HTG_STATUS') and MODULE_OTHER_HTG_STATUS == 'True'){
            if(MODULE_OTHER_HTG_DISTRIBUTOR_ID == $distributor_id){
                return true;
            }
        }
    }
    
    /**
     * Erlaubte Laender Shop Versandadresse
     * 
     * Gibt ein Array aller Laender zurueck in die versendet werden darf.
     */
    public static function get_allowed_delivery_countries(){
        global $InstanceCache;
        $key = 'allowed_delivery_countries';
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $array = [];
            $query = xtc_db_query(sprintf(
                "SELECT sgc.country_id,c.countries_name FROM shipping_graduation_countries sgc LEFT JOIN %s c ON c.countries_id=sgc.country_id ORDER BY c.countries_name",
                TABLE_COUNTRIES
            ));
            while($record = xtc_db_fetch_array($query)){
                if($record['countries_name'] != ''){
                    $array[] = [
                        'id'=>$record['country_id'],
                        'text'=>$record['countries_name']
                    ];
                }
            }
            $CachedString->set($array)->expiresAfter(0)->addTag('shop');//allowed_delivery_countries
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            return $array;
        }
        return $CachedString->get();
    }
    
    public static function get_currencies(){
        global $InstanceCache;
        $key = 'currencies';
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $values = [];
            $query = xtc_db_query(sprintf(
                "SELECT * FROM %s",
                TABLE_CURRENCIES
            ));
            while($record = xtc_db_fetch_array($query)){
                $values[] = $record;
            }
            $CachedString->set($values)->expiresAfter(0)->addTag('shop');//currencies
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            return $values;
        }
        return $CachedString->get();
    }
    
    /**
     * returns array (all fields from table customers_status) by a specific customers_status_id/language_id
     * throws error Exception when customers_status_id not exists
     * 
     * @param int $customers_status_id
     * @param int $languages_id
     * 
     * @return array
     */
    public static function get_customers_status( $customers_status_id, $languages_id = 2 ){
        global $InstanceCache;
        if($customers_status_id === Null){
            $customers_status_id = DEFAULT_CUSTOMERS_STATUS_ID;
        }
        $key = 'customers_status_'.$customers_status_id;
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $customers_status = \YES4Trade\Model\customers_status::get_by_customers_status_id_and_language_id(
                intval($customers_status_id),
                intval($languages_id)
            );
            if($customers_status !== null){
                $result = $customers_status[0]->toArray();
                $CachedString->set( $result )->expiresAfter(0)->addTag('shop');//customers_status_*
                $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            }else{
                throw new Exception('Invalid customers_status');
            }
        }else{
            $result = $CachedString->get();
        }
        return $result;
    }
    
    public static function get_country_values( int $countries_id ){
        global $InstanceCache;
        $key = 'country_values_'.$countries_id;
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $result = yes_query(
                "SELECT * FROM countries WHERE countries_id=:countries_id",
                ['countries_id'=>$countries_id],
                true
            );
            $CachedString->set($result)->expiresAfter(0)->addTag('shop');//country_values_*
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $result = $CachedString->get();
        }
        return $result;
    }
    
    public static function get_country_values_from_name( string $country_name ){
        global $InstanceCache;
        $key = 'country_values_name_'.md5($country_name);
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $result = yes_query(
                "SELECT * FROM countries WHERE countries_name=:country",
                ['country'=>$country_name],
                true
            );
            $CachedString->set($result)->expiresAfter(0)->addTag('shop');//country_values_name_
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $result = $CachedString->get();
        }
        return $result;
    }
    
    public static function get_orders_status_name( int $orders_status_id, $language_id ){
        global $InstanceCache;
        if (empty($language_id) or (int)$language_id < 1) {
            $language_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
        }
        $key = 'orders_status_name_'.$orders_status_id.'_'.$language_id;
        $CachedString = $InstanceCache->getItem($key);
        if (!$CachedString->isHit()) {
            $orders_status = yes_query(sprintf(
                "select orders_status_name from %s where orders_status_id =:status_id and language_id =:language_id",
                    TABLE_ORDERS_STATUS
                ),['status_id'=>$orders_status_id,'language_id'=>(int)$language_id],
                true
            );
            $CachedString->set($orders_status)->expiresAfter(0)->addTag('shop');//orders_status_name_*
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $orders_status = $CachedString->get();
        }
        return $orders_status['orders_status_name'];
    }
    
    public static function update_configuration_value( string $key, $value ){
        global $InstanceCache;
        if(empty($key)){
            throw new Exception('update_configuration_value() needs a valid key');
        }
        $update_sql_array = [
            'configuration_value'=>$value,
            'last_modified'=>'now()'
        ];
        xtc_db_perform('configuration', $update_sql_array,'update',"configuration_key='".$key."'");
        $InstanceCache->deleteItem('configuration');
    }

    public static function substr(string $string, int $length):string{
        if(strlen($string)>$length){
            $string_print = sprintf(
                '<span title="%s">%s[...]</span>',
                str_replace('"',"'",$string),
                substr($string,0,$length)
            );
        }else{
            $string_print = $string;
        }
        return $string_print;
    }

}
