<?php
/**
 * Description of order_position
 *
 * @author Mario Aspeleiter <m.aspeleiter at yes-websolutions.de>
 */
class order_position {
	var $single_price;
	var $total_price;
	var $single_price_netto;
	var $total_price_netto;
	var $title;
	var $text1;
	var $text2;
	var $quantity;
	var $position;
	var $products_model;
	var $properties;
	var $class;
	var $weight;
	public float $weight_netto = 0;
	var $total_weight;
	public float $total_weight_netto = 0;
	public float $width = 0;
	public float $height = 0;
	public float $depth = 0;
	var $characteristics;
	var $allow_tax;
	var $products_ean;
	var $collis;
	var $storages;
	var $products_short_description;
	var $slave_title;
	var $tax_rate;
	var $image;
	var $persons;
	var $products_id;
	var $storages_array;
	public string $country_of_origin = '';
	public float $own_volume = 0;
	public float $own_weight = 0;
	public string $un_classification_title = '';
	public string $un_classification_description = '';
	public int $orders_products_id = 0;
	public string $un_classification_full_string = '';
	public array $un_classification_values = [];
	public array $un_score_values = [];

	function getArray(){
		return array(
			'PRODUCTS_ID'=>$this->getProducts_id(),
			'ORDERS_PRODUCTS_ID'=>$this->getOrders_products_id(),
			'SINGLE_PRICE'=>$this->getSingle_price(),
			'TOTAL_PRICE'=>$this->getTotal_price(),
			'SINGLE_PRICE_NETTO'=>$this->getSingle_price_netto(),
			'TOTAL_PRICE_NETTO'=>$this->getTotal_price_netto(),
			'TITLE'=>$this->getTitle(),
			'TEXT1'=>$this->getText1(),
			'TEXT2'=>$this->getText2(),
			'QUANTITY'=>$this->getQuantity(),
			'POSITION'=>$this->getPosition(),
			'PRODUCTS_MODEL'=>$this->getProducts_model(),
			'CLASS'=>$this->getClass(),
			'PROPERTIES'=>$this->getProperties(),
			'WEIGHT'=>$this->getWeight(),
			'WEIGHT_NETTO'=>$this->getWeight_netto(),
			'CHARACTERISTICS'=>$this->getCharacteristics(),
			'ALLOW_TAX'=>$this->getAllow_tax(),
			'PRODUCTS_EAN'=>$this->getProducts_ean(),
			'COLLIS'=>$this->getCollis(),
			'STORAGES'=>$this->getStorages(),
			'STORAGES_ARRAY'=>$this->getStorages_array(),
			'PRODUCTS_SHORT_DESCRIPTION'=>$this->getProducts_short_description(),
			'TOTAL_WEIGHT'=>$this->getWeight()*$this->getQuantity(),
			'TOTAL_WEIGHT_NETTO'=>$this->getWeight_netto() * $this->getQuantity(),
			'SLAVE_TITLE'=>$this->getSlave_title(),
			'TAX_RATE'=>$this->getTax_rate(),
			'IMAGE'=>$this->getImage(),
			'PERSONS'=>$this->getPersons(),
			'WIDTH'=>$this->getWidth(),
			'HEIGHT'=>$this->getHeight(),
			'DEPTH'=>$this->getDepth(),
			'COUNTRY_OF_ORIGIN'=>$this->getCountry_of_origin(),
			'OWN_WEIGHT'=>$this->getOwn_weight(),
			'OWN_VOLUME'=>$this->getOwn_volume(),
			'OWN_WEIGHT_TOTAL'=>$this->getOwn_weight() * $this->getQuantity(),
			'OWN_VOLUME_TOTAL'=>$this->getOwn_volume() * $this->getQuantity(),
			'UN_CLASSIFICATION_TITLE'=>$this->getUn_classification_title(),
			'UN_CLASSIFICATION_DESCRIPTION'=>$this->getUn_classification_description(),
			'UN_CLASSIFICATION_FULL_STRING'=>$this->getUn_classification_full_string(),
			'UN_CLASSIFICATION_VALUES'=>$this->getUn_classification_values(),
			'UN_SCORE_VALUES'=>$this->getUn_score_values(),
		);
	}

	public function getWidth():float{
		return $this->width;
	}
	public function getHeight():float{
		return $this->height;
	}
	public function getDepth():float{
		return $this->depth;
	}

	public function setWidth(float $width):void{
		$this->width = $width;
	}

	public function setHeight(float $height):void{
		$this->height = $height;
	}

	public function setDepth(float $depth):void{
		$this->depth = $depth;
	}

	function getSlave_title() {
		return $this->slave_title;
	}

	function setSlave_title($slave_title) {
		$this->slave_title = $slave_title;
	}
	
	function getSingle_price() {
		return $this->single_price;
	}

	function setSingle_price($single_price) {
		$this->single_price = $single_price;
	}

	function getTotal_price() {
		return $this->total_price;
	}

	function setTotal_price($total_price) {
		$this->total_price = $total_price;
	}

	function getSingle_price_netto() {
		return $this->single_price_netto;
	}

	function setSingle_price_netto($single_price_netto) {
		$this->single_price_netto = $single_price_netto;
	}

	function getTitle() {
		return $this->title;
	}

	function setTitle($title) {
		$this->title = $title;
	}

	function getQuantity() {
		return $this->quantity;
	}

	function setQuantity($quantity) {
		$this->quantity = $quantity;
	}

	function getPosition() {
		return $this->position;
	}

	function setPosition($position) {
		$this->position = $position;
	}

	function getProducts_model() {
		return $this->products_model;
	}

	function setProducts_model($products_model) {
		$this->products_model = $products_model;
	}

	function getTotal_price_netto() {
		return $this->total_price_netto;
	}

	function setTotal_price_netto($total_price_netto) {
		$this->total_price_netto = $total_price_netto;
	}

	function getText1() {
		return $this->text1;
	}

	function setText1($text1) {
		$this->text1 = $text1;
	}

	function getText2() {
		return $this->text2;
	}

	function setText2($text2) {
		$this->text2 = $text2;
	}

	function getClass() {
		return $this->class;
	}

	public function getProperties() {
		return $this->properties;
	}

	public function setProperties($properties) {
		$this->properties = $properties;
	}
	
	public function getWeight() {
	    return $this->weight;
	}

	public function setWeight($weight) {
	    $this->weight = $weight;
	}

	public function getWeight_netto():float{
		return $this->weight_netto;
	}

	public function setWeight_netto( float $weight_netto ):void{
		$this->weight_netto = $weight_netto;
	}
	
	public function getCharacteristics(){
	    return $this->characteristics;
	}
	public function setCharacteristics($value){
	    $this->characteristics = $value;
	}
	public function getAllow_tax(){
	    return $this->allow_tax;
	}
	public function setAllow_tax($value){
	    $this->allow_tax = $value;
	}
	public function getProducts_ean(){
	    return $this->products_ean;
	}
	public function setProducts_ean($value){
	    $this->products_ean = $value;
	}
	public function getCollis(){
	    return $this->collis;
	}
	public function setCollis($value){
	    $this->collis = $value;
	}
	public function getStorages(){
	    return $this->storages;
	}
	public function setStorages($value){
	    $this->storages = $value;
	}
	public function getProducts_short_description(){
	    return $this->products_short_description;
	}
	public function setProducts_short_description($value){
	    $this->products_short_description = $value;
	}
	
	
	public function getImage() {
	    return $this->image;
	}

	public function setImage($image) {
	    $this->image = $image;
	}
        

        function getPersons() {
            return $this->persons;
        }


        function setPersons($persons) {
            $this->persons = $persons;
        }

        
       function getProducts_id(){
       	return $this->products_id;
       }
       function setProducts_id(int $products_id){
       	$this->products_id = $products_id;
       }
       
       function getStorages_array() {
           return $this->storages_array;
       }

       function setStorages_array($storages_array){
           $this->storages_array = $storages_array;
       }

	   	public function getCountry_of_origin():string{
			return $this->country_of_origin;
	   	}

	   	public function setCountry_of_origin(string $country_of_origin):void{
			$this->country_of_origin = $country_of_origin;
	   	}

		public function getOwn_weight():float{
			return $this->own_weight;
		}

		public function setOwn_weight(float $own_weight):void{
			$this->own_weight = $own_weight;
		}

		public function getOwn_volume():float{
			return $this->own_volume;
		}

		public function setOwn_volume(float $own_volume):void{
			$this->own_volume = $own_volume;
		}

                       		
	/**
	 * Values:
	 *
	 * product
	 * ot
	 * shipping
	 *
	 * @param string $class
	 */
	function setClass($class) {
		$this->class = $class;
	}

	public function getTax_rate() {
	    return $this->tax_rate;
	}

	public function setTax_rate($tax_rate) {
	    $this->tax_rate = $tax_rate;
	}

	/**
	 * Get the value of un_classification_title
	 */ 
	public function getUn_classification_title():string{
		return $this->un_classification_title;
	}

	/**
	 * Set the value of un_classification_title
	 *
	 * @return  self
	 */ 
	public function setUn_classification_title(string $un_classification_title):void{
		$this->un_classification_title = $un_classification_title;
	}

	/**
	 * Get the value of un_classification_description
	 */ 
	public function getUn_classification_description():string{
		return $this->un_classification_description;
	}

	/**
	 * Set the value of un_classification_description
	 */ 
	public function setUn_classification_description(string $un_classification_description):void{
		$this->un_classification_description = $un_classification_description;
	}



	/**
	 * Get the value of orders_products_id
	 */ 
	public function getOrders_products_id():int{
		return $this->orders_products_id;
	}

	/**
	 * Set the value of orders_products_id
	 */ 
	public function setOrders_products_id(int $orders_products_id):void{
		$this->orders_products_id = $orders_products_id;
	}

	/**
	 * Get the value of un_classification_full_string
	 */ 
	public function getUn_classification_full_string():string{
		return $this->un_classification_full_string;
	}

	/**
	 * Set the value of un_classification_full_string
	 */ 
	public function setUn_classification_full_string(string $un_classification_full_string):void{
		$this->un_classification_full_string = $un_classification_full_string;
	}

	public function getUn_classification_values():array{
		return $this->un_classification_values;
	}

	public function setUn_classification_values(array $un_classification_values):void{
		$this->un_classification_values = $un_classification_values;
	}

	public function getUn_score_values():array{
		return $this->un_score_values;
	}

	public function setUn_score_values(array $un_score_values):void{
		$this->un_score_values = $un_score_values;
	}
}
