<?php
/**
 * Description of order_positions
 *
 * @author Mario Aspeleiter <m.aspeleiter at yes-websolutions.de>
 */
require_once(DIR_FS_CATALOG.'includes/classes/order_position.php');
class order_positions {
	var $positions = array();
	var $subtotal;
	var $subtotal_netto;
	var $products_total;
	var $products_total_netto;
	var $is_netto;
	var $total;
	var $total_netto;
	var $tax_values;
	var $add_tax_to_total;
	var $weight;
	var $title_subtotal = '';
	var $title_total = '';
	public string $commission_number = '';

	public float $weight_netto = 0;
	public float $own_weight = 0;
	public float $own_volume = 0;
	public string $distribution_warehouse = '';
	public array $countries_of_origin = [];
	public array $pallets = [];

	function addPosition($position,$id=-1){
		if($id>=0){
			$this->positions[$id] = $position;
		}else{
			array_push($this->positions,$position);
		}
	}
	function calcTotal_netto(){
		$value = 0;
		if(!is_array($this->getPositions())) return $value;
		foreach($this->getPositions() as $pos){
			$value += $pos->getTotal_price_netto();
		}
		return $value;
	}

	function calcTotal_netto2($order_totals){
		$taxes = 0;
		$total = 0;
		foreach($order_totals as $ot){
			switch($ot['class']){
				case 'ot_tax':
					$taxes += $ot['value'];
					break;
				case 'ot_total':
					$total = $ot['value'];
					break;
			}
		}
		return $total-$taxes;
	}

	function calcTotal(){
		$value = 0;
		if(!is_array($this->getPositions())) return $value;
		foreach($this->getPositions() as $pos){
			$value += $pos->getTotal_price();
		}
		return $value;
	}

	function calcSubtotal(){
		$value = 0;
		if(!is_array($this->getPositions())) return $value;
		foreach($this->getPositions() as $pos){
			if($pos->getClass() == 'product' or $pos->getClass() == 'shipping'){
				$value += $pos->getTotal_price();
			}
		}
		return $value;
	}

	function calcSubtotal_netto(){
		$value = 0;
		if(!is_array($this->getPositions())) return $value;
		foreach($this->getPositions() as $pos){
			if($pos->getClass() == 'product' or $pos->getClass() == 'shipping'){
				$value += $pos->getTotal_price_netto();
			}
		}
		return $value;
	}


	function calcProducts_total(){
		$value = 0;
		if(!is_array($this->getPositions())) return $value;
		foreach($this->getPositions() as $pos){
			if($pos->getClass() == 'product'){
				$value += $pos->getTotal_price();
			}
		}
		return $value;
	}

	function calcProducts_total_netto(){
		$value = 0;
		if(!is_array($this->getPositions())) return $value;
		foreach($this->getPositions() as $pos){
			if($pos->getClass() == 'product'){
				$value += $pos->getTotal_price_netto();
			}
		}
		return $value;
	}

	function calcTax_values($totals){
		$values = array();
		if(!is_array($totals) or sizeOf($totals) == 0) return $values;
		foreach($totals as $total){
			if($total['class'] == 'ot_tax'){
				$values[] = array(
					'TITLE'=>$total['title'],
					'TEXT'=>$total['text'],
					'CLASS'=>$total['class'],
					'VALUE'=>$total['value']
				);
			}
		}
		return $values;
	}

	/**
	 * Erwartet $order->totals um die MWST zu ermitteln
	 *
	 * @param Array $order_totals
	 */
	function process($order_totals){
//		$this->setTotal_netto( $this->calcTotal_netto() );
		$this->setTotal_netto( $this->calcTotal_netto2($order_totals) );
		$this->setTotal($this->calcTotal());
		$this->setSubtotal($this->calcSubtotal());
		$this->setSubtotal_netto($this->calcSubtotal_netto());
		$this->setProducts_total($this->calcProducts_total());
		$this->setProducts_total_netto($this->calcProducts_total_netto());
		$this->setTax_values($this->calcTax_values($order_totals));
	}

	function getPositions() {
		return $this->positions;
	}

	function getPositionsArray() {
		$values = array();
		if(!is_array($this->positions) or sizeOf($this->positions) == 0) return $values;
		foreach($this->positions as $pos){
			$values[] = $pos->getArray();
		}
		return $values;
	}

	function setPositions($positions) {
		$this->positions = $positions;
	}

	function getSubtotal() {
		return $this->subtotal;
	}

	function setSubtotal($subtotal) {
		$this->subtotal = $subtotal;
	}

	function getSubtotal_netto() {
		return $this->subtotal_netto;
	}

	function setSubtotal_netto($subtotal_netto) {
		$this->subtotal_netto = $subtotal_netto;
	}

	function getProducts_total() {
		return $this->products_total;
	}

	function setProducts_total($products_total) {
		$this->products_total = $products_total;
	}

	function getProducts_total_netto() {
		return $this->products_total_netto;
	}

	function setProducts_total_netto($products_total_netto) {
		$this->products_total_netto = $products_total_netto;
	}

	public function setCommission_number( string $commission_number ):void{
		$this->commission_number = $commission_number;
	}

	public function getCommission_number():string{
		return $this->commission_number;
	}

	function getIs_netto() {
		return $this->is_netto;
	}

	function setIs_netto($is_netto) {
		$this->is_netto = $is_netto;
	}

	function getTotal() {
		if(!$this->getAdd_tax_to_total()){
			return $this->total;
		}else{
			// BUGFIX 18.02.10
			if(!sizeOf($this->getTax_values())){
				return $this->total;
			}
			$tax_total = 0;
			foreach($this->getTax_values() as $tax){
				$tax_total += $tax['VALUE'];
			}
			return $this->total + $tax_total;
		}
	}

	function setTotal($total) {
		$this->total = $total;
	}

	function getTotal_netto() {
		return $this->total_netto;
	}

	function setTotal_netto($total_netto) {
		$this->total_netto = $total_netto;
	}

	function getTax_values() {
		return $this->tax_values;
	}

	function setTax_values($tax_values) {
		$this->tax_values = $tax_values;
	}

	function getAdd_tax_to_total() {
		return $this->add_tax_to_total;
	}

	function setAdd_tax_to_total($add_tax_to_total) {
		$this->add_tax_to_total = $add_tax_to_total;
	}
	
	public function getWeight(){
	    return $this->weight;
	}
	
	public function setWeight($weight){
	    $this->weight = $weight;
	}

	public function getWeight_netto():float{
		return $this->weight_netto;
	}

	public function setWeight_netto(float $weight_netto):void{
		$this->weight_netto = $weight_netto;
	}

	public function setOwn_volume(float $own_volume):void{
		$this->own_volume = $own_volume;
	}

	public function setOwn_weight(float $own_weight):void{
		$this->own_weight = $own_weight;
	}

	public function getOwn_weight():float{
		return $this->own_weight;
	}

	public function getOwn_volume():float{
		return $this->own_volume;
	}

	public function getDistribution_warehouse():string{
		return $this->distribution_warehouse;
	}

	public function setDistribution_warehouse(string $distribution_warehouse):void{
		$this->distribution_warehouse = $distribution_warehouse;
	}
	
	private function get_countries_of_origin_array(){
		$values = array();
		if(!is_array($this->positions) or sizeOf($this->positions) == 0) return $values;
		foreach($this->positions as $pos){
			if(isset($pos->products_id) and intval($pos->products_id) > 0){
				if(!empty($pos->country_of_origin)){
					if(!in_array($pos->country_of_origin, $values)){
						$values[] = $pos->country_of_origin;
					}
				}
			}
		}
		return $values;
	}

	function getArray($xtPrice){
		return array(
			'POSITIONS'=>$this->getPositionsArray(),
			'SUBTOTAL'=>$xtPrice->xtcFormat($this->getSubtotal(),true),
			'SUBTOTAL_NETTO'=>$xtPrice->xtcFormat($this->getSubtotal_netto(),true),
			'PRODUCTS_TOTAL'=>$xtPrice->xtcFormat($this->getProducts_total(),true),
			'PRODUCTS_TOTAL_NETTO'=>$xtPrice->xtcFormat($this->getProducts_total_netto(),true),
			'TOTAL'=>$xtPrice->xtcFormat($this->getTotal(),true),
			'TOTAL_NETTO'=>$xtPrice->xtcFormat($this->getTotal_netto(),true),
			'TAX_VALUES'=>$this->getTax_values(),
			'IS_NETTO'=>$this->getIs_netto(),
		    'WEIGHT'=>$this->getWeight(),
			'WEIGHT_NETTO'=>$this->getWeight_netto(),
			'TITLE_SUBTOTAL'=>$this->title_subtotal,
			'TITLE_TOTAL'=>$this->title_total,
			'COMMISSION_NUMBER'=>$this->getCommission_number(),
			'OWN_WEIGHT'=>$this->getOwn_weight(),
			'OWN_VOLUME'=>$this->getOwn_volume(),
			'DISTRIBUTION_WAREHOUSE'=>$this->getDistribution_warehouse(),
			'COUNTRIES_OF_ORIGIN'=>$this->get_countries_of_origin_array(),
			'COUNTRY_OF_ORIGIN_TITLE'=>COUNTRY_OF_ORIGIN_TITLE,
			'COUNTRIES_OF_ORIGIN_TITLE'=>COUNTRIES_OF_ORIGIN_TITLE,
			'PALLETS'=>$this->getPallets()
		);
	}

	/**
	 * Get the value of pallets
	 */ 
	public function getPallets():array{
		return $this->pallets;
	}

	/**
	 * Set the value of pallets
	 */ 
	public function setPallets($pallets):void{
		$this->pallets = $pallets;
	}
}
