<?php
/* -----------------------------------------------------------------------------------------
   $Id: split_page_results.php,v 1.3 2010/06/19 08:34:33 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(split_page_results.php,v 1.14 2003/05/27); www.oscommerce.com 
   (c) 2003	 nextcommerce (split_page_results.php,v 1.6 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

  class splitPageResults {
    var $sql_query, $number_of_rows, $current_page_number, $number_of_pages, 
        $number_of_rows_per_page,$pdo_parameter;
    // class constructor
    function __construct($query, $page, $max_rows, $count_key = '*',$use_cache = false, array $pdo_parameter = []) {
      $this->sql_query = $query;
      $this->pdo_parameter = $pdo_parameter;
      if (empty($page) or (is_numeric($page) == false) or $page < 1) {
          $page = 1;
      }
      $this->current_page_number = intval($page);

      $this->number_of_rows_per_page = $max_rows;

      $pos_to = strlen($this->sql_query);
      $pos_from = strpos($this->sql_query, ' from', 0);
      
      $pos_group_by = strpos($this->sql_query, ' group by', $pos_from);
      if (($pos_group_by < $pos_to) && ($pos_group_by != false)) $pos_to = $pos_group_by;

      $pos_having = strpos($this->sql_query, ' having', $pos_from);
      if (($pos_having < $pos_to) && ($pos_having != false)) $pos_to = $pos_having;

      $pos_order_by = strpos($this->sql_query, ' order by', $pos_from);
      if (($pos_order_by < $pos_to) && ($pos_order_by != false)) $pos_to = $pos_order_by;

      if (strpos($this->sql_query, 'distinct') || strpos($this->sql_query, 'group by')) {
        $count_string = 'distinct ' . xtc_db_input($count_key);
        //$count_string = xtc_db_input($count_key);
      } else {
        $count_string = xtc_db_input($count_key);
      }
        if(!$use_cache){
            if(sizeOf($this->pdo_parameter)){
              try{
                $count = yes_query(
                    "select count(" . $count_string . ") as total " . substr($this->sql_query, $pos_from, ($pos_to - $pos_from)),
                    $this->pdo_parameter,
                    true
                );
              } catch (PDOException $e) {
                  // Nur SQLSTATE[HY000] und Fehlercode 1267 (Collation-Konflikt)
                  $sqlState = $e->getCode();
                  $errorCode = $e->errorInfo[1] ?? null;

                  if ($sqlState === 'HY000' && $errorCode === 1267) {
                      // Leise behandeln → keine Treffer
                      $count = ['total'=>0];
                  } else {
                      // Alle anderen Fehler normal weiterwerfen
                      throw $e;
                  }
              }

            }else{
              try{
                $count_query = xtc_db_query("select count(" . $count_string . ") as total " . substr($this->sql_query, $pos_from, ($pos_to - $pos_from)));
                $count = xtc_db_fetch_array($count_query);
              } catch (PDOException $e) {
                  // Nur SQLSTATE[HY000] und Fehlercode 1267 (Collation-Konflikt)
                  $sqlState = $e->getCode();
                  $errorCode = $e->errorInfo[1] ?? null;

                  if ($sqlState === 'HY000' && $errorCode === 1267) {
                      // Leise behandeln → keine Treffer
                      $count = ['total'=>0];
                  } else {
                      // Alle anderen Fehler normal weiterwerfen
                      throw $e;
                  }
              }
            }
        }else{
            $query_string = "select count(" . $count_string . ") as total " . substr(
                                              $this->sql_query,
                                              $pos_from,
                                              ($pos_to - $pos_from));
            if(is_countable($this->pdo_parameter) and sizeOf($this->pdo_parameter)){
              try{
                $count = yes_query($query_string,$this->pdo_parameter,true);
              } catch (PDOException $e) {
                  // Nur SQLSTATE[HY000] und Fehlercode 1267 (Collation-Konflikt)
                  $sqlState = $e->getCode();
                  $errorCode = $e->errorInfo[1] ?? null;

                  if ($sqlState === 'HY000' && $errorCode === 1267) {
                      // Leise behandeln → keine Treffer
                      $count = ['total'=>0];
                  } else {
                      // Alle anderen Fehler normal weiterwerfen
                      throw $e;
                  }
              }
            }else{
              try{
                $count_query = yes_db_query($query_string,true);
                if(yes_db_num_rows($count_query)){
                        $count = current($count_query);
                }
              } catch (PDOException $e) {
                  // Nur SQLSTATE[HY000] und Fehlercode 1267 (Collation-Konflikt)
                  $sqlState = $e->getCode();
                  $errorCode = $e->errorInfo[1] ?? null;

                  if ($sqlState === 'HY000' && $errorCode === 1267) {
                      // Leise behandeln → keine Treffer
                      $count = ['total'=>0];
                  } else {
                      // Alle anderen Fehler normal weiterwerfen
                      throw $e;
                  }
              }
            }
        }

        $this->number_of_rows = $count['total'];

        $this->number_of_pages = ceil($this->number_of_rows / $this->number_of_rows_per_page);

        if ($this->current_page_number > $this->number_of_pages and $this->number_of_pages > 0) {
            $this->current_page_number = $this->number_of_pages;
        }

        $offset = ($this->number_of_rows_per_page * ($this->current_page_number - 1));

        $this->sql_query .= " limit " . $offset . ", " . $this->number_of_rows_per_page;
    }

    // class functions

    // display split-page-number-links
    function display_links($max_page_links, $parameters = '') {
      global $PHP_SELF, $request_type;

      $display_links_string = '';

      $class = 'class="pageResults"';

      if (xtc_not_null($parameters) && (substr($parameters, -1) != '&')) $parameters .= '&';
      // previous button - not displayed on first page
      if ($this->current_page_number > 1) $display_links_string .= '<a href="' . xtc_href_link(basename($PHP_SELF), $parameters . 'page=' . ($this->current_page_number - 1), $request_type) . '" class="pageResults" title=" ' . PREVNEXT_TITLE_PREVIOUS_PAGE . ' "><u>' . PREVNEXT_BUTTON_PREV . '</u></a>&nbsp;&nbsp;';

      // check if number_of_pages > $max_page_links
      $cur_window_num = intval($this->current_page_number / $max_page_links);
      if ($this->current_page_number % $max_page_links) $cur_window_num++;

      $max_window_num = intval($this->number_of_pages / $max_page_links);
      if ($this->number_of_pages % $max_page_links) $max_window_num++;

      // previous window of pages
      if ($cur_window_num > 1) $display_links_string .= '<a href="' . xtc_href_link(basename($PHP_SELF), $parameters . 'page=' . (($cur_window_num - 1) * $max_page_links), $request_type) . '" class="pageResults" title=" ' . sprintf(PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE, $max_page_links) . ' ">...</a>';

      // page nn button
      for ($jump_to_page = 1 + (($cur_window_num - 1) * $max_page_links); ($jump_to_page <= ($cur_window_num * $max_page_links)) && ($jump_to_page <= $this->number_of_pages); $jump_to_page++) {
        if ($jump_to_page == $this->current_page_number) {
          $display_links_string .= '&nbsp;<b>' . $jump_to_page . '</b>&nbsp;';
        } else {
          $display_links_string .= '&nbsp;<a href="' . xtc_href_link(basename($PHP_SELF), $parameters . 'page=' . $jump_to_page, $request_type) . '" class="pageResults" title=" ' . sprintf(PREVNEXT_TITLE_PAGE_NO, $jump_to_page) . ' "><u>' . $jump_to_page . '</u></a>&nbsp;';
        }
      }

      // next window of pages
      if ($cur_window_num < $max_window_num) $display_links_string .= '<a href="' . xtc_href_link(basename($PHP_SELF), $parameters . 'page=' . (($cur_window_num) * $max_page_links + 1), $request_type) . '" class="pageResults" title=" ' . sprintf(PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE, $max_page_links) . ' ">...</a>&nbsp;';

       // next button
      if (($this->current_page_number < $this->number_of_pages) && ($this->number_of_pages != 1)) $display_links_string .= '&nbsp;<a href="' . xtc_href_link(basename($PHP_SELF), $parameters . 'page=' . ($this->current_page_number + 1), $request_type) . '" class="pageResults" title=" ' . PREVNEXT_TITLE_NEXT_PAGE . ' "><u>' . PREVNEXT_BUTTON_NEXT . '</u></a>&nbsp;';

      return $display_links_string;
    }

    // display number of total products found
    function display_count($text_output) {
      $to_num = ($this->number_of_rows_per_page * $this->current_page_number);
      if ($to_num > $this->number_of_rows) $to_num = $this->number_of_rows;

      $from_num = ($this->number_of_rows_per_page * ($this->current_page_number - 1));

      if ($to_num == 0) {
        $from_num = 0;
      } else {
        $from_num++;
      }

      return sprintf($text_output, $from_num, $to_num, $this->number_of_rows);
    }
  }
?>
