<?php

namespace Secuconnect\Client\Api;

use PHPUnit\Framework\TestCase;
use Secuconnect\Client\ApiException;
use Secuconnect\Client\Model\PaymentCustomersProductModel;
use Secuconnect\Client\Model\PaymentInformation;
use Secuconnect\Client\Model\SecupayBasketItem;
use Secuconnect\Client\Model\SecupayTransactionProductDTO;
use Secuconnect\Client\Model\SecupayTransactionProductModel;

/**
 * Class PaymentSecupayPrepaysApiTest
 */
class PaymentSecupayPrepaysApiTest extends TestCase
{
    /**
     * @var PaymentSecupayPrepaysApi
     */
    private $api;

    /**
     * @var SecuconnectObjects
     */
    private static $secuconnectObjects;

    /**
     * @var string
     */
    private static $prepayTransactionId;

    /**
     * @var string
     */
    private static $customerId;

    /**
     * @var int
     */
    private static $amount;

    /**
     * @var string
     */
    private static $currency;

    /**
     * @var string
     */
    private static $purpose;

    /**
     * @var string
     */
    private static $orderId;

    /**
     * @var bool
     */
    private static $accrual;

    /**
     * @var SecupayBasketItem[]
     */
    private static $basket;

    /**
     * Setup before running any test cases
     *
     * @throws ApiException
     */
    public static function setUpBeforeClass(): void
    {
        parent::setUpBeforeClass();
        self::$secuconnectObjects = SecuconnectObjects::getInstance();
        self::$customerId = self::$secuconnectObjects->getCustomer()->getId();
        self::$amount = 6324;
        self::$currency = 'EUR';
        self::$orderId = 'ZZZZZZ';
        self::$accrual = true;
        self::$basket = self::$secuconnectObjects->getBasket();
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        parent::setUp();
        $this->api = new PaymentSecupayPrepaysApi();
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
        $this->api = null;
        parent::tearDown();
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
        self::$secuconnectObjects = null;
        self::$customerId = null;
        self::$amount = null;
        self::$currency = null;
        self::$orderId = null;
        self::$accrual = null;
        self::$basket = null;
        parent::tearDownAfterClass();
    }

    /**
     * Test case for paymentSecupayprepaysPost
     *
     * @throws ApiException
     */
    public function testPaymentSecupayprepaysPost()
    {
        $invoiceData = [
            'customer' => self::$customerId,
            'amount' => self::$amount,
            'currency' => self::$currency,
            'purpose' => self::$purpose,
            'order_id' => self::$orderId,
            'accrual' => self::$accrual,
            'basket' => self::$basket
        ];

        try {
            $response = $this->api->paymentSecupayprepaysPost(new SecupayTransactionProductDTO($invoiceData));
            self::$prepayTransactionId = $response->getId();
        } catch (ApiException $e) {
            print_r($e->getResponseBody());
            throw $e;
        }

        $this->assertNotEmpty(self::$prepayTransactionId);
        $this->assertInstanceOf(SecupayTransactionProductModel::class, $response);
        $this->assertEquals('payment.secupayprepays', $response->getObject());
        $this->assertEquals(self::$prepayTransactionId, $response->getId());
        $this->assertNotEmpty($response->getTransId());
        $this->assertNotEmpty($response->getStatus());
        $this->assertEquals(self::$amount, $response->getAmount());
        $this->assertEquals(self::$currency, $response->getCurrency());
        $this->assertEquals(self::$purpose, $response->getPurpose());
        $this->assertEquals(self::$orderId, $response->getOrderId());

        for ($i = 0; $i < 3; ++$i) {
            $this->assertEquals(self::$basket[$i], $response->getBasket()[$i]);
            $this->assertEquals(self::$basket[$i]->getItemType(), $response->getBasket()[$i]->getItemType());
            $this->assertEquals(self::$basket[$i]->getArticleNumber(), $response->getBasket()[$i]->getArticleNumber());
            $this->assertEquals(self::$basket[$i]->getQuantity(), $response->getBasket()[$i]->getQuantity());
            $this->assertEquals(self::$basket[$i]->getName(), $response->getBasket()[$i]->getName());
            $this->assertEquals(self::$basket[$i]->getModel(), $response->getBasket()[$i]->getModel());
            $this->assertEquals(self::$basket[$i]->getEan(), $response->getBasket()[$i]->getEan());
            $this->assertEquals(self::$basket[$i]->getTax(), $response->getBasket()[$i]->getTax());
            $this->assertEquals(self::$basket[$i]->getTotal(), $response->getBasket()[$i]->getTotal());
            $this->assertEquals(self::$basket[$i]->getPrice(), $response->getBasket()[$i]->getPrice());
            $this->assertEquals(self::$basket[$i]->getApikey(), $response->getBasket()[$i]->getApikey());
            $this->assertEquals(self::$basket[$i]->getTransactionHash(), $response->getBasket()[$i]->getTransactionHash());
            $this->assertEquals(self::$basket[$i]->getContractId(), $response->getBasket()[$i]->getContractId());
        }

        $this->assertEquals(self::$accrual, $response->getAccrual());
        $this->assertEquals('sale', $response->getPaymentAction());
        $this->assertNotEmpty($response->getTransferPurpose());
        $this->assertInstanceOf(PaymentInformation::class, $response->getTransferAccount());
        $this->assertNotEmpty($response->getTransferAccount()->getIban());
        $this->assertNotEmpty($response->getTransferAccount()->getBic());
        $this->assertNotEmpty($response->getTransferAccount()->getOwner());
        $this->assertInstanceOf(PaymentCustomersProductModel::class, $response->getCustomer());
        $this->assertNotEmpty($response->getCustomer());
        $this->assertEquals('payment.customers', $response->getCustomer()->getObject());
        $this->assertEquals(self::$customerId, $response->getCustomer()->getId());
        $this->assertNotEmpty($response->getCustomer()->getCreated());
        $this->assertNotEmpty($response->getRedirectUrl());
        $this->assertNotEmpty($response->getRedirectUrl()->getIframeUrl());
        $this->assertNotEmpty($response->getRedirectUrl()->getUrlSuccess());
        $this->assertNotEmpty($response->getRedirectUrl()->getUrlFailure());
        $this->assertNotEmpty($response->getIframeUrl());
    }

    /**
     * Test case for paymentSecupayprepaysHashGet
     *
     * @depends testPaymentSecupayprepaysPost
     *
     * @throws ApiException
     */
    public function testPaymentSecupayPrepaysGetById()
    {
        $this->assertNotEmpty(self::$prepayTransactionId);
        try {
            $response = $this->api->paymentSecupayPrepaysGetById(self::$prepayTransactionId);
        } catch (ApiException $e) {
            print_r($e->getResponseBody());
            throw $e;
        }

        $this->assertNotEmpty(self::$prepayTransactionId);
        $this->assertInstanceOf(SecupayTransactionProductModel::class, $response);
        $this->assertEquals('payment.secupayprepays', $response->getObject());
        $this->assertEquals(self::$prepayTransactionId, $response->getId());
        $this->assertNotEmpty($response->getTransId());
        $this->assertNotEmpty($response->getStatus());
        $this->assertEquals(self::$amount, $response->getAmount());
        $this->assertEquals(self::$currency, $response->getCurrency());
        $this->assertEquals(self::$purpose, $response->getPurpose());
        $this->assertEquals(self::$orderId, $response->getOrderId());

        for ($i = 0; $i < 3; ++$i) {
            $this->assertEquals(self::$basket[$i], $response->getBasket()[$i]);
            $this->assertEquals(self::$basket[$i]->getItemType(), $response->getBasket()[$i]->getItemType());
            $this->assertEquals(self::$basket[$i]->getArticleNumber(), $response->getBasket()[$i]->getArticleNumber());
            $this->assertEquals(self::$basket[$i]->getQuantity(), $response->getBasket()[$i]->getQuantity());
            $this->assertEquals(self::$basket[$i]->getName(), $response->getBasket()[$i]->getName());
            $this->assertEquals(self::$basket[$i]->getModel(), $response->getBasket()[$i]->getModel());
            $this->assertEquals(self::$basket[$i]->getEan(), $response->getBasket()[$i]->getEan());
            $this->assertEquals(self::$basket[$i]->getTax(), $response->getBasket()[$i]->getTax());
            $this->assertEquals(self::$basket[$i]->getTotal(), $response->getBasket()[$i]->getTotal());
            $this->assertEquals(self::$basket[$i]->getPrice(), $response->getBasket()[$i]->getPrice());
            $this->assertEquals(self::$basket[$i]->getApikey(), $response->getBasket()[$i]->getApikey());
            $this->assertEquals(self::$basket[$i]->getTransactionHash(), $response->getBasket()[$i]->getTransactionHash());
            $this->assertEquals(self::$basket[$i]->getContractId(), $response->getBasket()[$i]->getContractId());
        }

        $this->assertEquals(self::$accrual, $response->getAccrual());
        $this->assertEquals('sale', $response->getPaymentAction());
        $this->assertNotEmpty($response->getTransferPurpose());
        $this->assertInstanceOf(PaymentInformation::class, $response->getTransferAccount());
        $this->assertNotEmpty($response->getTransferAccount()->getIban());
        $this->assertNotEmpty($response->getTransferAccount()->getBic());
        $this->assertNotEmpty($response->getTransferAccount()->getOwner());
        $this->assertInstanceOf(PaymentCustomersProductModel::class, $response->getCustomer());
        $this->assertNotEmpty($response->getCustomer());
        $this->assertEquals('payment.customers', $response->getCustomer()->getObject());
        $this->assertEquals(self::$customerId, $response->getCustomer()->getId());
        $this->assertNotEmpty($response->getCustomer()->getCreated());
        $this->assertNotEmpty($response->getRedirectUrl());
        $this->assertNotEmpty($response->getRedirectUrl()->getIframeUrl());
        $this->assertNotEmpty($response->getRedirectUrl()->getUrlSuccess());
        $this->assertNotEmpty($response->getRedirectUrl()->getUrlFailure());
    }

    /**
     * Test case for paymentSecupayprepaysHashCancelPost
     *
     * @depends testPaymentSecupayprepaysPost
     *
     * @throws ApiException
     */
    public function testPaymentSecupayPrepaysCancelById()
    {
        $this->assertNotEmpty(self::$prepayTransactionId);
        try {
            $response = $this->api->cancelPaymentTransactionById('secupayprepays', self::$prepayTransactionId, null);
        } catch (ApiException $e) {
            print_r($e->getResponseBody());
            throw $e;
        }
        $this->assertNotEmpty($response);
        $this->assertNotEmpty($response['result']);
    }
}
