<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtcPrice.php,v 1.22 2019/01/10 11:25:56 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(currencies.php,v 1.15 2003/03/17); www.oscommerce.com
   (c) 2003         nextcommerce (currencies.php,v 1.9 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/


require_once(DIR_FS_INC.'xtc_get_currencies_values.inc.php');
class xtcPrice {
    var $currencies, $country_id, $zone_id, $cStatus,$actualGroup, $actualCurr;
    public function setCountryZone($country_id, $zone_id=0){
        $this->country_id = $country_id;
        $this->zone_id = $zone_id;
    }

    public function getZone_id(){
        return $this->zone_id;
    }

    public function setZone_id( $zone_id ){
        $this->zone_id = $zone_id;
    }

    public function getCountry_id(){
        return $this->country_id;
    }
        
    public function setCountry_id( $country_id ){
        $this->country_id = $country_id;
    }
        
    // class constructor
    function __construct($currency,$cGroup) {
        $this->currencies=array();
        $this->cStatus=array();
        $this->actualGroup=$cGroup;
        $this->actualCurr=$currency;
// 2021/08 die beiden variablen gibt es an dieser stelle nicht        
//        $this->country_id = $country_id;
//        $this->zone_id = $zone_id;

        // select Currencies
        $currencies_array = main::get_currencies();
        if(is_countable($currencies_array) and sizeOf($currencies_array)){
            foreach($currencies_array as $currencies){
                $this->currencies[$currencies['code']] = array('title' => $currencies['title'],
                   'symbol_left' => $currencies['symbol_left'],
                   'symbol_right' => $currencies['symbol_right'],
                   'decimal_point' => $currencies['decimal_point'],
                   'thousands_point' => $currencies['thousands_point'],
                   'decimal_places' => $currencies['decimal_places'],
                   'value' => $currencies['value']);
            }
        }
        // select Customers Status data
        $langId = (isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2;
        $cs = main::get_customers_status($this->actualGroup,$langId);
        if(is_countable($cs) and sizeOf($cs)){
            $customers_status_value = $cs;
        }else{
            $customers_status_value  = [];
        }
        $this->cStatus= array(
            'customers_status_id' => $this->actualGroup,
            'customers_status_name' => $customers_status_value['customers_status_name'],
            'customers_status_image' => $customers_status_value['customers_status_image'],
            'customers_status_public' => $customers_status_value['customers_status_public'],
            'customers_status_discount' => $customers_status_value['customers_status_discount'],
            'customers_status_ot_discount_flag' => $customers_status_value['customers_status_ot_discount_flag'],
            'customers_status_ot_discount' => $customers_status_value['customers_status_ot_discount'],
            'customers_status_graduated_prices' => $customers_status_value['customers_status_graduated_prices'],
            'customers_status_show_price' => $customers_status_value['customers_status_show_price'],
            'customers_status_show_price_tax' => $customers_status_value['customers_status_show_price_tax'],
            'customers_status_add_tax_ot' => $customers_status_value['customers_status_add_tax_ot'],
            'customers_status_payment_unallowed' => $customers_status_value['customers_status_payment_unallowed'],
            'customers_status_shipping_unallowed' => $customers_status_value['customers_status_shipping_unallowed'],
            'customers_status_discount_attributes' => $customers_status_value['customers_status_discount_attributes'],
            'customers_fsk18' => $customers_status_value['customers_fsk18'],
            'customers_fsk18_display' => $customers_status_value['customers_fsk18_display']
        );
    }

    function calcTax($price, $tax) {
        return $price * $tax / 100;
    }
    function xtcRemoveTax($price, $tax) {
        $price = ($price / (($tax +100) / 100));
        return $price;
    }

    function xtcGetTax($price, $tax) {
        $tax = $price - $this->xtcRemoveTax($price, $tax);
        return $tax;
    }

    function xtcRemoveDC($price,$dc) {
        $price = $price - ($price/100*$dc);
        return $price;	
    }

    function xtcGetDC($price,$dc) {
        $dc = $price/100*$dc;
        return $dc;	
    }

    function xtcCalculateCurrEx($price, $curr) {
        return $price * ($this->currencies[$curr]['value'] / $this->currencies[$this->actualCurr]['value']);
    }

    // get products Price
    function xtcGetPrice($pID,$format=true,$qty=0,$tax_class=0,$pPrice=0,$cedit_id=0,$use_cache_for_specials=false) {
        $pPrice = (float)$pPrice;
        // check if group is allowed to see prices
        // BUGFIX MARIO: IN KASSE ANZEIGEN
        if ($this->cStatus['customers_status_show_price'] == '0' && !preg_match('/admin\//',$_SERVER["SCRIPT_NAME"]) ){
            return $this->xtcShowNote();
        }

        // get Tax rate
        // cedit_id ist irrelevant, entweder country_id oder STORE_COUNTRY
        if ($cedit_id != 0) {
            if($this->getCountry_id() > 0){
                $products_tax=xtc_get_tax_rate( $tax_class, $this->getCountry_id(), $this->getZone_id() );
            }else{
                $products_tax = xtc_get_tax_rate($tax_class);
            }
        } else {
            // EU-OSS 2021/07
            if($this->getCountry_id() > 0){
                $products_tax=xtc_get_tax_rate( $tax_class, $this->getCountry_id(), $this->getZone_id() );
            }else{
                $products_tax=xtc_get_tax_rate( $tax_class );
            }
        }
        if ($this->cStatus['customers_status_show_price_tax'] =='0') {
            $products_tax = '';
        }
         // add taxes
        if ((float)$pPrice==0) {
            $pPrice=$this->getPprice($pID);
        }
        $pPrice = $this->xtcAddTax($pPrice,$products_tax);

         // check specialprice
        if($use_cache_for_specials){
            if ($sPrice = $this->xtcCheckSpecial($pID)) {
                return $this->xtcFormatSpecial($this->xtcAddTax($sPrice,$products_tax),$pPrice,$format);
            }
        }else{
            // NO CACHE
            if ($sPrice = $this->xtcCheckSpecial($pID,false)) {
                return $this->xtcFormatSpecial($this->xtcAddTax($sPrice,$products_tax),$pPrice,$format);
            }
        }

        // check Product Discount
        $discount = $this->xtcCheckDiscount($pID);
        if ($discount){ 
            return $this->xtcFormatSpecialDiscount($discount,$pPrice,$format);
        }

        // check graduated+Group Price
        if ($this->cStatus['customers_status_graduated_prices']=='1'){
            $sPrice = $this->xtcGetGraduatedPrice($pID,$qty);
            if($sPrice <> 0){
                return $this->xtcFormatSpecialGraduated($this->xtcAddTax($sPrice,$products_tax),$pPrice,$format);
            }
        }
        return $this->xtcFormat($pPrice,$format);
    }

    function getPprice($pID) {
        $pQuery = sprintf("SELECT products_price FROM %s WHERE products_id=:id",
            TABLE_PRODUCTS
        );
        $pQuery = yes_query($pQuery,[
            'id'=>intval($pID)
        ]);
        if(is_countable($pQuery)){
            $pData=current($pQuery);
            return $pData['products_price'];
        }else{
            yes_mail_debug($pQuery.' --- id='.$pID,false,'getPprice() mit ungueltiger pID');
            return 0;
        }
    }

    function xtcAddTax($price,$tax) {
        if($tax == 0){
            return $price;
        }
        // php8 bugfix
        $price = (float) $price;
        $tax = (float) $tax;
        $price=$price+$price/100*$tax;
        $price = $this->xtcCalculateCurr($price);
        return $price;
    }

    function xtcCheckDiscount($pID) {
        // check if group got discount
        if ($this->cStatus['customers_status_discount'] != '0.00' ) {
            $discount_query="SELECT products_discount_allowed FROM ".TABLE_PRODUCTS." WHERE products_id =:products_id";
            $discount_query = yes_query($discount_query,[
                'products_id'=> (int)$pID
            ]);
            if(sizeOf($discount_query)){
                $dData=current($discount_query);
                $discount = $dData['products_discount_allowed'];
                if ($this->cStatus['customers_status_discount'] < $discount){
                    $discount =  $this->cStatus['customers_status_discount'];
                }
                if ($discount == '0.00'){
                    return false;
                }
                return $discount;
            }
        }
        return false;
    }


    function xtcGetGraduatedPrice($pID,$qty) {
        $group_price_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
            $this->cStatus['customers_status_id'], (int)$pID
        );
        $found = false;
        foreach($group_price_items as $GPI){
            if($GPI->quantity <= $qty){
                $GPI_qty = $GPI;
                $found = true;
            }
        }
        if(!$found){
            return 0;
        }
        $sPrice = $GPI_qty->personal_offer;
        if ($sPrice <> 0 ){
            return $sPrice;
        }
        return 0;
    }

    function xtcShowNote() {
        return '<span class="view_price_not_allowed">'.NOT_ALLOWED_TO_SEE_PRICES.'</span>';
    }

    function xtcCheckSpecial($pID,$use_cache=true) {
        $product_query_raw = "select specials_new_products_price from " . TABLE_SPECIALS . " where products_id =:products_id and status";
        $product_query = yes_query(
            $product_query_raw,
            ['products_id'=>(int)$pID]
        );
        if(is_countable($product_query) and sizeOf($product_query)){
            $product = current($product_query);
            return $product['specials_new_products_price'];
        }
    }

    function xtcCalculateCurr($price) {
        return $this->currencies[$this->actualCurr]['value']*$price;
    }

    function xtcRemoveCurr($price) {
        // check if used Curr != DEFAULT curr
        if (DEFAULT_CURRENCY==$this->actualCurr) {
            return $price;
        }
        return $price*(1/$this->currencies[$this->actualCurr]['value']);
    }


 /*
 *
 *    Format Functions
 *
 *
 *
 */

    function xtcFormat($price,$format,$tax_class=0,$curr=false) {

        if ($curr) $price=$this->xtcCalculateCurr($price);

        if ($tax_class!=0)   {
            // EU-OSS 2021/07
            if($this->getCountry_id() > 0){
                $products_tax=xtc_get_tax_rate( $tax_class, $this->getCountry_id(), $this->getZone_id() );
            }else{
                $products_tax=xtc_get_tax_rate($tax_class);
            }
        }
        if ($this->cStatus['customers_status_show_price_tax'] =='0'){
            $products_tax = 0;
        }
        if(!isset($products_tax)){
            $products_tax = 0;
        }
        $price = $this->xtcAddTax($price,$products_tax);

        if ($format) {
            if(floatval($price) <> 0){
                $price=number_format(floatval($price),$this->currencies[$this->actualCurr]['decimal_places'], $this->currencies[$this->actualCurr]['decimal_point'], $this->currencies[$this->actualCurr]['thousands_point']);
            }else{
                $price=number_format(0,$this->currencies[$this->actualCurr]['decimal_places'], $this->currencies[$this->actualCurr]['decimal_point'], $this->currencies[$this->actualCurr]['thousands_point']);
            }
            $price = $this->currencies[$this->actualCurr]['symbol_left']. ' '.$price.' '.$this->currencies[$this->actualCurr]['symbol_right'];
            return $price;
        }
        return $price;
    }

    function xtcFormatSpecialDiscount($discount,$pPrice,$format) {
        $sPrice =  $pPrice-($pPrice / 100)*$discount;
        if (!$format) {
            return $sPrice;
        }
        if(XTPRICE_HIDE_SPECIALPRICE == 'True'){
            return $this->xtcFormat($sPrice,$format);
        }
        return '<span class="xtc_price_special_discount1">'.XTPRICE_SPECIAL_DISCOUNT1.'</span> <span class="xtc_price_special_discount_value1">'
            .$this->xtcFormat($pPrice,$format).
            '</span><br /><span class="xtc_price_special_discount2">'.XTPRICE_SPECIAL_DISCOUNT2.'</span> <span class="xtc_price_special_discount_value2">'
            .$this->xtcFormat($sPrice,$format).
            '</span><br /><span class="xtc_price_special_discount3">'.XTPRICE_SPECIAL_DISCOUNT3.'</span> <span class="xtc_price_special_discount_value3">'
            .$discount.
            '%</span>';
    }

    function xtcFormatSpecial($sPrice,$pPrice,$format) {
        if ($format) {
            return '<span class="xtc_price_special1">'.XTPRICE_SPECIAL_DISCOUNT1.'</span> <span class="xtc_price_special_value1">'
                    .$this->xtcFormat($pPrice,$format).
                    '</span><br /><span class="xtc_price_special2">'.XTPRICE_SPECIAL_DISCOUNT2.'</span> <span class="xtc_price_special_value2">'.
                    $this->xtcFormat($sPrice,$format).'</span>';
        }
        return $sPrice;
    }

    function xtcFormatSpecialGraduated($sPrice,$pPrice,$format) {
        if (!$format) {
            return $sPrice;
        }
        if ($sPrice == $pPrice) {
            return 'Ab '.$this->xtcFormat($sPrice,$format);
        }
        if(defined('SHOW_UVP_PRICE') and SHOW_UVP_PRICE == 'Off'){
            return $this->xtcFormat($sPrice,$format);
        }
        return '<span class="xtc_price_special_graduated1">'.XTPRICE_SPECIAL_GRADUATED1.'</span> <span class="xtc_price_special_graduated_value1">'.$this->xtcFormat($pPrice,$format).'</span><br /><span class="xtc_price_special_graduated_2">'.XTPRICE_SPECIAL_GRADUATED2.'</span> <span class="xtc_price_special_graduated_value2">'.$this->xtcFormat($sPrice,$format).'</span>';
        
    }

    function get_decimal_places($code) {
            return $this->currencies[$this->actualCurr]['decimal_places'];
    }
}

