<?php
// index.php

// DIESE TEMPLATES MIT JS
// newsletter.php
// newsletter.html
// password_double_opt.php && password_double_opt_in.html
// tell_a_friend.php und .html

// DIESE TEMPLATES NUR YES_CAPTCHA
// create_account.php & .html
// create_guest_account.php & create_account_guest.html

// form_check.js.php

// contact_us.html braucht {$YES_CAPTCHA} sowie den folgenden JS Code
/*
<script type="text/javascript">
{literal}
$(function(){
   $('form[name="contact_us"]').on('submit',function(){
      var action = $(this).attr('action')+'&json_response=1';
      $.ajax({
	  url: action,
	  data: $(this).serialize(),
	  dataType: 'json',
          type: 'POST',
	  success: function(json){
	      if(json.error != ''){
		  alert(json.error);
	      }else{
                  window.location.href = 'shop_content.php?coID=7&action=success';
              }
	  }
      });
      return false;
   });
});
{/literal}
</script>
*/


class yesTextCaptcha
{
	const MATH_OPERATIONS = array('+','-','*',':');
	const MATH2_OPERATIONS = array('>','<');
	const CAPTCHA_TYPE = array('math2','math','logic1','logic2');
	const LANGUAGE_INI_FILE = './yesCaptcha.ini';
	const CIPHERING = "AES-128-CTR";
	const DECRYPTION_IV = '1234567891011121';
	const DECRYPTION_KEY = "MAriOsCAPT2020cha";
	const IMAGE_FONT = 'admin/fonts/luximr.ttf';
	const CSS_PATH = 'templates/'.CURRENT_TEMPLATE.'/';
	const CAPTCHA_GET_URL = 'index.php';

	var $question, $answers, $lang, $lng, $current_url,$captcha_title, $captcha_question;

	public function __construct( $lang = 'german'){
		$this->lang = $lang;
		$this->current_url = basename($_SERVER['REQUEST_URI']);
		$ini = parse_ini_file(self::LANGUAGE_INI_FILE, TRUE);
		$this->lng = $ini[$this->lang];
		if(!is_file(self::CSS_PATH.'captcha.css') or !is_readable(self::CSS_PATH.'captcha.css')){
			die('YESCAPTCHA: Missing '.self::CSS_PATH.'captcha.css');
		}
		if(!is_file(self::LANGUAGE_INI_FILE)){
			die('YESCAPTCHA: Missing '.self::LANGUAGE_INI_FILE);
		}
		if(!isset($_SESSION['yesCaptcha_trys'])){
			$_SESSION['yesCaptcha_trys'] = 0;
		}
	}

	public function create( $show_header = true ){
		$captcha = self::CAPTCHA_TYPE[ array_rand(self::CAPTCHA_TYPE) ];
		switch($captcha){
			case 'math':
				$this->create_math_captcha();
				break;
			case 'math2':
				$this->create_math2_captcha();
				break;
			case 'logic1':
				$this->create_logic1_captcha();
				break;
			case 'logic2':
				$this->create_logic2_captcha();
				break;
		}
		return $this->draw( $this->captcha_title, $this->captcha_question, $show_header );
	}

	private function create_math_captcha(){
		$operation = self::MATH_OPERATIONS[ array_rand(self::MATH_OPERATIONS) ];
		switch($operation){
			case '+':
				$var1 = rand(0,10);
				$var2 = rand(0,10);
				$result = $var1+$var2;
				break;
			case '-':
				$var1 = rand(1,20);
				$var2 = rand(0,$var1);
				$result = $var1-$var2;
				break;
			case '*':
				$var1 = rand(1,5);
				$var2 = rand(1,5);
				$result = $var1*$var2;
				break;
			case ':':
				$var2 = rand(1,8);
				$_tmp = rand(1,9);
				$var1 = $var2*$_tmp;
				$result = $var1/$var2;
				break;
		}
		$this->save_result($result);
		$which_number_as_word = rand(1,2);
		if($which_number_as_word == 1){
			$var1 = ucfirst($this->get_number_word($var1, $this->lang));
		}else{
			$var2 = ucfirst($this->get_number_word($var2, $this->lang));
		}

		if(is_int($var1)){
			// Use openssl_encrypt() function to encrypt the data 
			$encryption = $this->text_encrypt($var1);
			$img_text = urlencode($encryption);
			$var1 = '<img class="yesCaptchaImgNumber" src="'.self::CAPTCHA_GET_URL.'?draw_captcha_image_text='.$img_text.'" />';
		}else if(is_int($var2)){
			$encryption = $this->text_encrypt($var2);
			$img_text = urlencode($encryption);
			$var2 = '<img class="yesCaptchaImgNumber" src="'.self::CAPTCHA_GET_URL.'?draw_captcha_image_text='.$img_text.'" />';
		}
		switch($operation){
			case '*':
				$operation_html = '&#215;';break;
			case ':':
				$operation_html = '&#247;';break;
			case '+':
				$operation_html = '&plus;';break;
			case '-':
				$operation_html = '&minus;';break;
		}
		$question = sprintf(
			"<div style=\"float: left;\">%s</div><div style=\"float: left;\" class=\"math_operator\"> %s </div><div style=\"float: left;\">%s</div><div style=\"float: left;\">&nbsp;&equals;&nbsp;</div><div style=\"float: left;\"><input type=\"number\" min=\"0\" max=\"100\" id=\"captcha_input\" name=\"captcha_result\" size=\"2\" value=\"\" maxlength=\"3\" /></div>",
			$var1, $operation_html, $var2
		);
		$this->captcha_title = $this->lng['question_math'];
		$this->captcha_question = $question;
	}



	private function create_math2_captcha(){
		$operation = self::MATH2_OPERATIONS[ array_rand(self::MATH2_OPERATIONS) ];
		$var1 = rand(6,20);

		$bigger_values = [];
		for($i=$var1+1;$i<30;$i++){
			$bigger_values[] = $i;
		}
		shuffle($bigger_values);
		$bigger = array_slice($bigger_values,0,5);

		$lesser_values = [];
		for($i=0;$i<($var1-1);$i++){
			$lesser_values[] = $i;
		}
		shuffle($lesser_values);
		$lesser = array_slice($lesser_values,0,5);

		$wrong_num = rand(1,3);
		switch($operation){
			case '>':
				for($i=0;$i<=$wrong_num; $i++){
					$bigger[$i] = $lesser[$i];
				}
				for($ii=$i;$ii<sizeOf($bigger);$ii++){
					$result[] = $bigger[$ii];
				}
				$clear_values_list = $bigger;
				break;
			case '<':
				for($i=0;$i<$wrong_num; $i++){
					$lesser[$i] = $bigger[$i];
				}
				for($ii=$i;$ii<sizeOf($lesser);$ii++){
					$result[] = $lesser[$ii];
				}
				$clear_values_list = $lesser;
				break;
		}
		$this->save_result($result);
		$which_number_as_word = rand(1,2);
		$output_list = [];
		shuffle($clear_values_list);
		foreach($clear_values_list as $cvl){
			$output_list[] = ['value'=>$cvl,'text'=>$cvl];
		}
		if($which_number_as_word == 1){
			$var1 = ucfirst($this->get_number_word($var1, $this->lang));
		}else{
			foreach($output_list as $k=>$ol){
				if($k < 2  and $ol['value'] < 21){
					$output_list[$k]['text'] = ucfirst($this->get_number_word($output_list[$k]['value'], $this->lang));
				}
			}
		}
		$how_much_as_images = rand(1,3);
		$as_images = 0;
		foreach($output_list as $k=>$ol){
			if(is_int($ol['text']) and ($as_images < $how_much_as_images)){
				$encryption = $this->text_encrypt($ol['text']);
				$img_text = urlencode($encryption);
				$output_list[$k]['text'] = '<img class="yesCaptchaImgNumber" src="'.self::CAPTCHA_GET_URL.'?draw_captcha_image_text='.$img_text.'" />';
				$as_images++;
			}
		}
		$questions = [];
		foreach($output_list as $ol){
			$questions[] = sprintf('<td><input type="checkbox" name="captcha_result[]" value="%s" /></td><td>%s</td>',
				urlencode( $this->text_encrypt($ol['value']) ), $ol['text']
			);
		}
		$question = '<table class="yesCaptchaInlineQuestionTable"><tr>';
		foreach($questions as $q){
			$question .= $q;
		}
		$question .= '</table>';
		$sign = ($operation == '>') ? $this->lng['question_math2_greater'] : $this->lng['question_math2_lesser'];
		$this->captcha_title = sprintf($this->lng['question_math2'], $sign, $var1);
		$this->captcha_question = $question;
	}

	private function get_number_word($number){
		return $this->lng['number_'.$number];
	}

	private function create_logic1_captcha(){
		$lists = ['vehicles','colors','numbers','animals'];
		$vehicles = $this->get_word_list('vehicles');
		$colors = $this->get_word_list('colors');
		$animals = $this->get_word_list('animals');
		$numbers = $this->get_word_list('numbers');

		$vehicles = array_slice($vehicles,2);
		$colors = array_slice($colors,2);
		$animals = array_slice($animals,2);
		$numbers = array_slice($numbers,2);

		$correct_list_type = $lists[ array_rand($lists) ];
		$incorrect_list_type = $correct_list_type;
		while($correct_list_type == $incorrect_list_type){
			$incorrect_list_type = $lists[ array_rand($lists) ];
		}
		$incorrect_item = rand(0,3);
		$correct_list = $$correct_list_type;
		$correct_list[ $incorrect_item ] = $$incorrect_list_type[ $incorrect_item ];
		$result = $correct_list[ $incorrect_item ];
		$this->save_result([$result]);

		foreach($correct_list as $k=>$v){
			$questions[] = sprintf('<td><input type="checkbox" name="captcha_result[]" value="%s" /></td><td>%s&nbsp;</td>',
				urlencode( $this->text_encrypt($v) ), $v
			);
		}
		$question = '<table class="yesCaptchaInlineQuestionTable"><tr>';
		foreach($questions as $q){
			$question .= $q;
		}
		$question .= '</table>';

		$title = $this->lng['question_logic1_'.$correct_list_type];
		$this->captcha_title = $title;
		$this->captcha_question = $question;
	}

	private function get_word_list($list){
		switch($list){
			case 'vehicles':
				$parts = ['car','airplane','truck','scooter','bike','moped'];
				break;
			case 'colors':
				$parts = ['red','yellow','white','blue','black','grey'];
				break;
			case 'animals':
				$parts = ['cow','chicken','fish','bird','dog','cat'];
				break;
			case 'numbers':
				for($i=1;$i<7;$i++){
					$return[] = ucfirst($this->get_number_word($i));
				}
				return $return;
				break;
		}
		$return = [];
		foreach($parts as $k=>$v){
			$return[] = $this->lng[$list.'_'.$v];
		}
		shuffle($return);
		return $return;
	}

	private function create_logic2_captcha(){
		$lists = ['vehicles','colors','numbers','animals'];
		$vehicles = $this->get_word_list('vehicles');
		$colors = $this->get_word_list('colors');
		$animals = $this->get_word_list('animals');
		$numbers = $this->get_word_list('numbers');

		$vehicles = array_slice($vehicles,2);
		$colors = array_slice($colors,2);
		$animals = array_slice($animals,2);
		$numbers = array_slice($numbers,2);

		$correct_list_type = $lists[ array_rand($lists) ];
		$incorrect_list_type = $correct_list_type;
		while($correct_list_type == $incorrect_list_type){
			$incorrect_list_type = $lists[ array_rand($lists) ];
		}
			
		$correct_list = $$correct_list_type;
		$number_of_incorrect_items = rand(1,3);
		$result = [];

		$incorrect_items_values = [];
		for($i=0;$i<=3;$i++){
			$incorrect_items_values[] = $i;
		}
		shuffle($incorrect_items_values);
		$_incorrect_items = array_slice($incorrect_items_values,0,$number_of_incorrect_items);
		$incorrect_items = [];
		foreach($_incorrect_items as $ii){
			$incorrect_items[] = $$incorrect_list_type[ $ii ];
		}

		foreach($incorrect_items as $ik=>$incrrct){
			$correct_list[$ik] = $incrrct;
		}
		for($i=($ik+1);$i<sizeOf($correct_list);$i++){
			$result[] = $correct_list[$i];
		}
		$this->save_result($result);

		foreach($correct_list as $k=>$v){
			$questions[] = sprintf('<td><input type="checkbox" name="captcha_result[]" value="%s" /></td><td>%s&nbsp;</td>',
				urlencode( $this->text_encrypt($v) ), $v
			);
		}
		$question = '<table class="yesCaptchaInlineQuestionTable"><tr>';
		foreach($questions as $q){
			$question .= $q;
		}
		$question .= '</table>';

		$this->captcha_title = $this->lng['question_logic2_'.$correct_list_type];
		$this->captcha_question = $question;
	}

	private function get_html_heading(){
		return "<link rel=\"stylesheet\" type=\"text/css\" href=\"".self::CSS_PATH."captcha.css\">
			<script>
			function load_new_question(){
				$('#yesCaptchaContainer').load('".self::CAPTCHA_GET_URL."?action=new_captcha');
			}
			function testsolve( formObj ){
				var zeitsperre_grundwert = 1500*".($_SESSION['yesCaptcha_trys']+1).";
				var zeitsperre = zeitsperre_grundwert;
				var zeitsperre_js_counter = 0;
				var params = '';
				$('#yesCaptchaContainer input').each(function(){
					switch($(this).attr('type')){
						case 'button':
							// der testbutton
							break;
						case 'radio':
							if($(this).prop('checked') === true){
								params += '&'+$(this).attr('name')+'='+encodeURIComponent($(this).val());
							}
							break;
						case 'checkbox':
							if($(this).prop('checked') === true){
								params += '&'+$(this).attr('name')+'='+encodeURIComponent($(this).val());
							}
							break;
						case 'number':
							if($(this).val() != ''){
								params += '&'+$(this).attr('name')+'='+encodeURIComponent($(this).val());
							}
							break;
						default:
							alert($(this).attr('type'));
							break;
					}
				});
				if(params == ''){
					alert('".$this->lng['captcha_no_input']."');
					return false;
				}
				$.ajax({
					url: '".self::CAPTCHA_GET_URL."?action=solve_captcha'+params,
					dataType: 'json',
					success: function(json){
						if(json.INCORRECT){
							$('table.yesCaptcha tbody td.question_container').html('<div id=\"yesCaptchaWait\" align=\"center\"><font color=\"red\" size=\"5\">'+json.MSG+'&nbsp;<img src=\"admin/images/wait.gif\"></font></div>');
							zeitsperre_js_counter++;
							zeitsperre = zeitsperre_grundwert*zeitsperre_js_counter;
							if(zeitsperre > 10000){
								zeitsperre = 10000;
							}
							console.log('zeitsperre: '+zeitsperre);
							setTimeout(load_new_question, zeitsperre);
							return false;
						}else{
							vv_code_pre_check_success = true;
							$(formObj).unbind('submit').submit();
						}
					},
					error: function(){
						alert('Captcha Solve Error');
					}
				});
			}
			</script>";
	}
	private function get_reload_link_html(){
		return sprintf('<a class="yesCaptchaReload_link" href="captcha.php">&#x21bb; %s</a>',
			$this->lng['captcha_reload']
		);
	}
	private function get_html_footer(){
		return sprintf('<!--<div align="right" id="yesCaptcha_footer" >%s</div>//--></div>',
			$this->get_reload_link_html()
		);
	}

	private function draw( $title, $question, $show_header ){
		$string = '';
		if($show_header){
			$string .= $this->get_html_heading();
			$string .= "<div id=\"yesCaptchaContainer\">";
		}
		$string .= sprintf(
			"<table class=\"yesCaptcha\"><thead>
				<tr><th>%s</th></tr></thead><tbody>
				<tr><td class=\"question_container\">%s</td></tr></tbody></table>",
			$title, $question
		);
		if($show_header){
			$string .= $this->get_html_footer();
		}
		return $string;
	}


	public function text_decrypt($encryption){
		// Use OpenSSl Encryption method 
		$iv_length = openssl_cipher_iv_length(self::CIPHERING); 
		$options = 0; 
		  
		// Use openssl_decrypt() function to decrypt the data 
		return openssl_decrypt ($encryption, self::CIPHERING,  
			self::DECRYPTION_KEY, $options, self::DECRYPTION_IV); 
	}

	public function text_encrypt( $string ){
		  
		// Use OpenSSl Encryption method 
		$iv_length = openssl_cipher_iv_length(self::CIPHERING); 
		$options = 0; 
		  
		return openssl_encrypt($string, self::CIPHERING, 
			self::DECRYPTION_KEY, $options, self::DECRYPTION_IV); 
	}

	public function generate_image( $text ){
		header("Content-type: image/png");
		$width = (strlen($text)*12)+10;
		$im = @imagecreate($width, 26)
		      or die("Kann keinen neuen GD-Bild-Stream erzeugen");
		$background_color = imagecolorallocate($im, 255, 255, 255);
		$text_color = imagecolorallocate($im, 0, 0, 0);;
		imagefttext($im, 10, 0, 5, 20, $text_color, self::IMAGE_FONT, $text);
	//	imagestring($im, 2, 5, 5, substr($_GET['draw'],0,15), $text_color);
		imagepng($im);
		imagedestroy($im);
	}
	public function check( $json = true ){
		$reqVar = ($json) ? $_GET : $_POST;
		if(!isset($_SESSION['yesCaptcha_result'])){
			if(isset($_SESSION['yesCaptcha_trys'])){
				$_SESSION['yesCaptcha_trys']++;
			}
			return $this->lng['captcha_incorrect'];
		}
		if(is_array($_SESSION['yesCaptcha_result']) and is_countable($reqVar['captcha_result'])){
			if(sizeOf($_SESSION['yesCaptcha_result']) != sizeOf($reqVar['captcha_result'])){
				$_SESSION['yesCaptcha_trys']++;
				return $this->lng['captcha_incorrect'];
			}
			foreach($reqVar['captcha_result'] as $r){
				if(!in_array($this->text_decrypt(urldecode($r)), $_SESSION['yesCaptcha_result'])){
					$_SESSION['yesCaptcha_trys']++;
					return $this->lng['captcha_incorrect'];
				}
			}
			$_SESSION['yesCaptcha_trys'] = 0;
			return $this->lng['captcha_correct'];
		}
		if(urldecode($reqVar['captcha_result']) != $_SESSION['yesCaptcha_result']){
			$_SESSION['yesCaptcha_trys']++;
			return $this->lng['captcha_incorrect'];
		}
		$_SESSION['yesCaptcha_trys'] = 0;
		return $this->lng['captcha_correct'];
	}

	private function save_result($result){
		$_SESSION['yesCaptcha_result'] = $result;
	}
}

/*
if(!defined('CURRENT_TEMPLATE')){
	define('CURRENT_TEMPLATE','xtc4');
}
if(!isset($_SESSION['yesCaptcha_trys'])){
	$_SESSION['yesCaptcha_trys'] = 0;
}
if(!isset($_SESSION['captcha_lng'])){
	$_SESSION['captcha_lng'] = 'german';
}
if(isset($_GET['lng']) and $_GET['lng'] == 'english'){
	$_SESSION['captcha_lng'] = 'english';
}
if(isset($_GET['lng']) and $_GET['lng'] == 'german'){
	$_SESSION['captcha_lng'] = 'german';
}

$captcha = new yesTextCaptcha($_SESSION['captcha_lng']);
if(isset($_GET['draw'])){
	$text = $captcha->text_decrypt(urldecode($_GET['draw']));
	$captcha->generate_image( $text );
	exit;
}
if(isset($_GET['action']) and $_GET['action'] == 'new'){
	$captcha->create(false);
	exit;
}
if(isset($_GET['action']) and $_GET['action'] == 'solve'){
	$msg = $captcha->check();
	die(json_encode(array(
		'MSG'=>$msg,
		'INCORRECT'=>$msg == $captcha->lng['captcha_incorrect']
	)));
}
$captcha->create();*/
