<?php
/* -----------------------------------------------------------------------------------------
   $Id: ot_gv.php,v 1.4 2020/03/09 06:13:56 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(ot_gv.php,v 1.37.3 2004/01/01); www.oscommerce.com

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contributions:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

class ot_gv {
    var $title, $output,$used_tax_rate,$header,$description,$user_prompt,$enabled,
        $sort_order,$include_shipping,$include_tax,$calculate_tax,$credit_tax,
        $tax_class,$credit_class, $checkbox, $Price, $code;

    function __construct($price) {
        // aus checkout_shipping.php und application_top
        global $dieSession,$dieSessionID;

        $this->code = 'ot_gv';
        $this->title = MODULE_ORDER_TOTAL_GV_TITLE;
        $this->header = MODULE_ORDER_TOTAL_GV_HEADER;
        $this->description = MODULE_ORDER_TOTAL_GV_DESCRIPTION;
        $this->user_prompt = (defined('MODULE_ORDER_TOTAL_GV_USER_PROMPT')) ? MODULE_ORDER_TOTAL_GV_USER_PROMPT:'';
        $this->enabled = (defined('MODULE_ORDER_TOTAL_GV_STATUS'))?MODULE_ORDER_TOTAL_GV_STATUS:false;
        $this->sort_order = (defined('MODULE_ORDER_TOTAL_GV_SORT_ORDER'))?MODULE_ORDER_TOTAL_GV_SORT_ORDER:0;
        if(defined('MODULE_ORDER_TOTAL_GV_STATUS')){
            $this->include_shipping = MODULE_ORDER_TOTAL_GV_INC_SHIPPING;
            $this->include_tax = MODULE_ORDER_TOTAL_GV_INC_TAX;
            $this->calculate_tax = MODULE_ORDER_TOTAL_GV_CALC_TAX;
            $this->credit_tax = MODULE_ORDER_TOTAL_GV_CREDIT_TAX;
            $this->tax_class  = MODULE_ORDER_TOTAL_GV_TAX_CLASS;
            //$this->show_redeem_box = MODULE_ORDER_TOTAL_GV_REDEEM_BOX;
        }
        $this->credit_class = true;
      
        if(defined('USE_EASYCHECKOUT') and USE_EASYCHECKOUT == 'True'){
            $this->checkbox = $this->user_prompt.'<input type="checkbox" onclick="sendAJAX(\''.$dieSession.'\',\''.$dieSessionID.'\')" name="'.'c'.$this->code.'">';
        }else{
            $this->checkbox = $this->user_prompt . '<input type="checkbox" onClick="submitFunction()" name="' . 'c' . $this->code . '">';
        }
        $this->output = array();
        $this->Price=$price;
        $this->used_tax_rate = 0; /// MARIO: WIRD BEI calculate_tax_deduction GESETZT FUER tax_rate_percent
    }

    function process() {
        global $order, $currencies;
//      if ($_SESSION['cot_gv']) {  // old code Strider
        if (isset($_SESSION['cot_gv']) && $_SESSION['cot_gv'] == true) {
            $order_total = $this->get_order_total();
            $od_amount = $this->calculate_credit($order_total);
            if ($this->calculate_tax != "None") {
                $tod_amount = $this->calculate_tax_deduction($order_total, $od_amount, $this->calculate_tax);
                $od_amount = $this->calculate_credit($order_total);
            }

            $this->deduction = $od_amount;

            $order->info['total'] = $order->info['total'] - $od_amount;
            if ($od_amount > 0) {
                $this->output[] = array('title' => $this->title . ':',
                    'text' => '<b><font color="ff0000">-' .$this->Price->xtcFormat($od_amount, true) . '</font></b>',
                    'value' => $this->Price->xtcFormat($od_amount, false),
                    'tax_rate_percent'=>$this->used_tax_rate
                );
            }
        }
    }

    function selection_test() {
        if ($this->user_has_gv_account($_SESSION['customer_id'])) {
          return true;
        }
        return false;
    }

    function pre_confirmation_check($order_total) {
        global $order;
        $od_amount = 0; // set the default amount we will send back
        if (isset($_SESSION['cot_gv']) && $_SESSION['cot_gv'] == true) {
// pre confirmation check doesn't do a true order process. It just attempts to see if
// there is enough to handle the order. But depending on settings it will not be shown
// all of the order so this is why we do this runaround jane. What do we know so far.
// nothing. Since we need to know if we process the full amount we need to call get order total
// if there has been something before us then

            if ($this->include_tax == 'false') {
                $order_total = $order_total - $order->info['tax'];
            }
            if ($this->include_shipping == 'false') {
                $order_total = $order_total - $order->info['shipping_cost'];
            }
            $od_amount = $this->calculate_credit($order_total);
            if ($this->calculate_tax != "None") {
                $tod_amount = $this->calculate_tax_deduction($order_total, $od_amount, $this->calculate_tax);
                $od_amount = $this->calculate_credit($order_total)+$tod_amount;
            }
        }
        return $od_amount;
    }
    // original code
	/*function pre_confirmation_check($order_total) {
      if ($SESSION['cot_gv']) {
        $gv_payment_amount = $this->calculate_credit($order_total);
      }
      return $gv_payment_amount;
    } */

    function use_credit_amount() {
        $output_string = '';
        $_SESSION['cot_gv'] = false;
        if ($this->selection_test()) {
            $output_string .=  '    <td nowrap align="right" class="main">';
            $output_string .= '<b>' . $this->checkbox . '</b>' . '</td>' . "\n";
        }
        return $output_string;
    }

    function update_credit_account($i) {
        global $order, $insert_id, $REMOTE_ADDR;
        $_matches = []; // um eregi sauber auszufuehren
        if (ereg('^GIFT', addslashes($order->products[$i]['model']),$_matches) ) {
            $gv_order_amount = ($order->products[$i]['final_price']);
            if ($this->credit_tax=='true') $gv_order_amount = $gv_order_amount * (100 + $order->products[$i]['tax']) / 100;
//        $gv_order_amount += 0.001;
            $gv_order_amount = $gv_order_amount * 100 / 100;
            if (MODULE_ORDER_TOTAL_GV_QUEUE == 'false') {
                // GV_QUEUE is false so release amount to account immediately
                $gvc = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id((int)$_SESSION['customer_id']);
                $customer_gv = false;
                $total_gv_amount = 0;
                if ($gvc !== null) {
                    $gv_result = $gvc->toArray();
                    $total_gv_amount = (float)$gv_result['amount'];
                    $customer_gv = true;
                }
                $total_gv_amount = $total_gv_amount + $gv_order_amount;
                if ($customer_gv) {
                    $upd = new \YES4Trade\Model\coupon_gv_customer([
                        'amount' => $total_gv_amount,
                        'customer_id' => (int)$_SESSION['customer_id']
                    ]);
                    $upd->update();
                } else {
                    $new = new \YES4Trade\Model\coupon_gv_customer([
                        'customer_id'=>(int)$_SESSION['customer_id'], 
                        'amount'=>$total_gv_amount
                    ]);
                    $new->create();
                }
            } else {
                // GV_QUEUE is true - so queue the gv for release by store owner
                $insert_sql_array = [
                    'customer_id'=>(int)$_SESSION['customer_id'], 
                    'order_id'=>$insert_id, 
                    'amount'=>$gv_order_amount, 
                    'date_created'=>'now()', 
                    'ipaddr'=>$REMOTE_ADDR
                ];
                $gv_insert = yes_db_perform(
                    TABLE_COUPON_GV_QUEUE, 
                    $insert_sql_array
                );
            }
        }
    }

    function credit_selection() {
        $selection_string = '';
        return $selection_string;
    }

    function apply_credit() {
        global $order, $coupon_no;
        if (isset($_SESSION['cot_gv']) && $_SESSION['cot_gv'] == true) {
            $gvc = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id((int)$_SESSION['customer_id']);
            $gv_payment_amount = $this->deduction;
            $gv_amount = 0;
            if($gvc !== null){
                $gv_amount = (float)$gvc->amount - $this->Price->xtcRemoveCurr($gv_payment_amount);
            }
            $upd = new \YES4Trade\Model\coupon_gv_customer([
                'amount' => $gv_amount,
                'customer_id' => (int)$_SESSION['customer_id']
            ]);
            $upd->update();
        }
        return $gv_payment_amount;
    }

    function collect_posts() {
        global $currencies, $coupon_no, $REMOTE_ADDR;
        if (isset($_POST['gv_redeem_code']) and !empty($_POST['gv_redeem_code'])) {
            $coupon = \YES4Trade\Model\coupons::get_by_coupon_code($_POST['gv_redeem_code'],[
                'coupon_id', 'coupon_type', 'coupon_amount'
            ]);
            if ($coupon !== null) {
                //$gv_result = current($gv_query);
                $redeems = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id(intval($coupon->coupon_id),[
                    'coupon_id'
                ]);
                if ( sizeOf($redeems) > 0 and $coupon->coupon_type == 'G' ) {
                    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_NO_INVALID_REDEEM_GV), 'SSL'));
                }
            }
            if ($coupon->coupon_type == 'G') {
                $gv_amount = $coupon->coupon_amount;
                $gvc = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id((int)$_SESSION['customer_id'],[
                    'amount'
                ]);
                $customer_gv = false;
                $total_gv_amount = $gv_amount;
                if ($gvc !== null) {
                    $gv_amount_result = $gvc->toArray();
                    $total_gv_amount = (float)$gv_amount_result['amount'] + $gv_amount;
                    $customer_gv = true;
                }
                $upd = new \YES4Trade\Model\coupons([
                    'coupon_active' => 'N',
                    'coupon_id' => intval($coupon->coupon_id)
                ]);
                $upd->update();

                $new = new \YES4Trade\Model\coupon_redeem_track([
                    'coupon_id'=>intval($gv_result['coupon_id']), 
                    'customer_id'=>(int)$SESSION['customer_id'], 
                    'redeem_date'=>date('Y-m-d H:i:s'), 
                    'redeem_ip'=>$REMOTE_ADDR
                ]);
                $new->create();
                if ($customer_gv) {
                    $upd = new \YES4Trade\Model\coupon_gv_customer([
                        'amount' => (float)$total_gv_amount,
                        'customer_id' => (int)$_SESSION['customer_id']
                    ]);
                    $upd->update();
                } else {
                    $new = new \YES4Trade\Model\coupon_gv_customer([
                           'customer_id'=>(int)$_SESSION['customer_id'], 
                           'amount'=>(float)$total_gv_amount
                    ]);
                    $new->create();
                }
            }
        }
        if (isset($_POST['submit_redeem_x']) and $coupon->coupon_type == 'G') {
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_NO_REDEEM_CODE), 'SSL'));
        }
   }

    function calculate_credit($amount) {
        global $order;
        $cgv = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id((int)$_SESSION['customer_id'], [
            'amount'
        ]);
        $gv_payment_amount = $cgv->amount??0;
        $full_cost = $amount - $gv_payment_amount;
        if ($full_cost <= 0) {
            $full_cost = 0;
            $gv_payment_amount = $amount;
        }
        return $gv_payment_amount;
    }

    function calculate_tax_deduction($amount, $od_amount, $method) {
        global $order;
        $country_id = $order->delivery['country_id'];
        $zone_id = $order->delivery['zone_id'];
      
      
        $tax_class = $order->get_shipping_tax_class();
        switch ($method) {
            case 'Standard':
                $ratio1 = xtc_round($od_amount / $amount,2);
                $tod_amount = 0;
                reset($order->info['tax_groups']);
                foreach($order->info['tax_groups'] as $key => $value) {
                    $tax_rate = xtc_get_tax_rate_from_desc($key,$country_id, $zone_id);
                    $total_net += $tax_rate * $order->info['tax_groups'][$key];
                }
                if ($od_amount > $total_net) {
                    $od_amount = $total_net;
                }
                reset($order->info['tax_groups']);
                foreach($order->info['tax_groups'] as $key => $value) {
                    $tax_rate = xtc_get_tax_rate_from_desc($key,$country_id, $zone_id);
                    $net = $tax_rate * $order->info['tax_groups'][$key];
                    if ($net > 0) {
                        $this->used_tax_rate = $tax_rate;
                        $god_amount = $order->info['tax_groups'][$key] * $ratio1;
                        $tod_amount += $god_amount;
                        $order->info['tax_groups'][$key] = $order->info['tax_groups'][$key] - $god_amount;
                    }
                }
                $order->info['tax'] -= $tod_amount;
                $order->info['total'] -= $tod_amount;
            break;
        case 'Credit Note':
            $tax_rate = xtc_get_tax_rate($tax_class, $country_id, $zone_id);
            $this->used_tax_rate = $tax_rate;
            $tax_desc = xtc_get_tax_description($tax_class, $country_id, $zone_id);
            $tod_amount = $this->deduction / (100 + $tax_rate)* $tax_rate;
            $order->info['tax_groups'][$tax_desc] -= $tod_amount;
            break;
      }
      return $tod_amount;
    }

    function user_has_gv_account($c_id) {
        $gvc = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id(intval($c_id),[
            'amount'
        ]);
        if ($gvc !== null) {
            if ($gvc->amount>0) {
                return true;
            }
        }
        return false;
    }

    function get_order_total() {
      global $order;
      $order_total = $order->info['total'];
      if ($this->include_tax == 'false') $order_total = $order_total - $order->info['tax'];
      if ($this->include_shipping == 'false') $order_total = $order_total - $order->info['shipping_cost'];

      return $order_total;
    }

    function check() {
      if (!isset($this->check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_GV_STATUS'");
        $this->check = xtc_db_num_rows($check_query);
      }

      return $this->check;
    }

    function keys() {
      return array('MODULE_ORDER_TOTAL_GV_STATUS', 'MODULE_ORDER_TOTAL_GV_SORT_ORDER', 'MODULE_ORDER_TOTAL_GV_QUEUE', 'MODULE_ORDER_TOTAL_GV_INC_SHIPPING', 'MODULE_ORDER_TOTAL_GV_INC_TAX', 'MODULE_ORDER_TOTAL_GV_CALC_TAX', 'MODULE_ORDER_TOTAL_GV_TAX_CLASS', 'MODULE_ORDER_TOTAL_GV_CREDIT_TAX');
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('', 'MODULE_ORDER_TOTAL_GV_STATUS', 'true', '6', '1','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('', 'MODULE_ORDER_TOTAL_GV_SORT_ORDER', '80', '6', '2', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('', 'MODULE_ORDER_TOTAL_GV_QUEUE', 'true', '6', '3','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function ,date_added) values ('', 'MODULE_ORDER_TOTAL_GV_INC_SHIPPING', 'true', '6', '5', 'xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function ,date_added) values ('', 'MODULE_ORDER_TOTAL_GV_INC_TAX', 'true', '6', '6','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function ,date_added) values ('', 'MODULE_ORDER_TOTAL_GV_CALC_TAX', 'None', '6', '7','xtc_cfg_select_option(array(\'None\', \'Standard\', \'Credit Note\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('', 'MODULE_ORDER_TOTAL_GV_TAX_CLASS', '0', '6', '0', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_id, configuration_key, configuration_value, configuration_group_id, sort_order, set_function ,date_added) values ('', 'MODULE_ORDER_TOTAL_GV_CREDIT_TAX', 'false', '6', '8','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
}
