<?php
require_once(DIR_FS_INC.'yes_set_products_distributors_stock.inc.php');
class htg{
    const IMPORT_FILE_SEPARATOR = "\t";
    const DISPLAY_LIMIT = 50;
    var $error_messages, $code,$title, $description, $sort_order, $enabled, $_check;
    
    function __construct() {
        $this->error_messages = array();
        $this->code = 'htg';
        $this->title = MODULE_OTHER_HTG_TEXT_TITLE;
        $this->description = MODULE_OTHER_HTG_TEXT_DESCRIPTION;
        if(defined('MODULE_OTHER_HTG_SORT_ORDER')){
            $this->sort_order = MODULE_OTHER_HTG_SORT_ORDER;
            $this->enabled = ((MODULE_OTHER_HTG_STATUS == 'True') ? true : false);
        }
    }

    private static function get_import_file_location(){
        return main::get_importdata_path().'Stock.xml';
    }


    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_OTHER_HTG_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_HTG_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_HTG_SORT_ORDER', '0',  '6', '2', now())");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added,set_function,use_function) values ('MODULE_OTHER_HTG_CATEGORIES_ID', '0',  '6', '8', now(),'xtc_cfg_pull_down_shop_categories(','xtc_get_categories_name')");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added,set_function,use_function) values ('MODULE_OTHER_HTG_DISTRIBUTOR_ID', '0',  '6', '9', now(),'xtc_cfg_pull_down_distributors(','xtc_get_distributor_name')");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added,set_function,use_function) values ('MODULE_OTHER_HTG_VPE_LITER', '0',  '6', '10', now(),'xtc_cfg_pull_down_vpe_values(','xtc_get_vpe_name')");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added,set_function,use_function) values ('MODULE_OTHER_HTG_VPE_ML', '0',  '6', '11', now(),'xtc_cfg_pull_down_vpe_values(','xtc_get_vpe_name')");
   }

    function remove() {
        xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
        return array('MODULE_OTHER_HTG_STATUS', 
            'MODULE_OTHER_HTG_SORT_ORDER',
            'MODULE_OTHER_HTG_CATEGORIES_ID',
            'MODULE_OTHER_HTG_VPE_LITER',
            'MODULE_OTHER_HTG_VPE_ML',
            'MODULE_OTHER_HTG_DISTRIBUTOR_ID'
        );
    }    
    
    public function add_error( string $error ){
        $this->error_messages[] = $error;
    }
    
    public function display_errors(){
        if(!sizeOf($this->error_messages)){
            return false;
        }
        foreach($this->error_messages as $em){
            printf("\t%s\r\n",$em);
        }
    }
    
    public static function getProducts_id_allocation( string $ArticleNumber){
        $query = xtc_db_query(sprintf(
                "SELECT products_id FROM products_distributors WHERE distributor_products_number='%s' AND distributor_id='%d'",
                $ArticleNumber,MODULE_OTHER_HTG_DISTRIBUTOR_ID
        ));
        $record = xtc_db_fetch_array($query);
        return $record['products_id'];
    }
    public function allocation_exists( string $ArticleNumber ){
        $query = xtc_db_query(sprintf(
                "SELECT id FROM products_distributors WHERE distributor_products_number='%s' AND distributor_id='%d'",
                $ArticleNumber,MODULE_OTHER_HTG_DISTRIBUTOR_ID
        ));
        return xtc_db_num_rows($query);
    }

    public function import_item(string $ArticleNumber){
        $Product = $this->getProductFromXMLByArticleNumber($ArticleNumber);
        $vpe_value = 0;
        $vpe = '';
        $products_vpe_id = 0;
        switch($Product->Weight_UnitOfMeasurement){
            case 'liter':
            case 'ml':
                $products_vpe_id = constant('MODULE_OTHER_HTG_VPE_'.strtoupper($Product->Weight_UnitOfMeasurement));
                $vpe_value = (float)str_replace(',','.',$Product->Weight);
                $vpe = $Product->Weight_UnitOfMeasurement;
                break;
        }
        $insert_sql_array = array(
            'products_model'=>"".$Product->ArticleNumber,
            'products_ean'=>"".$Product->Barcode,
            'products_vpe'=>$products_vpe_id,
            'products_vpe_status'=>($products_vpe_id > 0) ? 1 : 0,
            'products_vpe_value'=>$vpe_value,
        );
        xtc_db_perform('products',$insert_sql_array);
        $pID = xtc_db_insert_id();
        //print_r($insert_sql_array);
        $insert_sql_array = array(
            'products_id'=>$pID,
            'language_id'=>2,
            'products_name'=>"".$Product->Description,
            'products_short_description'=>"".$Product->ProductTranslation->ProductExtendedDescription,
        );
        xtc_db_perform('products_description',$insert_sql_array);
        //print_r($insert_sql_array);
        $insert_sql_array = array(
            'products_id'=>$pID,
            'categories_id'=>MODULE_OTHER_HTG_CATEGORIES_ID,
        );
        xtc_db_perform('products_to_categories',$insert_sql_array);
        $insert_sql_array = array(
            'products_id'=>$pID,
            'distributor_id'=>MODULE_OTHER_HTG_DISTRIBUTOR_ID,
            'distributor_products_number'=>"".$Product->ArticleNumber,
            'comments'=>"".$Product->ProductTranslation->ProductShortDescription
        );
        xtc_db_perform('products_distributors',$insert_sql_array);
        $pdID = xtc_db_insert_id();
        $insert_sql_array = array(
            'products_id'=>$pID,
            'distributor_id'=>MODULE_OTHER_HTG_DISTRIBUTOR_ID,
            'price'=>(float)str_replace(',','.',$Product->Price),
            'date_saved'=>'now()',
        );
        xtc_db_perform('distributor_product_prices',$insert_sql_array);
        yes_set_products_distributors_stock(MODULE_OTHER_HTG_DISTRIBUTOR_ID, $pID, "".$Product->AvailableStock);
        return true;
    }
    
    public function update_stock(string $ArticleNumber, int $stock){
        $pID = $this->getProducts_id_allocation($ArticleNumber);
        $Product = $this->getProductFromXMLByArticleNumber($ArticleNumber);
        yes_set_products_distributors_stock(MODULE_OTHER_HTG_DISTRIBUTOR_ID, $pID, "".$Product->AvailableStock);
    }
    public function getProductFromXMLByArticleNumber(string $ArticleNumber){
        $data = $this->read_importfile(0, 'articlenumber', $ArticleNumber);
        return current($data);
    }
    
    public function read_importfile( int $start = 0, string $search_field = '', string $search_string = ''){
        $rows = array();
        if (!file_exists(self::get_import_file_location())) {
            $this->add_error("Import file not found");
            return $rows;
        }
        if (!is_readable(self::get_import_file_location())) {
            $this->add_error("Import file not found");
            return $rows;
        }
        $xml = simplexml_load_file(self::get_import_file_location());
        $row = 0;
        foreach($xml->Product as $P){
            if($row == 0){ // HEADER
                $row++;
                //print_r(explode("\t",$line));
                continue; 
            }
            if( $row >= $start ){
                if($search_field != '' and $search_string != ''){
                    switch($search_field){
                        case 'barcode':
                            if($P->Barcode == $search_string){
                                $rows[] = $P;
                            }
                            break;
                        case 'articlenumber':
                            if($P->ArticleNumber == $search_string){
                                $rows[] = $P;
                            }
                            break;
                        case 'description':
                            if(stristr($P->Description,$search_string)){
                                $rows[] = $P;
                            }
                            break;
                    }
                }else{
                    $rows[] = $P;
                }
            }
            $row++;
        }
        $rows = array_slice($rows, $start, self::DISPLAY_LIMIT);
        return $rows;
    }
    
    public function get_importfile_date(){
        if (!file_exists(self::get_import_file_location())) {
            $this->add_error("Import file not found");
            return false;
        }
        if (!is_readable(self::get_import_file_location())) {
            $this->add_error("Import file not found");
            return false;
        }
        return date('d.m.Y H:i:s',filemtime(self::get_import_file_location()));
    }
    
    public function get_importfile_data_size(string $search_field = '', string $search_string = ''){
        if (!file_exists(self::get_import_file_location())) {
            $this->add_error("Import file not found");
            return false;
        }
        if (!is_readable(self::get_import_file_location())) {
            $this->add_error("Import file not found");
            return false;
        }
        $xml = simplexml_load_file(self::get_import_file_location());
        if($search_field != '' and $search_string != ''){
            $matches = 0;
            foreach($xml->Product as $P){
                switch($search_field){
                    case 'barcode':
                        if($P->Barcode == $search_string){
                            $matches++;
                        }
                        break;
                    case 'articlenumber':
                        if($P->ArticleNumber == $search_string){
                            $matches++;
                        }
                        break;
                    case 'description':
                        if(stristr($P->Description, $search_string)){
                            $matches++;
                        }
                        break;
                }
            }
            return $matches;
        }else{
            return sizeOf($xml->Product);
        }
    }
    
    public function assign_products_allocation( array $Products ){
        foreach($Products as $k=>$P){
            if($this->allocation_exists($P->ArticleNumber)){
                $Products[$k]->products_id = $this->getProducts_id_allocation($P->ArticleNumber);
            }
        }
        return $Products;
    }
}
