<?php
class yes_hitmeister_api {
    var $code, $title, $description, $enabled, $tiefpreis_automatic,
            $customers_status,$shipping_class, $alias, $key, $secret, 
            $carrier_allocation;

    function __construct() {
		$this->code = 'yes_hitmeister_api';
		$this->title = MODULE_OTHER_YES_HITMEISTER_API_TEXT_TITLE;
		$this->description = MODULE_OTHER_YES_HITMEISTER_API_TEXT_DESCRIPTION;
                if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS')){
                    $this->sort_order = MODULE_OTHER_YES_HITMEISTER_API_SORT_ORDER;
                    $this->enabled = ((MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True') ? true : false);
                    $this->customers_status = MODULE_OTHER_YES_HITMEISTER_API_CUSTOMERS_STATUS;
                    $this->shipping_class = MODULE_OTHER_YES_HITMEISTER_API_SHIPPING_CLASS;
                    $this->tiefpreis_automatic = (defined('MODULE_OTHER_YES_HITMEISTER_API_TIEFPREIS_AUTOMATIC')) ? MODULE_OTHER_YES_HITMEISTER_API_TIEFPREIS_AUTOMATIC : 'False';
                    $this->alias = MODULE_OTHER_YES_HITMEISTER_API_ALIAS;
                    $this->key = MODULE_OTHER_YES_HITMEISTER_API_KEY;
                    $this->secret = MODULE_OTHER_YES_HITMEISTER_API_SECRET;
                }
    }


    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_OTHER_YES_HITMEISTER_API_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_YES_HITMEISTER_API_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YES_HITMEISTER_API_SORT_ORDER', '0',  '6', '2', now())");

        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_YES_HITMEISTER_API_SELLER_TIEFPREIS_AUTOMATIC', 'False',  '6', '3', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function,date_added) values ('MODULE_OTHER_YES_HITMEISTER_API_CUSTOMERS_STATUS', '1',  '6', '4', 'xtc_cfg_pull_down_customers_status_list(', 'xtc_get_customers_status_name', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_YES_HITMEISTER_API_SHIPPING_CLASS', 'yes_yes',  '6', '5', 'xtc_cfg_pull_down_shipping_methods_list(',now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YES_HITMEISTER_API_ALIAS', '',  '6', '6',now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YES_HITMEISTER_API_KEY', '',  '6', '7',now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YES_HITMEISTER_API_SECRET', '',  '6', '8',now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YES_HITMEISTER_API_EMAIL_SUBJECT', '',  '6', '9',now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_YES_HITMEISTER_API_USE_YES_PRODUCTS_NAME_IN_ORDERS', 'False',  '6', '10', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_YES_HITMEISTER_API_CARRIER_ALLOCATION', '',  '6', '11', 'xtc_cfg_yes_hitmeister_carrier_allocation(', now())");
        
        
                
                
                try{
                    xtc_db_query("ALTER TABLE `admin_access` ADD `hitmeister` INT( 1 ) NOT NULL");
                }catch(Exception $e){
                    // nix, einfach abfangen
                    //echo $e->getMessage();
                }
		xtc_db_query("CREATE TABLE IF NOT EXISTS `hitmeister_orders` ( `hitmeister_orders_id` INT NOT NULL AUTO_INCREMENT , `hitmeister_id_order` VARCHAR(16) NOT NULL , `orders_id` INT NOT NULL , `invoice_upload` INT(1) NOT NULL, PRIMARY KEY (`hitmeister_orders_id`), INDEX (`hitmeister_id_order`), INDEX (`orders_id`)) ENGINE = InnoDB COMMENT = 'Zuweisung hitmeister Auftraege'");
		xtc_db_query("UPDATE `admin_access` SET `hitmeister` = '1' WHERE `admin_access`.`customers_id` = '1'");
		xtc_db_query("CREATE TABLE IF NOT EXISTS `hitmeister_products` ( `hitmeister_products_id` INT NOT NULL AUTO_INCREMENT , `hitmeister_id_item` VARCHAR(16) NOT NULL , `products_id` INT NOT NULL , `quantity` INT NOT NULL, PRIMARY KEY (`hitmeister_products_id`), INDEX (`hitmeister_id_item`), INDEX (`products_id`)) ENGINE = InnoDB COMMENT = 'Zuweisung hitmeister Artikel'");
                try{
                    xtc_db_query("ALTER TABLE `hitmeister_products` ADD `id_unit` VARCHAR(16) NOT NULL AFTER `products_id`");
                }catch(Exception $e){
                    // nix, einfach abfangen
                    //$e->getMessage();
                }
                xtc_db_query("CREATE TABLE IF NOT EXISTS `hitmeister_tickets` ( `hitmeister_tickets_id` INT NOT NULL AUTO_INCREMENT , `id_ticket` VARCHAR(16) NOT NULL , `id_buyer` VARCHAR(16) NOT NULL , `date_added` DATETIME NOT NULL , PRIMARY KEY (`hitmeister_tickets_id`), INDEX (`id_ticket`)) ENGINE = InnoDB");
                
                $insert_sql = <<<HITMEISTERINSERTSQL
                    DROP TABLE IF EXISTS `hitmeister_orders_units`;
                    CREATE TABLE `hitmeister_orders_units` (
                      `hitmeister_orders_units_id` int NOT NULL,
                      `hitmeister_orders_id` int NOT NULL,
                      `id_order_unit` varchar(16) NOT NULL,
                      `price` decimal(15,4) NOT NULL,
                      `id_offer` varchar(16) NOT NULL,
                      `id_item` varchar(16) NOT NULL,
                      `delivery_time` varchar(1) NOT NULL,
                      `delivery_time_expires` datetime NOT NULL,
                      `fulfillment_sent` int NOT NULL DEFAULT '0'
                    ) ENGINE=InnoDB;
                    ALTER TABLE `hitmeister_orders_units`
                      ADD PRIMARY KEY (`hitmeister_orders_units_id`),
                      ADD KEY `hitmeister_orders_id` (`hitmeister_orders_id`);
                    ALTER TABLE `hitmeister_orders_units`
                      MODIFY `hitmeister_orders_units_id` int NOT NULL AUTO_INCREMENT;
HITMEISTERINSERTSQL;
                xtc_db_query($insert_sql);
   }

    function remove() {
        xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
        return array('MODULE_OTHER_YES_HITMEISTER_API_STATUS', 'MODULE_OTHER_YES_HITMEISTER_API_SORT_ORDER',
            'MODULE_OTHER_YES_HITMEISTER_API_SELLER_TIEFPREIS_AUTOMATIC', /* false */
            'MODULE_OTHER_YES_HITMEISTER_API_CUSTOMERS_STATUS', /* 1 */
            'MODULE_OTHER_YES_HITMEISTER_API_SHIPPING_CLASS', /*yes_yes*/
            'MODULE_OTHER_YES_HITMEISTER_API_ALIAS',
            'MODULE_OTHER_YES_HITMEISTER_API_KEY',
            'MODULE_OTHER_YES_HITMEISTER_API_SECRET',
            'MODULE_OTHER_YES_HITMEISTER_API_EMAIL_SUBJECT',
            'MODULE_OTHER_YES_HITMEISTER_API_USE_YES_PRODUCTS_NAME_IN_ORDERS',
            'MODULE_OTHER_YES_HITMEISTER_API_CARRIER_ALLOCATION'
        );
    }
    
    function configuration_save_handler(){
	/**
	 * Zusammensetzen und Speichern der Konfigurationsvariable
         * MODULE_OTHER_YES_HITMEISTER_API_CARRIER_ALLOCATION
	 */
        $cfg = array();
	foreach($_POST['YES_HITMEISTER_CARRIER'] as $versender=>$hitmeister_carrier){
            $cfg[] = sprintf('%s:%s',$versender,$hitmeister_carrier);
        }
        
	xtc_db_query("update " . TABLE_CONFIGURATION . " set configuration_value = '" . implode(',',$cfg) . "' where configuration_key = 'MODULE_OTHER_YES_HITMEISTER_API_CARRIER_ALLOCATION'");
    }
    
}