<?php
/* include api class, include path in "admin" mode differs from "shop" mode */
if (file_exists(DIR_WS_CLASSES . 'secupay_api.php')) {
    require_once(DIR_WS_CLASSES . 'secupay_api.php');
    if(is_file("secupay_conf.php")){
        require_once("secupay_conf.php");
    }
} else {
    require_once("../" . DIR_WS_CLASSES . 'secupay_api.php');
    if(is_file(DIR_FS_CATALOG."secupay_conf.php")){
        require_once(DIR_FS_CATALOG."secupay_conf.php");
    }
}
/**
 * class that provides access to Secupay Debit payments
 */
class secupay_inv_xtc {

    var $code, //name of the module
            $title, //title name in list
            $description,
            $enabled,
            $iframe,
            $history_id,
            $demo,
            $sp_log,
            $conf;

    /**
     * Constructor
     */
    function __construct() {
        global $order;
        $this->code = 'secupay_inv_xtc';
        $this->title = (!strstr($_SERVER['SCRIPT_URL'],'/admin/') and function_exists('xtc_catalog_href_link')) ? MODULE_PAYMENT_SPINV_TEXT_TITLE . "<br/><img style='border:0;text-decoration:none;' alt='secupay logo' src='images/secupay_label_24.png'/>" : MODULE_PAYMENT_SPINV_TEXT_TITLE;
        $this->sort_order = (defined('MODULE_PAYMENT_SPINV_SORT_ORDER')) ? MODULE_PAYMENT_SPINV_SORT_ORDER : 0;
        $this->enabled = (defined('MODULE_PAYMENT_SPINV_STATUS')) ? strcmp(MODULE_PAYMENT_SPINV_STATUS, 'Ja') == 0 ? true : false : false;
        $this->sp_log = (defined('MODULE_PAYMENT_SPINV_LOGGING')) ? strcmp(MODULE_PAYMENT_SPINV_LOGGING, 'Ja') == 0 ? true : false : false;

        //Demo Modus
        if (defined('MODULE_PAYMENT_SPINV_SIMULATION_MODE') and strcmp(MODULE_PAYMENT_SPINV_SIMULATION_MODE, "Simulation") == 0) {
            $this->demo = true;
        } else {
            $this->demo = false;
        }

        if (defined('MODULE_PAYMENT_SPINV_ORDER_STATUS_ID') and (int) MODULE_PAYMENT_SPINV_ORDER_STATUS_ID > 0) {
            $this->order_status_success = MODULE_PAYMENT_SPINV_ORDER_STATUS_ID;
        }
        if(function_exists('get_sp_conf')){
            $this->conf = get_sp_conf();
        }else{
            $this->enabled = false;
        }
        
        $this->description = MODULE_PAYMENT_SPINV_TEXT_DESCRIPTION . "<br/>Version " . $this->conf->general->modulversion .
                " - <a style='color:green;' href='".SECUPAY_FRONTEND_URL."/' target='_blank'>secupay Login</a>" .
                " - <a style='color:green;' href='http://www.secupay.ag/' target='_blank'>secupay Website</a>";
        $api_key = (defined('MODULE_PAYMENT_SECUPAY_APIKEY')) ? MODULE_PAYMENT_SECUPAY_APIKEY : '';
        if(defined('SECUPAY_INFO_IFRAME_URL')){
            $this->description.='<iframe frameborder="0" scrolling="auto" src="'.SECUPAY_INFO_IFRAME_URL.'?vertrag_id_inv=' . $api_key . '&amp;shop=' . $this->conf->general->shop . '&amp;shopversion=' . urlencode(PROJECT_VERSION) . '&amp;modulversion=' . urlencode($this->conf->general->modulversion) . '" marginwidth="0px" marginheight="0px" name="secupay_info" style="border:0px; display:block;width:98%;margin-top:3px;margin-bottom:3px;"></iframe>';
        }else{
            $this->description .= '<p class="errorText">SECUPAY_INFO_IFRAME_URL is not defined</p>';
        }

        secupay_log($this->sp_log, "secupay_inv_xtc constructor php " . PHP_VERSION);
        if($this->enabled){
            secupay_log($this->sp_log, "Conf: " . json_encode($this->conf));
        }
        $logs = ['MODULE_PAYMENT_SPINV_SIMULATION_MODE',
            'MODULE_PAYMENT_SPINV_SORT_ORDER',
            'MODULE_PAYMENT_SPINV_STATUS',
            'MODULE_PAYMENT_SPINV_SHOPNAME',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_ID',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_ACCEPTED_ID',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_DENIED_ID',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_ISSUE_ID',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_VOID_ID',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_AUTHORIZED_ID'
        ];
        foreach($logs as $log){
            $lval = (defined($log)) ? constant($log) : '';
            secupay_log($this->sp_log, str_replace('MODULE_PAYMENT_SPINV_','',$log) .':'. $lval);
        }
        
        if (is_object($order)) {
            $this->update_status();
        }
    }

    /**
     * Function that checks if payment_module is available for this zone
     * Function is called when displaying the available payments
     */
    function update_status() {
        global $order;
        secupay_log($this->sp_log, "update_status");

        if (($this->enabled == true) && ((int) MODULE_PAYMENT_SPINV_ZONE > 0)) {
        	// BOF - DIRTY WORKAROUND 2022-04
        	// EINZELNE GEO ZONES KOENNEN WIR NICHT MEHR ABFRAGEN
        	return true;
        	// EOF - DIRTY WORKAROUND 2022-04
        	
            $check_flag = false;
            try {
		// im admin ist die Variable anders
		$billing_country_id = (!strstr($_SERVER['SCRIPT_URL'],'/admin/') and function_exists('xtc_catalog_href_link')) ? $order->billing['country']['id'] : $order->billing['country_id'];
                $check_query = xtc_db_query("SELECT zone_id FROM " . TABLE_ZONES_TO_GEO_ZONES . " WHERE geo_zone_id = '" . MODULE_PAYMENT_SPINV_ZONE . "' AND zone_country_id = '" . $billing_country_id . "' ORDER BY zone_id");
                while ($check = xtc_db_fetch_array($check_query)) {
                    if ($check['zone_id'] < 1) {
                        $check_flag = true;
                        break;
                    } elseif ($check['zone_id'] == $order->billing['zone_id']) {
                        $check_flag = true;
                        break;
                    }
                }
            } catch(Exception $e) {
                secupay_log($this->sp_log, 'update_status EXCEPTION: ' . $e->getMessage());
            }

            if ($check_flag == false) {
                $this->enabled = false;
            }
        }
        
        if (($this->enabled == true) && $this->conf->secupay_inv_xtc->delivery_differs_disable && MODULE_PAYMENT_SPINV_DELIVERY_DISABLE == "Ja") {
            $check_delivery_differs = $this->_check_delivery_differs($order);
            if ($check_delivery_differs) {
                $this->enabled = false;
            }
        }        
    }

    /**
     * Function that returns javascript code that will validate the data required from user for the payment
     *
     * @return string
     */
    function javascript_validation() {
        return '';
    }

    /**
     * Function that returns what should be displayed on Available payment types page
     *
     * @return array
     */
    function selection() {
        global $order;
        unset($_SESSION['iframe_link']);
        //Kompatibilität mit gambio
        if(!isset($_SESSION['sp_tag'])) {
            unset($_SESSION['sp_success']);
        }
        $vert = MODULE_PAYMENT_SECUPAY_APIKEY;

        // check if payment type is available for vertag_id
        $requestData = array();
        $requestData['data'] = array('apikey' => $vert);
        $sp_api = new secupay_api($requestData, 'gettypes', 'application/json', $this->sp_log);
        $response = $sp_api->request();
        //secupay_log($this->sp_log,"available payment methods:". print_r($response, true));
        if (!isset($response) || $response->status != 'ok' || !in_array($this->conf->secupay_inv_xtc->payment_type, $response->data)) {
            // debit payment type is not available
		$err_str = sprintf("Secupay selection: Status %s\r\n",$response->status);;
		foreach($response->errors as $rerr){
			$err_str .= sprintf("\tCode: %s, message: %s\r\n",$rerr->code, $rerr->message);
		}
		mail('b.agri@yes4trade.de','Secupay Error@'.STORE_NAME,"Installiertes Secupay Modul ".basename(__FILE__)." konnte nicht initialisiert werden.\r\n\r\n".$err_str);
            $this->enabled = false;
            return '';
        }

        $logo = "<img alt=\"secupay Kauf auf Rechnung\" style=\"border:0;\" src=\"images/secupay-Rechnungskauf.png\" />";
        $title = $this->title;

	$fields = array(array('field' => $logo));
        if ($this->conf->secupay_inv_xtc->delivery_differs_disable && $this->_check_delivery_differs($order)) {
	    if(MODULE_PAYMENT_SPINV_DELIVERY_DISABLE == "Hinweis"){
	            $additional_messages = array('title' => MODULE_PAYMENT_SPINV_HINT, 'field' => MODULE_PAYMENT_SPINV_DELIVERY_HINT);
	            $fields[] = $additional_messages;
	    }elseif(MODULE_PAYMENT_SPINV_DELIVERY_DISABLE == "Ja"){
		    // debit payment type is not available
		    $this->enabled = false;
		    return '';
	    }
	}
	$selection = array('id' => $this->code, 'module' => $title,
	    'fields' => $fields
	);

	$selection['description'] = MODULE_PAYMENT_SECUPAY_SPINV_TEXT_INFO;
	// MARIO (YES): process button starten um secupay_ls_total zu setzen
	$this->process_button();
        return $selection;
    }

    /**
     * Function that checks if configuration key is available in database
     */
    function check() {
        if(!function_exists('get_sp_conf')){
            return false;
        }
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_PAYMENT_SPINV_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function pre_confirmation_check() {
        //secupay_log($this->sp_log,"pre_confirmation_check");
    }

    function confirmation() {
        global $order;

        $confirmation = array('title' => $this->title,
            'fields' => array()
        );

        if ($this->conf->secupay_inv_xtc->delivery_differs_disable && MODULE_PAYMENT_SPINV_DELIVERY_DISABLE == "Hinweis" && $this->_check_delivery_differs($order)) {
            $additional_messages = array('title' => MODULE_PAYMENT_SPINV_HINT, 'field' => MODULE_PAYMENT_SPINV_DELIVERY_HINT);
            $confirmation['fields'][] = $additional_messages;
        }
        
        return $confirmation;
    }

    function process_button() {
        global $order;
        if($order === null){
            return false;
        }
        if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
            $total = $order->info['total'] + $order->info['tax'];
        } else {
            $total = $order->info['total'];
        }

        secupay_log($this->sp_log, "process_button", $_POST, "summe_aus_button: " . number_format($order->info['total'], 2, '.', ''));
        $_SESSION['secupay_ls_total'] = number_format($total, 2, '.', '');

        return false;
    }
    
    function get_db_values(){
	global $order;
	$query = xtc_db_query(sprintf(
		"SELECT * FROM secupay_transaction_order WHERE ordernr='%d'",
		$order->info['id']
	));
	return xtc_db_fetch_array($query);
    }

    function get_status($hash){
        secupay_log($this->sp_log, 'Starte get_status()');
        $data = Array();
        $data['apikey'] = MODULE_PAYMENT_SECUPAY_APIKEY;
	$data['hash'] = $hash;
        if ($this->demo) {
            $data['demo'] = 1;
        }
        if($_SESSION['language'] == "english") {
            $data['language'] = 'en_US';
        } else {
            $data['language'] = 'de_DE';
        }
        $requestData = array('data'=>$data);
        $sp_api = new secupay_api($requestData, 'status', 'application/json', $this->sp_log, $data['language']);
        $api_return = $sp_api->request();
        $error = '';
        if ($api_return->status != "ok") { //Fehler
            	$error = 'Secupay Result Fehler '.$api_return->errors[0]->message;
        }else{
		return $api_return;
	}
        secupay_log($this->sp_log, 'Beende get_status');
	return $error;
    }

    function set_inv_first_capture($hash,$orders_id,$shipper,$tracking_number=''){
        global $order;

        secupay_log($this->sp_log, 'Starte set_inv_first_capture fuer '.$hash);
        $data = Array();
        $data['apikey'] = MODULE_PAYMENT_SECUPAY_APIKEY;
	$data['hash'] = $hash;
        $data['tracking'] = array(
            'provider'=>$shipper
        );
        if($tracking_number != ''){
            $data['tracking']['number'] = $tracking_number;
        }
        $data['invoice_number'] = $orders_id;

        if($_SESSION['language'] == "english") {
            $data['language'] = 'en_US';
        } else {
            $data['language'] = 'de_DE';
        }
        if ($this->demo) {
            $data['demo'] = 1;
        }
        $uid = md5(uniqid(mt_rand()));
        $_SESSION['uid'] = $uid;
        $requestData = array('data' => $data);
        $sp_api = new secupay_api($requestData, 'capture', 'application/json', $this->sp_log, $data['language']);
        $api_return = $sp_api->request();
        $error = '';
        if ($api_return->status != "ok") { //Fehler
            $error = $api_return->errors[0]->message;
        } else {
            //yes_debug($api_return->iframe_url);
            $error = 'Secupay Result Fehler '.$api_return->errors[0]->message;
            //yes_debug($api_return);
        }
        secupay_log($this->sp_log, 'Beende set_inv_first_capture');
	return $error;
        exit;
        unset($_SESSION['sp_success']);
    }
    
    function set_shipped($hash,$orders_id,$shipper,$tracking_number=''){
        global $order;

        secupay_log($this->sp_log, 'Starte set_shipped fuer '.$hash);
        $data = Array();
        $data['apikey'] = MODULE_PAYMENT_SECUPAY_APIKEY;
	$data['hash'] = $hash;
        $data['tracking'] = array(
            'provider'=>$shipper
        );
        if($tracking_number != ''){
            $data['tracking']['number'] = $tracking_number;
        }
        $data['invoice_number'] = $orders_id;

        if($_SESSION['language'] == "english") {
            $data['language'] = 'en_US';
        } else {
            $data['language'] = 'de_DE';
        }
        if ($this->demo) {
            $data['demo'] = 1;
        }
        $uid = md5(uniqid(mt_rand()));
        $_SESSION['uid'] = $uid;
        $requestData = array('data' => $data);
        $sp_api = new secupay_api($requestData, 'adddata', 'application/json', $this->sp_log, $data['language']);
        $api_return = $sp_api->request();
        $error = '';
        if ($api_return->status != "ok") { //Fehler
            $error = $api_return->errors[0]->message;
        } else {
            //yes_debug($api_return->iframe_url);
            $error = 'Secupay Result Fehler '.$api_return->errors[0]->message;
            //yes_debug($api_return);
        }
        secupay_log($this->sp_log, 'Beende set_inv_first_capture');
	return $error;
        exit;
        unset($_SESSION['sp_success']);
    }
    
    /**
     * Function that handles successfull payment, or does the request on Secupay API
     */
    function before_process() {
        global $order;
        if (!isset($_SESSION['sp_success'])) {
            secupay_log($this->sp_log, "payment_action sp_success ist leer in session");

            //Daten vorbereiten

            $_mwst_bug = 0;
            if (MODULE_PAYMENT_SPINV_MWST == "Ja") {
                // MWST WAR STATISCH MIT 19 ANGEGEBEN - 2020/06/08
                $tax_class_id = $order->get_shipping_tax_class();
                $tax_rate = xtc_get_tax_rate($tax_class_id, $order->delivery['country']['id'], $order->delivery['zone_id']);
                $_mwst_bug = number_format($order->info['shipping_cost'] * ((100+$tax_rate) / 100), 2, '.', '');
            }

            secupay_log($this->sp_log, "mwst_bug $_mwst_bug");

            $amount = $_SESSION['secupay_ls_total'] + $_mwst_bug;

            secupay_log($this->sp_log, "amount $amount");
            $data = Array();

            try {
                $cust = \YES4Trade\Model\customers::get_by_customers_id($_SESSION['customer_id'],[
                    'customers_dob'
                ]);
                if ($cust !== null) {
                    $data['dob'] = $cust->customers_dob;
                }
            } catch(Exception $e) {
                secupay_log($this->sp_log, 'dob EXCEPTION: ' . $e->getMessage());
            }

            $store_name = MODULE_PAYMENT_SPINV_SHOPNAME;

            if (empty($store_name)) {
                try {
                    if(!defined('STORE_NAME')){
                        $res_store_name = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key='STORE_NAME'");
                        $row_store_name = xtc_db_fetch_array($res_store_name);
                        $store_name = $row_store_name['configuration_value'];
                    }else{
                        $store_name = STORE_NAME;
                    }
                } catch(Exception $e) {
                    secupay_log($this->sp_log, 'storename EXCEPTION: ' . $e->getMessage());
                }                
            }
            
            $data['apikey'] = MODULE_PAYMENT_SECUPAY_APIKEY;
            $data['shop'] = "yes4trade";
            $data['shopversion'] = 'YES4Trade_Standard';
            $data['modulversion'] = $this->conf->general->modulversion;
            $data['amount'] = $amount * 100;
            $data['currency'] = $order->info['currency'];

            $data['apiversion'] = API_VERSION;

            if($_SESSION['language'] == "english") {
                $data['language'] = 'en_US';
            } else {
                $data['language'] = 'de_DE';
            }
            
            $data['purpose'] = "Bestellung vom " . date("d.m.y", time()) . "|bei " . $store_name . "|Bei Fragen TEL 035955755055";
            if ($this->demo) {
                $data['demo'] = 1;
            }
            
            switch ($order->customer['gender']) {
                case 'm':
                    $data['title'] = 'Herr';
                    break;
                case 'f':
                    $data['title'] = 'Frau';
                    break;
            }            
            $data['firstname'] = $order->billing['firstname'];
            $data['lastname'] = $order->billing['lastname'];
            $data['street'] = $order->billing['street_address'];
            $data['zip'] = $order->billing['postcode'];
            $data['city'] = $order->billing['city'];
            $data['country'] = $order->billing['country']['iso_code_2'];
            $data['email'] = $order->customer['email_address'];
            $data['company'] = $order->billing['company'];
            $data['telephone'] = $order->customer['telephone'];
            $data['ip'] = $_SERVER['REMOTE_ADDR'];

            $uid = md5(uniqid(mt_rand()));
            $_SESSION['uid'] = $uid;
            $data['url_success'] = str_replace('&amp;', '&', xtc_href_link('secupay_checkout_success.php', 'payment_error=secupay_inv_xtc&uid=' . $uid, 'SSL', true, false));
            $data['url_failure'] = xtc_href_link('secupay_checkout_failure.php', 'payment_error=secupay_inv_xtc', 'SSL', true, false);

            $basketcontents = $order->products;

            foreach ($basketcontents as $item) {
                $product = new stdClass();
                $product->article_number = $item['id'];
                $product->name = $item['name'];
                $product->model = $item['model'];
                $product->ean = $this->_get_product_ean($item['id']);
                $product->quantity = $item['qty'];
                $product->price = $item['price'] * 100;
                $product->total = $item['final_price'] * 100;
                $product->tax = $item['tax'];
                $products[] = $product;
            }

            $data['basket'] = json_encode($products);

            $delivery_address = new stdClass();
            $delivery_address->firstname = $order->delivery['firstname'];
            $delivery_address->lastname = $order->delivery['lastname'];
            $delivery_address->street = $order->delivery['street_address'];     
            $delivery_address->zip = $order->delivery['postcode'];
            $delivery_address->city = $order->delivery['city'];
            $delivery_address->country = $order->delivery['country']['iso_code_2'];
            $delivery_address->company = $order->delivery['company'];
            $data['delivery_address'] = $delivery_address;

            $data["payment_type"] = $this->conf->secupay_inv_xtc->payment_type;
            $data["payment_action"] = $this->conf->secupay_inv_xtc->payment_action;
            if(main::isDev()){
                $data["url_push"] = xtc_href_link('secupay_status_push.php', 'payment_type=' . $this->conf->secupay_inv_xtc->payment_type);
            }else{
                $data["url_push"] = xtc_href_link('secupay_status_push.php', 'payment_type=' . $this->conf->secupay_inv_xtc->payment_type, 'SSL', true, false);
            }
            $requestData = array();
            $requestData['data'] = $data;
            $sp_api = new secupay_api($requestData, 'init', 'application/json', $this->sp_log, $data['language']);
            $api_return = $sp_api->request();
            $log_amount = $amount * 100;
            $this->history_id = $this->_prepare_trans_log(json_encode($requestData), json_encode($api_return), addslashes($api_return->data->hash), addslashes($api_return->data->transaction_id), '', addslashes($api_return->status), $log_amount);

            unset($_SESSION['secupay_ls_total']);

            if ($api_return->status != "ok") { //Fehler
                $error = $api_return->errors[0]->message;
                $payment_error_return = 'payment_error=' . $this->code . '&error=' . urlencode($error);
                xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, $payment_error_return, 'SSL', true, false));
            } else {
                $this->iframe = $api_return->iframe_url;
                $_SESSION['sp_transaction_id'] = $api_return->data->transaction_id;
                $_SESSION['sp_hash'] = $api_return->data->hash;
                $_SESSION['iframe_link'] = stripslashes($api_return->data->iframe_url);
                $_SESSION['sp_amount'] = $amount * 100;
                
                if(isset($api_return->data->hash)) {
                    $this->_insert_hash(addslashes($api_return->data->hash));
                    if(isset($api_return->data->iframe_url)) {
                        $this->_insert_iframe_url($api_return->data->iframe_url, $api_return->data->hash);
                    }
                }
                
                //Kompatibilität mit gambio
                $_SESSION['sp_tag'] = 1;
                xtc_redirect(xtc_href_link("secupay_checkout_iframe.php", "", 'SSL', true, false));
            }
        }
        if (isset($_SESSION['sp_success']) && $_SESSION['sp_success'] == false) {
            // if request failed, then checkout again
            unset($_SESSION['sp_success']);
            secupay_log($this->sp_log, 'payment_action, transaction failure: ', json_encode($_REQUEST));
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, "", 'SSL', true, false));
        }
        secupay_log($this->sp_log, 'payment_action session sp_success true');
        unset($_SESSION['sp_success']);
    }

    /**
     * function that writes to log and db
     */
    function after_process() {
        global $insert_id;
        $is_demo = $this->demo;
        $is_delivery_differs = isset($_SESSION['sp_ls_delivery_differs']) && $_SESSION['sp_ls_delivery_differs'];
        secupay_log($this->sp_log, "after_process insert_id $insert_id");
        if (isset($_SESSION['sp_hash'])) {

            try {
                //prepare for Status push
                $update_sql_array = [
                    'ordernr' => $insert_id
                ];
                yes_db_perform('secupay_transaction_order',$update_sql_array,'update',[
                    'hash' => $_SESSION['sp_hash']
                ]);
                //write to log
                $update_sql_array = [
                    'ordernr' => $insert_id
                ];
                yes_db_perform('secupay_history_inv',$update_sql_array, 'update', [
                    'hash' => $_SESSION['sp_hash']
                ]);
            } catch(Exception $e) {
                    secupay_log($this->sp_log, 'secupay_transaction_order EXCEPTION: ' . $e->getMessage());
            }            
        }
        $comment = "";

        //Hinweis bei abweichender Lieferadresse
        if ($is_delivery_differs) {
            $comment = "Achtung: abweichende Lieferadresse!";
        }
        if ($is_demo) {
            $comment .= MODULE_PAYMENT_SPINV_DEMO_HINT;
        }
        if (!is_numeric($this->order_status_success)) {
            $this->order_status_success = 0;
        }

        try {
            if ($is_demo || $is_delivery_differs) {
                $insert_sql_array = [
                    'orders_id'=>(int)$insert_id, 
                    'orders_status_id'=>(int)$this->order_status_success, 
                    'date_added'=>'now()', 
                    'comments'=>$comment
                ];
                yes_db_perform(TABLE_ORDERS_STATUS_HISTORY,$insert_sql_array);
                secupay_log($this->sp_log, $sql);
            }
            if ($this->order_status_success) {
                $update_sql_array = [
                    'orders_status'=>$this->order_status_success
                ];
                yes_db_perform(TABLE_ORDERS,$update_sql_array,'update',[
                    'orders_id'=>(int)$insert_id
                ]);
            }
            $customer_comment .= $this->_get_invoice_info($insert_id);
            $insert_sql_array = array(
                'orders_id'=>(int)$insert_id,
                'paymentinstructions'=>$customer_comment,
                'date_saved'=>'now()'
            );
            yes_db_perform('orders_paymentinstructions',$insert_sql_array);
            
            //add payment info to order comment
            if (MODULE_PAYMENT_SPINV_PAYMENTINFO_TO_COMMENT == "Ja") {
                $sql_select_comment = "SELECT comments FROM " . TABLE_ORDERS . " WHERE orders_id =:orders_id";
                secupay_log($this->sp_log, $sql_select_comment);
                $qry = yes_query($sql_select_comment,[
                    'orders_id'=>(int)$insert_id
                ]);

                if(sizeOf($qry) == 1) {
                    $result = current($qry);
                    if(isset($result['comments'])) {
                        $customer_comment = $result['comments'];
                        secupay_log($this->sp_log, 'customer comment: ' . $customer_comment);
                        if(strlen($customer_comment) > 0) {
                            $customer_comment .= "\n\n";
                        }
                        secupay_log($this->sp_log, 'customer comment with payment info: ' . $customer_comment);
                        
                        $update_sql_array = [
                            'comments'=>$customer_comment
                        ];
                        yes_db_perform(TABLE_ORDERS,$update_sql_array,'update',[
                            'orders_id'=>(int)$insert_id
                        ]);
                    }
                } 
            }            
            
        } catch(Exception $e) {
            secupay_log($this->sp_log, 'after_process EXCEPTION: ' . $e->getMessage());
        }        
        
        //Kompatibilität mit gambio
        unset($_SESSION['sp_tag']);
    }

    /**
     * Function that returns URL of error
     */
    function get_error() {
        $fehler = $_GET['error'];
        secupay_log($this->sp_log, "get_error ($fehler)");
        $error = array('title' => MODULE_PAYMENT_SPINV_TEXT_ERROR, 'error' => stripslashes(urldecode($fehler)));
        return $error;
    }

    /**
     * Function that installs Secupay Invoice payment module
     */
    function install() {
        secupay_log($this->sp_log, "install");
        $pref = "INSERT INTO " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order,";

        if($this->conf->general->apikey && is_string($this->conf->general->apikey)){
            $vertrag_id_inv = trim($this->conf->general->apikey);
        }

        $modus = $this->conf->secupay_inv_xtc->modus == "live" ? "Produktivsystem" : "Simulation";
        $debug = $this->conf->secupay_inv_xtc->debug ? 'Ja' : 'Nein';
        $lw = $this->conf->secupay_inv_xtc->lieferanschrift_warnung ? 'Ja' : 'Nein';
        $modul = $this->conf->general->modul;

        xtc_db_query("$pref set_function, date_added) values ( 'MODULE_PAYMENT_SPINV_STATUS', 'Ja', '6', '0', 'xtc_cfg_select_option(array(\'Ja\', \'Nein\'), ', now())");
        xtc_db_query("$pref date_added) values ('MODULE_PAYMENT_SPINV_SORT_ORDER', '0',  '6', '0' , now())");
        xtc_db_query("$pref date_added) values ('MODULE_PAYMENT_SECUPAY_APIKEY', '{$vertrag_id_inv}',  '6', '0' , now())");

        xtc_db_query("$pref date_added) values ('MODULE_PAYMENT_SPINV_KONTO_NR', '',  '6', '0' , now())");
        xtc_db_query("$pref date_added) values ('MODULE_PAYMENT_SPINV_BLZ', '',  '6', '0' , now())");
        xtc_db_query("$pref date_added) values ('MODULE_PAYMENT_SPINV_BANKNAME', '',  '6', '0' , now())");
        xtc_db_query("$pref date_added) values ('MODULE_PAYMENT_SPINV_IBAN', '',  '6', '0' , now())");
        xtc_db_query("$pref date_added) values ('MODULE_PAYMENT_SPINV_BIC', '',  '6', '0' , now())");        
        
        xtc_db_query("$pref use_function, set_function, date_added) values ( 'MODULE_PAYMENT_SPINV_ZONE', '0',  '6', '0', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
        xtc_db_query("$pref set_function, use_function, date_added) values ('MODULE_PAYMENT_SPINV_ORDER_STATUS_ID', '0',  '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");

        xtc_db_query("$pref set_function, use_function, date_added) values ('MODULE_PAYMENT_SPINV_ORDER_STATUS_ACCEPTED_ID', '0',  '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
        xtc_db_query("$pref set_function, use_function, date_added) values ('MODULE_PAYMENT_SPINV_ORDER_STATUS_DENIED_ID', '0',  '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
        xtc_db_query("$pref set_function, use_function, date_added) values ('MODULE_PAYMENT_SPINV_ORDER_STATUS_ISSUE_ID', '0',  '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
        xtc_db_query("$pref set_function, use_function, date_added) values ('MODULE_PAYMENT_SPINV_ORDER_STATUS_VOID_ID', '0',  '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
        xtc_db_query("$pref set_function, use_function, date_added) values ('MODULE_PAYMENT_SPINV_ORDER_STATUS_AUTHORIZED_ID', '0',  '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
        
        xtc_db_query("$pref set_function, date_added) values ( 'MODULE_PAYMENT_SPINV_SIMULATION_MODE', '$modus', '6', '0', 'xtc_cfg_select_option(array(\'Simulation\', \'Produktivsystem\'), ', now())");
        xtc_db_query("$pref set_function, date_added) values ( 'MODULE_PAYMENT_SPINV_MWST', 'Nein', '6', '0', 'xtc_cfg_select_option(array(\'Ja\', \'Nein\'), ', now())");
        xtc_db_query("$pref set_function, date_added) values ( 'MODULE_PAYMENT_SPINV_LOGGING','$debug', '6', '0', 'xtc_cfg_select_option(array(\'Ja\', \'Nein\'), ', now())");
        xtc_db_query("$pref set_function, date_added) values ( 'MODULE_PAYMENT_SPINV_SHOW_QRCODE','Ja', '6', '0', 'xtc_cfg_select_option(array(\'Ja\', \'Nein\'), ', now())");
        
        xtc_db_query("$pref set_function, date_added) values ( 'MODULE_PAYMENT_SPINV_DUE_DATE','Nein', '6', '0', 'xtc_cfg_select_option(array(\'Ja\', \'Nein\'), ', now())");
        
        xtc_db_query("$pref date_added) values ('MODULE_PAYMENT_SPINV_SHOPNAME', '',  '6', '0' , now())");
        //xtc_db_query("$pref set_function, date_added) values ( 'MODULE_PAYMENT_SPINV_PREAUTH', '$aut', '6', '0', 'xtc_cfg_select_option(array(\'Ja\', \'Nein\'), ', now())");
        //xtc_db_query("$pref set_function, date_added) values ( 'MODULE_PAYMENT_SPINV_BID', 'Ja', '6', '99', 'xtc_cfg_select_option(array(\'Ja\', \'Nein\'), ', now())");

        if ($this->conf->secupay_inv_xtc->delivery_differs_disable) {
            xtc_db_query("$pref set_function, date_added) values ('MODULE_PAYMENT_SPINV_DELIVERY_DISABLE', 'Nein', '6', '0', 'xtc_cfg_select_option(array(\'Ja\', \'Nein\', \'Hinweis\'), ', now())");
        }        
        
        xtc_db_query("$pref set_function, date_added) values ( 'MODULE_PAYMENT_SPINV_PAYMENTINFO_TO_COMMENT', 'Nein', '6', '0', 'xtc_cfg_select_option(array(\'Ja\', \'Nein\'), ', now())");
        
        xtc_db_query("$pref date_added) values ('MODULE_PAYMENT_SECUPAY_INV_XTC_ALLOWED', '', '6', '0', now())");
        xtc_db_query("DROP TABLE IF EXISTS secupay_history_inv");
        xtc_db_query("CREATE TABLE secupay_history_inv (
            `log_id` int(10) unsigned not null auto_increment,
            `req_data` text,
            `ret_data` text,
            `payment_method` varchar(255) default null,
            `hash` char(40) default null,
            `transaction_id` int(10) unsigned default null,
            `ordernr` int(11) default null,
            `msg` varchar(255) default null,
            `rank` int(10) default null,
            `status` varchar(255) default null,
            `amount` varchar(255) default null,
            `action` text,
            `created` datetime not null,
            `timestamp` timestamp,
            primary key  (`log_id`))"
        );
        xtc_db_query("CREATE TABLE IF NOT EXISTS `secupay_transaction_order` (
            `hash` char(40) NOT NULL,
            `ordernr` int(11) DEFAULT NULL,
            `transaction_id` int(10) unsigned DEFAULT NULL,
            `created` datetime NOT NULL,
            `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            `capture_status` int(1) NOT NULL,
            PRIMARY KEY (`hash`)
          ) ENGINE=MyISAM;
        ");

        //try to add column iframe_url_id
        try {
            $qry = @xtc_db_query("SHOW COLUMNS FROM secupay_transaction_order LIKE 'iframe_url_id'");
            $result = xtc_db_fetch_array($qry);

            if( !isset($result['Field']) ) {
                xtc_db_query("ALTER TABLE secupay_transaction_order ADD iframe_url_id INT UNSIGNED DEFAULT NULL;");
            } else {
                xtc_db_query("ALTER TABLE secupay_transaction_order CHANGE iframe_url_id iframe_url_id INT UNSIGNED DEFAULT NULL;");
            }
            
            
        } catch(Exception $e) {
                secupay_log($this->sp_log, 'ALTER secupay_transaction_order EXCEPTION: ' . $e->getMessage());
        }    
        
        xtc_db_query("CREATE TABLE IF NOT EXISTS secupay_iframe_url (
            `iframe_url_id` int(10) unsigned not null auto_increment,
            `iframe_url` TEXT,
            PRIMARY KEY (`iframe_url_id`))"
        );        
        
    }

    /**
     * Function that removes payment module
     */
    function remove() {
        secupay_log($this->sp_log, "remove");
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key in ('" . implode("', '", $this->keys()) . "','MODULE_PAYMENT_SECUPAY_INV_XTC_ALLOWED') AND configuration_key NOT IN ('MODULE_PAYMENT_SECUPAY_APIKEY')");

        //check for other secupay payment module
        $qry = xtc_db_query("SELECT * FROM " . TABLE_CONFIGURATION . " WHERE configuration_key LIKE 'MODULE_PAYMENT_SP%_SORT_ORDER';");
        
        if(xtc_db_num_rows($qry) == 0) {
            //no other secupay payment module installed, remove apikey
            secupay_log($this->sp_log, "remove apikey");
            xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_PAYMENT_SECUPAY_APIKEY'");
        }
    }

    /**
     * Function that returns array of configuration options
     *
     * @return array
     */
    function keys() {
        $keys = array('MODULE_PAYMENT_SPINV_STATUS',
            'MODULE_PAYMENT_SECUPAY_APIKEY',
            'MODULE_PAYMENT_SPINV_SORT_ORDER',
            'MODULE_PAYMENT_SPINV_SHOPNAME',
            'MODULE_PAYMENT_SPINV_SIMULATION_MODE',
            'MODULE_PAYMENT_SPINV_LOGGING',
            'MODULE_PAYMENT_SPINV_ZONE',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_ID',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_ACCEPTED_ID',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_DENIED_ID',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_ISSUE_ID',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_VOID_ID',
            'MODULE_PAYMENT_SPINV_ORDER_STATUS_AUTHORIZED_ID',
            'MODULE_PAYMENT_SPINV_SHOW_QRCODE',
            'MODULE_PAYMENT_SPINV_MWST',
            'MODULE_PAYMENT_SPINV_KONTO_NR',
            'MODULE_PAYMENT_SPINV_BLZ',
            'MODULE_PAYMENT_SPINV_BANKNAME',
            'MODULE_PAYMENT_SPINV_IBAN',
            'MODULE_PAYMENT_SPINV_BIC',
            'MODULE_PAYMENT_SPINV_DUE_DATE',
            'MODULE_PAYMENT_SPINV_PAYMENTINFO_TO_COMMENT');
        
        if ($this->conf->secupay_inv_xtc->delivery_differs_disable) {
            $keys[] = 'MODULE_PAYMENT_SPINV_DELIVERY_DISABLE';
        }        
        secupay_log($this->sp_log, "keys", $keys);
        return $keys;
    }

    /**
     * Function that inserts into the log table
     *
     * @return id of inserted logrecord
     */
    function _prepare_trans_log($req_data, $ret_data, $hash, $transaction_id, $msg, $status, $amount) {
        try {
            $sql = "INSERT INTO secupay_history_inv (req_data, ret_data,payment_method,`hash`,transaction_id, msg,status,amount,action,created)" .
                    " VALUES ('" . xtc_db_input($req_data) . "','" . xtc_db_input($ret_data) . "','" . xtc_db_input($this->code) . "','" . xtc_db_input($hash) . "','" . xtc_db_input($transaction_id) . "','" . xtc_db_input($msg) . "','" . xtc_db_input($status) . "'," . xtc_db_input($amount) . ",'',NOW())";
            $qry = xtc_db_query($sql);
            return xtc_db_insert_id();
        } catch(Exception $e) {
            secupay_log($this->sp_log, '_prepare_trans_log EXCEPTION: ' . $e->getMessage());
            return -1;
        }            
    }

     /**
     * Function that inserts into secupay_transaction_order
     *
     * @return id of inserted record_id
     */
     private function _insert_hash($hash) {
        try {
            $sql = "INSERT INTO secupay_transaction_order (`hash`, `created`) VALUES ('".xtc_db_input($hash)."',NOW())";
            $qry = xtc_db_query($sql);
            return xtc_db_insert_id();
        } catch(Exception $e) {
            secupay_log($this->sp_log, '_prepare_trans_log EXCEPTION: ' . $e->getMessage());
            return -1;
        }
     }
    
     /**
     * Function that calculates the EAN for a product
     *
     * @return products_ean
     */
     private function _get_product_ean($product_id) {
         try {
            $sql = 'SELECT products_ean FROM '.TABLE_PRODUCTS.' WHERE products_id =:products_id';
            $result = yes_query($sql,[
                    'products_id'=> intval($product_id)
                ],
                true
            );
            return $result['products_ean'];
        } catch(Exception $e) {
            secupay_log($this->sp_log, '_get_product_ean EXCEPTION: ' . $e->getMessage());
            return '';
        }            
     }
     
     private function _insert_iframe_url($iframe_url, $hash) {
        try {
           $url = str_replace($hash, '', $iframe_url);
           $sql = "SELECT iframe_url_id FROM secupay_iframe_url WHERE iframe_url =:url LIMIT 1";
           secupay_log($this->sp_log, $sql);
           $result = yes_query($sql,['url'=>$url],
                true
           );

           $iframe_url_id = $result['iframe_url_id'];
           
           if(!isset($iframe_url_id) || !is_numeric($iframe_url_id)) {
               $sql = "INSERT INTO secupay_iframe_url (iframe_url) VALUES (:url);";
               secupay_log($this->sp_log, $sql);
               yes_query($sql,['url'=>$url]);
               $iframe_url_id = xtc_db_insert_id();
           }
           
           if(isset($iframe_url_id) && is_numeric($iframe_url_id) ) {
               $sql = "UPDATE secupay_transaction_order SET iframe_url_id =:url_id WHERE hash =:hash";
               secupay_log($this->sp_log, $sql);
               yes_query($sql,['url_id'=> intval($iframe_url_id),'hash'=> $hash]);
           }
        } catch(Exception $e) {
            secupay_log($this->sp_log, '_insert_iframe_url EXCEPTION: ' . $e->getMessage());
        }
         
     }
     
         /**
     * Function that checks if delivery adress differs from billing adress
     *
     * @return boolean
     */
    private function _check_delivery_differs($order) {

        if (isset($order->delivery)) {
            $differs = false;
            if ($order->delivery['firstname'] !== $order->billing['firstname']) {
                $differs = true;
            }
            if ($order->delivery['lastname'] !== $order->billing['lastname']) {
                $differs = true;
            }
            if ($order->delivery['company'] !== $order->billing['company']) {
                $differs = true;
            }
            if ($order->delivery['city'] !== $order->billing['city']) {
                $differs = true;
            }
            if ($order->delivery['postcode'] !== $order->billing['postcode']) {
                $differs = true;
            }
            if ($order->delivery['street_address'] !== $order->billing['street_address']) {
                $differs = true;
            }

            if ($order->delivery['country']['iso_code_2'] !== $order->billing['country']['iso_code_2']) {
                $differs = true;
            }

            return $differs;
        }
        secupay_log($this->sp_log, '_check_delivery_differs - delivery not set');
        return true;
    }
    
    private function _get_invoice_info($order_id) {
        secupay_log($this->sp_log, '_get_invoice_info - order_id: ' . $order_id);
        $invoice_transaction_result = yes_query("SELECT transaction_id, DATE_FORMAT(created, '%Y%m%d') AS date FROM 
            secupay_transaction_order
            WHERE ordernr =:ordernr",
            ['ordernr'=> intval($order_id)],
            true
        );
        
        secupay_log($this->sp_log, $invoice_transaction_result);

        $secupay_invoice_text = MODULE_PAYMENT_SPINV_INVOICE_TEXT_PDF;
        
        $secupay_invoice_account_info = MODULE_PAYMENT_SPINV_KONTO_NR_TITLE . ': ' . utf8_ensure(MODULE_PAYMENT_SPINV_KONTO_NR);
        $secupay_invoice_account_info .= ', ' . MODULE_PAYMENT_SPINV_BLZ_TITLE . ': ' . utf8_ensure(MODULE_PAYMENT_SPINV_BLZ);
        $secupay_invoice_account_info .= ', ' . MODULE_PAYMENT_SPINV_BANKNAME_TITLE . ': ' . utf8_ensure(MODULE_PAYMENT_SPINV_BANKNAME);
        
        $secupay_invoice_account_iban = MODULE_PAYMENT_SPINV_IBAN_TITLE . ': ' . utf8_ensure(MODULE_PAYMENT_SPINV_IBAN);
        $secupay_invoice_account_iban .= ', ' . MODULE_PAYMENT_SPINV_BIC_TITLE . ': ' . utf8_ensure(MODULE_PAYMENT_SPINV_BIC);

        $secupay_invoice_purpose = MODULE_PAYMENT_SPINV_INVOICE_PURPOSE . ': ';
        if(!empty($invoice_transaction_result['transaction_id'])) {
            $secupay_invoice_purpose .= 'TA ' . $invoice_transaction_result['transaction_id'] . ' ';
        }
        $secupay_invoice_purpose .= 'DT '. $invoice_transaction_result['date'];
        
        $invoice_info = '';
        $invoice_info .= $secupay_invoice_text;
        $invoice_info .= "\n";
        $invoice_info .= $secupay_invoice_account_info;
        $invoice_info .= "\n";
        $invoice_info .= $secupay_invoice_account_iban;
        $invoice_info .= "\n";
        $invoice_info .= $secupay_invoice_purpose;

        $show_invoice_url = strcmp(MODULE_PAYMENT_SPINV_SHOW_QRCODE, 'Ja') == 0 ? true : false;
        if ($show_invoice_url) {
            $invoice_url_result = xtc_db_query("SELECT CONCAT(iframe_url, hash) AS url FROM 
                secupay_transaction_order
                INNER JOIN secupay_iframe_url ON secupay_iframe_url.iframe_url_id = secupay_transaction_order.iframe_url_id
                WHERE ordernr =:ordernr",
                ['ordernr'=> intval($order_id)],
            );
            if (isset($invoice_url_result['url']) && strlen($invoice_url_result['url']) > 5) {
                $secupay_invoice_url = MODULE_PAYMENT_SPINV_INVOICE_URL_HINT . "\n";
                $secupay_invoice_url .= $invoice_url_result['url'];
                $invoice_info .= "\n\n";
                $invoice_info .= $secupay_invoice_url;
            }
        }
        
        $show_due_date = strcmp(MODULE_PAYMENT_SPINV_DUE_DATE, 'Ja') == 0 ? true : false;
        if($show_due_date) {
            $secupay_invoice_due_date = MODULE_PAYMENT_SPINV_DUE_DATE_TEXT_PDF;
            $invoice_info .= "\n\n";
            $invoice_info .= $secupay_invoice_due_date;
        }
        
        return $invoice_info;
    }
}
