<?php
class amazon_secondday extends shipping_default_class
{
    var $code, $title, $description, $icon, $enabled;

    public function __construct()
    {
        $this->code        = 'amazon_secondday';
        $this->title       = MODULE_SHIPPING_AMAZON_SECONDDAY_TEXT_TITLE;
        $this->description = MODULE_SHIPPING_AMAZON_SECONDDAY_TEXT_DESCRIPTION;
        $this->icon        = '';   // change $this->icon =  DIR_WS_ICONS . 'shipping_ups.gif'; to some freeshipping icon
        $this->sort_order  = MODULE_SHIPPING_AMAZON_SECONDDAY_SORT_ORDER;
        $this->enabled     = ((defined('MODULE_SHIPPING_AMAZON_SECONDDAY_STATUS') && MODULE_SHIPPING_AMAZON_SECONDDAY_STATUS != 'True')?false:true);
        $this->tax_class   = (defined('MODULE_SHIPPING_AMAZON_SECONDDAY_TAX_CLASS')) ? MODULE_SHIPPING_AMAZON_SECONDDAY_TAX_CLASS : Null;
    }

    function quote($method = '')
    {
        global $order;
        $this->quotes = array(
            'id' => $this->code,
            'module' => MODULE_SHIPPING_AMAZON_SECONDDAY_TEXT_TITLE
        );

        $this->quotes['methods'] = array(array(
            'id'    => $this->code,
            'title' => MODULE_SHIPPING_AMAZON_SECONDDAY_TEXT_WAY,
            'cost'  => 0
        ));

        if(xtc_not_null($this->icon))
        {
            $this->quotes['icon'] = xtc_image($this->icon, $this->title);
        }

        return $this->quotes;
    }

    function check()
    {
        $check = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_AMAZON_SECONDDAY_STATUS'");
        $check = xtc_db_num_rows($check);

        return $check;
    }

    function install() 
    {
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_SHIPPING_AMAZON_SECONDDAY_STATUS', 'False', '6', '7', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_AMAZON_SECONDDAY_ALLOWED', '', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_AMAZON_SECONDDAY_SORT_ORDER', '0', '6', '4', now())");
		xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_SHIPPING_AMAZON_SECONDDAY_TAX_CLASS', '0', '6', '0', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
    }

    function remove()
    {
        xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys()
    {
        return array('MODULE_SHIPPING_AMAZON_SECONDDAY_STATUS','MODULE_SHIPPING_AMAZON_SECONDDAY_SORT_ORDER','MODULE_SHIPPING_AMAZON_SECONDDAY_ALLOWED','MODULE_SHIPPING_AMAZON_SECONDDAY_TAX_CLASS');
    }
}
