<?php
/* --------------------------------------------------------------
   $Id: german.php,v 1.233 2020/06/12 11:19:45 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(german.php,v 1.99 2003/05/28); www.oscommerce.com 
   (c) 2003  nextcommerce (german.php,v 1.24 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License
   --------------------------------------------------------------
   Third Party contributions:
   Customers Status v3.x (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

// look in your $PATH_LOCALE/locale directory for available locales..
// on RedHat6.0 I used 'de_DE'
// on FreeBSD 4.0 I use 'de_DE.ISO_8859-1'
// this may not work under win32 environments..
setlocale(LC_TIME, 'de_DE.ISO_8859-1');
define('DATE_FORMAT_SHORT', '%d.%m.%Y');  // this is used for strftime()
define('DATE_FORMAT_LONG', '%A, %d. %m. %Y'); // this is used for strftime()
define('DATE_FORMAT', 'd.m.Y');  // this is used for strftime()
define('PHP_DATE_TIME_FORMAT', 'd.m.Y H:i:s'); // this is used for date()
define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');
////
// Return date in raw format
// $date should be in format mm/dd/yyyy
// raw date is in format YYYYMMDD, or DDMMYYYY
function xtc_date_raw($date, $reverse = false) {
  if ($reverse) {
    return substr($date, 0, 2) . substr($date, 3, 2) . substr($date, 6, 4);
  } else {
    return substr($date, 6, 4) . substr($date, 3, 2) . substr($date, 0, 2);
  }
}

// Global entries for the <html> tag
define('HTML_PARAMS',' xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en"');


// page title
define('TITLE', 'Your E-Business Solution');

// header text in includes/header.php
define('HEADER_TITLE_TOP', 'Administration');
define('HEADER_TITLE_SUPPORT_SITE', 'Supportseite');
define('HEADER_TITLE_ONLINE_CATALOG', 'Online Katalog');
define('HEADER_TITLE_ADMINISTRATION', 'Administration');

// text for gender
define('MALE', 'Herr');
define('FEMALE', 'Frau');

// text for date of birth example
define('DOB_FORMAT_STRING', 'tt.mm.jjjj');

// configuration box text in includes/boxes/configuration.php

define('BOX_HEADING_CONFIGURATION','Konfiguration');
define('BOX_HEADING_MODULES','Module');
define('BOX_HEADING_ZONE','Land / Steuer');
define('BOX_HEADING_CUSTOMERS','Kunden');
define('BOX_HEADING_PRODUCTS','Artikelkatalog');
define('BOX_HEADING_STATISTICS','Statistiken');
define('BOX_HEADING_TOOLS','Hilfsprogramme');

define('BOX_CONTENT','Content Manager');
define('TEXT_ALLOWED', 'Erlaubnis');
define('TEXT_ACCESS', 'Zugriffsbereich');
define('BOX_CONFIGURATION', 'Grundeinstellungen');
define('BOX_CONFIGURATION_1', 'Mein Shop');
define('BOX_CONFIGURATION_2', 'Minumum Werte');
define('BOX_CONFIGURATION_3', 'Maximum Werte');
define('BOX_CONFIGURATION_4', 'Bild Optionen');
define('BOX_CONFIGURATION_5', 'Kunden Details');
define('BOX_CONFIGURATION_6', 'Modul Optionen');
define('BOX_CONFIGURATION_7', 'Versand Optionen');
define('BOX_CONFIGURATION_8', 'Artikel Listen Optionen');
define('BOX_CONFIGURATION_9', 'Lagerverwaltungs Optionen');
define('BOX_CONFIGURATION_10', 'Logging Optionen');
define('BOX_CONFIGURATION_11', 'Cache Optionen');
define('BOX_CONFIGURATION_12', 'eMail Optionen');
define('BOX_CONFIGURATION_13', 'Download Optionen');
define('BOX_CONFIGURATION_14', 'Gzip Kompression');
define('BOX_CONFIGURATION_15', 'Sessions');
define('BOX_CONFIGURATION_16', 'Meta-Tags/Suchmaschinen');
define('BOX_CONFIGURATION_17', 'Zusatzmodule');
define('BOX_CONFIGURATION_18', 'UST ID');
define('BOX_CONFIGURATION_19', 'Google Conversion');

define('BOX_MODULES', 'Zahlungs-/Versand-/Verrechnungs-Module');
define('BOX_PAYMENT', 'Zahlungsoptionen');
define('BOX_SHIPPING', 'Versandart');
define('BOX_ORDER_TOTAL', 'Zusammenfassung');
define('BOX_CATEGORIES', 'Kategorien / Artikel');
define('BOX_PRODUCTS_ATTRIBUTES', 'Artikelmerkmale');
define('BOX_MANUFACTURERS', 'Hersteller');
define('BOX_REVIEWS', 'Artikelbewertungen');
define('BOX_XSELL_PRODUCTS', 'Cross Marketing');
define('BOX_SPECIALS', 'Sonderangebote');
define('BOX_PRODUCTS_EXPECTED', 'Erwartete Artikel');
define('BOX_CUSTOMERS', 'Kunden');
define('BOX_ACCOUNTING', 'Adminrechte Verwaltung');
define('BOX_CUSTOMERS_STATUS','Kundengruppen');
define('BOX_ORDERS', 'Bestellungen');
define('BOX_COUNTRIES', 'Land');
define('BOX_ZONES', 'Bundesl&auml;nder');
define('BOX_GEO_ZONES', 'Steuerzonen');
define('BOX_TAX_CLASSES', 'Steuerklassen');
define('BOX_TAX_RATES', 'Steuers&auml;tze');
define('BOX_HEADING_REPORTS', 'Berichte');
define('BOX_PRODUCTS_VIEWED', 'Besuchte Artikel');
define('BOX_STOCK_WARNING','Lager Bericht');
define('BOX_PRODUCTS_PURCHASED', 'Verkaufte Artikel');
define('BOX_STATS_CUSTOMERS', 'Kunden-<br>&nbsp;Bestellstatistik');
define('BOX_BACKUP', 'Datenbank Manager');
define('BOX_BANNER_MANAGER', 'Banner Manager');
define('BOX_CACHE', 'Cache Steuerung');
define('BOX_DEFINE_LANGUAGE', 'Sprachen definieren');
define('BOX_FILE_MANAGER', 'Datei-Manager');
define('BOX_MAIL', 'eMail versenden');
define('BOX_NEWSLETTERS', 'Rundschreiben Manager');
define('BOX_SERVER_INFO', 'Server Info');
define('BOX_WHOS_ONLINE', 'Wer ist Online');
define('BOX_TPL_BOXES','Box Reihenfolge');
define('BOX_CURRENCIES', 'W&auml;hrungen');
define('BOX_LANGUAGES', 'Sprachen');
define('BOX_ATTRIBUTES_MANAGER','Attribut Verwaltung');
define('BOX_ORDERS_STATUS','Bestellstatus');
define('BOX_SHIPPING_STATUS','Lieferstatus');
define('BOX_SALES_REPORT','Umsatzstatistik');
define('BOX_MODULE_EXPORT','XT-Module');
define('BOX_HEADING_GV_ADMIN', 'Gutscheine/Kupons');
define('BOX_GV_ADMIN_QUEUE', 'Gutschein Queue');
define('BOX_GV_ADMIN_MAIL', 'Gutschein eMail');
define('BOX_GV_ADMIN_SENT', 'Gutscheine versandt');
define('BOX_HEADING_COUPON_ADMIN','Rabattkupons');
define('BOX_COUPON_ADMIN','Kupon Admin');
define('BOX_TOOLS_BLACKLIST','-CC-Blacklist');

define('TXT_GROUPS','<b>Gruppen</b>:');
define('TXT_SYSTEM','System');
define('TXT_CUSTOMERS','Kunden/Bestellungen');
define('TXT_PRODUCTS','Artikel/Kategorien');
define('TXT_STATISTICS','Statistiktools');
define('TXT_TOOLS','Zusatzprogramme');
define('TEXT_ACCOUNTING','Zugriffseinstellungen f&uuml;r:');

//Dividers text for menu

define('BOX_HEADING_LOCALIZATION', 'Sprachen/W&auml;hrungen');
define('BOX_HEADING_TEMPLATES','Templates');
define('BOX_HEADING_LOCATION_AND_TAXES', 'Land / Steuer');
define('BOX_HEADING_CATALOG', 'Katalog');
define('BOX_MODULE_NEWSLETTER','Rundschreiben');

// javascript messages
define('JS_ERROR', 'W&auml;hrend der Eingabe sind Fehler aufgetreten!\nBitte korrigieren Sie folgendes:\n\n');

define('JS_OPTIONS_VALUE_PRICE', '* Sie m&uuml;ssen diesem Wert einen Preis zuordnen\n');
define('JS_OPTIONS_VALUE_PRICE_PREFIX', '* Sie m&uuml;ssen ein Vorzeichen für den Preis angeben (+/-)\n');

define('JS_PRODUCTS_NAME', '* Der neue Artikel muss einen Namen haben\n');
define('JS_PRODUCTS_DESCRIPTION', '* Der neue Artikel muss eine Beschreibung haben\n');
define('JS_PRODUCTS_PRICE', '* Der neue Artikel muss einen Preis haben\n');
define('JS_PRODUCTS_WEIGHT', '* Der neue Artikel muss eine Gewichtsangabe haben\n');
define('JS_PRODUCTS_QUANTITY', '* Sie m&uuml;ssen dem neuen Artikel eine verf&uuml;gbare Anzahl zuordnen\n');
define('JS_PRODUCTS_MODEL', '* Sie m&uuml;ssen dem neuen Artikel eine Artikel-Nr. zuordnen\n');
define('JS_PRODUCTS_IMAGE', '* Sie m&uuml;ssen dem Artikel ein Bild zuordnen\n');

define('JS_SPECIALS_PRODUCTS_PRICE', '* Es muss ein neuer Preis für diesen Artikel festgelegt werden\n');

define('JS_GENDER', '* Die \'Anrede\' muss ausgew&auml;hlt werden.\n');
define('JS_FIRST_NAME', '* Der \'Vorname\' muss mindestens aus ' . ENTRY_FIRST_NAME_MIN_LENGTH . ' Zeichen bestehen.\n');
define('JS_LAST_NAME', '* Der \'Nachname\' muss mindestens aus ' . ENTRY_LAST_NAME_MIN_LENGTH . ' Zeichen bestehen.\n');
define('JS_DOB', '* Das \'Geburtsdatum\' muss folgendes Format haben: xx.xx.xxxx (Tag/Jahr/Monat).\n');
define('JS_EMAIL_ADDRESS', '* Die \'eMail-Adresse\' muss mindestens aus ' . ENTRY_EMAIL_ADDRESS_MIN_LENGTH . ' Zeichen bestehen.\n');
define('JS_ADDRESS', '* Die \'Strasse\' muss mindestens aus ' . ENTRY_STREET_ADDRESS_MIN_LENGTH . ' Zeichen bestehen.\n');
define('JS_POST_CODE', '* Die \'Postleitzahl\' muss mindestens aus ' . ENTRY_POSTCODE_MIN_LENGTH . ' Zeichen bestehen.\n');
define('JS_CITY', '* Die \'Stadt\' muss mindestens aus ' . ENTRY_CITY_MIN_LENGTH . ' Zeichen bestehen.\n');
define('JS_STATE', '* Das \'Bundesland\' muss ausgewählt werden.\n');
define('JS_STATE_SELECT', '-- Wählen Sie oberhalb --');
define('JS_ZONE', '* Das \'Bundesland\' muss aus der Liste für dieses Land ausgewählt werden.');
define('JS_COUNTRY', '* Das \'Land\' muss ausgew&auml;hlt werden.\n');
define('JS_TELEPHONE', '* Die \'Telefonnummer\' muss aus mindestens ' . ENTRY_TELEPHONE_MIN_LENGTH . ' Zeichen bestehen.\n');
define('JS_PASSWORD', '* Das \'Passwort\' sowie die \'Passwortbest&auml;tigung\' m&uuml;ssen &uuml;bereinstimmen und aus mindestens ' . ENTRY_PASSWORD_MIN_LENGTH . ' Zeichen bestehen.\n');

define('JS_ORDER_DOES_NOT_EXIST', 'Auftragsnummer %s existiert nicht!');

define('CATEGORY_PERSONAL', 'Pers&ouml;nliche Daten');
define('CATEGORY_ADDRESS', 'Adresse');
define('CATEGORY_CONTACT', 'Kontakt');
define('CATEGORY_COMPANY', 'Firma');
define('CATEGORY_OPTIONS', 'Weitere Optionen');

define('ENTRY_GENDER', 'Anrede:');
define('ENTRY_GENDER_ERROR', '&nbsp;<span class="errorText">notwendige Eingabe</span>');
define('ENTRY_FIRST_NAME', 'Vorname:');
define('ENTRY_FIRST_NAME_ERROR', '&nbsp;<span class="errorText">mindestens ' . ENTRY_FIRST_NAME_MIN_LENGTH . ' Buchstaben</span>');
define('ENTRY_LAST_NAME', 'Nachname:');
define('ENTRY_LAST_NAME_ERROR', '&nbsp;<span class="errorText">mindestens ' . ENTRY_LAST_NAME_MIN_LENGTH . ' Buchstaben</span>');
define('ENTRY_DATE_OF_BIRTH', 'Geburtsdatum:');
define('ENTRY_DATE_OF_BIRTH_ERROR', '&nbsp;<span class="errorText">(z.B. 21.05.1970)</span>');
define('ENTRY_EMAIL_ADDRESS', 'E-Mail Adresse:');
define('ENTRY_EMAIL_ADDRESS_ERROR', '&nbsp;<span class="errorText">mindestens ' . ENTRY_EMAIL_ADDRESS_MIN_LENGTH . ' Buchstaben</span>');
define('ENTRY_EMAIL_ADDRESS_CHECK_ERROR', '&nbsp;<span class="errorText">ung&uuml;ltige eMail Adresse!</span>');
define('ENTRY_EMAIL_ADDRESS_ERROR_EXISTS', '&nbsp;<span class="errorText">Diese eMail Adresse existiert schon!</span>');
define('ENTRY_COMPANY', 'Firmenname:');
define('ENTRY_STREET_ADDRESS', 'Strasse:');
define('ENTRY_STREET_ADDRESS_ERROR', '&nbsp;<span class="errorText">mindestens ' . ENTRY_STREET_ADDRESS_MIN_LENGTH . ' Buchstaben</span>');
define('ENTRY_SUBURB', 'Adress Zusatz:');
define('ENTRY_POST_CODE', 'Postleitzahl:');
define('ENTRY_POST_CODE_ERROR', '&nbsp;<span class="errorText">mindestens ' . ENTRY_POSTCODE_MIN_LENGTH . ' Zahlen</span>');
define('ENTRY_CITY', 'Stadt:');
define('ENTRY_CITY_ERROR', '&nbsp;<span class="errorText">mindestens ' . ENTRY_CITY_MIN_LENGTH . ' Buchstaben</span>');
define('ENTRY_STATE', 'Bundesland:');
define('ENTRY_STATE_ERROR', '&nbsp;<span class="errorText">notwendige Eingabe</font></small>');
define('ENTRY_COUNTRY', 'Land:');
define('ENTRY_TELEPHONE_NUMBER', 'Telefonnummer:');
define('ENTRY_TELEPHONE_NUMBER_ERROR', '&nbsp;<span class="errorText">mindestens ' . ENTRY_TELEPHONE_MIN_LENGTH . ' Zahlen</span>');
define('ENTRY_FAX_NUMBER', 'Telefaxnummer:');
define('ENTRY_NEWSLETTER', 'Rundschreiben:');
define('ENTRY_HOMEPAGE', 'Homepage:');
define('ENTRY_CUSTOMERS_STATUS', 'Kundengruppe:');
define('ENTRY_NEWSLETTER_YES', 'abonniert');
define('ENTRY_NEWSLETTER_NO', 'nicht abonniert');
define('ENTRY_MAIL_ERROR','&nbsp;<span class="errorText">Bitte treffen sie eine Auswahl</span>');
define('ENTRY_PASSWORD','Passwort (autom. erstellt)');
define('ENTRY_PASSWORD_ERROR','&nbsp;<span class="errorText">Ihr Passwort muss aus mindestens ' . ENTRY_PASSWORD_MIN_LENGTH . ' Zeichen bestehen.</span>');
define('ENTRY_MAIL_COMMENTS','Zus&auml;tzlicher eMailtext:');

define('ENTRY_MAIL','eMail mit Passwort an Kunden versenden?');
define('YES','ja');
define('NO','nein');
define('SAVE_ENTRY','&Auml;nderungen Speichern?');
define('TEXT_CHOOSE_INFO_TEMPLATE','Vorlage f&uuml;r Artikeldetails');
define('TEXT_CHOOSE_OPTIONS_TEMPLATE','Vorlage f&uuml;r Artikeloptionen');
define('TEXT_SELECT','-- Bitte wählen Sie --');

// images
define('IMAGE_ANI_SEND_EMAIL', 'eMail versenden');
define('IMAGE_BACK', 'Zur&uuml;ck');
define('IMAGE_BACKUP', 'Datensicherung');
define('IMAGE_CANCEL', 'Abbruch');
define('IMAGE_CONFIRM', 'Best&auml;tigen');
define('IMAGE_COPY', 'Kopieren');
define('IMAGE_COPY_TO', 'Kopieren nach');
define('IMAGE_DETAILS', 'Details');
define('IMAGE_DELETE', 'L&ouml;schen');
define('IMAGE_EDIT', 'Bearbeiten');
define('IMAGE_EMAIL', 'eMail versenden');
define('IMAGE_FILE_MANAGER', 'Datei-Manager');
define('IMAGE_ICON_STATUS_GREEN', 'Aktiv');
define('IMAGE_ICON_STATUS_GREEN_LIGHT', 'aktivieren');
define('IMAGE_ICON_STATUS_RED', 'Inaktiv');
define('IMAGE_ICON_STATUS_RED_LIGHT', 'deaktivieren');
define('IMAGE_ICON_INFO', 'Information');
define('IMAGE_INSERT', 'Einf&uuml;gen');
define('IMAGE_LOCK', 'Sperren');
define('IMAGE_MODULE_INSTALL', 'Modul Installieren');
define('IMAGE_MODULE_REMOVE', 'Modul Entfernen');
define('IMAGE_MOVE', 'Verschieben');
define('IMAGE_NEW_BANNER', 'Neuen Banner aufnehmen');
define('IMAGE_NEW_CATEGORY', 'Neue Kategorie erstellen');
define('IMAGE_NEW_COUNTRY', 'Neues Land aufnehmen');
define('IMAGE_NEW_CURRENCY', 'Neue W&auml;hrung einf&uuml;gen');
define('IMAGE_NEW_FILE', 'Neue Datei');
define('IMAGE_NEW_FOLDER', 'Neues Verzeichnis');
define('IMAGE_NEW_LANGUAGE', 'Neue Sprache anlegen');
define('IMAGE_NEW_NEWSLETTER', 'Neues Rundschreiben');
define('IMAGE_NEW_PRODUCT', 'Neuen Artikel aufnehmen');
define('IMAGE_NEW_TAX_CLASS', 'Neue Steuerklasse erstellen');
define('IMAGE_NEW_TAX_RATE', 'Neuen Steuersatz anlegen');
define('IMAGE_NEW_TAX_ZONE', 'Neue Steuerzone erstellen');
define('IMAGE_NEW_ZONE', 'Neues Bundesland einf&uuml;gen');
define('IMAGE_ORDERS', 'Bestellungen');
define('IMAGE_ORDERS_INVOICE', 'Rechnung');
define('IMAGE_ORDERS_PACKINGSLIP', 'Lieferschein');
define('IMAGE_PREVIEW', 'Vorschau');
define('IMAGE_RESET', 'Zur&uuml;cksetzen');
define('IMAGE_RESTORE', 'Zur&uuml;cksichern');
define('IMAGE_SAVE', 'Speichern');
define('IMAGE_SEARCH', 'Suchen');
define('IMAGE_SELECT', 'Ausw&auml;hlen');
define('IMAGE_SEND', 'Versenden');
define('IMAGE_SEND_EMAIL', 'eMail versenden');
define('IMAGE_UNLOCK', 'Entsperren');
define('IMAGE_UPDATE', 'Aktualisieren');
define('IMAGE_UPDATE_CURRENCIES', 'Wechselkurse aktualisieren');
define('IMAGE_UPLOAD', 'Hochladen');
define('IMAGE_ACCOUNTING','Accounting');
define('IMAGE_STATUS','Kundengruppe');
define('IMAGE_IPLOG','IP-Log');
define('CREATE_ACCOUNT','Neuer Kunde');
define('IMAGE_START','Modul Starten');
define('IMAGE_CLOSE','Fenster schliessen');
define('IMAGE_AUTH_DENIED','Fehlende Berechtigung');
define('IMAGE_EDIT_CUSTOMER','Stammdaten bearbeiten');
define('IMAGE_EXPORT','Exportieren');
define('IMAGE_STORAGE_ADMIN','Lagerorte');
define('IMAGE_DISTRIBUTOR_ADMIN','Lieferanten');

define('ICON_CROSS', 'Falsch');
define('ICON_CURRENT_FOLDER', 'Aktueller Ordner');
define('ICON_DELETE', 'L&ouml;schen');
define('ICON_ERROR', 'Fehler');
define('ICON_FILE', 'Datei');
define('ICON_FILE_DOWNLOAD', 'Herunterladen');
define('ICON_FOLDER', 'Ordner');
define('ICON_LOCKED', 'Gesperrt');
define('ICON_PREVIOUS_LEVEL', 'Vorherige Ebene');
define('ICON_PREVIEW', 'Vorschau');
define('ICON_STATISTICS', 'Statistik');
define('ICON_SUCCESS', 'Erfolg');
define('ICON_TICK', 'Wahr');
define('ICON_UNLOCKED', 'Entsperrt');
define('ICON_WARNING', 'Warnung');

// constants for use in tep_prev_next_display function
define('TEXT_RESULT_PAGE', 'Seite %s von %d');
define('TEXT_DISPLAY_NUMBER_OF_BANNERS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Bannern)');
define('TEXT_DISPLAY_NUMBER_OF_COUNTRIES', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> L&auml;ndern)');
define('TEXT_DISPLAY_NUMBER_OF_CUSTOMERS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Kunden)');
define('TEXT_DISPLAY_NUMBER_OF_CURRENCIES', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> W&auml;hrungen)');
define('TEXT_DISPLAY_NUMBER_OF_LANGUAGES', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Sprachen)');
define('TEXT_DISPLAY_NUMBER_OF_MANUFACTURERS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Herstellern)');
define('TEXT_DISPLAY_NUMBER_OF_NEWSLETTERS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Rundschreiben)');
define('TEXT_DISPLAY_NUMBER_OF_ORDERS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Bestellungen)');
define('TEXT_DISPLAY_NUMBER_OF_ORDERS_STATUS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Bestellstatus)');
define('TEXT_DISPLAY_NUMBER_OF_SHIPPING_STATUS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Lieferstatus)');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Artikeln)');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_EXPECTED', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> erwarteten Artikeln)');
define('TEXT_DISPLAY_NUMBER_OF_REVIEWS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Bewertungen)');
define('TEXT_DISPLAY_NUMBER_OF_SPECIALS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Sonderangeboten)');
define('TEXT_DISPLAY_NUMBER_OF_TAX_CLASSES', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Steuerklassen)');
define('TEXT_DISPLAY_NUMBER_OF_TAX_ZONES', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Steuerzonen)');
define('TEXT_DISPLAY_NUMBER_OF_TAX_RATES', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Steuers&auml;tzen)');
define('TEXT_DISPLAY_NUMBER_OF_ZONES', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Bundesl&auml;ndern)');
define('TEXT_DISPLAY_NUMBER_OF_ITEMS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Datens&auml;tzen)');

define('TEXT_SHOW_ALL','Alle anzeigen');


define('PREVNEXT_BUTTON_PREV', '&lt;&lt;');
define('PREVNEXT_BUTTON_NEXT', '&gt;&gt;');

define('TEXT_DEFAULT', 'Standard');
define('TEXT_SET_DEFAULT', 'als Standard definieren');
define('TEXT_FIELD_REQUIRED', '&nbsp;<span class="fieldRequired">* Erforderlich</span>');

define('ERROR_NO_DEFAULT_CURRENCY_DEFINED', 'Fehler: Es wurde keine Standardw&auml;hrung definiert. Bitte definieren Sie unter Adminstration -> Sprachen/W&auml;hrungen -> W&auml;hrungen eine Standardw&auml;hrung.');

define('TEXT_CACHE_CATEGORIES', 'Kategorien Box');
define('TEXT_CACHE_MANUFACTURERS', 'Hersteller Box');
define('TEXT_CACHE_ALSO_PURCHASED', 'Ebenfalls gekauft Modul');

define('TEXT_NONE', '--keine--');
define('TEXT_TOP', 'Top');

define('TEXT_NO_COMMENTS','Keine Kommentare');

define('ERROR_DESTINATION_DOES_NOT_EXIST', 'Fehler: Speicherort existiert nicht.');
define('ERROR_DESTINATION_NOT_WRITEABLE', 'Fehler: Speicherort ist nicht beschreibbar.');
define('ERROR_FILE_NOT_SAVED', 'Fehler: Datei wurde nicht gespeichert.');
define('ERROR_FILETYPE_NOT_ALLOWED', 'Fehler: Dateityp ist nicht erlaubt.');
define('SUCCESS_FILE_SAVED_SUCCESSFULLY', 'Erfolg: Hochgeladene Datei wurde erfolgreich gespeichert.');
define('WARNING_NO_FILE_UPLOADED', 'Warnung: Es wurde keine Datei hochgeladen.');

define('DELETE_ENTRY','Eintrag l&ouml;schen?');
define('TEXT_PAYMENT_ERROR','<b>WARNUNG:</b><br>Bitte Aktivieren Sie ein Zahlungsmodul!');
define('TEXT_SHIPPING_ERROR','<b>WARNUNG:</b><br>Bitte Aktivieren Sie ein Versandmodul!');

define('TEXT_NETTO','Netto: ');

define('ENTRY_CID','Kundennummer:');
define('IP','Bestell IP:');
define('CUSTOMERS_MEMO','Memos:');
define('DISPLAY_MEMOS','Anzeigen/Schreiben');
define('TITLE_MEMO','Kunden MEMO');
define('ENTRY_LANGUAGE','Sprache:');
define('CATEGORIE_NOT_FOUND','Kategorie nicht vorhanden');

define('IMAGE_RELEASE', 'Gutschein einl&ouml;sen');

define('_JANUARY', 'Januar');
define('_FEBRUARY', 'Februar');
define('_MARCH', 'März');
define('_APRIL', 'April');
define('_MAY', 'Mai');
define('_JUNE', 'Juni');
define('_JULY', 'Juli');
define('_AUGUST', 'August');
define('_SEPTEMBER', 'September');
define('_OCTOBER', 'Oktober');
define('_NOVEMBER', 'November');
define('_DECEMBER', 'Dezember');

// Beschreibung für Abmeldelink im Newsletter
define('TEXT_NEWSLETTER_REMOVE', 'Um sich von unserem Newsletter abzumelden klicken Sie hier:');


define('TEXT_DISPLAY_NUMBER_OF_GIFT_VOUCHERS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Gutscheinen)');
define('TEXT_DISPLAY_NUMBER_OF_COUPONS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> ((von insgesamt <b>%d</b> Kupons)');

define('TEXT_VALID_PRODUCTS_LIST', 'Artikelliste');
define('TEXT_VALID_PRODUCTS_ID', 'Artikelnummer');
define('TEXT_VALID_PRODUCTS_NAME', 'Artikelname');
define('TEXT_VALID_PRODUCTS_MODEL', 'Artikelnummer');

define('TEXT_VALID_CATEGORIES_LIST', 'Kategorieliste');
define('TEXT_VALID_CATEGORIES_ID', 'Kategorienummer');
define('TEXT_VALID_CATEGORIES_NAME', 'Kategoriename');

define('SECURITY_CODE_LENGTH_TITLE', 'L&auml;nge des Gutscheincodes');
define('SECURITY_CODE_LENGTH_DESC', 'Geben Sie hier die Länge des Gutscheincode ein. (max. 16 Zeichen)');

define('NEW_SIGNUP_GIFT_VOUCHER_AMOUNT_TITLE', 'Willkommens-Geschenk Gutschein Wert');
define('NEW_SIGNUP_GIFT_VOUCHER_AMOUNT_DESC', 'Willkommens-Geschenk Gutschein Wert: Wenn Sie keinen Gutschein in Ihrer Willkommens-eMail versenden wollen, tragen Sie hier 0 ein, ansonsten geben Sie den Wert des Gutscheins an, zB. 10.00 oder 50.00, aber keine W&auml;hrungszeichen');
define('NEW_SIGNUP_DISCOUNT_COUPON_TITLE', 'Willkommens-Rabatt Kupon Code');
define('NEW_SIGNUP_DISCOUNT_COUPON_DESC', 'Willkommens-Rabatt Kupon Code: Wenn Sie keinen Kupon in Ihrer Willkommens-eMail versenden wollen, lassen Sie dieses Feld leer, ansonsten tragen Sie den Kupon Code ein, den Sie verwenden wollen');
define('NEWSLETTER_SUBSCRIPTION_COUPON_TITLE','Newsletter Anmeldung: Kuponcode');
define('NEWSLETTER_SUBSCRIPTION_COUPON_DESC','Wenn bei einer Newsletter Anmeldung dem Kunden ein Kuponcode zugesendet werden soll, k&ouml;nnen Sie hier einen Kupon-Code hinterlegen. Dieser muss g&uuml;ltig sein und sowohl einen Kuponwert als auch eine Beschreibung enthalten.');

define('TXT_ALL','Alle');


// UST ID
define('HEADING_TITLE_VAT','Ust-ID');
define('ENTRY_VAT_ID','Ust-ID:');
define('ENTRY_CUSTOMERS_VAT_ID', 'UstID:');
define('TEXT_VAT_FALSE','<font color="FF0000">Geprüft/Falsch!</font>');
define('TEXT_VAT_TRUE','<font color="FF0000">Geprüft/OK!</font>');
define('TEXT_VAT_UNKNOWN_COUNTRY','<font color="FF0000">Nicht Geprüft/Land unbekannt!</font>');
define('TEXT_VAT_UNKNOWN_ALGORITHM','<font color="FF0000">Nicht Geprüft/Keine Überprüfung möglich!</font>');
define('ENTRY_VAT_ID_ERROR', '<font color="FF0000">* Die Eingegebene UST ID Nummer ist Falsch oder kann derzeit nicht geprüft werden!</font>');

define('ERROR_GIF_MERGE','Fehlender GDlib Gif Support, kein Wasserzeichen (Merge) möglich');
define('ERROR_GIF_UPLOAD','Fehlender GDlib Gif Support, kein Upload von GIF Bildern möglich');

define('_MODULES_SORT_ORDER_TITLE','Anzeigereihenfolge');
define('_MODULES_SORT_ORDER_DESC','Reihenfolge der Anzeige. Kleinste Ziffer wird zuerst angezeigt.');
define('_MODULES_ZONE_TITLE','Zone');
define('_MODULES_ZONE_DESC','Wenn eine Zone ausgew&auml;hlt ist, wird das Modul nur f&uuml;r diese Zone angezeigt.');
define('_MODULES_ZONE_ALLOWED_TITLE','Erlaubte Zonen');
define('_MODULES_ZONE_ALLOWED_DESC','Geben Sie <b>einzeln</b> die Zonen an, welche f&uuml;r dieses Modul erlaubt sein sollen. (z.B. AT,DE (wenn leer, werden alle Zonen erlaubt))');
define('_MODULES_PAYMENT_FEE_TITLE','Zahlungsgeb&uuml;hr');
define('_MODULES_PAYMENT_FEE_DESC','Aufschlag f&uuml;r diese Zahlungsweise');
define('_MODULES_SET_ORDER_STATUS_TITLE','Bestellstatus festlegen');
define('_MODULES_SET_ORDER_STATUS_DESC','Bestellungen, welche mit diesem Modul gemacht werden, auf diesen Status setzen');
define('_MODULES_TAX_ZONE_TITLE' , 'Steuersatz');
define('_MODULES_TAX_ZONE_DESC' , 'Wählen Sie die UST Klasse für diese Versandart aus.');

define('BOX_PAYPAL','PayPal');

// SONDERANGEBOTE
define('XTPRICE_SPECIAL_DISCOUNT1','Statt');
define('XTPRICE_SPECIAL_DISCOUNT2','Nur');
define('XTPRICE_SPECIAL_DISCOUNT3','Sie sparen');
define('XTPRICE_SPECIAL_GRADUATED1','UVP');
define('XTPRICE_SPECIAL_GRADUATED2','Ihr Preis');


define('YES_LINKTEXT','Seite aufrufen');
define('ADD_QUICKNOTE','Quick-Notiz anlegen');
define('TEXT_LOADING','Daten werden geladen ... Bitte warten');

define('PRODUCTS_STATUS_1','Auf Lager');
define('PRODUCTS_STATUS_0','Nicht vorr&auml;tig');

define('EBAY_ITEMSPECIFICS_NAME','Titel des Merkmals');
define('EBAY_ITEMSPECIFICS_VALUE','Wert des Merkmals');

define('TEXT_SELECT_ALL','Alle Markieren');
define('TEXT_UNSELECT_ALL','Alle De-Markieren');

define('ENTRY_COMMENT','Kommentar:');

define('TEXT_PRODUCTS_ID','pID');

define('TEXT_MAIN_STORAGE','Stammlager');

define('BUTTON_MAILMASTER_VIEW_REPLY','[Antwort / ansehen]');

define('TEXT_ORDER','Auftrag');
define('TEXT_INVOICE','Rechnung');
define('TEXT_ORDER_SHORT','Re-Nr');
define('TEXT_OFFER','Angebot');
define('TEXT_BRANCH','Filiale');
define('TEXT_BRANCHES','Filialen');
define('TEXT_PRODUCT_GROUPS','Produktgruppen');
define('TEXT_PRODUCT_GROUP','Produktgruppe');
define('TEXT_PRODUCT_GROUP_SETS','Merkmale');
define('TEXT_PRODUCT_GROUP_SET','Merkmal');

define('TEXT_DISTRIBUTOR_ORDER','Lieferantenbestellung');
define('TEXT_PRINT_PACKINGSLIP','Lieferschein drucken');

define('ORDER_PDF_NAME','Rechnung_%s.pdf');

define('TEXT_ORDER_SKONTO','Bei Zahlung innerh. %s Tagen %s%% Skonto:');

// VARIABLEN FUER SYSTEMWEITE FUNKTIONEN
define('YES_TEXT_SQ_CANCEL_AUCTION','Auktion %s: vorzeitig beendet, %s Stk. wieder gutgeschrieben');
define('YES_TEXT_HISTORY_AUCTION_CANCEL','Auktion %s vorzeitig bei Ebay beendet. Bestand wieder gutgeschrieben.');
define('YES_TEXT_MESSAGE_AUCTION_CANCEL_ERROR','Es wurden bereits Gebote auf Auktion %s abgegeben.');
define('YES_TEXT_MESSAGE_NO_AUCTION_FOUND','Keine Auktion gefunden');

define('TEXT_ORDERS_STATUS_OFFER','Angebot');
define('TEXT_ORDERS_STATUS_ALL','Auftrag');
define('TEXT_AUCTION','Auktion');
define('TEXT_FIXEDPRICE','Festpreis');

define('TEXT_DISTRIBUTOR','Lieferant');
define('TEXT_SHIPPER','Versender');

define('TEXT_WEEK','Woche');
define('TEXT_WEEKS','Wochen');
define('TEXT_DAY','Tag');
define('TEXT_MONTH','Monat');
define('TEXT_MONTHS','Monate');
define('TEXT_YEAR','Jahr');
define('TEXT_DAYS','Tage');
define('TEXT_YEARS','Jahre');
define('TEXT_HOUR','Stunde');
define('TEXT_MINUTE','Minute');

define('TEXT_QUANTITY','Anzahl');

define('TEXT_HEADER_NOTICE_UNREAD','<b>%s</b> ungelesene Nachrichten');
define('TEXT_HEADER_NOTICE_TERMIN','Sie haben %s Notiz(en) an die Sie erinnert werden wollten.');
define('TEXT_HEADER_NOTICE_NEW','Neue Notiz');
define('TEXT_HEADER_NOTICE_CLOSE','Schliessen');
define('TEXT_HEADER_MENU_CUSTOMER_GROUPS','Kundengruppen');
define('TEXT_HEADER_MENU_CUSTOMERS','Kunden');
define('TEXT_HEADER_MENU_ORDERS','Auftr&auml;ge');
define('TEXT_HEADER_MENU_OTC','Warenausgabe');
define('TEXT_HEADER_MENU_RECLAMATIONS','Reklamationen');
define('TEXT_HEADER_MENU_RECLAMATIONS_REASONS','Reklamationsgr&uuml;nde');
define('TEXT_HEADER_MENU_RETOURE','Retouren');
define('TEXT_HEADER_MENU_RUECKERSTATTUNGEN','R&uuml;ckerstattungen');
define('TEXT_HEADER_MENU_WARNINGS','Mahnungen');
define('TEXT_HEADER_MENU_LAWYER_EXPORTS','RA Exporte');
define('TEXT_HEADER_MENU_EBAY_FAVORITES','Ebay Favoriten');
define('TEXT_HEADER_MENU_ORDERSCOUNTER','Auftrags-Kasse');
define('TEXT_HEADER_MENU_COUNTER','Scanner-Kasse');
define('TEXT_HEADER_MENU_PAYMENTS_HISTORY','Zahlg.-Eing. Historie');
define('TEXT_HEADER_MENU_PAYPAL_PAYMENTS','Paypal-Zahlungen');
define('TEXT_HEADER_MENU_PAYPAL','Paypal');
define('TEXT_HEADER_MENU_PAYMENTS','Zahlungseingang');
define('TEXT_HEADER_MENU_KASSE_PAYMENTS','Kasse Bezahlarten');
define('TEXT_HEADER_MENU_MODULES_OTHER','Zusatzmodule');
define('TEXT_HEADER_MENU_MODULES_OT','Rechnungsmodule');
define('TEXT_HEADER_MENU_MODULES_PAYMENT','Bezahlmodule');
define('TEXT_HEADER_MENU_DATABASE','Datenbank-manager');
define('TEXT_HEADER_MENU_CONTENT','Contentmanager');
define('TEXT_HEADER_MENU_TEMPLATES','Templates verwalten');
define('TEXT_HEADER_MENU_FILES','Dateimanager');
define('TEXT_HEADER_MENU_DISTRIBUTOR_INVOICE_REASONS','Lieferanten Buchungsklassen');
define('TEXT_HEADER_MENU_DISTRIBUTOR_ORDER_STATUSES','Lieferanten Bestellstatus');
define('TEXT_HEADER_MENU_REVIEWS','Artikelbewertungen');
define('TEXT_HEADER_MENU_SHIPPINGSTATUSES','Lieferstatus');
define('TEXT_HEADER_MENU_SHIPPINGCOSTS','Versandkosten');
define('TEXT_HEADER_MENU_YESCONFIG','YES Konfiguration');
define('TEXT_HEADER_MENU_EBAYAPICART_ADMIN','Sammler verwalten');
define('TEXT_HEADER_MENU_EBAYAPICART','Sammler Produkte');
define('TEXT_HEADER_MENU_EBAYAPITIMINGS','Manuelle Zeitsteuerung');
define('TEXT_HEADER_MENU_EBAYAPIAUTOMATICS','Automatik Zeitsteuerung');
define('TEXT_HEADER_MENU_EBAYAPIRUNNINGS','Laufende Angebote');
define('TEXT_HEADER_MENU_EBAYAPIRELIST','Relist');
define('TEXT_HEADER_MENU_EBAYAPIHIGHBIDDER','Unterlegene Bieter');
define('TEXT_HEADER_MENU_EBAYAPIFAILED','Fehlgeschlagene Angebote');
define('TEXT_HEADER_MENU_EBAYAPIFEEDBACK','Bewertungssystem');
define('TEXT_HEADER_MENU_EBAYAPIUSER','Ebayuser verwalten');
define('TEXT_HEADER_MENU_EBAYAPIEXPORT','Sammler Ex-/Import');
define('TEXT_HEADER_MENU_CATEGORIES','Kategorien/Artikel');
define('TEXT_HEADER_MENU_STORAGES','Lager');
define('TEXT_HEADER_MENU_STORAGEPLACES','Lagerpl&auml;tze');
define('TEXT_HEADER_MENU_STORAGENUMBERS','Lagernummern');
define('TEXT_HEADER_MENU_SPECIALS','Sonderangebote');
define('TEXT_HEADER_MENU_MANUFACTURERS','Hersteller');
define('TEXT_HEADER_MENU_DISTRIBUTORS','Lieferanten');
define('TEXT_HEADER_MENU_DISTRIBUTOR_ORDERS','Lieferanten Bestellungen');
define('TEXT_HEADER_MENU_DISTRIBUTOR_INVOICES','Lieferanten Rechnungen');
define('TEXT_HEADER_MENU_DISTRIBUTOR_ORDERS_PROPOSAL','Bestellvorschl&auml;ge');
define('TEXT_HEADER_MENU_GROUPS','Produktgruppen');
define('TEXT_HEADER_MENU_GROUPS_ALLOCATION','Produktgruppen-Zuweisung');
define('TEXT_HEADER_MENU_BRANCHES','Filialen');
define('TEXT_HEADER_MENU_XSELLS','Cross-Selling');
define('TEXT_HEADER_MENU_STATS_STOCK','Bestands&uuml;bersicht');
define('TEXT_HEADER_MENU_UNITS','Mengeneinheiten');
define('TEXT_HEADER_MENU_MAILMASTER','Mailmaster');
define('TEXT_HEADER_MENU_MAILSEARCH','E-Mailsuche');
define('TEXT_HEADER_MENU_EBAYAPIMESSAGES','Ebay Nachrichten');
define('TEXT_HEADER_MENU_EBAYAPIBESTOFFERS','Ebay Preisvorschl&auml;ge');
define('TEXT_HEADER_MENU_NOTICE','Notizen');
define('TEXT_HEADER_MENU_TEXTITEMS','Textbausteine');
define('TEXT_HEADER_MENU_NEWSLETTER','Rundschreiben');
define('TEXT_HEADER_MENU_MAILACCOUNTS','E-Mail Konten');
define('TEXT_HEADER_MENU_MODULES_EXPORT','Export-Module');
define('TEXT_HEADER_MENU_ONIX','ONIX Produktimport');
define('TEXT_HEADER_MENU_NEDIS','Nedis Produktimport');
define('TEXT_HEADER_MENU_UMBREIT','Umbreit Produktimport');
define('TEXT_HEADER_MENU_STATS_PRODUCTS_VIEWED','Besuchte Artikel');
define('TEXT_HEADER_MENU_STATS_PRODUCTS_PURCHASED','Verkaufte Artikel');
define('TEXT_HEADER_MENU_STATS_CUSTOMERS','Kunden/Bestellstatistik');
define('TEXT_HEADER_MENU_STATS_SALES_REPORT','Umsatzstatistik');
define('TEXT_HEADER_MENU_STATS_AUCTIONS','Ebay Abverk&auml;ufe');
define('TEXT_HEADER_MENU_STATS_EBAYSELLING','Einstellvolumen');
define('TEXT_HEADER_MENU_STATS_COUNTER','Kassenstatistik');
define('TEXT_HEADER_MENU_STATS_STOCK_OVERVIEW','Bestell&uuml;bersicht');
define('TEXT_HEADER_MENU_STATS_RECLAMATIONS','Reklamationen');
define('TEXT_HEADER_MENU_STATS_RECLAMATIONS_PRODUCTS','Reklamationsartikel');
define('TEXT_HEADER_MENU_STATS_SHIPPINGS','Versand');
define('TEXT_HEADER_MENU_STATS_WHOISONLINE','Aktuell Online');
define('TEXT_HEADER_MENU_STATS_CARTS','Warenk&ouml;rbe');
define('TEXT_HEADER_MENU_EVENT_TICKETS','Event Tickets');
define('TEXT_HEADER_MENU_EVENTS','Events');

define('TEXT_HEADER_MENU_SHIPPING','Versandabwicklung');
define('TEXT_HEADER_MENU_SHIPPING_HISTORY','Versandhistorie');
define('TEXT_HEADER_MENU_MAILARCHIVE','E-Mailarchiv');

define('TEXT_HEADER_MENU_PROCUREMENT','Auftragswesen');
define('TEXT_HEADER_MENU_PROCUREMENT_HTML5','Aufträge');

define('TEXT_HEADER_MENU_EBAYSELLING','Marktplätze');
define('TEXT_HEADER_MENU_SHIPMENT','Versand');
define('TEXT_HEADER_MENU_WAREHOUSE','Lager/Katalog');
define('TEXT_HEADER_MENU_TOOLS','Tools');
define('TEXT_HEADER_MENU_TOOLS_HTML5','Tools');

define('TEXT_HEADER_MENU_STATS','Statistiken');
define('TEXT_HEADER_MENU_CONFIG','Konfiguration');
define('TEXT_HEADER_MENU_ADMIN','Verwaltung');
define('TEXT_HEADER_MENU_TOP_COUNTER','Kasse');
define('TEXT_HEADER_MENU_GASTRO','Gastro Verwaltung');
define('TEXT_HEADER_MENU_CASHIER','Verk&auml;ufer Verwaltung');
define('TEXT_HEADER_MENU_PACKAGINGS','Verpackungen');

define('TEXT_HEADER_MENU_SHIPPING_DAILY_OTC','Versandscan');
define('TEXT_HEADER_MENU_COUPON','Kupons');
define('TEXT_HEADER_MENU_STATS_EBAYUSER','Ebay Käufer');

define('TEXT_HEADER_MENU_VPE','Verpackungseinheiten');
define('TEXT_HEADER_MENU_PRODUCTS_NOTIFICATIONS','Artikelbenachrichtigungen');
define('TEXT_HEADER_MENU_PRODUCTS_CONDITIONS','Artikelzust&auml;nde');
define('TEXT_HEADER_MENU_CALENDAR','Kalender');


define('TEXT_HEADER_CUSTOMERNAME','Kunde');
define('TEXT_HEADER_PRODUCT','Artikel');
define('TEXT_HEADER_FEEDBACK','Feedback/Anfrage/Bugs');
define('TEXT_HEADER_SEARCH_PRODUCTS','Artikelsuche');
define('TEXT_HEADER_SEARCH_INTRO','Durchsucht die Artikel nach folgenden Feldern: pID, Produktname, Artikelnummer, EAN, MPN, Lieferantennummer, Ebaytitel und Extratext');
define('TEXT_HEADER_SEARCH_CUSTOMERS','Kundensuche');
define('TEXT_HEADER_SEARCH_CUSTOMERS_INTRO','Suche in Firma, E-Mail und Ebay-Name');
define('TEXT_HEADER_SEARCH_CUSTOMERS_NAME_PAIR_INTRO','Suche nach Vorname+Nachname');
define('TEXT_HEADER_SEARCH_CUSTOMERS_CITY_INTRO','Suche nach PLZ/Ort');
define('TEXT_HEADER_MENU_TOOLS_COUPON_ORDERS','Eingelöste Kupons');
define('TEXT_HEADER_MENU_TAGESABSCHLUSS','Tagesabschluss');

define('TEXT_PRODUCT_IS_MASTER','Dieses Produkt ist ein Parent');

define('HISTORY_FIBUNUMBER_AUTOMATIC_ADD','Mit dem Statuswechsel wurde automatisch die FiBu Nummer %s für diesen Auftrag generiert.');

define('TEXT_RECLAMATION_SHIPPING_STATUS_0','Noch nicht im Versand');
define('TEXT_RECLAMATION_SHIPPING_STATUS_1','Im Versandmodul/Initiiert');
define('TEXT_RECLAMATION_SHIPPING_STATUS_2','Versand abgeschlossen');
define('TEXT_NO_EDIT_USER_KASSE','Kunde Kasse darf nicht editiert werden.');

define('QUICKSEARCH_PREFIX','Schnellsuche');
define('TEXT_SYSTEM_ALERTS','Systemmeldung');
define('IMAGE_CRM','CRM');

define('JS_CONFIRM_REALLY_DELETE_ITEMS','Ausgewählte Datensätze wirklich löschen?');

define('TEXT_SORT_ASC','Aufsteigend');
define('TEXT_SORT_DESC','Absteigend');

define('BUTTON_IMPORT','Import');

define('MSG_ERROR_NO_EBAY_DEFAULT_CATEGORY','Keine Default Ebaykategorie gespeichert.');
define('MSG_ERROR_NO_CONDITIONS_FOR_CATEGORY','Ebaykategorie %s bietet keine Zustandsauswahl');

define('TEXT_CATEGORY_ITEMCONDITIONS_NOT_SAVED','Unbekannt');
define('TEXT_CATEGORY_ITEMCONDITIONS_NOT_SET','Kein');
define('TEXT_NUMBER_OF_SHIPPINGMETHODS_LINK','%s Versandmethoden');
define('TEXT_SELECT_SHIPPINGMETHODS','Versandmethoden ausw&auml;hlen');

define('TEXT_MESSAGESTACK_SHOW_ALL','Alle Meldungen anzeigen');
define('TEXT_MESSAGESTACK_HIDE_ALL','Alle Meldungen ausblenden');

/**
 * AMAZON
 */
define('TEXT_AMAZON_SKU','Amazon SKU');
define('TEXT_AMAZON_QUANTITY','Amazon Bestand');
define('TEXT_AMAZON_PRICE_BRUTTO','Amazon VK Preis');
define('TEXT_AMAZON_PLEASE_WAIT','Kontaktiere Amazon API ...');
define('TEXT_ADD_TO_AMAZON','Artikel in Amazon Integrieren');
define('TEXT_UPDATE_AMAZON','Gespeicherte Artikel Amazon-Konfiguration');
define('TEXT_UPDATE_AMAZON_INTRO','Beim Speichern werden die ge&auml;nderten Daten in der lokalen Datenbank sowie bei Amazon aktualisiert.');
define('TEXT_NO_AMAZON_ASIN','<i>Noch nicht vergeben.</i>');

define('MSG_OPEN_AMAZON_FULFILLMENTS','Es m&uuml;ssen %s Versandbest&auml;tigungen Amazon gemeldet werden. %s');

define('BUTTON_STORAGE_ADMIN','Lagerorte');

define('INTRO_UPSELLING_END', 'Auftr&auml;ge im Status Upselling k&ouml;nnen durch den Ebayk&auml;ufer in der Kaufabwicklung oder durch eBay (Kombinieren) ge&auml;ndert werden und d&uuml;rfen deshalb nicht bearbeitet werden.');
define('INTRO_UPSELLING_END2', 'Um den Auftrag zu bearbeiten, muss der Status gewechselt werden. Dadurch kann der Ebayk&auml;ufer NICHT mehr die YES interne Kaufabwicklung durchlaufen, ebenso kann das kombinieren seitens eBay nicht mehr verarbeitet werden.');
define('START_UPSELLING_END', 'Auftrag auf Status Offen setzen');

define('TXT_PM_PayPal', 'PayPal');
define('TXT_PAYPAL_ADDRESS', 'PayPal E-Mail Adresse des Shops');

define('TEXT_PRODUCTS_HISTORY','Historie');
define('SUBJECT_SEND_FEEDBACK_MAIL','Vielen Dank - Ihr Auftrag Nr. %s');

define('PAYMENT_CONFIRMATION_EMAIL_SUBJECT','Zahlung zu Auftrag Nr %s erhalten');

define('TEXT_ADMINCART_CONTENT','Der Warenkorb des Kunden enth&auml;lt:');
define('TEXT_ADMINCART_PRODUCT','Artikel');
define('TEXT_ADMINCART_SUMME','Summe');
define('TEXT_ADMINCART_PLUS','Menge erhöhen');
define('TEXT_ADMINCART_MINUS','Menge verringern');

define('JS_CONFIRM_ADMINCART_DELETE_ITEM','Wollen Sie den Artikel wirklich aus dem Warenkorb entfernen?');

define('TEXT_PRINT','Drucken');
define('TEXT_VIEW','Anzeigen');
define('JS_MISSING_PERMISSION','Sie haben keine Berechtigung für den Prozess %s');
define('TEXT_OFFERCONFIRM','Auftragsbestätigung');
define('TEXT_BOOKING','Buchhaltung');
define('TEXT_RUECKERSTATTUNG','Rückerstattung');
define('TEXT_RETOURE','Retoure');
define('TEXT_RECLAMATION','Reklamation');
define('TEXT_OTC','Warenausgabe');
define('TEXT_CUSTOMER','Kunde');
define('TEXT_CRM','CRM');
define('TEXT_NEW_ORDER','Neuer Auftrag');
define('TEXT_NEW_OFFER','Neues Angebot');
define('TEXT_PRODUCT','Artikel');
define('TEXT_XSELL','Cross Marketing');
define('TEXT_SHOP_PREVIEW','Shop Vorschau');
define('TEXT_EBAY_PREVIEW','eBay Vorschau');
define('TEXT_PRODUCTS_QUANTITY_INPUT','Bestandseingabe');
define('TEXT_PRODUCTS_QUANTITY_DETAILS','Bestandsdetails');
define('TEXT_MASTER_SLAVE','Parent/Child Verwaltung');

define('TXT_PER',' pro ');

define('IMAGE_CONFIRM_YES','Ja');
define('IMAGE_CONFIRM_NO','Nein');
define('CONFIRM_CREATE_NEW_ORDER','Möchten Sie wirklich einen Auftrag zur Auftrags-Kasse erstellen?');
define('CONFIRM_TAGESABSCHLUSS','Kasse Tagesabschluss durchführen?');
define('TEXT_DIALOG_CONFIRMATION','Aktion bestätigen');

define('TEXT_PROPERTIES','Artikeleigenschaften');

define('TEXT_PRODUCTS_QUANTITY_SHIPPED','Anzahl bereits versendeter Artikel.');
define('TEXT_PRODUCTS_QUANTITY_NOT_SHIP','Anzahl Artikel die noch nicht versendet werden sollen.');

define('TEXT_PART_ORDER','Zu diesem Auftrag gab es bereits Teillieferungen');
define('TEXT_NOT_SHIP_PRODUCTS_IN_ORDER','In diesem Auftrag gibt es Artikel die von der Versandabwicklung ausgeschlossen sind.');

define('MSG_OPEN_EBAY_MESSAGES','Sie haben %s ungelesene eBay Benachrichtigungen.');
define('MSG_OPEN_EBAY_WARNINGS','Sie haben %s ungelesene eBay Warnungen.');

define('YES_HELP_CLUETIP_TITLE','YES Hilfesystem');

define('TEXT_STORAGE','Lager');

define('TEXT_PRODUCT_SHIPPINGINFO_QTY','Bestellt');
define('TEXT_PRODUCT_SHIPPINGINFO_QUANTITY_SHIPPED','Geliefert');
define('TEXT_PRODUCT_SHIPPINGINFO_NOT_SHIP','Rest');
define('TEXT_PART_DELIVERY','Teillieferung');

define('TEXT_ALL_CARTS','Alle Sammler');

define('TEXT_LOG_EXCEPTION','Es ist ein Fehler aufgetreten.');
define('TEXT_LOG_EXCEPTION_DESC','Beim Aufrufen der von Ihnen gew&uuml;nschten Seite, kam es zu einem Fehler. Das Team von <b>YES websolutions</b> wurde automatisch benachrichtigt. Wir werden versuchen den Fehler so schnell wie m&ouml;glich zu beheben.');
define('TEXT_LOG_EXCEPTION_REFRESH','Um auf die Startseite weitergeleitet zu werden, bitte %s klicken.');
define('TEXT_LOG_EXCEPTION_REFRESH_HERE','hier');

define('TEXT_DEFAULT_CATEGORY','Default Kategorie');

define('BUTTON_YES_PAYMODULE_UPDATE_PRODUCTS_PRICES_FROM_CART','Sammlerpreise synchronisieren');
define('TEXT_YES_PAYMODULE_UPDATE_PRODUCTS_PRICES_FROM_CART_INTRO','M&ouml;chten Sie die Preise der Festpreis-Angebote des Sammlers &raquo;%s&laquo; auf die Kundengruppenpreise der Artikel &uuml;bertragen?');
define('TEXT_YES_PAYMODULE_UPDATE_PRODUCTS_PRICES_FROM_CART_CUSTOMERS_STATUS','F&uuml;r welche Kundengruppe sollen die Preise der Sammlerprodukte gelten?');
define('YES_PAYMODULE_UPDATE_PRODUCTS_PRICES_FROM_CART_HISTORY_CART','Preis Synchronisation: pID %s wurde aktualisiert - Preis: %s / Kundengruppe: %s');
define('YES_PAYMODULE_UPDATE_PRODUCTS_PRICES_FROM_CART_HISTORY_PRODUCT','Preis Synchronisation: Aus SammlerID %s wurde der Preis %s übernommen / Kundengruppe: %s');
define('MSG_SUCCESS_YES_PAYMODULE_UPDATE_PRODUCTS_PRICES_FROM_CART','Die Sammlerpreise wurden synchronisiert');

define('BUTTON_QUICK_PRODUCT_ADD','Artikel Schnellerfassung');
define('BUTTON_PRINT_PACKINGSLIP_ALLPRODUCTS','Gesamtlieferschein drucken');

define('TEXT_EBAY_RETURNSWITHINCODE','eBay Rücknahmebedingungen Zeitraum');
define('TEXT_EBAY_SHIPPINGCOSTPAIDBY','eBay Rücksendekosten trägt');

define('TEXT_SHIPPINGCOSTPAIDBY_SELLER','Verkäufer');
define('TEXT_SHIPPINGCOSTPAIDBY_BUYER','Käufer');
define('TEXT_SHIPPINGCOSTPAIDBY_EUBuyer_CancelRightsUnder40','Widerruf: Käufer trägt die Rücksendekosten wenn WW unter 40 EUR');
define('TEXT_SHIPPINGCOSTPAIDBY_EUSeller_CancelRights','Widerruf: Verkäufer trägt die Rücksendekosten');
define('TEXT_SHIPPINGCOSTPAIDBY_EUSeller_ReturnRights','Rückgabe: Verkäufer trägt die Rücksendekosten');

define('TEXT_ORDER_COSTS_SHIPPING_TITLE','Reale Versandkosten');

define('TEXT_STATUS','Status:');
define('TEXT_CREATE_PDF','PDF erzeugen');
define('TEXT_QTY_STAMMLAGER','Artikelbestand in Stammlager (Phys)');
define('TEXT_QTY_AV1','Verfügbarer Artikelbestand 1');
define('TEXT_QTY_AV2','Verfügbarer Artikelbestand 2');
define('TEXT_QTY_STAMMLAGER_SHORT','Stammlager');
define('TEXT_QTY_AV1_SHORT','V1');
define('TEXT_QTY_AV2_SHORT','V2');
define('TEXT_QTY_STUECKLISTEN','Artikelbestand St&uuml;cklistenartikel');
define('TEXT_SPECIAL','Sonderangebot');
define('TEXT_EBAY_USERID','eBay ID');
define('TEXT_EMAIL','Email');
define('TEXT_CID_SHORT','Kd-Nr.');
define('TEXT_CONDITION','Zustand');
define('TEXT_YES_EXPORT_MODULES_TYPE_INT','Zahl');
define('TEXT_YES_EXPORT_MODULES_TYPE_SHORT_TEXT','Kurztext (max 32 Zeichen)');
define('TEXT_YES_EXPORT_MODULES_TYPE_LARGE_TEXT','Freitext');
define('TEXT_YES_EXPORT_MODULES_TYPE_TEXT','Text (max. 255 Zeichen)');
define('TEXT_YES_EXPORT_MODULES_TYPE_DATE','Datum');
define('TEXT_YES_EXPORT_MODULES_TYPE_PRICE','Preis');
define('TEXT_YES_EXPORT_MODULES_TYPE_BOOL','Wahr/Falsch');
define('TEXT_YES_EXPORT_MODULES_TYPE_SELECT','Auswahlliste');
define('TEXT_YES_EXPORT_MODULES_TYPE_FLOAT','Gleitkommazahl');
define('TEXT_YES_EXPORT_MODULES_TYPE_IMAGE','Artikelbild');
define('TEXT_MANDATORY','Pflichtfeld');
define('MSG_AMAZON_ORDERS_TO_COMBINE','Es sind kombinierbare Amazonauftr&auml;ge vorhanden. %s');
define('BOX_WISHLIST','Merkzettel');       // wishlist2.2
define('TEXT_DISPLAY_NUMBER_OF_WISHLISTS', 'Angezeigt werden <b>%d</b> bis <b>%d</b> (von insgesamt <b>%d</b> Merkzetteln)');  // wishlist2.2
define('TEXT_SCROLL_PAGE_UP','Zum Seitenanfang');
define('TEXT_ORDERS_SOURCE','Auftragsherkunft');
define('TEXT_ORDERS_SOURCE_COUNTER','Kasse');
define('TEXT_ORDERS_SOURCE_ADMIN','Kundendienst');
define('TEXT_PACKAGING_COSTS','Verpackungskosten');
define('MSG_AMAZON_UPDATE_QTY','Anzahl bei Amazon wurde aktualisiert von %s zu %s');
define('TEXT_ORDERS_MARGE_SAVED','Der Deckungsbeitrag wurde mit Wert %s gespeichert.');
define('TEXT_MARGE_DIFF','Deckungsbeitrag');
define('YES_TEXT_HISTORY_AUCTION_ALWAYS_CANCELLED','Die Auktion %s ist bereits beendet und kann nicht erneut beendet werden.');
define('YES_TEXT_HISTORY_UNKNOWN_AUCTION_VARIATION','Zur Auktion %s wurde keine Variante mit der pID %s gefunden.');
define('REVISE_ITEM_QUANTITY_ERROR','Die Anzahl der Auktion %s konnte nicht in %s ge&auml;ndert werden, nicht genug Bestand.');
define('REVISE_VARIATION_ITEM_PRODUCTS_HISTORY','Revise der Variante in Auktion %s auf %s Stk.');
define('REVISE_ITEM_QTY_SUCCESFUL','Die Anzahl der Auktion %s wurde zu %s ge&auml;ndert.');
define('REVISE_VARIATION_ITEM_QTY_SUCCESFUL','Die Anzahl der Variante pID %s in Auktion %s wurde zu %s ge&auml;ndert.');

define('TEXT_ERROR_AUCTION_VARIATION_EXISTS','Der Artikel mit pID %s ist bereits Teil des Variantensets');
define('TEXT_ERROR_PRODUCTS_ID_NOT_EXISTS','Es existiert kein Artikel mit der pID %s');
define('TEXT_ERROR_PRODUCT_HAS_COLLIES','Der Artikel mit der pID %s ist ein Stücklistenartikel und kann nicht verwendet werden.');
define('TEXT_ERROR_PRODUCT_HAS_NO_AV2_QTY','Der Artikel mit der pID %s hat keinen Bestand (V2)');
define('TEXT_ERROR_PRODUCT_HAS_NOT_ENOUGH_AV2_QTY','Der Artikel mit der pID %s hat nur einen Bestand (V2) von %s Stk');
define('TEXT_SQ_NEW_VARIATION_AUCTION','Als Variante zur Auktion %s gespeichert. %s Stk');
define('TEXT_SQ_DELETED_VARIATION_AUCTION','Die Variante zur Auktion %s wurde gelöscht. %s Stk');

define('TEXT_PRODUCTS_IMG_STATUS_INACTIVE','Artikelstatus (Webshop) ist deaktiviert und ');
define('TEXT_PRODUCTS_IMG_STATUS_ACTIVE','Artikelstatus (Webshop) ist aktiv und ');
define('TEXT_PRODUCTS_IMG_LISTING_STATUS_INACTIVE',' in Shopkategorien deaktiviert');
define('TEXT_PRODUCTS_IMG_LISTING_STATUS_ACTIVE',' in Shopkategorien aktiviert');

define('YES_PAYMODULE_PRODUCTS_FAKE_SETS_BUTTON_EDIT','Fake Sets');
define('YES_PAYMODULE_PRODUCTS_FAKE_SETS_TEXT_LEGEND','Legen Sie fest welche Artikelnummern mit welcher Menge zum Produkt gespeichert sind.');
define('YES_PAYMODULE_PRODUCTS_FAKE_SETS_TEXT_ARTNR','Externe Artikelnummer');
define('YES_PAYMODULE_PRODUCTS_FAKE_SETS_TEXT_QUANTITY','Externe Menge');
define('YES_PAYMODULE_PRODUCTS_FAKE_SETS_TEXT_SUCCESS','Fake Sets zum Artikel wurden aktualisiert.');
define('MSG_OPEN_PRODUCTS_EMAIL_NOTIFICATIONS','Es k&ouml;nnen zu %s wieder verf&uuml;gbaren Artikeln Emailbenachrichtigungen versendet werden. %s');
define('AMAZONUSER_COUNTER_NO_ACCOUNTS','Sie haben keine Amazon Accounts zur Verf&uuml;gung. Diese m&uuml;ssen durch das YES Team freigeschaltet werden.');

define('MODULE_ATTACHMENTS_BUTTON','Attachments');
define('MODULE_ATTACHMENTS_HEADING_TITLE','Attachments verwalten');
define('MODULE_ATTACHMENTS_ADD_FILE','Neues Attachment hinzufügen');
define('MODULE_ATTACHMENTS_FILES','Folgende Attachments sind gespeichert:');
define('JS_REALLY_DELETE_ATTACHMENT','Attachment wirklich löschen?');
define('IMAGE_REDEEM_GIFT','Kupon einlösen');
define('ERROR_NO_INVALID_REDEEM_GV','Der Kuponcode "%s" ist nicht verwendbar.');
define('REDEEMED_AMOUNT','Kuponwert ');
define('ERROR_INVALID_STARTDATE_COUPON','Der Kupon kann noch nicht verwendet werden (Startdatum).');
define('ERROR_INVALID_FINISDATE_COUPON','Der Kupon ist abgelaufen.');
define('ERROR_INVALID_USES_COUPON','Der Kupon wurde bereits %sx eingelöst. (abgelaufen)');
define('ERROR_INVALID_USES_USER_COUPON','Der Kupon wurde vom Kunden schon %sx verwendet');
define('ERROR_COUPON_TYPE_S_NOT_IN_ADMIN','Versandkostenkupons können nicht über die Scannerkasse eingelöst werden');
define('REDEEMED_COUPON','Der Kupon wurde erfolgreich eingelöst');
define('TEXT_BRANCHES_TOTAL_QUANTITY','Gesamtbestand in Filialen');
define('TEXT_PRODUCTS_DATE_AVAILABLE_SHORT','Verf&uuml;gbar ab');
define('TEXT_PRODUCTS_DATE_AVAILABLE_SUPER_SHORT','Verf. ab');
define('EBAY_EAN_UNKNOWN_IDENTIFIER_GERMAN','Nicht zutreffend');
define('EBAY_EAN_UNKNOWN_IDENTIFIER_ENGLISH','Does not apply');
define('TEXT_PACKAGING','Verpackung');
define('TEXT_PRODUCTS_MODEL','Art.-Nr.');
define('TEXT_MANUFACTURER', 'Hersteller');
define('TEXT_MPN_LONG', 'Hersteller Nummer');
define('TEXT_PRODUCT_HAS_COLLIES','Dieser Artikel enth&auml;lt die folgenden Collis');
define('TEXT_ORDER_NETTO_SUBTEXT','Netto-Rechnung - Steuerfreie Ausfuhr gem. §4 Ziffer 1A des Umsatzsteuergesetzes');
define('TEXT_EBAY_SELLER_PROFILE_SHIPPING_ID','Seller Rahmenbedingungen: Versand ID');
define('TEXT_EBAY_SELLER_PROFILE_PAYMENT_ID','Seller Rahmenbedingungen: Bezahlarten ID');
define('TEXT_EBAY_SELLER_PROFILE_RETURN_POLICY_ID','Seller Rahmenbedingungen: Rücknahmebedingungen ID');

define('TEXT_EPO_MESSAGES','eBay Return Nachrichten');
define('TEXT_EPO_MESSAGES_INTRO','Verwalten Sie die Aktionen zu den offenen Kundenanfragen in Ihrem eBay Sellerkonto.');
define('TEXT_STATS_STATUS_FILTER','Filtereinstellungen');
define('TEXT_SEARCH_FILTER','Einstellungen zur Suche');
define('TEXT_EXTENSION_NOT_INSTALLED','Diese Erweiterung ist nicht installiert. Kontaktieren Sie das Team von yes4trade um weitere Informationen zu erhalten');
define('TEXT_SHIPPING_TRACKING_IDS','Trackingnummer(n)');
define('TEXT_ORDER_EBAY_SPERRE','Der eBay Auftrag ist erst vor unter einer Stunde angelegt worden.');
define('TEXT_ADD_EVENT_PRODUCT','Als Event Speichern');
define('TEXT_EVENT_PRODUCT','Event Artikel');
define('TEXT_EVENT_DATE','Event Datum');
define('TEXT_EVENT_DATE_TIMER_AVAILABLE_QUANTITY','Verf. Event Plätze');
define('MSG_ERROR_ORDERS_EDIT_EVENT_PRODUCTS_QUANTITY','Es sind nur %s freie Plätze für den Event Artikel verfügbar');
define('TEXT_EVENT_HAS_NO_DATES_AVAILABLE','Keine Event Plätze');
define('MSG_ERROR_EVENT_PRODUCT_MISSING_PARAMS','Artikel pID %s ist ein Eventartikel und wurde ohne entsprechende Parameter übergeben');
define('JS_ALERT_SELECT_EVENT_DATE_TIMER_ID','Bitte wählen Sie Datum und Uhrzeit des Event Artikels');
define('TEXT_EVENT_PERSONS','Personen');
define('JS_ALERT_SELECT_EVENTS_TO_EVENT_TICKETS_ID','Bitte wählen Sie ein Event Ticket');
define('PRODUCTS_STORAGE_COMMENTS','Lager Hinweis');
define('MSG_UNKNOWN_PAYPAL_TXN_NOTIFICATIONS','Es liegen %s unbekannte Zahlungen im Paypalkonto vor. %s');
define('TEXT_HEADER_MENU_SECUPAY_CAPTURE_ERROR','Fehlgeschl. Secupay');
define('MSG_ERROR_DELETE_PRODUCTS_MAXIMUM','Es k&ouml;nnen maximal %s Artikel gel&ouml;scht werden. Beim l&ouml;schen dieser Kategorie w&uuml;rden aber %s Artikel betroffen sein.');
define('MSG_ERROR_DELETE_PRODUCTS_ERRORS','Artikel wurden ermittelt die nicht gel&ouml;scht werden d&uuml;rfen');
define('DELETE_PRODUCTS_CHECK_INTRO','Pr&uuml;fung ob Artikel gel&ouml;scht werden d&uuml;rfen');
define('JS_REALLY_DELETE_MANUFACTURER_PRODUCTS','Artikel dieses Lieferanten wirklich unwiderruflich Löschen?');
define('TEXT_READ_LATER','Systemmeldungen ausblenden/später lesen');
define('TEXT_NOTICE_READ_LATER','Notizen ausblenden/später lesen');
define('TEXT_READ_LATER_INTRO','Die Systemmeldungen sind anschliessend auf der YES Admin Startseite wieder abrufbar. Nach einer Stunde oder einem Logout werden die ungelesenen Systemmeldungen erneut angezeigt.');
define('TEXT_MARK_SYSTEMMESSAGE_AS_READ','Als gelesen markieren');
define('TEXT_SYSTEMMESSAGES','Systembenachrichtigungen');
define('TEXT_NOTIZEN_TERMINE','Terminierte Notizen');
define('TEXT_SYSTEMMESSAGES_REACTIVATE','Sie haben YES Systembenachrichtigungen ausgeblendet, hier haben Sie die M&ouml;glichkeit diese wieder anzeigen zu lassen');
define('TEXT_NOTIZEN_TERMINE_REACTIVATE','Sie haben terminierte Notizen ausgeblendet, hier haben Sie die M&ouml;glichkeit diese wieder anzeigen zu lassen');
define('TEXT_SYSTEMMESSAGES_SHOW','Anzeigen');
define('MSG_SHIPPING_EMAILS_TO_SEND','Es k&ouml;nnen %s Versandbest&auml;tigungs-Emails gesendet werden.');
define('MSG_SHIPPING_SPINV_SEND_CAPTURE','Es können %s Versandmeldungen an Secupay gemeldet werden');
define('MSG_EBAY_COMPLETESALES_PREVIEW','eBay Versandmeldungen zu %s Auftr&auml;gen verf&uuml;gbar.');
define('TEXT_HEADER_MENU_SHIPPING_MODULES','Versandmodule');
define('ERROR_CUSTOMERS_STATUS_GUEST_NOT_ALLOWED_TO_CREATE_NEW_ORDER','Zur Kundengruppe Gast darf kein neuer Auftrag erzeugt werden');
define('TEXT_ORDER_ALLOCATION_ALLOCATE_USER','Email dem Kundenkonto des Auftrags zuweisen');
define('TEXT_ORDER_ALLOCATION_UNALLOCATE_INFO','Wird keine Auftragsnummer angegeben, werden die Zuweisungen dieser Email automatisch entfernt');
define('TEXT_PRODUCTREFERENCEID','ePid (eBay Produkt ID)');
define('TEXT_HEADER_MENU_HITMEISTER','Kaufland');
define('HISTORY_PRODUCTS_MO_IMAGE_UPLOAD','Weiteres Artikelbild %s wurde gespeichert.');
define('TEXT_AMAZON_INVOICE_UPLOAD','Rechnung Upload');
define('TEXT_AMAZON_INVOICE_UPLOAD_STATUS_0','Noch nicht gestartet');
define('TEXT_AMAZON_INVOICE_UPLOAD_STATUS_1','In Warteschleife');
define('TEXT_AMAZON_INVOICE_UPLOAD_STATUS_2','Abgeschlossen');
define('TEXT_AMAZON_INVOICE_UPLOAD_STATUS_3','Fehlgeschlagen');
define('MSG_ERROR_ITEMADDPROCESS_STUECKLISTEN_NOT_ALLOWED','Stücklistenartikel können nicht in Variantenauktionen verwendet werden');
define('MSG_OPEN_EMAIL_STAFF_ALLOCATIONS','Es gibt %d Benachrichtigungen in Ihren zugewiesenen Emails');
define('MSG_OPEN_REAL_ORDERS','Es sind %d nicht importierte Kaufland Aufträge vorhanden.');
define('MSG_SHIPPING_HITMEISTER_FULFILLMENT_SEND','Es können %d Kaufland Aufträge als Versendet gemeldet werden.');
define('JS_ERROR_NO_MAILBODY','Email hat keinen Inhalt.');
define('TEXTITEMS_CUSTOMER_SHOPPING_CART','Warenkorb Inhalt des Kunden');
define('TEXTITEMS_CUSTOMER_SHOPPING_CART_NUMBER_OF_ITEMS','Ihr Warenkorb enthält %d Artikel');
define('TEXT_HEADER_MENU_DHL_API','DHL Label Historie');
define('MSG_EBAY_SPECIALS_PRICE_REVISE_DEACTIVATE','Sonderangebote abgelaufen: Es müssen %d eBay Auktionen aktualisiert werden.');
define('MSG_EBAY_SPECIALS_PRICE_REVISE_ACTIVATE','Sonderangebote aktualisieren: Es müssen %d eBay Auktionen aktualisiert werden.');
define('SPECIALS_REVISE_JOB_EXISTS','Es sind unverarbeitete Revise Daten für eBay Sonderangebote vorhanden. Diese müssen erst abgearbeitet werden.');
define('MSG_EBAY_LMS_SPECIALS_REVISE_EXPIRED','Sonderangebote sind abgelaufen, zu %d Auktionen m&uuml;ssen Preis&auml;nderungen gesendet werden. %s');
define('MSG_EBAY_LMS_SPECIALS_DATAFILE_UPLOAD','Datei mit Daten f&uuml;r eBay steht bereit zum Verarbeiten. %s');
define('MSG_EBAY_LMS_SPECIALS_AUCTIONS_AVAILABLE','Zu %d Auktionen m&uuml;ssen Sonderangebot Preis&auml;nderungen an eBay gesendet werden. %s');
define('MSG_EBAY_LMS_SPECIALS_AUCTIONS_AVAILABLE_DEREVISE','Zu %d Auktionen m&uuml;ssen abgelaufene Sonderangebot Preis&auml;nderungen an eBay gesendet werden. %s');
define('MSG_EBAY_LMS_SPECIALS_AUCTIONS_UPLOAD_FILES_AVAILABLE','Es liegen %d Dateien bereit die an eBay gesendet werden m&uuml;ssen um Sonderangebotspreise zu synchronisieren. %s');
define('BUTTON_WEMALO_NOT_SUBMITTED_LIST','Daten an wemalo senden');
define('MSG_WEMALO_SUBMIT_LIST','Es können %d Versandmeldungen an Wemalo gesendet werden.');
define('WEMALO_SUBMIT_INTRO','Die folgenden Versandauftr&auml;ge werden an Wemalo gemeldet. Sobald Wemalo diese als Versendet gemeldet hat, erhalten Sie eine Benachrichtigung.');
define('BUTTON_WEMALO_SEND_NOW','Als Versendet melden');
define('MSG_WEMALO_ORDERS_SUBMITTED','Die Versanddaten wurden an Wemalo gesendet.');
define('BUTTON_WEMALO_CHECK_STATUS','Status prüfen');
define('MSG_WEMALO_SUBMITTED_ORDERS_CHECK','Es sind %d Versanddatensätze bei Wemalo gemeldet die geprüft werden können.');
define('TEXT_ALLOW_SHIPPING_EBAY_1_HOUR','Versandsperre 1 Stunde');
define('INTRO_ALLOW_SHIPPING_EBAY_1_HOUR','Bei eBay Aufträgen wird für die Dauer von 1 Stunde verhindert, dass diese im Versandmodul verfügbar sind. Sie können diese Sperre hier manuell für diesen Auftrag abschalten.');
define('BUTTON_TOGGLE_ALLOW_SHIPPING_EBAY_1_HOUR','Versandsperre deaktivieren');
define('TEXT_TOGGLE_ALLOW_SHIPPING_EBAY_1_HOUR_REST_DURATION','Noch %d Minuten gesperrt');
define('CONFIRM_TOGGLE_ALLOW_SHIPPING_EBAY_1_HOUR_REST_DURATION_ACTIVE','eBay 1 Stunden Versandsperre entfernen? Auftrag wird im Versandmodul verfügbar gemacht.');
define('CONFIRM_TOGGLE_ALLOW_SHIPPING_EBAY_1_HOUR_REST_DURATION_INACTIVE','eBay 1 Stunden Versandsperre wieder aktivieren? Auftrag ist nicht mehr im Versandmodul verfügbar bis zum Ablauf der Stunde.');
define('ALLOW_SHIPPING_EBAY_1_HOUR_UPDATED','eBay 1 Stunden Versandsperre des Auftrags wurde aktualisiert');

define('MSG_SUCCESS_CATEGORY_COPY','Kategorie wurde kopiert.');
define('TEXT_CATEGORY_COPY','Kategoriestruktur Kopieren');
define('TEXT_COPY_CATEGORY_INTRO','Beim kopieren der Kategoriestruktur, werden Beschreibungen (alle installierten Sprachen) sowie evtl. vorhandene Kategorie/Produktgruppenzuweisungen <b>inkl. aller Unterkategorien</b> kopiert. Dabei werden <b>keine Artikel</b> kopiert.');
define('TEXT_BRANCHES_COUNTER','Filialkasse');
define('TEXT_BRANCHES_COUNTER_MAIN','Filialkasse Stammlager');
define('TEXT_FIBU_SHORT','FiBu');
define('NO_TAX_CLASS_ALLOCATION','Keine Steuerklasse Zuweisung vorhanden');
define('NO_TAX_CLASS_ALLOCATION_INTRO','Hinterlegen Sie Steuerklassen in der Artikelbearbeitung "Preise" oder weisen Sie dem Artikel einer passenden Produktgruppe zu. Zu den einzelnen Produktgruppen können Sie Steuerklassen/Steuersätze konfigurieren.');
define('TEXT_SHIPPER_PROFILES_ADMIN','Versender Profile verwalten');
define('TEXT_IMAGE_NONEXISTENT','Kein Bild verfügbar');
define('ERROR_CART_ITEM_DOESNT_EXISTS','Die Sammler ID %s existiert nicht.');
define('TEXT_NOT_CONFIGURED','nicht konfiguriert');

define('HINT_INTRO_STREET_SPECIAL','Strasse + Nr. oder Postfiliale + Nr. bzw. Packstation + Nr.');
define('HINT_INTRO_STREET_SPECIAL_VALUE','Musterstrasse 12 oder Postfiliale 123 bzw. Packstation 123');
define('HINT_INTRO_SUBURB_SPECIAL','Adresszusatz oder nur Postnummer');
define('HINT_INTRO_SUBURB_SPECIAL_VALUE','Adresszusatz oder nur Postnummer');
define('TEXT_PAYOUT_LINK','Per Kasse abwickeln');

define('TEXT_TODAY','Heute');
define('TEXT_EREYESTERDAY','Vorgestern');
define('TEXT_YESTERDAY','Gestern');
define('TEXT_LAST_UPDATE','Letzte Aktualisierung');
define('TEXT_DAILY','täglich');
define('TEXT_HOURLY','stündlich');
define('TEXT_HOURLY_2','Alle 2 Stunden');
define('ERROR_SUPPORT_REQUEST_MESSAGE_EMPTY','Bitte geben Sie eine Nachricht ein.');
define('SUCCESS_SUPPORT_REQUEST_MESSAGE_SENT','Support E-Mail wurde versendet.');
define('TEXT_EMAIL_UNREAD','Ungelesen');
define('TEXT_EMAIL_UNALLOCATED','Nicht zugewiesen');
define('TEXT_EMAIL_CLOSED','Geschlossen');
define('TEXT_EMAIL_OWNMAIL','Eigene');
define('PAYMODULE_MARGE_NOT_ACTIVATED','Modul zur Erfassung und Darstellung von Deckungsbeiträgen und Selbstkosten ist nicht installiert.');