<?php
/* -----------------------------------------------------------------------------------------
   $Id: redirect.php,v 1.1 2012/08/13 08:11:42 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(redirect.php,v 1.9 2003/02/13); www.oscommerce.com 
   (c) 2003	 nextcommerce (redirect.php,v 1.7 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');

require_once(DIR_FS_INC . 'xtc_update_banner_click_count.inc.php');

switch ($_GET['action']) {
    case 'banner':
        $banner_query = yes_query(sprintf(
            "select banners_url from %s where banners_id =:banners_id",
            TABLE_BANNERS
        ),[ 'banners_id'=>$_GET['goto'] ]);
        if(sizeOf($banner_query)) {
            $banner = current($banner_query);
            xtc_update_banner_click_count($_GET['goto']);
            xtc_redirect($banner['banners_url']);
        } else {
            xtc_redirect(xtc_href_link(FILENAME_DEFAULT));
        }
        break;
    case 'url':
        if (isset($_GET['goto'])) {
            xtc_redirect('http://' . $_GET['goto']);
        } else {
            xtc_redirect(xtc_href_link(FILENAME_DEFAULT));
        }
        break;
    case 'manufacturer':
        if (isset($_GET['manufacturers_id'])) {
            $manufacturer_query = yes_query(sprintf(
                "select manufacturers_url from %s where manufacturers_id =:manufacturers_id and languages_id =:languages_id",
                TABLE_MANUFACTURERS_INFO
            ),[
                'manufacturers_id'=>(int)$_GET['manufacturers_id'],
                'languages_id'=> (int)$_SESSION['languages_id']
            ]);
            if (!sizeOf($manufacturer_query)) {
                // no url exists for the selected language, lets use the default language then
                $manufacturer_query = yes_query(sprintf(
                    "select mi.languages_id, mi.manufacturers_url from %s mi, %s l where mi.manufacturers_id =:manufacturers_id and mi.languages_id = l.languages_id and l.code =:default_lang",
                    TABLE_MANUFACTURERS_INFO,TABLE_LANGUAGES
                ),[
                    'manufacturers_id'=>(int)$_GET['manufacturers_id'],
                    'default_lang'=> DEFAULT_LANGUAGE
                ]);
                if (!sizeOf($manufacturer_query)) {
                    // no url exists, return to the site
                    xtc_redirect(xtc_href_link(FILENAME_DEFAULT));
                } else {
                    $manufacturer = current($manufacturer_query);
                    yes_query(sprintf(
                        "update %s set url_clicked = url_clicked+1, date_last_click = now() where manufacturers_id =:manufacturers_id and languages_id =:languages_id",
                        TABLE_MANUFACTURERS_INFO
                    ),[
                        'manufacturers_id' => (int)$_GET['manufacturers_id'],
                        'languages_id'=>$manufacturer['languages_id']
                    ]);
                }
            } else {
                // url exists in selected language
                $manufacturer = current($manufacturer_query);
                yes_query(sprintf(
                    "update %s set url_clicked = url_clicked+1, date_last_click = now() where manufacturers_id =:manufacturers_id and languages_id =:languages_id",
                    TABLE_MANUFACTURERS_INFO
                ),[
                    'manufacturers_id' => (int)$_GET['manufacturers_id'],
                    'languages_id'=>$_SESSION['languages_id']
                ]);
            }
            xtc_redirect($manufacturer['manufacturers_url']);
        } else {
            xtc_redirect(xtc_href_link(FILENAME_DEFAULT));
        }
        break;
    default:
        xtc_redirect(xtc_href_link(FILENAME_DEFAULT));
        break;
}