<?php
$message = json_decode(file_get_contents('php://input'), true);

if(!isset($message['yes_push_hash']) or !isset($message['message']) or !isset($message['push_target_link']) or empty($message['message']) ){
    die('invalid call');
}

if(crypt($message['message'].$message['push_target_link'],'YES_PUSH_81175') != $message['yes_push_hash']){
	die('modified data');
}

require __DIR__ . '/admin/push/vendor/autoload.php';
use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Utils;
use Minishlink\WebPush\VAPID;
include('includes/application_top.php');
function yes_allow_push($cID,$allocation){
    $query = yes_query(
        "SELECT push_customer_allocations_id FROM push_customer_allocations WHERE customers_id=:customers_id AND allocation=:allocation",
        ['customers_id'=>$cID,'allocation'=>$allocation],
    );
    return sizeOf($query);
}
$secure_path = main::get_secure_path();
define('YES_PUSH_VAPID_KEYS_FILE',$secure_path.'yes_push_vapid_keys.vapid');
if(!is_file(YES_PUSH_VAPID_KEYS_FILE)){
    $vapid = VAPID::createVapidKeys();
    file_put_contents(YES_PUSH_VAPID_KEYS_FILE,json_encode($vapid));
    chmod(YES_PUSH_VAPID_KEYS_FILE,0400);
}
$auth = json_decode(file_get_contents(YES_PUSH_VAPID_KEYS_FILE));
$sub_array = array();
$send_to_filter = "";
if($message['tag'] == 'login'){
	if(is_array($message['send_to']) and sizeOf($message['send_to'])){
		$send_to_filter = sprintf(" AND customers_id IN(%s) ",
			implode(', ',$message['send_to'])
		);
	}
	$query = xtc_db_query(sprintf(
		"SELECT * FROM push_subscriber WHERE customers_id!='%s' %s",
		$message['class_params']['customers_id'],
		$send_to_filter
	));
}else{
	if(is_array($message['send_to']) and sizeOf($message['send_to'])){
		$send_to_filter = sprintf(" WHERE customers_id IN(%s) ",
			implode(', ',$message['send_to'])
		);
	}
	$query = xtc_db_query(
		"SELECT * FROM push_subscriber ".$send_to_filter
	);
}
while($record = xtc_db_fetch_array($query)){
	$record['key'] = $record['publicKey'];
	if(!isset($sub_array[ $record['customers_id'] ])){
		$sub_array[ $record['customers_id'] ] = array();
	}
	$sub_array[ $record['customers_id'] ][] = $record;
}
$auth = array(
    'VAPID' => array(
        'subject' => (main::isDev(true)) ? HTTP_SERVER : HTTPS_SERVER,
        'publicKey' => $auth->publicKey,
        'privateKey' => $auth->privateKey,
    ),
);
$webPush = new WebPush($auth);
switch($tag){
    case 'email_staff':
        $tag = PUSH_NOTIFICATION_TAG_EMAIL_STAFF; // in lang/german/german.php
        break;
    default:
        $tag = ucfirst($message['tag']);
        break;
}
foreach($sub_array as $cID=>$subscriptions){
	if(!yes_allow_push($cID,$message['tag'])){ 
		continue;
	}
	foreach($subscriptions as $subscription){
		$res = $webPush->sendNotification(
		    $subscription['endpoint'],
		    json_encode(array(
			'tag'=>sprintf("[%s]", $tag),
			'push_text'=>$message['message'],
			'push_target_link'=>$message['push_target_link'],
		    )),
		    $subscription['key'],
		    $subscription['token']
		);
		if($res != '1' or (isset($res['success']) and $res['success'] !== True)){
                    //main::yes_debug_log(print_r($res,true));
		}
	}
}
$webPush->flush();
echo 'Done';

