<?php
define('SHOPGATE_PLUGIN_VERSION', '2.3.0');
if(!function_exists('xtc_category_link'))
require_once(DIR_FS_INC.'xtc_category_link.inc.php');
require_once(DIR_FS_INC.'xtc_get_category_path.inc.php');
require_once(DIR_FS_INC.'xtc_collis.inc.php');
require_once(DIR_FS_INC.'xtc_get_vpe_name.inc.php');
require_once(DIR_FS_INC.'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_CATALOG.'admin/includes/classes/class.storagequantity.php');
require_once(DIR_FS_CATALOG.'admin/includes/classes/class.group_handler.php');
require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
// BOF YES MARIO - end auction
require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
// EOF YES MARIO - end auction

/**
 * XTCommerce 3 Plugin for Shopgate
 */
class ShopgatePluginXtc3 extends ShopgatePlugin {

	/**
	 * @var ShopgateConfigXtc
	 */
	protected $config;

	private $languageId;
	private $countryId;
	private $zoneId;

	private $currency;

	private $language = "german";

	public function checkCart(ShopgateCart $cart) {
ob_start();
if(sizeOf($cart->getItems())){
	foreach($cart->getItems() as $ci){
		echo 'pID '.$ci->getItemNumber().': '.$ci->getQuantity()."\r\n";
	}
}
$out1 = ob_get_contents();
ob_end_clean();


	    mail('m.aspeleiter@yes-websolutions.de','check cart called',date('Y-m-d')."\r\n".basename(__FILE__)."\r\n".$out1);
	}
	public function startup() {
		if(!defined('_VALID_XTC')){
			define('_VALID_XTC', true);
		}

		$requiredFiles = array(
			'inc/xtc_validate_password.inc.php',
			'inc/xtc_format_price_order.inc.php',
			'inc/xtc_db_prepare_input.inc.php',
			'includes/classes/xtcPrice.php',
		);
		
		foreach($requiredFiles as $file) {
			require_once(DIR_FS_CATALOG.$file);
		}
		
		// initialize configuration
##### XTC3 BOF #####
		require_once(DIR_FS_CATALOG.'shopgate/base/shopgate_config.php');
		$this->config = new ShopgateConfigXtc();
##### XTC3 EOF #####
		if (!isset($_REQUEST['shop_number'])) {
			$this->config->loadFile();
		} else {
			$this->config->loadByShopNumber($_REQUEST['shop_number']);
		}
		
		// fetch country
		$qry = "SELECT * FROM `".TABLE_COUNTRIES."` WHERE UPPER(countries_iso_code_2) = UPPER('".$this->config->getCountry()."')";
		$result = xtc_db_query($qry);
		$qry = xtc_db_fetch_array($result);
		$this->countryId = !empty($qry['countries_id']) ? $qry['countries_id'] : 'DE';

		// fetch language
		$qry = "SELECT * FROM `".TABLE_LANGUAGES."` WHERE UPPER(code) = UPPER('".$this->config->getLanguage()."')";
		$result = xtc_db_query($qry);
		$qry = xtc_db_fetch_array($result);
		$this->languageId = !empty($qry['languages_id']) ? $qry['languages_id'] : 2;
		$this->language = !empty($qry['directory']) ? $qry['directory'] : 'german';

		// fetch currency
		$qry = "SELECT * FROM `".TABLE_CURRENCIES."` WHERE UPPER(code) = UPPER('".$this->config->getCurrency()."')";
		$result = xtc_db_query($qry);
		$qry = xtc_db_fetch_array($result);
		$this->exchangeRate = !empty($qry['value']) ? $qry['value'] : 1;
		$this->currencyId = !empty($qry['currencies_id']) ? $qry['currencies_id'] : 1;
		$this->currency = !empty($qry)
			? $qry
			: array('code' => 'EUR', 'symbol_left' => '', 'symbol_right' => ' EUR', 'decimal_point' => ',', 'thousands_point' => '.', 'decimal_places' => '2', 'value' => 1.0);

		$this->zoneId = $this->config->getTaxZoneId();

		if (!defined('DIR_FS_LANGUAGES')) {
			define('DIR_FS_LANGUAGES', rtrim(DIR_FS_CATALOG, '/'). '/lang/');
		}

##### XTC3 BOF #####
		$langFiles = array(
			'admin/categories.php',
			'admin/content_manager.php',
		);

		foreach($langFiles as $langFile) {
			include_once rtrim(DIR_FS_LANGUAGES, '/')."/$this->language/$langFile";
		}

		// Load shopgate-admin-language-files additionaly
		include_once(dirname(__FILE__)."/base/lang/$this->language/admin/$this->language.php");
##### XTC3 EOF #####
		
		return true;
	}

	public function createPluginInfo() {
		$projectVersion = '-';
		if(defined('PROJECT_VERSION')){
			$projectVersion = PROJECT_VERSION;
		}
		return array('xtCommerce 3 Version' => $projectVersion);
	}
	
	protected function createCategoriesCsv() {
		$this->log("Start export categories tree...", ShopgateLogger::LOGTYPE_DEBUG);
		
		if($this->config->getReverseCategoriesSortOrder()){
			$maxOrder = 0;
		} else {
			$qry = "SELECT MAX( sort_order ) sort_order FROM " . TABLE_CATEGORIES;
			$result = xtc_db_query( $qry );
			$maxOrder = xtc_db_fetch_array( $result );
			$maxOrder = $maxOrder["sort_order"] + 1;
		}
		
		$this->_buildCategoriesTree(0, $maxOrder);
	}

	private function _buildCategoriesTree($parentId = 0, $maxOrder = 0 ) {
		$this->log("Start buldiding Categories tree: parent_id = ". $parentId ."...", ShopgateLogger::LOGTYPE_DEBUG);
		
		$qry = "
		SELECT DISTINCT
		c.categories_id,
		c.parent_id,
		c.categories_image,
		c.categories_status,
		c.sort_order,
		c.shopgate_block,
		cd.categories_name
		FROM ".TABLE_CATEGORIES." c
		LEFT JOIN ".TABLE_CATEGORIES_DESCRIPTION." cd ON (c.categories_id = cd.categories_id
		AND cd.language_id = $this->languageId)
		WHERE c.parent_id = $parentId ORDER BY c.categories_id ASC
		";

		$qry = xtc_db_query( $qry );

		while( $item = xtc_db_fetch_array( $qry ) ) {
			if($item['shopgate_block'] == 1) continue;
			$row = $this->buildDefaultCategoryRow();

			$row["category_number"] = $item["categories_id"];
			$row["parent_id"] = (empty($item["parent_id"]) || ($item['parent_id'] == $item['categories_id']))
				? ""
				: $item["parent_id"];
			$row["category_name"] = htmlentities($item["categories_name"], ENT_NOQUOTES, $this->config->getEncoding());

			if(!empty($item["categories_image"])){
				$row["url_image"] = HTTP_SERVER.DIR_WS_CATALOG.DIR_WS_IMAGES."categories/".$item["categories_image"];
			}

			if (!empty($item["sort_order"]) || ((string) $item['sort_order'] === '0')) {
				if($this->config->getReverseCategoriesSortOrder()){
					// reversed means the contrary to ordering system in shopgate - order_index is a priority system - high number = top position
					// so just taking over the values means reversing the order
					$row["order_index"] = $item["sort_order"];
				} else {
					$row["order_index"] = $maxOrder - $item["sort_order"];
				}
			}
			
			$row["is_active"] = $item["categories_status"];
			$row['url_deeplink'] = xtc_href_link(FILENAME_DEFAULT, xtc_category_link($item['categories_id'], $item['categories_name']), 'NONSSL', false);
			
			$this->addCategoryRow($row);
			
			if ($item['parent_id'] != $item['categories_id']) {
				$this->_buildCategoriesTree($item["categories_id"], $maxOrder);
			}
		}
	}

	/**
	 * returns all sub categories including the given parent as a list that is a mapping from one category to a higher category if a given depth is exceeded
	 * @param int $maxDepth
	 * @param int $parentId
	 * @param int $copyId
	 * @param int $depth
	 * @throws ShopgateLibraryException
	 * @return array
	 */
	private function _getCategoryReducementMap($maxDepth = null, $parentId = null, $copyId = null, $depth = null) {
		$this->log("execute _getCategoryReducementMap() ...", ShopgateLogger::LOGTYPE_DEBUG);
		
		$circularDepthStop = 50;
		if(empty($depth)) {
			$depth = 1;
		} elseif($depth > $circularDepthStop) {
			// disallow circular category connections (detect by a maximum depth)
			throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_DATABASE_ERROR, 'error on loading sub-categories: Categories-Depth exceedes a value of '.$circularDepthStop.'. Check if there is a circular connection (referenced categories ids: '.$parentId.'=>'.$row['categories_id'].')', true);
		}
		
		$qry =
			"SELECT `categories_id` FROM `".TABLE_CATEGORIES."` WHERE" .
			// select by parent id, if set
			(!empty($parentId)
				? " (`parent_id` = '{$parentId}')"
				: " (`parent_id` IS NULL OR `parent_id` = 0 OR `parent_id` = '')"
			)
		;
		$qryResult = xtc_db_query($qry);
		if(!$qryResult) {
			throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_DATABASE_ERROR, 'error on selecting categories', true);
		}
		
		// add all sub categories to a simple one-dimensional array
		$categoryMap = array();
		while($row = xtc_db_fetch_array($qryResult)) {
			// copy only if a maximum depth is set, yet
			if(!empty($maxDepth)) {
				if($depth == $maxDepth) {
					$copyId = $row['categories_id'];
				}
			}
			// Check if a mapping to a higher category needs to be applied
			if(!empty($copyId) && !empty($row['categories_id'])) {
				$categoryMap[$row['categories_id']] = $copyId;
			} else {
				// no mapping to other categories, map to itself!
				$categoryMap[$row['categories_id']] = $row['categories_id'];
			}
			
			$subCategories = $this->_getCategoryReducementMap($maxDepth, $row['categories_id'], $copyId, $depth+1);
			if(!empty($subCategories)) {
				$categoryMap = $categoryMap+$subCategories;
			}
		}
		
		return $categoryMap;
	}
	
	/**
	 * @see ShopgatePluginApi::createItemsCsv()
	 */
	protected function createItemsCsv( $products_id = 0,$qty = -1 ) {
		$this->log('execute createItemsCsv '.(($products_id > 0)?' pID '.$products_id:''), ShopgateLogger::LOGTYPE_DEBUG);

		$customerGroupMaxPriceDiscount = 0;
		$customerGroupDiscountAttributes = false;

		$this->log("execute SQL customer group ...", ShopgateLogger::LOGTYPE_DEBUG);
		
		// get customer-group first
		$qry = "SELECT"
		. " status.customers_status_name,"
		. " status.customers_status_discount,"
		. " status.customers_status_discount_attributes"
		. " FROM " . TABLE_CUSTOMERS_STATUS . " AS status"
		. " WHERE status.customers_status_id = " . $this->config->getCustomerPriceGroup()
		. " AND status.language_id = " . $this->languageId
		. ";";

		// Check if the customer group exists (ignore if not)
		$queryResult = xtc_db_query($qry);
		if($queryResult) {
			$customerGroupResult = xtc_db_fetch_array($queryResult);
			if(!empty($customerGroupResult) && isset($customerGroupResult['customers_status_discount'])) {
				$customerGroupMaxPriceDiscount = $customerGroupResult['customers_status_discount'];
			}
			if(!empty($customerGroupResult) && isset($customerGroupResult['customers_status_discount'])) {
				$customerGroupDiscountAttributes = $customerGroupResult['customers_status_discount_attributes'] ? true : false;
			}
		}
		
		$categoryReducementMap = array();
		$maxCatDepth = $this->config->getMaximumCategoryExportDepth();
		if(!empty($maxCatDepth)) {
			$categoryReducementMap = $this->_getCategoryReducementMap($maxCatDepth);
		}

		$this->log("generate SQL get products ...", ShopgateLogger::LOGTYPE_DEBUG);
		
		$qry_select = "
			SELECT DISTINCT
				p.products_id,
				p.products_model,
				p.products_ean,
				p.products_quantity,
				p.products_image,
				p.products_price,
				DATE_FORMAT(p.products_last_modified, '%Y-%m-%d') as products_last_modified,
				p.products_status,
				sp.specials_new_products_price,
				sp.specials_quantity,
				pdsc.products_meta_keywords,
				pdsc.products_name,
				pdsc.products_description,
				pdsc.products_short_description,
				shst.shipping_status_name,
				mf.manufacturers_name,
				p.products_tax_class_id,
				p.products_fsk18,
				p.products_sort,
				p.products_startpage,
				p.products_startpage_sort,
				p.products_discount_allowed,
				p.products_date_available,
				p.products_master,
				p.products_master_status,
				p.products_vpe_value,
				p.products_vpe,
				p.products_vpe_status
			FROM ".TABLE_PRODUCTS." p
			LEFT JOIN ".TABLE_PRODUCTS_DESCRIPTION." pdsc ON (p.products_id = pdsc.products_id AND pdsc.language_id = '".$this->languageId."')
			LEFT JOIN ".TABLE_SHIPPING_STATUS." shst ON (p.products_shippingtime = shst.shipping_status_id AND shst.language_id = '".$this->languageId."')
			LEFT JOIN ".TABLE_MANUFACTURERS." mf ON (mf.manufacturers_id = p.manufacturers_id)
			LEFT JOIN ".TABLE_SPECIALS." sp ON (sp.products_id = p.products_id AND sp.status = 1 AND (sp.expires_date > now() OR sp.expires_date = '0000-00-00 00:00:00' OR sp.expires_date IS NULL))";
		if($products_id > 0){
			$qry = $qry_select." WHERE p.products_status = 1 AND p.shopgate_block='0' AND p.products_id='".$products_id."'";
		}else{
			$qry = $qry_select." WHERE p.products_status = 1 AND p.shopgate_block='0'";
		}
		
		// sp.specials_quantity > 0 deleted, to handle the check in the loop
		
		if(STOCK_CHECK == "true" && STOCK_ALLOW_CHECKOUT == 'false') {
			$qry .= " AND p.products_quantity > 0 ";
		}
		
		// Code for enabling to download specific products (for debugging purposes only, at this time)
		if(!empty($_REQUEST['item_numbers']) && is_array($_REQUEST['item_numbers'])) {
			$qry .= " AND p.products_id IN ('".implode("', '", $_REQUEST['item_numbers'])."') ";
		}
		
		// Ahorn24 fix. 10 products were not found without sorting.
		$qry .= ' ORDER BY p.products_id ASC ';
		$this->log("execute SQL get max_id ...", ShopgateLogger::LOGTYPE_DEBUG);
		
		$result = xtc_db_query("SELECT MAX(products_id) max_id FROM ".TABLE_PRODUCTS);
		$maxId = xtc_db_fetch_array( $result );
		$maxId = $maxId["max_id"];
		
		$this->log("execute SQL min_order, max_order ...", ShopgateLogger::LOGTYPE_DEBUG);
		
		// order_index for the products
		$result = xtc_db_query("SELECT MIN(products_sort) AS 'min_order', MAX(products_sort) AS 'max_order' FROM ".TABLE_PRODUCTS);
		$orderIndices = xtc_db_fetch_array( $result );
		$maxOrder = $orderIndices["max_order"]+1;
		$minOrder = $orderIndices["min_order"];
		$addToOrderIndex = 0;
		
		if($minOrder < 0) {
			// make the sort_order positive
			$addToOrderIndex += abs($minOrder);
		}
		
		if($this->splittedExport) $qry .= " LIMIT {$this->exportOffset}, {$this->exportLimit}";
		
		$this->log("execute SQL get products ...", ShopgateLogger::LOGTYPE_DEBUG);
		$query = xtc_db_query($qry);
		$_items = array();
		while($item = xtc_db_fetch_array($query)) {
			$_items[] = $item;
		}
		foreach($_items as $item){
			$this->log("start export products_id = ".$item["products_id"]." ...", ShopgateLogger::LOGTYPE_DEBUG);
			$itemArr = $this->buildDefaultItemRow();
			$orderInfos = array();
			
			$tax_rate = xtc_get_tax_rate($item["products_tax_class_id"], $this->countryId, $this->zoneId);
			
			$variations = array();
			// Get variantions and input fields
			if($products_id > 0){
				$options = $this->_getVariations($item["products_id"], $tax_rate,false);
				$itemArr['options']=$options;
			}else{
				$variations = $this->_getVariations($item["products_id"], $tax_rate);
			}
			$inputFields = $this->_getInputFields($item["products_id"]);
			
			// Get categories
			$categories = $this->_getProductPath($item["products_id"]);
			
			// Get Image Urls
			$images = $this->_getProductsImages($item);
			
			// get deeplink
			//$deeplink = xtc_href_link('product_info.php', xtc_product_link($item['products_id'], $item['products_name']), 'NONSSL', false);
			// YES MARIO
			$deeplink = xtc_href_link('product_info.php', 'products_id='.$item['products_id']);
			
			// Calculate the price
			$price = $item["products_price"];
			$oldPrice = '';
			
			// Special offers for a Customer group
			$pOffers = $this->_getPersonalOffersPrice($item, $tax_rate);
			if(!empty($pOffers) && round($pOffers, 2) > 0) {
				$price = $pOffers;
				// Ignore the "old price" if it is lower than the offer amount (xtc3 also tells the old price here, but it's not very intuitive)
				if($pOffers < $item["products_price"]) {
					$oldPrice = $item["products_price"];
				}
			}
			
			// General special offer or customer group price reduction
			$productDiscount = 0;
			if(!empty($item["specials_new_products_price"])) {
				if(STOCK_CHECK == 'true' && STOCK_ALLOW_CHECKOUT == 'false') {
					if($item["specials_quantity"] > 0){
						// Nur wenn die quantity > 0 ist dann specialprice setzen, ansonsten normalen Preis mit normalem Stock
						$item["products_quantity"] = $item["specials_quantity"] > $item["products_quantity"] ? $item["products_quantity"] : $item["specials_quantity"];
					}
				}
				// setting specialprice
				$oldPrice = $item["products_price"];
				$price = $item["specials_new_products_price"];
				
				$orderInfos['is_special_price'] = 1;
				
			} elseif(!empty($customerGroupMaxPriceDiscount) && round($customerGroupMaxPriceDiscount, 2) > 0
				  && !empty($item['products_discount_allowed']) && round($item['products_discount_allowed'], 2) > 0) {
				$productDiscount = round($item['products_discount_allowed'], 2);
				
				// Limit discount to the customer groups maximum discount
				if(round($customerGroupMaxPriceDiscount, 2) < $productDiscount) {
					$productDiscount = round($customerGroupMaxPriceDiscount, 2);
				}
				
				$oldPrice = $price;
				if($oldPrice < $item['products_price']) {
					$oldPrice = $item['products_price'];
				}
				
				// Reduce price to the discounted price
				$price = $this->_getDiscountPrice($price, $productDiscount);
			}
			
			$category_numbers = $this->_getProductCategoryNumbers($item, $maxOrder, $addToOrderIndex);
			// check if there is a category replacement map to reduce categories depth
			if(!empty($categoryReducementMap)) {
				foreach($category_numbers as &$categoryNumber) {
					// can possibly contain a split symbol "=>"
					if(strpos($categoryNumber, '=>') !== FALSE) {
						$catNumberParts = explode('=>', $categoryNumber);
						$catNumberParts[0] = $categoryReducementMap[$catNumberParts[0]];
						$categoryNumber = implode('=>', $catNumberParts);
					} else {
						$categoryNumber = $categoryReducementMap[$categoryNumber];
					}
				}
			}
			
			$price *= $this->exchangeRate;
			$price = $price * ( 1 + ( $tax_rate / 100 ) );
			
			if (!empty($oldPrice)) {
				$oldPrice = $oldPrice * $this->exchangeRate;
				$oldPrice = $this->formatPriceNumber( $oldPrice * ( 1 + ( $tax_rate / 100 ) ) );
			}
			
			// create the description, based on the settings
			$desc = $this->removeTagsFromString($item["products_description"]);
			$shortDesc = $this->removeTagsFromString($item["products_short_description"]);
			$description = '';
			switch($this->config->getExportDescriptionType()) {
				case SHOPGATE_SETTING_EXPORT_DESCRIPTION:
					$description = $desc;
					break;
				case SHOPGATE_SETTING_EXPORT_SHORTDESCRIPTION:
					$description = $shortDesc;
					break;
				case SHOPGATE_SETTING_EXPORT_DESCRIPTION_SHORTDESCRIPTION:
					$description = $desc . "<br/><br/>" . $shortDesc;
					break;
				case SHOPGATE_SETTING_EXPORT_SHORTDESCRIPTION_DESCRIPTION:
					$description = $shortDesc . "<br/><br/>" . $desc;
					break;
			}
			
			$description = preg_replace("/\n|\r/", "", $description);
			
			// BOF YES MARIO
			if($qty < 0){
				$SQ = new products_quantity($item["products_id"]);
				//$item_qty = (defined('STOCK_CHECK_AVAILABLE_METHOD') and STOCK_CHECK_AVAILABLE_METHOD == 'True') ? $SQ->get_available1_qty() : $SQ->get_available2_qty();
				// aus config

				$item_qty = $this->config->getDefaultItemQuantity();
			}else{
				$item_qty = $qty;
			}
			if(STOCK_CHECK == 'true'){
				if(defined('STOCK_CHECK_AVAILABLE_METHOD') and STOCK_CHECK_AVAILABLE_METHOD == 'True'){
					$check_qty = $SQ->get_available1_qty();
					
				}else{
					$check_qty = $SQ->get_available2_qty();
				}
				if( $check_qty < $item_qty ){
					$item_qty = $check_qty;
				}
				if($check_qty < 1){
					continue;
				}
			}
			// EOF YES MARIO

			$itemArr['item_number'] = $item["products_id"];
			$itemArr['item_number_public'] = $item['products_model'];
			$itemArr['manufacturer'] = $item["manufacturers_name"];
			$itemArr['manufacturer_item_number'] = $item['products_ean'];
			$itemArr['item_name'] = trim( preg_replace('/<[^>]+>/',' ', $item["products_name"]) );
			$itemArr['description'] =  $description;
			$itemArr['unit_amount'] = $this->formatPriceNumber($price);
			$itemArr['currency'] = $this->currency["code"];
			$itemArr['is_available'] = $item["products_status"];
			$itemArr['available_text'] = $this->_getAvailableText($item);
			$itemArr['url_deeplink'] = $deeplink;
			$itemArr['urls_images'] = $images;
			$itemArr['categories'] = $categories;
			$itemArr['category_numbers'] = implode("||", $category_numbers);
			$itemArr['use_stock'] = (STOCK_ALLOW_CHECKOUT == 'true' || STOCK_CHECK != 'true') ? 0 : 1;
			$itemArr['amount_info_text'] = $this->yes_getAmountInfoText($item,$price);
			$itemArr['stock_quantity'] = $item_qty; // YES CHANGE
			if($products_id > 0){ // bei manuell gleich auf aktiv
				$itemArr['is_active'] = true;
			}


			$itemArr['weight'] = xtc_get_ext_products_weight($item["products_id"])*1000;
			if($item["products_meta_keywords"] != '')
				$itemArr['tags'] = trim($item["products_meta_keywords"]);

			$itemArr['tax_percent'] = $tax_rate;
			$itemArr['shipping_costs_per_order'] = 0;
			$itemArr['additional_shipping_costs_per_unit'] = 0;
			$itemArr['ean'] = preg_replace("/\s+/i",'',$item["products_ean"]);
			$itemArr['last_update'] = $item["products_last_modified"];
			$itemArr['block_pricing'] =  $this->_getPackeges($item, $tax_rate);
			$itemArr['age_rating'] = $item["products_fsk18"] == 1 ? '18' : '';
			$itemArr['related_shop_item_numbers'] = $this->_getRelatedShopItems($item["products_id"]);
			$itemArr['basic_price'] = $this->_getProductVPE($item, $price);
			$itemArr['is_highlight'] = $item["products_startpage"];
			$itemArr['highlight_order_index'] = $item["products_startpage_sort"];

			if($this->config->getReverseItemsSortOrder()){
				// $addToOrderIndex to make positive sort_order
				$itemArr['sort_order'] = $item["products_sort"] + $addToOrderIndex;
			} else {
				$itemArr['sort_order'] = ($maxOrder - $item["products_sort"])+$addToOrderIndex;
			}
			
			if(!empty($orderInfos)){
				$itemArr['internal_order_info'] = $this->jsonEncode($orderInfos);
			}

			$itemNumber = 0 ;
			
			if(!empty($oldPrice) && round($oldPrice, 2) > 0) {
				$itemArr['old_unit_amount'] = $oldPrice;
			} else {
				$itemArr['old_unit_amount'] = '';
			}

			if($itemArr['available_text'] == 'Unbekannt') {
				$itemArr['is_available'] = 0;
			}

			if(!empty($inputFields)){
				$itemArr['has_input_fields'] = "1";
				$itemArr = array_merge($itemArr, $inputFields);
			}
			$itemArr['properties'] = $this->yes_getProperties($item['products_id']);
			if(sizeOf($itemArr['properties']) and $products_id < 1){ // bei autom.
				$_properties = array();
				foreach($itemArr['properties'] as $prop){
					$_properties[] = key($prop).'=>'.current($prop);
				}
				$itemArr['properties'] = implode('||',$_properties);
			}

			// BOF YES ATTRIBUTES
			if($item['products_master_status'] > 0){
				$itemArr['parent_item_number'] = 'P'.$item['products_id'];
				
			}elseif($item['products_master'] > 0){
				$pin = $this->yes_checkParentItemNumber($item['products_master']);
				if($pin > 0){ // nur wenn es einen
					$itemArr['parent_item_number'] = 'P'.$pin;
				}
			}
			if(isset($itemArr['parent_item_number']) and !empty($itemArr['parent_item_number'])){
				$attributes = $this->yes_getAttributes($item['products_id'],substr($itemArr['parent_item_number'],1,strlen($itemArr['parent_item_number'])));
				$max_att = 10;
				$cur_att = 0;
				if(sizeOf($attributes)){
					foreach($attributes as $att){
						if($cur_att < $max_att){
							$itemArr['attribute_'.($cur_att+1)] = $att['value'];
						}
						$cur_att++;
					}
				}else{
				    $itemArr['attribute_'.($cur_att+1)] = $itemArr['item_name'];
				}
			}
			// EOF YES ATTRIBUTES



			if(sizeOf($variations)) {
				if($variations["has_options"]) {
					$itemArr['has_options']=1;
					// fix for products with more than 10 options:
					if (isset($variations['option_11'])) {
						continue; // don't import
					}
					$this->addItemRow(array_merge($itemArr, $variations));
				} else {
					if(isset($variations['has_options'])){
						unset($variations['has_options']);
					}
					$itemArr['has_children']=1;
					$itemNumber = $itemArr["item_number"];
					$basePrice = round($itemArr["unit_amount"], 2);
					$baseOldPrice = round($itemArr["old_unit_amount"], 2);
					$baseWeight = $itemArr["weight"];

					$parentItemNumber = $itemArr["item_number"];
					$isFirst = true;

					// Kinder haben gleiche Textfelder
					if(!empty($inputFields)){
						$itemArr['has_input_fields'] = "1";
						$itemArr = array_merge($itemArr, $inputFields);
					}

					foreach ($variations as $key => $variation) {
						$price = 0;
						$weight = 0;
						// Offset amount including tax without discounts (but with exchange rate, of set)
						$originalOffsetAmount = 0;
						if(!empty($variation["offset_amount"])) {
							if(!empty($this->exchangeRate)) {
								$variation["offset_amount"] *= $this->exchangeRate;
								$variations[$key]["offset_amount"] = $variation["offset_amount"];
							}
							$originalOffsetAmount = $variation["offset_amount"]*(1+($tax_rate/100));
							
							// Variations also need to be discounted if products discount is set
							if(!empty($productDiscount) && round($productDiscount, 2) > 0) {
								if($customerGroupDiscountAttributes) { // Seems to be buggy in gambio so it is ignored here
									$variation["offset_amount"] = $this->_getDiscountPrice($variation["offset_amount"], $productDiscount);
									$variations[$key]["offset_amount"] = $variation["offset_amount"];
								}
							}
							$price = $variation["offset_amount"]*(1+($tax_rate/100));
						}


						if(isset($variation["offset_weight"]))
							$weight = $variation["offset_weight"] * 1000;

						$hash = "";

						for($i=1; $i < 10 && isset($variation["attribute_$i"]); $i++) {
							$hash .= $variation["attribute_$i"];
							$itemArr["attribute_$i"] = htmlentities($variation["attribute_$i"], ENT_NOQUOTES, $this->config->getEncoding());
						}

						$hash = md5($hash);
						$hash = substr($hash, 0, 5);
						if(empty($variation)) $variation = array("order_info" => array());

						// Set Order Info from parent product
						if(!empty($variation['order_info']) && is_array($variation['order_info'])){
							$variation["order_info"] = array_merge($orderInfos, $variation['order_info']);
						} else {
							$variation["order_info"] = $orderInfos;
						}
						
						$variation["order_info"]["base_item_number"] = $itemNumber;

						$itemArr['internal_order_info'] = $this->jsonEncode($variation["order_info"]);
						$itemArr["item_number"] = $itemNumber.($isFirst?"":"_".$hash);
						if(!empty($variation["item_number"])){
							$itemArr["item_number_public"] = $variation["item_number"];
						} else {
							$itemArr['item_number_public'] = $item['products_model'];
						}
						
						$itemArr["unit_amount"] = $this->formatPriceNumber($basePrice + $price);
						if(!empty($baseOldPrice) && round($baseOldPrice, 2) > 0) {
							$itemArr["old_unit_amount"] = $this->formatPriceNumber($baseOldPrice + $originalOffsetAmount);
						} else {
							$itemArr["old_unit_amount"] = '';
						}
						$itemArr["weight"]			= $baseWeight + $weight;
						
						if($isFirst == false){
							$itemArr["use_stock"]	= (STOCK_ALLOW_CHECKOUT == 'true' || ATTRIBUTE_STOCK_CHECK != 'true') ? 0 : 1;
						}
						// Overwrite stock only if its set up in the configuration
						if(ATTRIBUTE_STOCK_CHECK == 'true' && $isFirst == false){
							if(!empty($item["specials_new_products_price"]) && $item["specials_quantity"] > 0){
								$itemArr["stock_quantity"] = $variation["stock_quantity"] > $item["specials_quantity"] ? $item["specials_quantity"] : $variation["stock_quantity"];
							} else {
								$itemArr["stock_quantity"]		= $variation["stock_quantity"];
							}
						}

						$itemArr['properties'] = $this->_buildProperties($item, $itemArr);
						$this->addItemRow($itemArr);

						$isFirst = false;
						$itemArr['has_children']=0;
						$itemArr["parent_item_number"] = $parentItemNumber;
					}
				}
			} else {
				$itemArr['has_children']=0;
				//$itemArr['properties'] = $this->_buildProperties($item, $itemArr);
				if($products_id > 0) return $itemArr;
				if($item['products_master_status'] > 0){
					$pitem = $itemArr;
					$pitem['parent_item_number'] = 0;
					$pitem['item_number'] = 'P'.$item['products_id'];
					$pitem['has_children'] = 1;
					$attributes = $this->yes_getAttributes($item['products_id'],substr($itemArr['parent_item_number'],1,strlen($itemArr['parent_item_number'])));
					$max_att = 10;
					$cur_att = 0;
					if(sizeOf($attributes)){
						foreach($attributes as $att){
							if($cur_att < $max_att){
								$pitem['attribute_'.($cur_att+1)] = $att['title'];
							}
							$cur_att++;
						}
					}
					$this->addItemRow($pitem);
				}
				$this->addItemRow($itemArr);
			}
		}
	}

	private function _getPackeges($product, $tax_rate) {
		$customerStatusId = $this->config->getCustomerPriceGroup();
		if($customerStatusId > 0) return '';

		$qry = "
			SELECT *
			FROM ".TABLE_PERSONAL_OFFERS_BY."$customerStatusId
			WHERE products_id = '".$product["products_id"]."'
			  AND quantity > 1
			ORDER BY quantity
		";

		$specialOffers = array();
		$_specialOffers = xtc_db_query($qry);

		while($specialOffer = xtc_db_fetch_array($_specialOffers)) {
			$specialOffers[] = implode("=>", array(
				"qty" => $specialOffer["quantity"],
				"personal_offer" => round($specialOffer["personal_offer"] * (1+($tax_rate/100)), 2),
			));
		}

		return implode("||", $specialOffers);
	}

	private function _getProductVPE($product, $price) {
		$vpe = "";
                if($product['products_vpe'] > 0){
                    $product['products_vpe_name'] = xtc_get_vpe_name($product['products_vpe']);
                }
		if(!empty($product["products_vpe_value"]) && !empty($product["products_vpe_name"]) && $product["products_vpe_value"] != 0.0000){

			if($product["products_vpe_status"] == 1){

				$factor = 1;
				switch(strtolower($product["products_vpe_name"])) {
					case "ml":
					case "mg":
						$factor = $product["products_vpe_value"]<250?100:1000;
						break;
				}
				
				$_price = ( $price / $product["products_vpe_value"] ) * $factor;

				$vpe  = $this->currency["symbol_left"];
				
				$vpe .= $this->formatPriceNumber(
					$_price,
					$this->currency["decimal_places"],
					$this->currency["decimal_point"],
					$this->currency["thousands_point"]
				);
				
				$vpe .= " " . trim($this->currency["symbol_right"]);
				$vpe .= ' pro '.(($factor == 1) ? '' : $factor.' ');
				$vpe .= $product["products_vpe_name"];
			}
		}

		return $vpe;
	}

	/**
	 * Generates an available text based on the date available field
	 *
	 * @param array $item
	 * @return string
	 */
	private function _getAvailableText($item = array(), $defaultStatusName = '') {
		if(empty($item) || empty($item['shipping_status_name']) && empty($defaultStatusName)) {
			return '';
		}
		
		if(!empty($defaultStatusName)) {
			$availableText = (string) $defaultStatusName;
		} else {
			$availableText = (string) $item['shipping_status_name'];
		}
		
		// Check if the product is available in the future
		if(!empty($item['products_date_available'])) {
			// Check if the date is in the future
			$availableOnTimestamp = strtotime(substr($item['products_date_available'], 0, 10) . ' 00:00:00'); // Take the date beginning at 00:00:00 o' clock
			// Set the "available on" text only if it is at least one day in the future
			if($availableOnTimestamp-time() > 60*60*24) { // 60sec * 60min * 24h == count seconds in 1 day
				switch(strtolower($this->config->getLanguage())) {
					case 'de':
						$dateAvailableFormatted = date('d.m.Y', $availableOnTimestamp);
						break;
					case 'en':
					default:
						$dateAvailableFormatted = date('m/d/Y', $availableOnTimestamp);
						break;
				}
				if(isset($availableText) and $availableText != ''){
				    $availableText .= ' / ';
				}
				$availableText .= str_replace('#DATE#', $dateAvailableFormatted, SHOPGATE_PLUGIN_FIELD_AVAILABLE_TEXT_AVAILABLE_ON_DATE);
				//$availableText .= ' - '.str_replace('#SHIPPINGTIME#', (string) $item['shipping_status_name'], SHOPGATE_PLUGIN_FIELD_AVAILABLE_TEXT_SHIPPING_DELAY);
			}
		}
		
		// return a default string as fallback
		return $availableText;
	}

	/**
	 * Function to Parse Options like [TAB:xxxx] in the Description
	 * @param string $descrtiption
	 */
	private function _parseDescription($description) {
		$tabs = array();
		$_tabs = preg_match_all("/\[TAB:[\w\s\d\&\;]*\]/", $description, $tabs);

		foreach($tabs[0] as $replace) {
			$replacement = preg_replace("/(\[TAB:)|\]/", "", $replace);
			$replacement = "<h1>".$replacement."</h1>";

			$description = preg_replace("/".preg_quote($replace)."/", $replacement, $description);
		}

		return $description;
	}

	/**
	 * Exportiere alle Produktbilder
	 *
	 * @param string $product
	 */
	private function _getProductsImages($product) {
		$this->log("execute _getProductImages() ...", ShopgateLogger::LOGTYPE_DEBUG);
		
		$qry = "
			SELECT *
			FROM ".TABLE_PRODUCTS_IMAGES."
			WHERE products_id = '".$product["products_id"]."'
			ORDER BY image_nr
		";

		$images = array();

		if(!empty($product['products_image'])){
			if(file_exists(DIR_FS_CATALOG.'images/product_images/original_images/'.$product['products_image'])){
				$images[] = HTTP_SERVER.'images/product_images/original_images/'.$product['products_image'];
			}elseif(file_exists(DIR_FS_CATALOG.'images/product_images/popup_images/'.$product['products_image'])){
				$images[] = HTTP_SERVER.'images/product_images/popup_images/'.$product['products_image'];
			}
		}

		$query = xtc_db_query($qry);
		while($image = xtc_db_fetch_array($query)) {
			if(file_exists(DIR_FS_CATALOG.'images/product_images/original_images/'.$image['image_name'])){
				$images[] = HTTP_SERVER.'images/product_images/original_images/'.$image['image_name'];
			}elseif(file_exists(DIR_FS_CATALOG.'images/product_images/popup_images/'.$image['image_name'])){
				$images[] = HTTP_SERVER.'images/product_images/popup_images/'.$image['image_name'];
			}
		}

		$images = implode("||", $images);

		return $images;
	}

	private function _getProductCategoryNumbers($item, $maxId, $addToOrderIndex) {
		$this->log("execute _getProductCategoryNumbers() ...", ShopgateLogger::LOGTYPE_DEBUG);
		
		$category_numbers = array();
		$catsQry = "
			SELECT DISTINCT
				ptc.categories_id,
				c.products_sorting2
			FROM ".TABLE_PRODUCTS_TO_CATEGORIES." ptc
			INNER JOIN ".TABLE_CATEGORIES." c ON (ptc.categories_id = c.categories_id)
			WHERE ptc.products_id = '".$item["products_id"]."'
				AND c.categories_status = 1 and c.shopgate_block=0
			";
		$catsQuery = xtc_db_query($catsQry);
		
		while($category = xtc_db_fetch_array($catsQuery)) {
			if(empty($category["categories_id"])) {
				continue;
			}
			
			$catNumber = "";
			
			if($category["products_sorting2"] != "ASC"){
				
				if($this->config->getReverseItemsSortOrder()){
					$sort = $maxId - $item["products_sort"];
				} else {
					$sort = $item["products_sort"];
				}
				
			} else {
				
				if($this->config->getReverseItemsSortOrder()){
					$sort = $item["products_sort"];
				} else {
					$sort = $maxId - $item["products_sort"];
				}
			}
			
			if (!empty($sort) || ((string) $sort === '0')) {
				$sort += $addToOrderIndex;
				$catNumber = "=>".$sort;
			}
			$catNumber = $category["categories_id"].$catNumber;
			$category_numbers[] = $catNumber;
		}
		
		return $category_numbers;
	}

	/**
	 *
	 * @param mixed[] $product
	 * @param mixed[] $tax
	 * @return float
	 */
	private function _getPersonalOffersPrice($product, $tax) {
		$this->log("execute _getPersonalOffersPrice() ...", ShopgateLogger::LOGTYPE_DEBUG);
		
		$customerStatusId = $this->config->getCustomerPriceGroup();
		if(empty($customerStatusId)) return false;

		$qry = "SELECT * FROM ".TABLE_PERSONAL_OFFERS_BY."$customerStatusId
		WHERE products_id = '".$product["products_id"]."'
		AND quantity = 1";
		
		$qry = xtc_db_query($qry);
		if(!$qry) return false;
		
		$specialOffer = xtc_db_fetch_array( $qry );
		
		return floatval($specialOffer["personal_offer"]);
	}

	/**
	 * Takes a price value and a discount percent value and returns the new discounted price
	 * @param float $price
	 * @param float $discountPercent
	 * @return float
	 */
	private function _getDiscountPrice($price, $discountPercent) {
		$discountedPrice = $price * (1-$discountPercent/100);
		return $discountedPrice;
	}
	
	/**
	 * Load all Categories of the product and build its category-path
	 *
	 * The categories are seperated by a =>. The Paths are seperated b< a double-pipe ||
	 *
	 * Example: kategorie_1=>kategorie_2||other_1=>other_2
	 * @param int $productId
	 * @return string
	 */
	private function _getProductPath($productId) {
		$this->log("execute _getProductPath() ...", ShopgateLogger::LOGTYPE_DEBUG);

		$catsQry = "
			SELECT DISTINCT ptc.categories_id
			FROM ".TABLE_PRODUCTS_TO_CATEGORIES." ptc
			INNER JOIN ".TABLE_CATEGORIES." c ON ptc.categories_id = c.categories_id
			WHERE ptc.products_id = '$productId'
			  AND c.categories_status = 1
			ORDER BY products_sorting
		";
		$catsQuery = xtc_db_query($catsQry);

		$categories = "";
		while($category = xtc_db_fetch_array($catsQuery)) {
			$cats = xtc_get_category_path($category["categories_id"]);
			$cats = preg_replace("/\_/", ",", $cats);

			$q = "
				SELECT DISTINCT cd.categories_name
				FROM ".TABLE_CATEGORIES_DESCRIPTION." cd
				WHERE cd.categories_id IN (".$cats.")
					AND cd.language_id = ".$this->languageId."
				ORDER BY find_in_set(cd.categories_id, '$cats')
			";

			$q = xtc_db_query($q);
			$cats = "";
			while($cd = xtc_db_fetch_array($q)) {
				if(!empty($cats))$cats.="=>";
				$cats.=$cd["categories_name"];
			}
			if(!empty($categories))$categories.="||";
			$categories.=$cats;
		}

		return $categories;
	}

	/**
	 * Returns a array with all Variations of the Product
	 * @param int $productId
	 */
	private function _getVariations($productId, $tax_rate,$string_mode = true) {
		// YES: bei string_mode false gebe ich ein sauberes Array zurueck
		$this->log("execute _getVariations() ...", ShopgateLogger::LOGTYPE_DEBUG);
		
		$sg_prod_var = array();
		

 		// BOF YES - mario

		$query = xtc_db_query(sprintf(
			"SELECT pp.products_properties_id,ppd.title FROM products_properties pp LEFT JOIN products_properties_description ppd USING(products_properties_id) WHERE products_id='%s' AND ppd.language_id='%s' ORDER BY pp.sort_order ASC",
			$productId,$this->languageId
		));
		if(xtc_db_num_rows($query)){
			$options = array();
			$properties_array = array();
			$num_variations = 0;
			while($record = xtc_db_fetch_array($query)){
				$properties_array[] = array('id'=>$record['products_properties_id'],'text'=>$record['title']);
			}
			foreach($properties_array as $pp){
				$values = array();
				$query = xtc_db_query(sprintf(
					"SELECT ppv.products_properties_values_id,price,sort_order,image,ppvd.title FROM products_properties_values ppv LEFT JOIN products_properties_values_description ppvd USING(products_properties_values_id) WHERE ppv.products_properties_id='%s' AND ppvd.language_id='%s'",
					$pp['id'],$this->languageId
				));
				while($record = xtc_db_fetch_array($query)){
					$optionOffsetPrice = $record['price']*$this->exchangeRate*(1+($tax_rate/100)); // Include Tax
					$optionOffsetPrice = round($optionOffsetPrice * 100, 2); // get euro-cent
					$values[] = array(
						'value_number'=>$record['products_properties_values_id'],
						'value'=>$record['title'],
						'additional_unit_amount_with_tax'=>$optionOffsetPrice,
						'brutto_price'=>$record['price']*$this->exchangeRate*(1+($tax_rate/100)),
						'netto_price'=>$record['price']
					);
				}
				$num_variations += sizeOf($values);
				$option = array(
					'option_number'=>$pp['id'],
					'name'=>$pp['text'],
					'values'=>$values
				);
				$options[] = $option;
			}
			if(!$string_mode){
				return $options;
			}
			$this->_buildOptions($sg_prod_var, $options, $tax_rate);
			$sg_prod_var["has_options"] = 1;
			return $sg_prod_var;
		}

		// EOF YES - mario

		$qry = "
			SELECT
				pa.products_attributes_id,
				po.products_options_id,
				pov.products_options_values_id,
				po.products_options_name,
				pov.products_options_values_name,
				pa.attributes_model,
				pa.options_values_price,
				pa.price_prefix,
				pa.options_values_weight,
				pa.attributes_stock,
				pa.weight_prefix
			FROM ".TABLE_PRODUCTS_ATTRIBUTES." pa
			INNER JOIN ".TABLE_PRODUCTS_OPTIONS." po ON (pa.options_id = po.products_options_id AND po.language_id = $this->languageId)
			INNER JOIN ".TABLE_PRODUCTS_OPTIONS_VALUES." pov ON (pa.options_values_id = pov.products_options_values_id AND pov.language_id = $this->languageId)
			WHERE pa.products_id = '".$productId."'
				AND pov.products_options_values_name != 'TEXTFELD'
		";

		$qry .= " ORDER BY po.products_options_id, pa.sortorder ASC";

		$query = xtc_db_query($qry);

		//		$options = array_pad(array(), 5, "");
		$options = array();

		$i=-1;
		$old = null;
		while($variation = xtc_db_fetch_array($query)) {
			if($variation["products_options_id"] != $old || is_null($old)){
				$i++;
				$old = $variation["products_options_id"];
			}
			$options[$i][] = $variation;
		}

		if(empty($options)) return array();

		// Find and rename duplicate option-value names
		foreach($options as $optionIndex => $singleOption) {
			// Check all option-value names for duplicate names
			foreach($singleOption as $key => $optionVariation) {
				if(!empty($optionVariation)) {
					// Compare with following entries
					$indexNumber = 1;
					for($i = $key+1; $i < count($singleOption); $i++) {
						if(trim($singleOption[$i]['products_options_values_name']) == trim($optionVariation['products_options_values_name'])) {
							$indexNumber++;
							$options[$optionIndex][$i]['products_options_values_name'] .= " $indexNumber";
						}
					}
					// Add index 1 to the actual name if duplicate name-entries found
					if($indexNumber > 1) {
						$options[$optionIndex][$key]['products_options_values_name'] .= " 1";
		
						// Refresh the working variable for further operation
						$singleOption = $options[$optionIndex];
					}
				}
			}
		}
		
		$countVariations = 1;
		foreach($options as $option){
			$countVariations *= count($option);
		}

		if($countVariations > $this->config->getMaxAttributes()) {
			$this->_buildOptions($sg_prod_var, $options, $tax_rate);
			$sg_prod_var["has_options"] = 1;
		} else {
			$this->_buildAttributes($sg_prod_var, $options);
			$sg_prod_var["has_options"] = 0;
		}

		return $sg_prod_var;
	}


	/**
	 * Build the Productvariations as options
	 *
	 * @param &array $sg_prod_var
	 * @param array $variations
	 * @param float $tax_rate
	 */
	private function _buildOptions(&$sg_prod_var, $variations, $tax_rate) {
		$this->log("execute _buildOptions() ...", ShopgateLogger::LOGTYPE_DEBUG);
		
		$tmp=array();
		$i = 0;
		foreach($variations as $_variation) {
			$i++;
			$tmp["option_$i"] = $_variation["option_number"] . '=' . strip_tags($_variation["name"]);

			$options = array();
			foreach($_variation['values'] as $option) {
				$field  = strip_tags($option["value_number"])."=".strip_tags($option["value"]);
				$field .= ($option['netto_price'] != 0)
					? "=>".$option['additional_unit_amount_with_tax']
					: "";
				$options[] = $field;
			}
			$tmp["option_".$i."_values"] = implode("||", $options);
		}

		$sg_prod_var = $tmp;
	}

	/**
	 * Build the Productvariations recursively
	 *
	 * @param &array $sg_prod_var
	 * @param array $variations
	 * @param int $index
	 * @param array $tmp
	 */
	private function _buildAttributes(&$sg_prod_var, $variations, $index = 0, $baseVar = array()) {
		$this->log("execute _buildAttributes() ...", ShopgateLogger::LOGTYPE_DEBUG);
		
		if($index == 0) {
			// Index 0 sind die Überschriften. Diese müssen als erstes hinzugefügt werden
			for($i = 0; $i < count($variations); $i++){
				$sg_prod_var[0]['attribute_'.($i+1)] = $variations[$i][0]['products_options_name'];
			}
		}
		
		foreach($variations[$index] as $variation) {
			$tmpNewVariation = array();
			
			// copy all prvious attributes (inclusive the order info)
			if(!empty($baseVar)) {
				for($i = 1; $i <= 10; $i++) {
					$keyName = 'attribute_'.$i;
					if(array_key_exists($keyName, $baseVar)) {
						$tmpNewVariation[$keyName] = $baseVar[$keyName];
						$tmpNewVariation['order_info'][$keyName] = $baseVar['order_info'][$keyName];
					} else {
						break;
					}
				}
			}
			
			if(count($variations) == 1){
				// only if 1 dimension
				$tmpNewVariation['item_number'] = $variation['attributes_model'];
			}
			
			$tmpNewVariation['attribute_'.($index+1)] = $variation['products_options_values_name'];
			$tmpNewVariation['order_info']['attribute_'.($index+1)] = array(
				$variation['products_attributes_id'] => array(
					'options_id' => $variation['products_options_id'],
					'options_values_id' => $variation['products_options_values_id'],
				),
			);
			
			$tmpNewVariation['stock_quantity'] = $variation['attributes_stock'];
			if(isset($baseVar['stock_quantity']) && $baseVar['stock_quantity'] < $variation['attributes_stock']){
				$tmpNewVariation['stock_quantity'] = $baseVar['stock_quantity'];
			}

			// Kalkuliere den Preisunterschied (Steuern und Währung werden noch nicht hier berücksichtigt)
			$price = $variation['options_values_price'];
			if($variation['price_prefix'] == '-'){
				$price = -1 * $price;
			}
			if(empty($baseVar['offset_amount'])) {
				$baseVar['offset_amount'] = 0;
			}
			$tmpNewVariation['offset_amount'] = $baseVar['offset_amount'] + $price;

			// Kalkuliere den Gewichtsunterschied
			$weight = (float) $variation['options_values_weight'];
			if($variation['weight_prefix'] == '-'){
				$weight = -1 * $weight;
			}
			if(empty($baseVar['offset_weight'])) {
				$baseVar['offset_weight'] = 0;
			}
			$tmpNewVariation['offset_weight'] = $baseVar['offset_weight'] + (double) $weight;

			if($index < (count($variations)-1)) {
				// Fahre mit nächstem Attribute fort (mit aktuellem Zwischenattribut als Basis für die Gewicht, Stock und Preisberechnung)
				// Das aktuelle Zwischenattribut enthält das Gesamtgewicht, den Gesamtpreis und den max-Stock, der für weitere Berechnungen notwendig ist
				$this->_buildAttributes($sg_prod_var, $variations, $index+1, $tmpNewVariation);
			} else {
				// Wenn kein Attribut mehr existiert, dieses auf den Stack legen
				$sg_prod_var[] = $tmpNewVariation;
			}
		}
	}

	private function _getRelatedShopItems($products_id) {
		$this->log("execute _getRelatedShopItems() ...", ShopgateLogger::LOGTYPE_DEBUG);
		$qry = "
			SELECT px.xsell_id
			FROM ".TABLE_PRODUCTS_XSELL." px
			INNER JOIN ".TABLE_PRODUCTS." p ON (px.products_id = p.products_id)
			WHERE p.products_id = '$products_id'
				AND (p.products_date_available < NOW() OR p.products_date_available IS NULL)
			ORDER BY px.sort_order
		";
		
		$xSellIds = array();
		
		$query = xtc_db_query($qry);
		for($i = 0; $i < xtc_db_num_rows($query); $i++) {
		$array = xtc_db_fetch_array($query);
		$xSellIds[] = $array["xsell_id"];
		}
		
		return implode("||", $xSellIds);
	}
	
	private function _buildProperties($product, $itemArr) {
		$properties = array();

		if(!empty($product["products_fsk18"]) && $product["products_fsk18"] == 1)
			$properties[] = "Altersbeschraenkung=>18 Jahre";

		return implode("||", $properties);
	}


	private function _getInputFields($productId){
		$this->log("execute _getInputFields() ...", ShopgateLogger::LOGTYPE_DEBUG);
		$qry = "
			SELECT
				pa.products_attributes_id,
				po.products_options_id,
				pov.products_options_values_id,
				po.products_options_name,
				pov.products_options_values_name,
				pa.attributes_model,
				pa.options_values_price,
				pa.price_prefix,
				pa.options_values_weight,
				pa.attributes_stock,
				pa.weight_prefix
			FROM ".TABLE_PRODUCTS_ATTRIBUTES." pa
			INNER JOIN ".TABLE_PRODUCTS_OPTIONS." po ON pa.options_id = po.products_options_id
			INNER JOIN ".TABLE_PRODUCTS_OPTIONS_VALUES." pov ON (pa.options_values_id = pov.products_options_values_id AND pov.language_id = $this->languageId)
			WHERE pa.products_id = '$productId'
				AND pov.products_options_values_name = 'TEXTFELD'
			ORDER BY po.products_options_id, pa.sortorder
		";
		
		$query = xtc_db_query($qry);
		
		while($inputFields = xtc_db_fetch_array($query)) {
			if($inputFields["products_options_id"] != $old){
				$i++;
				$old = $inputFields["products_options_id"];
			}
			$inputFieldsAll[$i][] = $inputFields;
		}
		
		if(empty($inputFieldsAll)){
			return;
		}
		
		$sg_product_var = $this->_buildInputFields($inputFieldsAll);

		return $sg_product_var;

	}

	private function _buildInputFields($inputFieldsAll){
		$sg_product_var = array();
		$i = 0;
		foreach($inputFieldsAll as $inputField) {
			$i++;
			
			//			$sg_product_var["has_input_fields"] = 1;
			$sg_product_var["input_field_".$i."_type"] = 'text';
			$sg_product_var["input_field_".$i."_label"] = strip_tags($inputField[0]["products_options_name"]);
			$sg_product_var["input_field_".$i."_add_amount"] = ($inputField["options_values_price"] != 0)
				? "=>".$option["price_prefix"].round($inputField["options_values_price"], 2)
				: "";
			// keine Angabe möglich
			$sg_product_var["input_field_".$i."_infotext"] = '';
			$sg_product_var["input_field_".$i."_required"] = 0;
		}
		
		return $sg_product_var;
	}


	/**
	 * @see ShopgatePlugin::getCustomer()
	 */
	public function getCustomer($user, $pass) {
		// save the UTF-8 version for logging etc.
		$userUtf8 = $user;
		
		// decode the parameters if necessary to make them work with xtc_* functions
		$user = $this->stringFromUtf8($user, $this->config->getEncoding());
		$pass = $this->stringFromUtf8($pass, $this->config->getEncoding());

		// find customer
		$qry = "SELECT"

		// basic user information
		. " customer.customers_id,"
		. " customer.customers_cid,"
		. " status.customers_status_name,"
		. " status.customers_status_id,"
		. " customer.customers_gender,"
		. " customer.customers_firstname,"
		. " customer.customers_lastname,"
		. " date_format(customer.customers_dob,'%Y-%m-%d') as customers_birthday,"
		. " customer.customers_telephone,"
		. " customer.customers_email_address,"

		// additional information for password verification, default address etc.
		. " customer.customers_password,"
		. " customer.customers_default_address_id"

		. " FROM " . TABLE_CUSTOMERS . " AS customer"

		. " INNER JOIN " . TABLE_CUSTOMERS_STATUS . " AS status"
		. " ON customer.customers_status = status.customers_status_id"
		. " AND status.language_id = ".$this->languageId

		. " WHERE customers_email_address = '" . xtc_db_input($user) . "';";

		// user exists?
		$customerResult = xtc_db_query($qry);
		if (empty($customerResult)) {
			throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_WRONG_USERNAME_OR_PASSWORD, 'User: '.$userUtf8);
		}

		// password's correct?
		$customerData = xtc_db_fetch_array($customerResult);
		if (!xtc_validate_password($pass, $customerData['customers_password'])) {
			throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_WRONG_USERNAME_OR_PASSWORD, 'User: '.$userUtf8);
		}

		// fetch customers' addresses
		$qry = "SELECT"

		. " address.address_book_id,"
		. " address.entry_gender,"
		. " address.entry_firstname,"
		. " address.entry_lastname,"
		. " address.entry_company,"
		. " address.entry_street_address,"
		. " address.entry_postcode,"
		. " address.entry_city,"
		. " country.countries_iso_code_2,"
		. " zone.zone_code"


		. " FROM " . TABLE_ADDRESS_BOOK . " AS address"

		. " LEFT JOIN " . TABLE_COUNTRIES . " AS country"
		. " ON country.countries_id = address.entry_country_id"

		. " LEFT JOIN " . TABLE_ZONES . " AS zone"
		. " ON address.entry_zone_id = zone.zone_id"
		. " AND country.countries_id = zone.zone_country_id"

		. " WHERE address.customers_id = " . xtc_db_input($customerData['customers_id']) . ";";

		$addressResult = xtc_db_query($qry);
		if (empty($addressResult)) {
			throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_NO_ADDRESSES_FOUND, 'User: '.$userUtf8);
		}

		$addresses = array();
		while ($addressData = xtc_db_fetch_array($addressResult)) {
			try {
				$stateCode = ShopgateXtcMapper::getShopgateStateCode($addressData["countries_iso_code_2"], $addressData["zone_code"]);
			} catch (ShopgateLibraryException $e) {
				// if state code can't be mapped to ISO use xtc3 state code
				$stateCode = $addressData['zone_code'];
			}

			try {
				$address = new ShopgateAddress();
				$address->setId($addressData['address_book_id']);
				$address->setAddressType(ShopgateAddress::BOTH); // xtc3 doesn't make a difference
				$address->setGender($addressData["entry_gender"]);
				$address->setFirstName($addressData["entry_firstname"]);
				$address->setLastName($addressData["entry_lastname"]);
				$address->setCompany($addressData["entry_company"]);
				$address->setStreet1($addressData["entry_street_address"]);
				$address->setZipcode($addressData["entry_postcode"]);
				$address->setCity($addressData["entry_city"]);
				$address->setCountry($addressData["countries_iso_code_2"]);
				//yes mario: raus
				$address->setState('');
			} catch (ShopgateLibraryException $e) {
				// don't abort here
			}

			// put default address in front, append the others
			if ($address->getId() == $customerData['customers_default_address_id']) {
				array_unshift($addresses, $address);
			} else {
				$addresses[] = $address;
			}
		}

		try {
			$customer = new ShopgateCustomer();
			$customer->setCustomerId($customerData["customers_id"]);
			$customer->setCustomerNumber($customerData["customers_cid"]);
			$customer->setCustomerGroup($customerData['customers_status_name']);
			$customer->setCustomerGroupId($customerData['customers_status_id']);
			$customer->setGender($customerData["customers_gender"]);
			$customer->setFirstName($customerData["customers_firstname"]);
			$customer->setLastName($customerData["customers_lastname"]);
			$customer->setBirthday($customerData["customers_birthday"]);
			$customer->setPhone($customerData["customers_telephone"]);
			$customer->setMail($customerData["customers_email_address"]);
			$customer->setAddresses($addresses);

			// utf-8 encode the values recursively
			$customer = $customer->utf8Encode($this->config->getEncoding());
		} catch (ShopgateLibraryException $e) {
			// don't abort here
		}

		return $customer;
	}

	/**
	 * @see ShopgatePluginCore::addOrder()
	 */
	public function addOrder(ShopgateOrder $order) {
		// save UTF-8 payment infos (to build proper json)
		$paymentInfosUtf8 = $order->getPaymentInfos();
		
		$this->log('start add_order()', ShopgateLogger::LOGTYPE_DEBUG);
		
		// data needs to be utf-8 decoded for äöüß and the like to be saved correctly
		$order = $order->utf8Decode($this->config->getEncoding());
		if ($order instanceof ShopgateOrder); // for Eclipse auto-completion

		$this->log('db: duplicate_order', ShopgateLogger::LOGTYPE_DEBUG);
		
		// check that the order is not imported already
		$qry = "
			SELECT
			o.*,
			so.shopgate_order_number
			FROM ".TABLE_ORDERS." o
			INNER JOIN ".TABLE_SHOPGATE_ORDERS." so ON (so.orders_id = o.orders_id)
			WHERE so.shopgate_order_number = '{$order->getOrderNumber()}'
		";
		$result = xtc_db_query( $qry );
		$dbOrder = xtc_db_fetch_array( $result );

		if(!empty($dbOrder)) {
			throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_DUPLICATE_ORDER, 'external_order_number: '. $dbOrder["orders_id"], true);
		}

		// retrieve address information
		$delivery = $order->getDeliveryAddress();
		$invoice = $order->getInvoiceAddress();

		// find customer
		$customerId = $order->getExternalCustomerId();

		$shopCustomer = array();
		if (!empty($customerId)) {
			$this->log('db: customer', ShopgateLogger::LOGTYPE_DEBUG);
			$result = xtc_db_query("SELECT * FROM " . TABLE_CUSTOMERS . " WHERE customers_id = '{$customerId}'");
			$shopCustomer = xtc_db_fetch_array($result);
		}
		if (empty($shopCustomer)) {
			$this->log('create Guest User', ShopgateLogger::LOGTYPE_DEBUG);
			$shopCustomer = $this->_createGuestUser($order);
		}

		$phone_number = $order->getMobile();
		if(empty($phone_number)) {
			$phone_number = $order->getPhone();
		}

		// get customers address
		$qry = "
			SELECT
				*
			FROM `".TABLE_ADDRESS_BOOK."` AS `ab`
			WHERE `ab`.`customers_id` = '{$shopCustomer['customers_id']}'".(!empty($shopCustomer['customers_default_address_id']) ? ("
				AND `ab`.`address_book_id` = '{$shopCustomer['customers_default_address_id']}'") : "")."
		;";
		$qryResult = xtc_db_query($qry);
		$customersAddress = xtc_db_fetch_array($qryResult);
		// get address format
		if(!empty($customersAddress)) {
			$addressFormatCustomer = $this->_getAddressFormatId(null, $customersAddress['entry_country_id']);
		} else {
			$customersAddress = array(
				'entry_gender' => $shopCustomer['customers_gender'],
				'entry_company' => '',
				'entry_firstname' => $shopCustomer['customers_firstname'],
				'entry_lastname' => $shopCustomer['customers_lastname'],
				'entry_street_address' => '',
				'entry_suburb' => '',
				'entry_postcode' => '',
				'entry_city' => '',
				'entry_state' => '',
				'entry_country_id' => '',
				'entry_zone_id' => '',
			);
		}
		$addressFormatDelivery = $this->_getAddressFormatId($delivery->getCountry());
		$addressFormatInvoice = $this->_getAddressFormatId($invoice->getCountry());
		if(empty($addressFormatCustomer)) {
			$addressFormatCustomer = $addressFormatInvoice;
		}
		if(empty($addressFormatCustomer)) {
			$addressFormatCustomer = $addressFormatDelivery;
		}

		$this->log('db: customer_status', ShopgateLogger::LOGTYPE_DEBUG);
		
		$result = xtc_db_query("SELECT * FROM " . TABLE_CUSTOMERS_STATUS . " WHERE language_id = '{$this->languageId}' AND customers_status_id = '{$shopCustomer["customers_status"]}'");
		$customersStatus = xtc_db_fetch_array($result);
		if (empty($customersStatus)) throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_NO_CUSTOMER_GROUP_FOUND, print_r($shopCustomer,true));


		$this->log('before ShopgateMapper', ShopgateLogger::LOGTYPE_DEBUG);
		
		// map state codes (called "zone id" in shopsystem)
		$customersStateCode = $customersAddress['entry_state'];
		$invoiceStateCode  = $invoice->getState();
		$deliveryStateCode = $delivery->getState();

		$this->log('db: countries', ShopgateLogger::LOGTYPE_DEBUG);
		
		$result = xtc_db_query("SELECT * FROM ".TABLE_COUNTRIES." WHERE countries_id = '{$customersAddress['entry_country_id']}'");
		$customersCountry = xtc_db_fetch_array($result);
		$result = xtc_db_query("SELECT * FROM ".TABLE_COUNTRIES." WHERE countries_iso_code_2 = '{$delivery->getCountry()}'");
		$deliveryCountry = xtc_db_fetch_array($result);
		$result = xtc_db_query("SELECT * FROM ".TABLE_COUNTRIES." WHERE countries_iso_code_2 = '{$invoice->getCountry()}'");
		$invoiceCountry = xtc_db_fetch_array($result);
		if(empty($customersCountry)) {
			$customersCountry = $invoiceCountry;
		}
		if(empty($customersCountry)) {
			$customersCountry = $deliveryCountry;
		}

		///////////////////////////////////////////////////////////////////////
		// Save order
		///////////////////////////////////////////////////////////////////////

		$orderData = array();
		$orderData["customers_id"]					= $shopCustomer["customers_id"];
		$orderData["customers_cid"]					= $shopCustomer["customers_cid"];
		$orderData["customers_vat_id"]				= $shopCustomer["customers_vat_id"];
		$orderData["customers_status"]				= $customersStatus["customers_status_id"];
		$orderData["customers_status_name"]			= $customersStatus["customers_status_name"];
		$orderData["customers_status_image"]		= $customersStatus["customers_status_image"];
		$orderData["customers_status_discount"]		= 0;

		$orderData["customers_name"]				= $customersAddress['entry_firstname']." ".$customersAddress['entry_lastname'];
		//$orderData["customers_firstname"]			= $customersAddress['entry_firstname'];
		//$orderData["customers_lastname"]			= $customersAddress['entry_lastname'];
		$orderData["customers_company"]				= $customersAddress['entry_company'];
		$orderData["customers_street_address"]		= $customersAddress['entry_street_address'];
		$orderData["customers_suburb"]				= $customersAddress['entry_suburb'];
		$orderData["customers_city"]				= $customersAddress['entry_city'];
		$orderData["customers_postcode"]			= $customersAddress['entry_postcode'];
		$orderData["customers_state"]				= $customersStateCode;
		$orderData["customers_country"]				= $customersCountry['countries_name'];
		$orderData["customers_telephone"]			= $shopCustomer['customers_telephone'];
		$orderData["customers_email_address"]		= $shopCustomer['customers_email_address'];
		$orderData["customers_address_format_id"]	= $addressFormatCustomer;

		$orderData["delivery_name"]					= $delivery->getFirstName()." ".$delivery->getLastName();
		//$orderData["delivery_firstname"]			= $delivery->getFirstName();
		//$orderData["delivery_lastname"]				= $delivery->getLastName();
		$orderData["delivery_company"]				= $delivery->getCompany();
		$orderData["delivery_street_address"]		= $delivery->getStreet1() . (strlen($delivery->getStreet2()) > 0 ? (' ' . $delivery->getStreet2()) : '');
		$orderData["delivery_suburb"]				= "";
		$orderData["delivery_city"]					= $delivery->getCity();
		$orderData["delivery_postcode"]				= $delivery->getZipcode();
		$orderData["delivery_state"]				= $deliveryStateCode;
		$orderData["delivery_country"]				= $deliveryCountry["countries_name"];
		//$orderData["delivery_country_iso_code_2"]	= $delivery->getCountry();
		$orderData["delivery_address_format_id"]	= $addressFormatDelivery;

		$orderData["billing_name"]					= $invoice->getFirstName()." ".$invoice->getLastName();
		//$orderData["billing_firstname"]				= $invoice->getFirstName();
		//$orderData["billing_lastname"]				= $invoice->getLastName();
		$orderData["billing_company"]				= $invoice->getCompany();
		$orderData["billing_street_address"]		= $invoice->getStreet1() . (strlen($invoice->getStreet2()) > 0 ? (' ' . $invoice->getStreet2()) : '');
		$orderData["billing_suburb"]				= "";
		$orderData["billing_city"]					= $invoice->getCity();
		$orderData["billing_postcode"]				= $invoice->getZipcode();
		$orderData["billing_state"]					= $invoiceStateCode;
		$orderData["billing_country"]				= $invoiceCountry["countries_name"];
		//$orderData["billing_country_iso_code_2"]	= $invoice->getCountry();
		$orderData["billing_address_format_id"]		= $addressFormatInvoice;

		$orderData["shipping_method"]				= "Pauschal"; // TODO
		$orderData["shipping_class"]				= "flat_flat"; // TODO

		$orderData["cc_type"]						= "";
		$orderData["cc_owner"]						= "";
		$orderData["cc_number"]						= "";
		$orderData["cc_expires"]					= "";
		$orderData["cc_start"]						= "";
		$orderData["cc_issue"]						= "";
		$orderData["cc_cvv"]						= "";
		$orderData["comments"]						= "";

		$orderData["last_modified"]					= date('Y-m-d H:i:s');
		$orderData["date_purchased"]				= $order->getCreatedTime( 'Y-m-d H:i:s' );

		$orderData["currency"]						= $order->getCurrency();
		$orderData["currency_value"]				= $this->exchangeRate;

		$orderData["account_type"]					= "";

		$orderData["payment_method"]				= "shopgate";
		$orderData["payment_class"]					= "shopgate";

		$orderData["customers_ip"]					= "";
		$orderData["language"]						= $this->language;

		//$orderData["afterbuy_success"]				= 0;
		//$orderData["afterbuy_id"]					= 0;

		$orderData["refferers_id"]					= 0;
		$orderData["conversion_type"]				= "2";

		$orderData["orders_status"]					= $this->config->getOrderStatusOpen();

		$orderData["orders_date_finished"] 			= null;
		$orderData["source"] 			= 'shopgate';
		
		
		// BOF - DEFAULT VERSENDER
		$default_shipper = '';
		if(sizeof($order->getItems()) == 1){
		    foreach($order->getItems() as $orderItem) {
			$order_infos = $orderItem->getInternalOrderInfo();
			$order_infos = $this->jsonDecode($order_infos, true);
			$item_number = $orderItem->getItemNumber();
			if(isset($order_infos["base_item_number"])){
				$item_number = $order_infos["base_item_number"];
			}
			if($orderItem->getQuantity() == 1){
			    if(!function_exists('yes_get_products_default_shipper')){
				require_once(DIR_FS_INC.'yes_get_products_default_shipper.inc.php');
			    }
			    $default_shipper = yes_get_products_default_shipper($item_number);
			}
		    }
		}
		// EOF - DEFAULT VERSENDER
		
		$orderData['versender'] = $default_shipper;

		$this->log('db: save order', ShopgateLogger::LOGTYPE_DEBUG);
		
		// Speichere die Bestellung
		xtc_db_perform(TABLE_ORDERS,$orderData);
		$dbOrderId = xtc_db_insert_id();

		$this->log('db: save', ShopgateLogger::LOGTYPE_DEBUG);
		
		$ordersShopgateOrder = array(
			"orders_id" => $dbOrderId,
			"shopgate_order_number" => $order->getOrderNumber(),
			"is_paid" => $order->getIsPaid(),
			"is_shipping_blocked" => $order->getIsShippingBlocked(),
			"payment_infos" => $this->jsonEncode($paymentInfosUtf8, true),
			"is_sent_to_shopgate" => 0,
			"modified" => "now()",
			"created" => "now()",
		);
		xtc_db_perform(TABLE_SHOPGATE_ORDERS, $ordersShopgateOrder);
		
		$this->log('method: _insertStatusHistory() ', ShopgateLogger::LOGTYPE_DEBUG);
		$this->_insertStatusHistory($order, $dbOrderId, $orderData['orders_status']);
		
		$this->log('method: _setOrderPayment() ', ShopgateLogger::LOGTYPE_DEBUG);
		$this->_setOrderPayment($order, $dbOrderId, $orderData['orders_status']);
		
		$this->log('method: _insertOrderItems() ', ShopgateLogger::LOGTYPE_DEBUG);
		$this->_insertOrderItems($order, $dbOrderId, $orderData['orders_status']);
		
		$this->log('method: _insertOrderTotal() ', ShopgateLogger::LOGTYPE_DEBUG);
		$this->_insertOrderTotal($order, $dbOrderId);
		
		$this->log('db: update order ', ShopgateLogger::LOGTYPE_DEBUG);
		
		// Save status in order
		$orderUpdateData 					= array();
		$orderUpdateData["orders_status"]	= $orderData["orders_status"];
		$orderUpdateData["last_modified"]	= date( 'Y-m-d H:i:s' );
		xtc_db_perform(TABLE_ORDERS,$orderUpdateData, "update", "orders_id = {$dbOrderId}");
		
		$this->log('method: _pushOrderToAfterbuy', ShopgateLogger::LOGTYPE_DEBUG);
		$this->_pushOrderToAfterbuy($dbOrderId, $order);
		$this->log('method: _pushOrderToDreamRobot', ShopgateLogger::LOGTYPE_DEBUG);
		$this->_pushOrderToDreamRobot($dbOrderId, $order);
		
		$this->log('return: end addOrder()', ShopgateLogger::LOGTYPE_DEBUG);
		return array(
			'external_order_id'=>$dbOrderId,
			'external_order_number'=>$dbOrderId
		);
	}

	public function updateOrder(ShopgateOrder $order) {
		// save UTF-8 payment infos (to build proper json)
		$paymentInfosUtf8 = $order->getPaymentInfos();
		
		// data needs to be utf-8 decoded for äöüß and the like to be saved correctly
		$order = $order->utf8Decode($this->config->getEncoding());
		if ($order instanceof ShopgateOrder); // for Eclipse auto-completion
		
		$qry = "
		SELECT
			o.*,
			so.shopgate_order_id,
			so.shopgate_order_number,
			so.is_paid,
			so.is_shipping_blocked,
			so.payment_infos
		FROM ".TABLE_ORDERS." o
		INNER JOIN ".TABLE_SHOPGATE_ORDERS." so ON (so.orders_id = o.orders_id)
		WHERE so.shopgate_order_number = '{$order->getOrderNumber()}'
		";
		$result = xtc_db_query( $qry );
		$dbOrder = xtc_db_fetch_array( $result );

		if($dbOrder == false){
			throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_ORDER_NOT_FOUND, "Shopgate order number: '{$order->getOrderNumber()}'.");
		}

		$errorOrderStatusIsSent = false;
		$errorOrderStatusAlreadySet = array();
		$statusShoppingsystemOrderIsPaid = $dbOrder['is_paid'];
		$statusShoppingsystemOrderIsShippingBlocked = $dbOrder['is_shipping_blocked'];
		$status = $dbOrder["orders_status"];
		
		// check if shipping is already done, then throw at end of method a OrderStatusIsSent - Exception
		if($status == $this->config->getOrderStatusShipped() && ($statusShoppingsystemOrderIsShippingBlocked || $order->getIsShippingBlocked())){
			$errorOrderStatusIsSent = true;
		}

		if( $order->getUpdatePayment() == 1 ) {

			if(!is_null($statusShoppingsystemOrderIsPaid) && $order->getIsPaid() == $statusShoppingsystemOrderIsPaid &&
				!is_null($dbOrder['payment_infos']) && $dbOrder['payment_infos'] == $this->jsonEncode($paymentInfosUtf8)){
				$errorOrderStatusAlreadySet[] = 'payment';
			}

			if(!is_null($statusShoppingsystemOrderIsPaid) && $order->getIsPaid() == $statusShoppingsystemOrderIsPaid){
				// do not update is_paid
			} else {

				// Save order status
				$orderStatus = array();
				$orderStatus["orders_id"]					= $dbOrder["orders_id"];
				$orderStatus["orders_status_id"]			= $status;
				$orderStatus["date_added"]					= date( 'Y-m-d H:i:s');
				$orderStatus["customer_notified"]			= false;
				if($order->getIsPaid()) {
					$orderStatus['comments'] = 'Bestellstatus von Shopgate geändert: Zahlung erhalten';
				} else {
					$orderStatus['comments'] = 'Bestellstatus von Shopgate geändert: Zahlung noch nicht erhalten';
				}
				
				$orderStatus['comments'] = $this->stringFromUtf8($orderStatus['comments'], $this->config->getEncoding());
				
				xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY,$orderStatus);

				// update the shopgate order status information
				$ordersShopgateOrder = array(
					"is_paid" => (int)$order->getIsPaid(),
					"modified" => "now()",
				);
				xtc_db_perform(TABLE_SHOPGATE_ORDERS, $ordersShopgateOrder, "update", "shopgate_order_id = {$dbOrder['shopgate_order_id']}");

				// update var
				$statusShoppingsystemOrderIsPaid = $order->getIsPaid();

				// Save status in order
				$orderData 					= array();
				$orderData["orders_status"]	= $status;
				$orderData["last_modified"]	= date( 'Y-m-d H:i:s' );
				xtc_db_perform(TABLE_ORDERS,$orderData, "update", "orders_id = {$dbOrder['orders_id']}");

			}

			// update paymentinfos
			if(!is_null($dbOrder['payment_infos']) && $dbOrder['payment_infos'] != $this->jsonEncode($paymentInfosUtf8)){

				$dbPaymentInfos = $this->jsonDecode($dbOrder['payment_infos'], true);
				$paymentInfos = $order->getPaymentInfos();
				$histories = array();

				switch($order->getPaymentMethod()) {
					case ShopgateOrder::SHOPGATE:
					case ShopgateOrder::INVOICE:
					case ShopgateOrder::COD:
						break;
					case ShopgateOrder::PREPAY:

						if(isset($dbPaymentInfos['purpose']) && $paymentInfos['purpose'] != $dbPaymentInfos['purpose']){
							$comments  = $this->stringFromUtf8("Shopgate: Zahlungsinformationen wurden aktualisiert: \n\nDer Kunde wurde angewiesen Ihnen das Geld mit dem Verwendungszweck \"", $this->config->getEncoding());
							$comments .= $paymentInfos["purpose"];
							$comments .= $this->stringFromUtf8("\" auf Ihr Bankkonto zu überweisen", $this->config->getEncoding());
							
							// Order is not paid yet
							$histories[] = 	array(
								"orders_id"=> $dbOrder["orders_id"],
								"orders_status_id"=>$status,
								"date_added"=>date( 'Y-m-d H:i:s'),
								"customer_notified"=>false,
								"comments"=>xtc_db_prepare_input($comments)
							);
						}

						break;
					case ShopgateOrder::DEBIT:
						$qry = "
							SELECT
								*
							FROM banktransfer b
							WHERE b.orders_id = '{$dbOrder['orders_id']}'";
						$result = xtc_db_query( $qry );
						$dbBanktransfer = xtc_db_fetch_array( $result );

						if(!empty($dbBanktransfer)){
							$banktransferData = array();
							$banktransferData["banktransfer_owner"]		= $paymentInfos["bank_account_holder"];
							$banktransferData["banktransfer_number"]	= $paymentInfos["bank_account_number"];
							$banktransferData["banktransfer_bankname"]	= $paymentInfos["bank_name"];
							$banktransferData["banktransfer_blz"]		= $paymentInfos["bank_code"];
							xtc_db_perform("banktransfer", $banktransferData, "update", "orders_id = {$dbOrder['orders_id']}");

							$comments  = $this->stringFromUtf8("Shopgate: Zahlungsinformationen wurden aktualisiert: \n\n", $this->config->getEncoding());
							$comments .= $this->_createPaymentInfos($paymentInfos, $dbOrder['orders_id'], $status, false);
				
							$histories[] = 	array(
								"orders_id"=> $dbOrder["orders_id"],
								"orders_status_id"=>$status,
								"date_added"=>date( 'Y-m-d H:i:s'),
								"customer_notified"=>false,
								"comments"=>xtc_db_prepare_input($comments)
							);
						}

						break;
					case ShopgateOrder::PAYPAL:

						// Save paymentinfos in history
						$history = $this->_createPaymentInfos($paymentInfos, $dbOrder["orders_id"], $status);
						$history['comments'] = $this->stringFromUtf8("Shopgate: Zahlungsinformationen wurden aktualisiert: \n\n", $this->config->getEncoding()).$history['comments'];
						$histories[] = $history;

						break;
					default:
						// mobile_payment

						// Save paymentinfos in history
						$history = $this->_createPaymentInfos($paymentInfos, $dbOrder["orders_id"], $status);
						$history['comments'] = $this->stringFromUtf8("Shopgate: Zahlungsinformationen wurden aktualisiert: \n\n", $this->config->getEncoding()).$history['comments'];
						$histories[] = $history;

						break;
				}

				foreach($histories as $history){
					xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY,$history);
				}
			}

			$ordersShopgateOrder = array(
				"payment_infos" => $this->jsonEncode($paymentInfosUtf8),
				"modified" => "now()",
			);
			xtc_db_perform(TABLE_SHOPGATE_ORDERS, $ordersShopgateOrder, "update", "shopgate_order_id = {$dbOrder['shopgate_order_id']}");

		}


		if($order->getUpdateShipping() == 1){

			if(!is_null($statusShoppingsystemOrderIsShippingBlocked) && $order->getIsShippingBlocked() == $statusShoppingsystemOrderIsShippingBlocked){
				$errorOrderStatusAlreadySet[] = 'shipping';
			} else {
				if($status != $this->config->getOrderStatusShipped()){
					if($order->getIsShippingBlocked() == 1){
						$status = $this->config->getOrderStatusShippingBlocked();
					} else {
						$status = $this->config->getOrderStatusOpen();
					}
				}

				$orderStatus = array();
				$orderStatus["orders_id"]					= $dbOrder["orders_id"];
				$orderStatus["date_added"]					= date( 'Y-m-d H:i:s');
				$orderStatus["customer_notified"]			= false;
				$orderStatus['orders_status_id'] 			= $status;
				if($order->getIsShippingBlocked() == 0){
					$orderStatus["comments"] = "Bestellstatus von Shopgate geändert: Versand ist nicht mehr blockiert!";
				} else {
					$orderStatus['comments'] = 'Bestellstatus von Shopgate geändert: Versand ist blockiert!';
				}
				
				$orderStatus['comments'] = $this->stringFromUtf8($orderStatus['comments'], $this->config->getEncoding());
				
				xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY,$orderStatus);

				$ordersShopgateOrder = array(
					"is_shipping_blocked" => (int)$order->getIsShippingBlocked(),
					"modified" => "now()",
				);
				xtc_db_perform(TABLE_SHOPGATE_ORDERS, $ordersShopgateOrder, "update", "shopgate_order_id = {$dbOrder['shopgate_order_id']}");

				$statusShoppingsystemOrderIsShippingBlocked = $order->getIsShippingBlocked();

				// Save status in order
				$orderData 					= array();
				$orderData["orders_status"]	= $status;
				$orderData["last_modified"]	= date( 'Y-m-d H:i:s' );
				xtc_db_perform(TABLE_ORDERS,$orderData, "update", "orders_id = {$dbOrder['orders_id']}");

				$this->_pushOrderToAfterbuy($dbOrder["orders_id"], $order);
				$this->_pushOrderToDreamRobot($dbOrder["orders_id"], $order);
			}
		}

		if($errorOrderStatusIsSent){
			throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_ORDER_STATUS_IS_SENT);
		}

		if(!empty($errorOrderStatusAlreadySet)){
			throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_ORDER_ALREADY_UP_TO_DATE, implode(',', $errorOrderStatusAlreadySet), true);
		}

		return array(
			'external_order_id'=>$dbOrder["orders_id"],
			'external_order_number'=>$dbOrder["orders_id"]
		);
	}

	private function _insertStatusHistory(ShopgateOrder $order, $dbOrderId, &$currentOrderStatus) {
		///////////////////////////////////////////////////////////////////////
		// Speicher Kommentare zur Bestellung in der Historie
		///////////////////////////////////////////////////////////////////////

		$comment = "";
		if($order->getIsTest()){
			$comment .= "#### DIES IST EINE TESTBESTELLUNG ####\n";
		}
		$comment .= "Bestellung durch Shopgate hinzugefügt.";
		$comment .= "\nBestellnummer: ". $order->getOrderNumber();

		$paymentTransactionNumber = $order->getPaymentTransactionNumber();
		if(!empty($paymentTransactionNumber)){
			$comment .= "\nPayment-Transaktionsnummer: ". $paymentTransactionNumber."\n";
		}

		if($order->getIsShippingBlocked() == 0){
			$comment .= "\nHinweis: Der Versand der Bestellung ist bei Shopgate nicht blockiert!";
		} else {
			$comment .= "\nHinweis: Der Versand der Bestellung ist bei Shopgate blockiert!";
			$currentOrderStatus = $this->config->getOrderStatusShippingBlocked();
		}
		if ($order->getIsCustomerInvoiceBlocked()) {
			$comment .= "\nHinweis: Für diese Bestellung darf keine Rechnung versendet werden!";
		}

		$comment = $this->stringFromUtf8($comment, $this->config->getEncoding());
		
		$histories = array(
			array(
				"orders_id"=> $dbOrderId,
				"orders_status_id"=>$currentOrderStatus,
				"date_added"=>date('Y-m-d H:i:s'),
				"customer_notified"=>false,
				"comments"=>xtc_db_prepare_input($comment),
			)
		);

		foreach($histories as $history){
			xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY,$history);
		}
	}

	private function _setOrderPayment(ShopgateOrder $order, $dbOrderId, &$currentOrderStatus) {
		$payment = $order->getPaymentMethod();
		$paymentGroup = $order->getPaymentGroup();
		$paymentInfos = $order->getPaymentInfos();

		$orderData = array();
		$defaultPayment = 'mobile_payment';

		$histories = array();
		switch($payment) {
			case ShopgateOrder::SHOPGATE:
				$orderData["payment_method"] = "shopgate";
				$orderData["payment_class"] = "shopgate";

				break;
			case ShopgateOrder::PREPAY:
				$orderData["payment_method"] = "eustandardtransfer";
				$orderData["payment_class"] = "eustandardtransfer";
				if(!$order->getIsPaid()){
					$currentOrderStatus = 1;
					$comments  = $this->stringFromUtf8("Der Kunde wurde angewiesen Ihnen das Geld mit dem Verwendungszweck \"", $this->config->getEncoding());
					$comments .= $paymentInfos['purpose'];
					$comments .= $this->stringFromUtf8("\" auf Ihr Bankkonto zu überweisen", $this->config->getEncoding());

					// Order is not paid yet
					$histories[] = 	array(
						"orders_id"=> $dbOrderId,
						"orders_status_id"=>$currentOrderStatus,
						"date_added"=>date( 'Y-m-d H:i:s'),
						"customer_notified"=>false,
						"comments"=>xtc_db_prepare_input($comments)
					);
				}

				break;
			case ShopgateOrder::INVOICE:
				$orderData["payment_method"] = "invoice";
				$orderData["payment_class"] = "invoice";

				break;
			case ShopgateOrder::COD:
				$orderData["payment_method"] = "cod";
				$orderData["payment_class"] = "cod";

				break;
			case ShopgateOrder::DEBIT:
				$orderData["payment_method"] = "banktransfer";
				$orderData["payment_class"] = "banktransfer";

				$banktransferData = array();
				$banktransferData["orders_id"]				= $dbOrderId;
				$banktransferData["banktransfer_owner"]		= $paymentInfos["bank_account_holder"];
				$banktransferData["banktransfer_number"]	= $paymentInfos["bank_account_number"];
				$banktransferData["banktransfer_bankname"]	= $paymentInfos["bank_name"];
				$banktransferData["banktransfer_blz"]		= $paymentInfos["bank_code"];
				$banktransferData["banktransfer_status"]	= "0";
				$banktransferData["banktransfer_prz"]		= $dbOrderId;
				$banktransferData["banktransfer_fax"]		= null;
				xtc_db_perform("banktransfer", $banktransferData);

				$comments  = $this->stringFromUtf8("Sie müssen nun den Geldbetrag per Lastschrift von dem Bankkonto des Kunden abbuchen: \n\n", $this->config->getEncoding());
				$comments .= $this->_createPaymentInfos($paymentInfos, $dbOrderId, $currentOrderStatus, false);
				
				$histories[] = 	array(
					"orders_id"=> $dbOrderId,
					"orders_status_id"=>$currentOrderStatus,
					"date_added"=>date( 'Y-m-d H:i:s'),
					"customer_notified"=>false,
					"comments"=>xtc_db_prepare_input($comments)
				);

				break;
			case ShopgateOrder::PAYPAL:
				$orderData["payment_method"] = "paypal";
				$orderData["payment_class"] = "paypal";

				// Save paymentinfos in history
				$histories[] = $this->_createPaymentInfos($paymentInfos, $dbOrderId, $currentOrderStatus);

				break;
			default:
				$orderData["payment_method"] = "mobile_payment";
				$orderData["payment_class"] = "shopgate";

				// Save paymentinfos in history
				$histories[] = $this->_createPaymentInfos($paymentInfos, $dbOrderId, $currentOrderStatus);

				break;
		}

		foreach($histories as $history){
			xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $history);
		}

		xtc_db_perform(TABLE_ORDERS, $orderData, "update", "orders_id = {$dbOrderId}");
	}

	/**
	 * Parse the paymentInfo - array and get as output a array or a string
	 *
	 * @param Array $paymentInfos
	 * @param Integer $dbOrderId
	 * @param Integer $currentOrderStatus
	 *
	 * @return mixed History-Array or String
	 */
	private function _createPaymentInfos($paymentInfos, $dbOrderId, $currentOrderStatus, $asArray = true){
		$paymentInformation = '';
		foreach($paymentInfos as $key => $value){
			$paymentInformation .= $key.': '.$value."\n";
		}

		if($asArray){
			return array(
				"orders_id"=> $dbOrderId,
				"orders_status_id"=>$currentOrderStatus,
				"date_added"=>date('Y-m-d H:i:s'),
				"customer_notified"=>false,
				"comments"=>xtc_db_prepare_input($paymentInformation)
			);
		} else {
			return $paymentInformation;
		}
	}

	private function _insertOrderItems(ShopgateOrder $order, $dbOrderId, &$currentOrderStatus) {
		$saveShippingStatus = false;
		$qry = "SHOW COLUMNS FROM `".TABLE_ORDERS_PRODUCTS."`";
		$result = xtc_db_query($qry);
		while($row = xtc_db_fetch_array($result)) {
			if($row['Field'] == 'products_shipping_time') {
				$saveShippingStatus = true;
				break;
			}
		}
		// Alle Versandstatus abrufen
		$shippingStatus = array();
		if($saveShippingStatus) {
			$qry = "SELECT * FROM `".TABLE_SHIPPING_STATUS."` where `language_id` = '".$this->languageId."'";
			$result = xtc_db_query($qry);
			while($row = xtc_db_fetch_array($result)) {
				$shippingStatus[$row['shipping_status_id']] = $row;
			}
		}
		///////////////////////////////////////////////////////////////////////
		// Speichert die Produkte
		///////////////////////////////////////////////////////////////////////
		$errors = '';
		// BOF YES mario Kundengruppen  beruecksichtigen
		$yes_order_query = xtc_db_query(sprintf(
			"SELECT customers_status,customers_id FROM %s WHERE orders_id='%s'",
			TABLE_ORDERS,$dbOrderId
		));
		$yes_order = xtc_db_fetch_array($yes_order_query);
		$yes_cstatus_query = xtc_db_query(sprintf(
			"select customers_status_show_price_tax from %s where customers_status_id = '%s'",
			TABLE_CUSTOMERS_STATUS,$yes_order['customers_status']
		));
		$yes_cstatus = xtc_db_fetch_array($yes_cstatus_query);
		if(!function_exists('xtc_oe_customer_infos')){
		    require_once(DIR_FS_INC.'xtc_oe_customer_infos.inc.php');
		}
		$c_info = xtc_oe_customer_infos($yes_order['customers_id']);
		// BOF YES mario Kundengruppen  beruecksichtigen
		
		foreach($order->getItems() as $orderItem) {

			$order_infos = $orderItem->getInternalOrderInfo();
			$order_infos = $this->jsonDecode($order_infos, true);

			$item_number = $orderItem->getItemNumber();
			if(isset($order_infos["base_item_number"])){
				$item_number = $order_infos["base_item_number"];
			}

			$this->log('db: get product ', ShopgateLogger::LOGTYPE_DEBUG);
			
			$qry = xtc_db_query(
			"SELECT * FROM ".TABLE_PRODUCTS . " WHERE"
			. " products_id = '" . $item_number ."'"
			. " LIMIT 1");

			$dbProduct = xtc_db_fetch_array($qry);
			if(empty($dbProduct) && ($item_number == 'COUPON' || $item_number == 'PAYMENT_FEE')){
				$this->log('product is COUPON or PAYMENTFEE', ShopgateLogger::LOGTYPE_DEBUG);
				
				// workaround for shopgate coupons
				$dbProduct = array();
				// YES MARIO ADDON
				$dbProduct['products_id'] = ($item_number == 'COUPON') ? $this->config->getProductsIdCoupon() : $this->config->getProductsIdPaymentFee();
				$dbProduct['products_model'] = $item_number;
				$item_number = $dbProduct['products_id'];
			} else if(empty($dbProduct)){
				$this->log('no product found', ShopgateLogger::LOGTYPE_DEBUG);
				
				$this->log(ShopgateLibraryException::buildLogMessageFor(ShopgateLibraryException::PLUGIN_ORDER_ITEM_NOT_FOUND, 'Shopgate-Order-Number: '. $order->getOrderNumber() .', DB-Order-Id: '. $dbOrderId .'; item (item_number: '.$products_model.'). The item will be skipped.'));
				$errors .= "\nItem (item_number: ".$item_number.") can not be found in your shoppingsystem. Please contact Shopgate. The item will be skipped.";

				$dbProduct['products_id'] = 0;
				$dbProduct['products_model'] = $item_number;
			}

			$this->log('db: orders_products', ShopgateLogger::LOGTYPE_DEBUG);
			
			// BOF YES mario Kundengruppen  beruecksichtigen
			$yes_product_query = xtc_db_query(sprintf(
				"SELECT products_tax_class_id FROM %s WHERE products_id='%s'",
				TABLE_PRODUCTS,$item_number
			));
			$yes_product = xtc_db_fetch_array($yes_product_query);
			$yes_tax_rate = xtc_get_tax_rate($yes_product['products_tax_class_id'], $c_info['country_id'], $c_info['zone_id']);
			if($yes_cstatus['customers_status_show_price_tax'] == 1){
			    $yes_single_price = $orderItem->getUnitAmountWithTax();
			}else{
			    $yes_single_price = $orderItem->getUnitAmount();
			}
			//
			// EOF YES mario Kundengruppen
			
			
			
			$productData = array(
				"orders_id"			=>	$dbOrderId,
				"products_model"		=>	$dbProduct["products_model"],
				"products_id"			=>	$item_number,
				"products_name"			=>	xtc_db_prepare_input($orderItem->getName()),
				"products_price"		=>	$yes_single_price,
				"products_discount_made"	=>	0,
				"final_price"			=>	$orderItem->getQuantity() * $yes_single_price,
				"products_tax"			=>	$yes_tax_rate,
				"products_quantity"		=>	$orderItem->getQuantity(),
				"allow_tax"			=>	$yes_cstatus['customers_status_show_price_tax'],
				'date_added'			=>	'now()'
			);
			if($saveShippingStatus) {
				if(!empty($shippingStatus[$dbProduct['products_shippingtime']]['shipping_status_name'])) {
					$productData['products_shipping_time'] = $shippingStatus[$dbProduct['products_shippingtime']]['shipping_status_name'];
				}
			}

			$qry = xtc_db_perform(TABLE_ORDERS_PRODUCTS, $productData);
			$productsOrderId = xtc_db_insert_id();
			
			
			// BOF YES MARIO - end auction
		if(defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
			yes_end_auction_add($item_number,$orderItem->getQuantity());
			$insert_sql_array = array(
			    'products_id'=>$item_number,
			    'editor_id'=>0,
			    'date_saved'=>'now()',
			    'comments'=>'[Shopgate Order #'.$dbOrderId.'] '.$orderItem->getQuantity().' Stk.'
			);
			xtc_db_perform('products_history',$insert_sql_array);
		}
			// EOF YES MARIO - end auction
			
##### XTC3 BOF #####
//
//
//
//
//
//
//
//
##### XTC3 EOF #####
			
			$options = $orderItem->getOptions();
			if(!empty($options)) {
				$this->log('process options', ShopgateLogger::LOGTYPE_DEBUG);
				foreach($options as $option) {
					$attribute_model = $option->getValueNumber();
					$attribute_number = $option->getOptionNumber();
					
					$this->log('db: get attributes', ShopgateLogger::LOGTYPE_DEBUG);
					
					// Hole das Attribut aus der Datenbank
					$qry = "
						SELECT
							po.products_options_name,
							pov.products_options_values_name,
							pa.options_values_price,
							pa.price_prefix
						FROM ".TABLE_PRODUCTS_ATTRIBUTES." pa
						INNER JOIN ".TABLE_PRODUCTS_OPTIONS." po ON pa.options_id = po.products_options_id AND po.language_id = $this->languageId
						INNER JOIN ".TABLE_PRODUCTS_OPTIONS_VALUES_TO_PRODUCTS_OPTIONS." povtpo ON povtpo.products_options_id = po.products_options_id
						INNER JOIN ".TABLE_PRODUCTS_OPTIONS_VALUES." pov ON (povtpo.products_options_values_id = pov.products_options_values_id AND pa.options_values_id = pov.products_options_values_id AND pov.language_id = $this->languageId)
						WHERE pa.products_id = '".$dbProduct["products_id"]."'
						" . (!empty($attribute_number)
							? "AND pa.options_id = '{$attribute_number}'
						"
							: "") .
						"AND pa.options_values_id = '{$attribute_model}'
						LIMIT 1
					";
					
					$qry = xtc_db_query($qry);
					$dbattribute = xtc_db_fetch_array($qry);
					if(empty($dbattribute)) continue; //Fehler
					
					$this->log('db: save order product attributes', ShopgateLogger::LOGTYPE_DEBUG);
					
					$productAttributeData = array(
						"orders_id"=>$dbOrderId,
						"orders_products_id"=>$productsOrderId,
						"products_options"=>$dbattribute['products_options_name'],
						"products_options_values"=>$dbattribute["products_options_values_name"],
						"options_values_price"=>$dbattribute["options_values_price"],
						"price_prefix"=>$dbattribute["price_prefix"],
					);
##### XTC3 BOF #####
//
//
//
//
//
//
//
//
//
//
##### XTC3 EOF #####
					xtc_db_perform(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $productAttributeData);
				}
			} else {
				
				$this->log('attributes?', ShopgateLogger::LOGTYPE_DEBUG);
				
				for($i = 1; $i <= 10; $i++) {
					if(!isset($order_infos["attribute_$i"])){
						break;
					}
					$tmpAttr = $order_infos["attribute_$i"];
					// Code for support of the old internal_order_info structure
					if(!is_array($tmpAttr)) {
						$attribute_model = $tmpAttr;
					} else {
						// Den ersten und einzigen key nutzen (zur Sicherheit auf den start des Arrays setzen)
						reset($tmpAttr);
						$attribute_number = $tmpAttr[key($tmpAttr)]['options_id'];
						$attribute_model = $tmpAttr[key($tmpAttr)]['options_values_id'];
					}
					
					$this->log('db: get attribute', ShopgateLogger::LOGTYPE_DEBUG);
					
					// Hole das Attribut aus der Datenbank
					$qry = "
						SELECT
							po.products_options_name,
							pov.products_options_values_name,
							pa.options_values_price,
							pa.price_prefix
						FROM ".TABLE_PRODUCTS_ATTRIBUTES." pa
						INNER JOIN ".TABLE_PRODUCTS_OPTIONS." po ON pa.options_id = po.products_options_id AND po.language_id = $this->languageId
						INNER JOIN ".TABLE_PRODUCTS_OPTIONS_VALUES_TO_PRODUCTS_OPTIONS." povtpo ON povtpo.products_options_id = po.products_options_id
						INNER JOIN ".TABLE_PRODUCTS_OPTIONS_VALUES." pov ON (povtpo.products_options_values_id = pov.products_options_values_id AND pa.options_values_id = pov.products_options_values_id AND pov.language_id = $this->languageId)
						WHERE pa.products_id = '".$dbProduct["products_id"]."'
						" .
						// Still support the old internal_order_info structure
						(!empty($attribute_id)
							? "AND pa.products_attributes_id = '".$attribute_model."'
						"
							: "AND pa.options_id = '{$attribute_number}'
						AND pa.options_values_id = '{$attribute_model}'
						") .
						"LIMIT 1
					";
					
					$qry = xtc_db_query($qry);
					$dbattribute = xtc_db_fetch_array($qry);
					if(empty($dbattribute)) continue; //Fehler
					
					$this->log('db: save order product attributes', ShopgateLogger::LOGTYPE_DEBUG);
					
					$productAttributeData = array(
						"orders_id"=>$dbOrderId,
						"orders_products_id"=>$productsOrderId,
						"products_options"=>$dbattribute["products_options_name"],
						"products_options_values"=>$dbattribute["products_options_values_name"],
						"options_values_price"=>$dbattribute["options_values_price"],
						"price_prefix"=>$dbattribute["price_prefix"],
					);
##### XTC3 BOF #####
//
//
//
//
//
//
//
//
//
//
##### XTC3 EOF #####
					xtc_db_perform(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $productAttributeData);
				}
			}
		}
		
		
		$this->log('method: updateItemsStock (DEACTIVATED BY YES - Ticket 1391)', ShopgateLogger::LOGTYPE_DEBUG);
		//$this->updateItemsStock($order);

		if(!empty($errors)){
			$this->log('db: save errors in history', ShopgateLogger::LOGTYPE_DEBUG);
			$comments  = $this->stringFromUtf8('Es sind Fehler beim Importieren der Bestellung aufgetreten: ', $this->config->getEncoding());
			$comments .= $errors;

			$history = array(
				"orders_id"=> $dbOrderId,
				"orders_status_id"=>$currentOrderStatus,
				"date_added"=>date("Y-m-d H:i:s", time()-5),// "-5" Damit diese Meldung als erstes oben angezeigt wird
				"customer_notified"=>false,
				"comments"=>xtc_db_prepare_input($comments),
			);

			xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY,$history);
		}
	}

	private function _insertOrderTotal(ShopgateOrder $order, $dbOrderId) {
		///////////////////////////////////////////////////////////////////////
		// Speicher den Gesamtbetrag
		///////////////////////////////////////////////////////////////////////
		
		$amountWithTax = $order->getAmountComplete();
		$shippingTaxRate = $this->_getOrderShippingTaxRate($order);
		$taxes = $this->_getOrderTaxes($order, $dbOrderId, $shippingTaxRate);
		$xtPrice = new xtcPrice($this->currency["code"], 1);
		$shippingCosts = $order->getAmountShipping();
		
		$this->log('_insertOrderTotal(): add subtotal', ShopgateLogger::LOGTYPE_DEBUG);
		
		$sort = 10;
		
		// BOF YES mario - nettokunden
		$yes_order_query = xtc_db_query(sprintf(
			"SELECT customers_status,customers_id FROM %s WHERE orders_id='%s'",
			TABLE_ORDERS,$dbOrderId
		));
		$yes_order = xtc_db_fetch_array($yes_order_query);
		$lang_query = xtc_db_query("select languages_id, name, directory from " . TABLE_LANGUAGES . " WHERE code='" . DEFAULT_LANGUAGE . "'");
		$lang_data = xtc_db_fetch_array($lang_query);
		require_once (DIR_FS_CATALOG.'/lang/' . $lang_data['directory'] . '/modules/order_total/ot_total.php');
		require_once (DIR_FS_CATALOG.'/lang/' . $lang_data['directory'] . '/modules/order_total/ot_tax.php');
		require_once (DIR_FS_CATALOG.'/lang/' . $lang_data['directory'] . '/modules/order_total/ot_shipping.php');
		require_once (DIR_FS_CATALOG.'/lang/' . $lang_data['directory'] . '/modules/order_total/ot_subtotal.php');
		require_once (DIR_FS_CATALOG.'/lang/' . $lang_data['directory'] . '/modules/order_total/ot_subtotal_no_tax.php');
		$subtotal_title = MODULE_ORDER_TOTAL_SUBTOTAL_TITLE;
		$subtotal_class = 'ot_subtotal';
		$subtotal_sort_order = MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER;
		$stat_query = xtc_db_query(sprintf(
			"select * from %s where  customers_status_id = '%s' ",
			TABLE_CUSTOMERS_STATUS,$yes_order['customers_status']
		));
		$stat = xtc_db_fetch_array($stat_query);
		if( $stat['customers_status_show_price_tax']==0 and $stat['customers_status_add_tax_ot'] == 1){
			$subtotal_title = MODULE_ORDER_TOTAL_SUBTOTAL_TITLE_NO_TAX;
			$subtotal_class = 'ot_subtotal_no_tax';
			$subtotal_sort_order = MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_SORT_ORDER;
		}
		$yes_subtotal_query = xtc_db_query(sprintf(
			"SELECT SUM(final_price) AS subtotal FROM %s WHERE orders_id='%s'",
			TABLE_ORDERS_PRODUCTS,$dbOrderId
		));
		$yes_subtotal = xtc_db_fetch_array($yes_subtotal_query);
		// EOF YES mario - nettokunden
		
		$ordersTotal = array();
		$ordersTotal["orders_id"]		= $dbOrderId;
		$ordersTotal["title"]			= $subtotal_title;
		$ordersTotal["text"]			= $xtPrice->xtcFormat($yes_subtotal['subtotal'], true);
		$ordersTotal["value"]			= $yes_subtotal['subtotal'];
		$ordersTotal["class"]			= $subtotal_class;
		$ordersTotal["sort_order"]		= $subtotal_sort_order;
		xtc_db_perform(TABLE_ORDERS_TOTAL, $ordersTotal);
		
		// BOF ANTEILIGE SHIPPING COST RATEN
		if ($stat['customers_status_show_price_tax'] == 0){
			if($stat['customers_status_add_tax_ot'] == 0){
			    $shipping_tax_rates = $this->yes_getNebenleistungTaxRates($order,$shippingCosts);
ob_start();
echo 'SHIPPING COSTS: '.$shippingCosts."\r\n";
print_r($shipping_tax_rates);
print_r($order->getItems());
$out1 = ob_get_contents();
ob_end_clean();
mail('m.aspeleiter@yes-websolutions.de','DEBUG SG',$out1);
			    foreach($shipping_tax_rates as $shtr){
				$shippingCosts -= $shtr['amount'];
				$sh_tax_rate = intval($shtr['tax_rate']*100)/100;
				$taxes[ $sh_tax_rate ] += $shtr['amount'];
			    }
			}
		}
		// EOF ANTEILIGE SHIPPING COST RATEN
		
		$this->log('_insertOrderTotal(): add shipping costs total', ShopgateLogger::LOGTYPE_DEBUG);
		
		$ordersTotal = array();
		$ordersTotal["orders_id"]		= $dbOrderId;
		$ordersTotal["title"]			= MODULE_ORDER_TOTAL_SHIPPING_TITLE;
		$ordersTotal["text"]			= $xtPrice->xtcFormat($shippingCosts, true);
		$ordersTotal["value"]			= $shippingCosts;
		$ordersTotal["class"]			= "ot_shipping";
		$ordersTotal["sort_order"]		= MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER;
		xtc_db_perform(TABLE_ORDERS_TOTAL, $ordersTotal);

		// insert payment costs.
		//
		//WARNING: On modify: Change the taxes calculation too!
		if($order->getAmountShopPayment() != 0){
			$this->log('db: save payment fee', ShopgateLogger::LOGTYPE_DEBUG);
			
			$paymentInfos = $order->getPaymentInfos();
			
			$ordersTotal = array();
			$ordersTotal["orders_id"]		= $dbOrderId;
			$ordersTotal["title"]			= xtc_db_prepare_input('Zahlungsartkosten'. (!empty($paymentInfos['shopgate_payment_name']) ? ' ('.$paymentInfos['shopgate_payment_name'].'):' : ''));
			$ordersTotal["text"]			= $xtPrice->xtcFormat($order->getAmountShopPayment(), true);
			$ordersTotal["value"]			= $order->getAmountShopPayment();
			$ordersTotal["class"]			= "ot_shipping";
			$ordersTotal["sort_order"]		= MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER;
			xtc_db_perform(TABLE_ORDERS_TOTAL, $ordersTotal);
		
		}
		
		$this->log('_insertOrderTotal(): add tax totals', ShopgateLogger::LOGTYPE_DEBUG);
		if ($stat['customers_status_add_tax_ot'] == 1) {
		    foreach($taxes as $percent => $tax_value) {
			    $ordersTotal = array();
			    $ordersTotal["orders_id"]			= $dbOrderId;
			    $ordersTotal["title"]			= MODULE_ORDER_TOTAL_TAX_TITLE." {$percent} %";
			    $ordersTotal["text"]			= $xtPrice->xtcFormat($tax_value, true);
			    $ordersTotal["value"]			= $tax_value;
			    $ordersTotal["class"]			= "ot_tax";
			    $ordersTotal["sort_order"]			= MODULE_ORDER_TOTAL_TAX_SORT_ORDER;
			    $ordersTotal["tax_rate_percent"]		= $percent;
			    xtc_db_perform(TABLE_ORDERS_TOTAL, $ordersTotal);
		    }
		}
		
		$this->log('_insertOrderTotal(): add order total', ShopgateLogger::LOGTYPE_DEBUG);
		// BOF YES mario - nettokunden
		if ($stat['customers_status_show_price_tax'] == 0){
//			$total_query = xtc_db_query("SELECT SUM(value) as totalsum FROM orders_total WHERE orders_id='".$this->info['id']."' and class != 'ot_total' and class != 'ot_subtotal_no_tax'");
			$exclude_subtotal_class = 'ot_subtotal';
			// SPEZIALFALL
			if($stat['customers_status_add_tax_ot'] == 0){
				$exclude_subtotal_class = 'ot_subtotal_no_tax';
			}
			$yes_total_query = xtc_db_query(sprintf(
				"SELECT SUM(value) as totalsum FROM orders_total WHERE orders_id='%s' and class != 'ot_total' and class != '%s' and class != 'ot_coupon'",
				$dbOrderId,
				$exclude_subtotal_class
			));
		}else{
			$yes_total_query = xtc_db_query("SELECT SUM(value) as totalsum FROM orders_total WHERE orders_id='".$dbOrderId."' and class != 'ot_total' and class != 'ot_tax' and class != 'ot_coupon'");
		}
		$yes_total = xtc_db_fetch_array($yes_total_query);
		// EOF YES mario - nettokunden
		
		$ordersTotal = array();
		$ordersTotal["orders_id"]		= $dbOrderId;
		$ordersTotal["title"]			= MODULE_ORDER_TOTAL_TOTAL_TITLE;
		$ordersTotal["text"]			= "<b>".$xtPrice->xtcFormat($yes_total['totalsum'], true)."</b>";
		$ordersTotal["value"]			= $yes_total['totalsum'];
		$ordersTotal["class"]			= "ot_total";
		$ordersTotal["sort_order"]		= MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER;
		xtc_db_perform(TABLE_ORDERS_TOTAL, $ordersTotal);
		
	}
	
    private function yes_get_tax_proportional_distribution(ShopgateOrder $order){
	if(!sizeOf($order->getItems())){
	    return array(array(
		'tax_class_id'=>1,
		'tax_rate'=>xtc_get_tax_rate(1),
		'title'=>  xtc_get_tax_description(1),
		'percentage'=>100
	    ));
	}
	$return = array();
	$tc_values = array();
	$tc_percentage = array();
	$product_sum = 0;
	foreach($order->getItems() as $orderItem){
	    $item_number = $orderItem->getItemNumber();
	    $query = xtc_db_query(sprintf(
		    "SELECT products_tax_class_id FROM %s WHERE products_id='%s'",
		    TABLE_PRODUCTS,$item_number
	    ));
	    $record = xtc_db_fetch_array($query);
	    $item_tax_class_id = $record['products_tax_class_id'];
	    if(!isset($tc_values[ $item_tax_class_id ])){
		$tc_values[ $item_tax_class_id ] = 0;
	    }
	    $tc_values[ $item_tax_class_id ] += $orderItem->getUnitAmountWithTax()*$orderItem->getQuantity();
	    $product_sum += $orderItem->getUnitAmountWithTax()*$orderItem->getQuantity();
	}
	foreach($tc_values as $tcID=>$sum){
	    $tc_percentage[ $tcID ] = 100/$product_sum*$sum;
	}
	foreach($tc_values as $tax_class_id=>$tr){
	    $return[] = array(
		'tax_class_id'=>$tax_class_id,
		'tax_rate'=>xtc_get_tax_rate($tax_class_id),
		'title'=> xtc_get_tax_description($tax_class_id),
		'percentage'=>$tc_percentage[ $tax_class_id ]
	    );
	}
	return $return;
    }
 
    private function yes_getNebenleistungTaxRates(ShopgateOrder $order, $value){
      $tpd = $this->yes_get_tax_proportional_distribution($order);
      $tax_values = array();
      foreach($tpd as $tr){
	  $_tax_rate = ($tr['tax_rate']+100)/100;
	  $anteil_brutto = ($value/100*$tr['percentage']);
	  $tr['amount'] = $anteil_brutto-($anteil_brutto/$_tax_rate);
	  $tax_values[] = $tr;
      }
      return $tax_values;
    }

	private function _getOrderTaxes(ShopgateOrder $order, $dbOrderId, $shippingTaxRate = 0) {
		$this->log('_getOrderTaxes(): start', ShopgateLogger::LOGTYPE_DEBUG);
		
		$taxes = array();
		
		foreach($order->getItems() as $orderItem) {
			$tax		= $orderItem->getTaxPercent();
			$tax		= intval($tax*100)/100;
			$tax_value	= $orderItem->getUnitAmountWithTax() - $orderItem->getUnitAmount();

			if(!isset($taxes[$tax])) $taxes[$tax]= 0;
			$taxes[$tax] += $tax_value * $orderItem->getQuantity();
		}

		if(!empty($shippingTaxRate)) {
			$shippingTaxRate = intval($shippingTaxRate*100)/100;
			if(!isset($taxes[$shippingTaxRate])) $taxes[$shippingTaxRate]= 0;
			$taxes[$shippingTaxRate] += $order->getAmountShipping()-$this->_getOrderShippingAmountWithoutTax($order, $shippingTaxRate);
		}
		
		// set taxes for payment method
		if($order->getAmountShopPayment() != 0){
			$tax		= $order->getPaymentTaxPercent();
			$tax		= intval($tax*100)/100;
			$tax_value	= $order->getAmountShopPayment() - round(($order->getAmountShopPayment()*100)/($order->getPaymentTaxPercent()+100),2);

			if(!isset($taxes[$tax])) $taxes[$tax]= 0;
			$taxes[$tax] += $tax_value;
		}
		
		$this->log('_getOrderTaxes(): end', ShopgateLogger::LOGTYPE_DEBUG);
		
		return $taxes;
	}

	private function _getOrderShippingTaxRate(ShopgateOrder $order) {
		$this->log('_getOrderShippingTaxRate(): start', ShopgateLogger::LOGTYPE_DEBUG);
		
		$shippingTaxRate = 0;
		
		// Check if a shipping method is set in config
		$shippingMethod = $this->config->getShipping();
		$orderCountryCode2 = $order->getInvoiceAddress()->getCountry();
		
		if(!empty($shippingMethod)) {
			$this->log('db: get configuration value ', ShopgateLogger::LOGTYPE_DEBUG);
			
			// Get tax value from shipping module
			$qry =
			"SELECT `c`.`configuration_value`, `tr`.`tax_rate` " .
			"FROM `" . TABLE_CONFIGURATION . "` AS `c` " .
			"INNER JOIN `" . TABLE_TAX_RATES . "` AS `tr` ON(`c`.`configuration_value`=`tr`.`tax_class_id`) " .
			"INNER JOIN `" . TABLE_ZONES_TO_GEO_ZONES . "` AS `geozones` ON(`tr`.`tax_zone_id`=`geozones`.`geo_zone_id`) " .
			"INNER JOIN `" . TABLE_COUNTRIES . "` AS `co` ON(`geozones`.`zone_country_id`=`co`.`countries_id`) " .
			"WHERE " .
			"`c`.`configuration_key` = 'MODULE_SHIPPING_".strtoupper($shippingMethod)."_TAX_CLASS' " .
			"AND " .
			"`co`.`countries_iso_code_2`='$orderCountryCode2';";
			$result = xtc_db_query($qry);
			$moduleTaxSetting = xtc_db_fetch_array($result);
			if(!empty($moduleTaxSetting) && !empty($moduleTaxSetting['configuration_value']) && !empty($moduleTaxSetting['tax_rate'])) {
				// get the tax rate for the shipping costs
				$shippingTaxRate = intval($moduleTaxSetting['tax_rate']*100)/100;
			}
		}
		
		$this->log('_getOrderShippingTaxRate(): end', ShopgateLogger::LOGTYPE_DEBUG);
		
		return $shippingTaxRate;
	}
	
	private function _getOrderShippingAmountWithoutTax(ShopgateOrder $order, $shippingTaxRate = 0) {
		$shippingAmountWithoutTax = $order->getAmountShipping();
		
		// Check if a shipping method is set in config
		$shippingMethod = $this->config->getShipping();
		if(!empty($shippingTaxRate)) {
			// remove tax from shipping costs
			$shippingAmountWithoutTax /= 1+$shippingTaxRate/100;
		}
		
		return $shippingAmountWithoutTax;
	}
	
	private function updateItemsStock(ShopgateOrder $order) {
		foreach($order->getItems() as $item) {
			// Skip "coupon" and "payment_fee" items
			if($item->getItemNumber() == 'COUPON' || $item->getItemNumber() == 'PAYMENT_FEE'){
				continue;
			}
			
			// Attribute ids are set inside the internal order info
			$internalOrderInfo = $this->jsonDecode($item->getInternalOrderInfo(), true);
			
			$usesProductsAttributes = false;
			
			// Get id (parent id for child products)
			$productId = $item->getItemNumber();
			if(!empty($internalOrderInfo['base_item_number'])) {
				$productId = $internalOrderInfo['base_item_number'];
				$usesProductsAttributes = true;
			}
			
			$itemOptions = $item->getOptions();
			if(!empty($itemOptions)) {
				$usesProductsAttributes = true;
			}
			
			// Update products stock if reduction enabled
			if(STOCK_LIMITED == 'true') {
				$qry = "
					UPDATE `" . TABLE_PRODUCTS . "` AS `p`
						SET `p`.`products_quantity` = `p`.`products_quantity` - {$item->getQuantity()}
					WHERE `p`.`products_id` = '{$productId}'
				;";
				xtc_db_query($qry);
				
				// Deactivate product if checkout is not allowed and the stock level reaches zero
				if(STOCK_ALLOW_CHECKOUT == 'false') {
					// commerce:seo has an additional constant that tells if the product may be deactivated (STOCK_ALLOW_CHECKOUT_DEACTIVATE)
					if(!defined('STOCK_ALLOW_CHECKOUT_DEACTIVATE') || STOCK_ALLOW_CHECKOUT_DEACTIVATE == 'true') { // don't update if defined and not true
						$qry = "
							UPDATE `" . TABLE_PRODUCTS . "` AS `p`
								SET `p`.`products_status` = 0
							WHERE `p`.`products_id` = '{$productId}' AND `p`.`products_quantity` <= 0
						;";
						xtc_db_query($qry);
					}
				}
			}
			
			// Attribute items also need to be reduced in stock
			if($usesProductsAttributes) {
				// Build additional SQL snippets to update the attributes stock (not using the products_attributes_id because they all change on each update of any attribute in the backend)
				$attributeSQLQueryParts = array();
				if(!empty($internalOrderInfo['base_item_number'])) {
					for($i = 1; $i <= 10; $i++) {
						if(!empty($internalOrderInfo["attribute_{$i}"])) {
							$tmpAttr = $internalOrderInfo["attribute_{$i}"];
							if(!is_array($tmpAttr)) {
								$attributeSQLQueryParts[] = " ATTRIBUTES_ID='{$tmpAttr}'";
							} else {
								// Only the first element is relevant since there can only be one per attribute-number
								reset($tmpAttr);
								$attributeSQLQueryParts[] = 'OPTIONS_ID=\''.$tmpAttr[key($tmpAttr)]['options_id'] . '\' AND OPTIONS_VALUES_ID=\''.$tmpAttr[key($tmpAttr)]['options_values_id'].'\'';
							}
						}
					}
				} else {
					// Attributes was exported as options
					foreach($itemOptions as $itemOption) {
						$attributeSQLQueryParts[] = 'OPTIONS_ID=\''.$itemOption->getOptionNumber() . '\' AND OPTIONS_VALUES_ID=\''.$itemOption->getValueNumber().'\'';
					}
				}
				if(!empty($attributeSQLQueryParts)) {
					// Attribute stock is ALWAYS reduced (no matter what is set as STOCK_LIMITED or the other constants)!
					$attributeSQLConditionSnippet = '(' . str_replace(array('OPTIONS_ID', 'OPTIONS_VALUES_ID', 'ATTRIBUTES_ID'), array('`pa`.`options_id`', '`pa`.`options_values_id`', '`pa`.`products_attributes_id`'), implode(') OR (', $attributeSQLQueryParts)) . ')';
					
					// Update attributes stock
					$qry = "
						UPDATE `" . TABLE_PRODUCTS_ATTRIBUTES . "` AS `pa`
							SET `pa`.`attributes_stock` = `pa`.`attributes_stock` - {$item->getQuantity()}
						WHERE `pa`.`products_id` = '{$productId}'
							AND ({$attributeSQLConditionSnippet})
					;";
					xtc_db_query($qry);
				}
			}
			
			// Specials stock and active status
			if(!empty($internalOrderInfo['is_special_price'])){
				// Always update specials quantity if it is a special
				$qry = "
					UPDATE `" . TABLE_SPECIALS . "` AS `s`
						SET `s`.`specials_quantity` = `s`.`specials_quantity` - {$item->getQuantity()}
					WHERE `s`.`products_id` = '{$productId}'
				;";
				xtc_db_query($qry);
				
				// Always deactivate specials that have turned to a value equal to or less than zero and deactivate all specials that are expired
				$qry = "
					UPDATE `" . TABLE_SPECIALS . "` AS `s`
						SET `s`.`status` = 0
					WHERE
						`s`.`status` != 0
						AND
							(`s`.`expires_date` < NOW() AND `s`.`expires_date` != '0000-00-00 00:00:00' AND `s`.`expires_date` IS NOT NULL
							OR
							`s`.specials_quantity <= 0 AND `s`.`products_id` = '{$productId}')
				;";
				xtc_db_query($qry);
			}
		}
	}

	protected function createReviewsCsv() {
		$sql = "
		SELECT
			r.reviews_id,
			r.products_id,
			r.customers_name,
			r.reviews_rating,
			r.date_added,
			rd.reviews_text
		FROM
		" . TABLE_REVIEWS . " as r
		INNER JOIN
		" . TABLE_REVIEWS_DESCRIPTION . " as rd ON r.reviews_id = rd.reviews_id
		WHERE rd.languages_id = '".$this->languageId."'
		ORDER BY r.products_id ASC";

		$limit 	= 10;
		$page  	= 1;
		$offset = ($page-1)*$limit;
		$pg 	= " LIMIT $offset,$limit";

		while($query = xtc_db_query($sql.$pg)) {
			$count = xtc_db_num_rows($query);
			if($count == 0) {
				break;
			}

			$reviews = array();
			while($entry = xtc_db_fetch_array($query)) {
				$review = $this->buildDefaultReviewRow();

				$review['item_number'] 		= $entry['products_id'] ;
				$review['update_review_id'] = $entry['reviews_id'];
				$review['score'] 			= $entry['reviews_rating']*2;
				$review['name'] 			= $entry['customers_name'];
				$review['date'] 			= $entry['date_added'];
				$review['title'] 			= '';
				$review['text'] 			= $entry['reviews_text'];

				$reviews[] = $review;
			}

			foreach($reviews as $review) {
				$this->addReviewRow($review);
			}

			$page++;
			$offset = ($page-1)*$limit;
			$pg		= " LIMIT $offset,$limit";
		}
	}

	protected function createPagesCsv() {
	}

	public function getSettings() {
	}


	public function redeemCoupons(ShopgateCart $cart) {
	}
	
	private function _getAddressFormatId($isoCode2 = 'DE', $countryId = null) {
		$isoCode2 = strtoupper($isoCode2);
		if(!empty($countryId)) {
			$qry = "
				SELECT c.address_format_id
				FROM ".TABLE_COUNTRIES." c
				WHERE c.countries_id = '$countryId'
			";
		} else {
			$qry = "
				SELECT c.address_format_id
				FROM ".TABLE_COUNTRIES." c
				WHERE UPPER(c.countries_iso_code_2) = '$isoCode2'
			";
		}

		$result = xtc_db_query($qry);
		$item = xtc_db_fetch_array($result);
		return $item["address_format_id"];
	}

	private function _createGuestUser(ShopgateOrder $order) {
		//		$order = new ShopgateOrder();
		$address = $order->getInvoiceAddress();

		$customerStatus = $this->config->getCustomersStatusId();
		if($customerStatus === -1) $customerStatus = DEFAULT_CUSTOMERS_STATUS_ID;

		$customer = array();
		$customer["customers_vat_id_status"] = 0;
		$customer["customers_status"] = $customerStatus;
		$customer["customers_gender"] =  $address->getGender();
		$customer["customers_firstname"] = $address->getFirstName();
		$customer["customers_lastname"] = $address->getLastName();
		$customer["customers_email_address"] = $order->getMail();
		$customer["customers_default_address_id"] = "";
		$customer["customers_telephone"] = $order->getPhone();
		$customer["customers_fax"] = "";
		$customer["customers_newsletter"] = 0;
		$customer["customers_newsletter_mode"] = 0;
		$customer["member_flag"] = 0;
		$customer["delete_user"] = 1;
		$customer["account_type"] = 0;
		$customer["refferers_id"] = 0;
		$customer["customers_date_added"] = date( 'Y-m-d H:i:s' );
		$customer["customers_last_modified"] = date( 'Y-m-d H:i:s' );

		xtc_db_perform(TABLE_CUSTOMERS, $customer);
		$customerId = xtc_db_insert_id();

		$qry = "SELECT countries_id FROM ".TABLE_COUNTRIES." WHERE UPPER(countries_iso_code_2) = UPPER('".$address->getCountry() ."')";
		$qry = xtc_db_query($qry);
		$country = xtc_db_fetch_array($qry);
		if(empty($country)) {
			$country = array(
				'countries_id' => 81,
			);
		}
		
		$qry = "SELECT zone_id, zone_name FROM ".TABLE_ZONES." WHERE zone_country_id = {$country['countries_id']} AND zone_code = '" . ShopgateXtcMapper::getXtcStateCode($address->getState())."'";
		$qry = xtc_db_query($qry);
		$zone = xtc_db_fetch_array($qry);
		if(empty($zone)) {
			$zone = array(
				'zone_id' => null,
				'zone_name' => $address->getState(),
			);
		}

		$_address = array(
			"customers_id" => $customerId,
			"entry_gender" => $address->getGender(),
			"entry_company" => $address->getCompany(),
			"entry_firstname" => $address->getFirstName(),
			"entry_lastname" => $address->getLastName(),
			"entry_street_address" => $address->getStreet1() . (strlen($address->getStreet2()) > 0 ? (' ' . $address->getStreet2()) : ''),
			"entry_suburb" => "",
			"entry_postcode" => $address->getZipcode(),
			"entry_city" => $address->getCity(),
			"entry_state" => $zone['zone_name'],
			"entry_country_id" => $country["countries_id"],
			"entry_zone_id" => $zone['zone_id'],
			"address_date_added" => date( 'Y-m-d H:i:s' ),
			"address_last_modified" => date( 'Y-m-d H:i:s' ),
		);
		xtc_db_perform(TABLE_ADDRESS_BOOK, $_address);
		$addressId = xtc_db_insert_id();

		$customer = array(
			"customers_default_address_id" =>$addressId
		);
		xtc_db_perform(TABLE_CUSTOMERS, $customer, "update", "customers_id = $customerId");

		$_info = array (
			"customers_info_id" => $customerId,
			"customers_info_date_of_last_logon" => date( 'Y-m-d H:i:s' ),
			"customers_info_number_of_logons" => '1',
			"customers_info_date_account_created" => date( 'Y-m-d H:i:s' ),
			"customers_info_date_account_last_modified" => date( 'Y-m-d H:i:s' ),
			"global_product_notifications" => 0
		);
		xtc_db_perform(TABLE_CUSTOMERS_INFO, $_info);

		$customerMemo = array();
		$customerMemo["customers_id"] = $customerId;
		$customerMemo["memo_date"] = date( 'Y-m-d' );
		$customerMemo["memo_title"] = "Shopgate - Account angelegt";
		$customerMemo["memo_text"] = "Account wurde von Shopgate angelegt";
		$customerMemo["poster_id"] = null;
		xtc_db_perform("customers_memo", $customerMemo);

		$result = xtc_db_query("SELECT * FROM ".TABLE_CUSTOMERS." WHERE customers_id = " . $customerId);
		$customer = xtc_db_fetch_array($result);
		return $customer;
	}
	
	private function _pushOrderToAfterbuy($iOrderId, ShopgateOrder $order) {
		if (!$order->getIsShippingBlocked() && defined('AFTERBUY_ACTIVATED') && AFTERBUY_ACTIVATED == 'true') {
			$this->log("START TO SEND ORDER TO AFTERBUY", ShopgateLogger::LOGTYPE_ACCESS);
	
			require_once (DIR_WS_CLASSES.'afterbuy.php');
			$aBUY = new xtc_afterbuy_functions( $iOrderId );
			if ($aBUY->order_send()) {
				$aBUY->process_order();
				$this->log("SUCCESSFUL ORDER SEND TO AFTERBUY", ShopgateLogger::LOGTYPE_ACCESS);
			} else {
				$this->log("ORDER ALREADY SEND TO AFTERBUY", ShopgateLogger::LOGTYPE_ACCESS);
			}
	
			$this->log("FINISH SEND ORDER TO AFTERBUY", ShopgateLogger::LOGTYPE_ACCESS);
		}
	}
	
	private function _pushOrderToDreamRobot($dbOrderId, ShopgateOrder $shopgateOrder) {
		if (!$shopgateOrder->getIsShippingBlocked() && file_exists(DIR_FS_CATALOG.'dreamrobot_checkout.inc.php')) {
			require_once(DIR_FS_CATALOG.'includes/classes/order.php');
			$this->log("START TO SEND ORDER TO DREAMROBOT", ShopgateLogger::LOGTYPE_ACCESS);
	
			$order = new order($dbOrderId);
			$_SESSION['tmp_oID'] = $dbOrderId;
			$order->info['shipping_cost'] = $shopgateOrder->getAmountShipping();
			include_once ('./dreamrobot_checkout.inc.php');
			
			$this->log("FINISH SEND ORDER TO DREAMROBOT", ShopgateLogger::LOGTYPE_ACCESS);
		}
	}
	
	public function cron($jobname, $params, &$message, &$errorcount) {
		switch ($jobname) {
			case 'set_shipping_completed': $this->cronSetOrdersShippingCompleted($message, $errorcount); break;
			default: throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_CRON_UNSUPPORTED_JOB, 'Job name: "'.$jobname.'"', true);
		}
	}
	
	/**
	 * Marks shipped orders as "shipped" at Shopgate.
	 *
	 * This will find all orders that are marked "shipped" in the shop system but not at Shopgate yet and marks them "shipped" at Shopgate via
	 * Shopgate Merchant API.
	 *
	 * @param string $message Process log will be appended to this reference.
	 * @param int $errorcount This reference gets incremented on errors.
	 */
	protected function cronSetOrdersShippingCompleted(&$message, &$errorcount) {
		$query =
			"SELECT `sgo`.`orders_id`, `sgo`.`shopgate_order_number` ".
			"FROM `".TABLE_SHOPGATE_ORDERS."` sgo ".
			"INNER JOIN `".TABLE_ORDERS."` xto ON (`xto`.`orders_id` = `sgo`.`orders_id`) ".
			"INNER JOIN `".TABLE_LANGUAGES."` xtl ON (`xtl`.`directory` = `xto`.`language`) ".
			"WHERE `sgo`.`is_sent_to_shopgate` = 0 ".
				"AND `xto`.`orders_status` = ".xtc_db_input($this->config->getOrderStatusShipped())." ".
				"AND `xtl`.`code` = '".xtc_db_input($this->config->getLanguage())."';";
		$result = xtc_db_query($query);
		
		if (empty($result)) {
			return;
		}
		
		while ($shopgateOrder = xtc_db_fetch_array($result)) {
			if (!$this->setOrderShippingCompleted($shopgateOrder['shopgate_order_number'], $shopgateOrder['orders_id'], $this->merchantApi, $this->config)) {
				$errorcount++;
				$message .= 'Shopgate order number "'.$shopgateOrder['shopgate_order_number'].'": error'."\n";
			}
		}
	}
	
	/**
	 * Set the shipping status for a list of order IDs.
	 *
	 * @param int[] $orderIds The IDs of the orders in the shop system.
	 * @param int $status The ID of the order status that has been set in the shopping system.
	 */
	public function updateOrdersStatus($orderIds, $status) {
		if (empty($orderIds) || !is_array($orderIds)) {
			return;
		}
		$query = xtc_db_input(
			"SELECT `sgo`.`orders_id`, `sgo`.`shopgate_order_number`, `xtl`.`code` ".
			"FROM `".TABLE_SHOPGATE_ORDERS."` sgo ".
			"INNER JOIN `".TABLE_ORDERS."` xto ON (`xto`.`orders_id` = `sgo`.`orders_id`) ".
			"INNER JOIN `".TABLE_LANGUAGES."` xtl ON (`xtl`.`directory` = `xto`.`language`) ".
			"WHERE `sgo`.`orders_id` IN (".xtc_db_input(implode(", ", $orderIds)).")");
		$result = xtc_db_query($query);
		
		if (empty($result)) {
			return;
		}

		$configurations = array();
		$merchantApis = array();
		while ($shopgateOrder = xtc_db_fetch_array($result)) {
			$language = $shopgateOrder['code']; // convenience
			
			if (empty($merchantApis[$language])) {
				try {
##### XTC3 BOF #####
					$config = new ShopgateConfigXtc();
##### XTC3 EOF #####
					$config->loadByLanguage($language);
					$builder = new ShopgateBuilder($config);
					$merchantApis[$language] = &$builder->buildMerchantApi();
					$configurations[$language] = $config;
				} catch (ShopgateLibraryException $e) {
					// do not abort. the error will be logged
				}
			}
			
			if ($status != $configurations[$language]->getOrderStatusShipped()) {
				return;
			}
			
			$this->setOrderShippingCompleted($shopgateOrder['shopgate_order_number'], $shopgateOrder['orders_id'], $merchantApis[$language], $configurations[$language]);
		}
	}
	
	/**
	 * Sets the order status of a Shopgate order to "shipped" via Shopgate Merchant API
	 *
	 * @param string $shopgateOrderNumber The number of the order at Shopgate.
	 * @param int $orderId The ID of the order in the shop system.
	 * @param ShopgateMerchantApi The SMA object to use for the request.
##### XTC3 BOF #####
	 * @param ShopgateConfigXtc The configuration to use for the order's status history.
##### XTC3 EOF #####
	 * @return bool true on success, false on failure.
	 */
##### XTC3 BOF #####
	protected function setOrderShippingCompleted($shopgateOrderNumber, $orderId, ShopgateMerchantApi &$merchantApi, ShopgateConfigXtc &$config) {
##### XTC3 EOF #####
		$success = false;
		// These are expected and should not be added to error count:
		$ignoreCodes = array(ShopgateMerchantApiException::ORDER_ALREADY_COMPLETED, ShopgateMerchantApiException::ORDER_SHIPPING_STATUS_ALREADY_COMPLETED);
		try {
			$merchantApi->setOrderShippingCompleted($shopgateOrderNumber);
			
			$statusArr = array(
					"orders_id" => $orderId,
					"orders_status_id" => $config->getOrderStatusShipped(),
					"date_added" => date( 'Y-m-d H:i:s' ),
					"customer_notified" => 1,
					"comments" => "[Shopgate] Bestellung wurde bei Shopgate als versendet markiert",
			);
			
			xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $statusArr);
			
			$success = true;
		} catch (ShopgateLibraryException $e) {
			$response = $this->stringFromUtf8($e->getAdditionalInformation(), $config->getEncoding());
			
			$statusArr = array(
					"orders_id" => $orderId,
					"orders_status_id" => $config->getOrderStatusShipped(),
					"date_added" => date( 'Y-m-d H:i:s' ),
					"customer_notified" => 0,
					"comments" => "[Shopgate] Ein Fehler ist im Shopgate Modul aufgetreten ({$e->getCode()}): {$response}",
			);
			
			xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $statusArr);
		} catch (ShopgateMerchantApiException $e) {
			$response = $this->stringFromUtf8($e->getMessage(), $config->getEncoding());
			
			$statusArr = array(
					"orders_id" => $orderId,
					"orders_status_id" => $config->getOrderStatusShipped(),
					"date_added" => date( 'Y-m-d H:i:s' ),
					"customer_notified" => 0,
					"comments" => "[Shopgate] Ein Fehler ist bei Shopgate aufgetreten ({$e->getCode()}): {$response}",
			);
			
			xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $statusArr);
			
			$success = (in_array($e->getCode(), $ignoreCodes)) ? true : false;
		} catch (Exception $e) {
			$response = $this->stringFromUtf8($e->getMessage(), $config->getEncoding());
			
			$statusArr = array(
					"orders_id" => $orderId,
					"orders_status_id" => $config->getOrderStatusShipped(),
					"date_added" => date( 'Y-m-d H:i:s' ),
					"customer_notified" => 0,
					"comments" => "[Shopgate] Ein unbekannter Fehler ist aufgetreten ({$e->getCode()}): {$response}",
			);
			
			xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $statusArr);
		}
		
		// Update shopgate order on success
		if($success) {
			$qry = 'UPDATE `'.TABLE_SHOPGATE_ORDERS.'` SET `is_sent_to_shopgate` = 1 WHERE `shopgate_order_number` = '.$shopgateOrderNumber.';';
			xtc_db_query($qry);
		}
		
		return $success;
	}
	
	private function xtc_get_products_stock($products_id) {
		$products_id = xtc_get_prid($products_id);
		$stock_query = xtc_db_query("select products_quantity from " . TABLE_PRODUCTS . " where products_id = '" . $products_id . "'");
		$stock_values = xtc_db_fetch_array($stock_query);
		
		return $stock_values['products_quantity'];
	}

	public function yes_createCategoriesCsv(){
		return $this->createCategoriesCsv($id);
	}

	public function yes_createItemsCsv($id=0,$qty = -1){
		return $this->createItemsCsv($id,$qty);
	}

	private function yes_checkParentItemNumber($products_id){
		$qry = xtc_db_query(sprintf(
			"SELECT products_id FROM %s p WHERE p.products_status = 1 AND p.shopgate_block='0' AND p.products_id='%s'",
			TABLE_PRODUCTS,$products_id
		));
		if(xtc_db_num_rows($qry))
			return $products_id;
		return 0;
	}

	private function yes_getAmountInfoText($product_array,$price){
		$xtPrice = new xtcPrice($this->currency["code"], 1);
		if(!isset($product_array['products_vpe_status']) or $product_array['products_vpe_status'] == 0)
			return '';

		if ($product_array['products_vpe_value'] != 0.0 && $price > 0) {
			return $xtPrice->xtcFormat($price * (1 / $product_array['products_vpe_value']), true) . TXT_PER . xtc_get_vpe_name($product_array['products_vpe']);
		}
		return '';
	}

	private function yes_getAttributes($pID,$master_products_id){
		$array = array();
		$query = xtc_db_query(sprintf(
			"SELECT pmsv.title as value, pmkd.title FROM products_master_slave_values pmsv LEFT JOIN products_master_keys_description pmkd ON pmsv.products_master_key_id=pmkd.products_master_keys_id LEFT JOIN products_master_keys pmk USING( products_master_keys_id ) WHERE pmsv.products_id='%s' AND pmsv.language_id='%s' AND pmkd.language_id='%s' AND pmk.products_id='%s' ORDER BY pmk.sort_order",
			$pID,$this->languageId,$this->languageId,$master_products_id
		));
		while($record = xtc_db_fetch_array($query)){
			$array[] = $record;
		}
		return $array;
	}

	public function yes_delete_item($pID,$language='de') {
		try {
			$config = new ShopgateConfigXtc();
			$config->loadByLanguage($language);
			$builder = new ShopgateBuilder($config);
			$merchantApis[$language] = &$builder->buildMerchantApi();
			$configurations[$language] = $config;
		} catch (ShopgateLibraryException $e) {
			// do not abort. the error will be logged
		}
		return $merchantApis[$language]->deleteItem($pID);
	}
	public function update_item($Item,$language='de') {
		try {
			$config = new ShopgateConfigXtc();
			$config->loadByLanguage($language);
			$builder = new ShopgateBuilder($config);
			$merchantApis[$language] = &$builder->buildMerchantApi();
			$configurations[$language] = $config;
		} catch (ShopgateLibraryException $e) {
			// do not abort. the error will be logged
		}
		$merchantApis[$language]->updateItem($Item);
	}
	public function add_item($Item,$language='de') {
/*
		try {
			// create a new instance of ShopgateBuilder
			// it will load the configuration file automatically
			$shopgateBuilder = new ShopgateBuilder();
		 
			// get the ShopgateMerchantApi instance from the builder
			$merchantApi = $shopgateBuilder->buildMerchantApi();
		 
			// send requests to the Shopgate Merchant API
			$res = $merchantApi->addItem($Item);
		 
		} catch (ShopgateMerchantApiException $e) {
			// Do not abort at this point as this would crash editing the order in the shop system's backend.
			// The ShopgateMerchantApiExceptions are logged automatically.
		 
			Logger::log($e);
		} catch (ShopgateLibraryException $e) {
			// Do not abort at this point as this would crash editing the order in the shop system's backend.
			// The ShopgateLibraryExceptions are logged automatically.
		 
			Logger::log($e);
		}
*/


		try {
			$config = new ShopgateConfigXtc();
			$config->loadByLanguage($language);
			$builder = new ShopgateBuilder($config);
			$merchantApis[$language] = &$builder->buildMerchantApi();
			$configurations[$language] = $config;
		} catch (ShopgateLibraryException $e) {
			// do not abort. the error will be logged
		}
		$merchantApis[$language]->addItem($Item);
	}

	public function yes_get_items($params,$language='de') {
		try {
			$config = new ShopgateConfigXtc();
			$config->loadByLanguage($language);
			$builder = new ShopgateBuilder($config);
			$merchantApis[$language] = &$builder->buildMerchantApi();
			$configurations[$language] = $config;
		} catch (ShopgateLibraryException $e) {
			// do not abort. the error will be logged
		}
		return $merchantApis[$language]->getItems($params);
	}

	private function yes_getProperties($products_id){
		$products_characteristics_data=array();

		$gh = new group_handler($this->languageId);
		$groups = xtc_get_product_groups($products_id);
		for($i=0;$i<sizeOf($groups);$i++){
			$gID = $groups[$i]['id'];
			$group = new group($gID,$_SESSION['languages_id']);
			for($gi=0;$gi<sizeOf($group->getCharacteristics());$gi++){
				$gc = $group->getCharacteristics($gi);
				if($gc->getVisible() == 1){
					$gcD = $gc->getDescription($this->languageId);
					if(isset($gcD->title) and $gcD->title != ''){
					    $title = $gcD->getTitle();
					    $desc = $gcD->getDescription();
					    $value = $gh->getProductSetValue($products_id,$group->getId(),$gc->getId(),$this->languageId);
						if(!empty($value)){
							    $products_characteristics_data[] = array(
								    $title=>$value
								    /*'description'=>$desc,
								    'no_sets'=>$gc->getNoSets(),*/
							    );
						}
					}
				}
			}
		}
		return $products_characteristics_data;
	}
}

class ShopgateXtcMapper {

	/**
	 * The countries with non-ISO-3166-2 state codes in xt:Commerce 3 are mapped here.
	 * @var string[][]
	 */
	protected static $stateCodesByCountryCode = array(
		'DE' => array(
			"BW" => "BAW",
			"BY" => "BAY",
			"BE" => "BER",
			"BB" => "BRG",
			"HB" => "BRE",
			"HH" => "HAM",
			"HE" => "HES",
			"MV" => "MEC",
			"NI" => "NDS",
			"NW" => "NRW",
			"RP" => "RHE",
			"SL" => "SAR",
			"SN" => "SAS",
			"ST" => "SAC",
			"SH" => "SCN",
			"TH" => "THE",
		),
		"AT" => array(
			"1" => "BL",
			"2" => "KN",
			"3" => "NO",
			"4" => "OO",
			"5" => "SB",
			"6" => "ST",
			"7" => "TI",
			"8" => "VB",
			"9" => "WI",
		),
		//"CH" => ist in xt:commerce bereits korrekt
		//"US" => ist in xt:commerce bereits korrekt
	);

	/**
	 * Finds the corresponding Shopgate state code for a given xt:Commerce 3 state code (zone_code).
	 *
	 * @param string $countryCode The code of the country to which the state belongs
	 * @param string $xtcStateCode The code of the state / zone as found in the default "zones" table of xt:Commerce 3
	 * @return string The state code as defined at Shopgate Wiki
	 *
	 * @throws ShopgateLibraryException if one of the given codes is unknown
	 */
	public static function getShopgateStateCode($countryCode, $xtcStateCode) {
		$countryCode = strtoupper($countryCode);
		$xtcStateCode = strtoupper($xtcStateCode);

		if (!isset(self::$stateCodesByCountryCode[$countryCode])) {
			return $countryCode.'-'.$xtcStateCode;
		}

		$codes = array_flip(self::$stateCodesByCountryCode[$countryCode]);
		if (!isset($codes[$xtcStateCode])) {
			return $countryCode.'-'.$xtcStateCode;
		}

		$stateCode = $codes[$xtcStateCode];
		return $countryCode.'-'.$stateCode;
	}

	/**
	 * Finds the corresponding xt:Commerce 3 state code (zone_code) for a given Shopgate state code
	 *
	 * @param string $shopgateStateCode The Shopgate state code as defined at Shopgate Wiki
	 * @return string The zone code for xt:Commerce 3
	 *
	 * @throws ShopgateLibraryException if the given code is unknown
	 */
	public static function getXtcStateCode($shopgateStateCode) {
		$splitCodes = null;
		preg_match('/^([A-Z]{2})\-([A-Z]{2})$/', $shopgateStateCode, $splitCodes);

		if (empty($splitCodes) || empty($splitCodes[1]) || empty($splitCodes[2])){
			return null;
		}

		if(!isset(self::$stateCodesByCountryCode[$splitCodes[1]]) || !isset(self::$stateCodesByCountryCode[$splitCodes[1]][$splitCodes[2]])) {
			//throw new ShopgateLibraryException(ShopgateLibraryException::PLUGIN_UNKNOWN_STATE_CODE, 'Code: '.$shopgateStateCode);
			return $splitCodes[2];
		} else {
			return self::$stateCodesByCountryCode[$splitCodes[1]][$splitCodes[2]];
		}
	}
}



