<?php
/**
 * DIESE DATEI IST NUR FUER DEV
 * SIE VERARBEITET EBAY NOTIFICATIONS DATEIEN DIE VORHER
 * VON DER soap.php GESPEICHERT WURDEN.
 * DIE DATEIEN WERDEN ABGEARBEITET UND ANHAND DES ENTHALTENEN
 * EBAY SELLERS (RecipientUserID) UND DER TABELLE soap_users
 * AN DIE EINZELNEN SYSTEME GESENDET. EMPFANGEN WERDEN DIESE
 * NACHRICHTEN DANN AUF DEM KUNDENSYSTEM UEBER DIE emp.php
 * DAMIT DIE SICHERHEIT FUER DIESES SENDEN GEWAEHRLEISTET IST
 * NUTZEN WIR VERSCHLUESSELUNG MIT DEM KEY YES2YES_SECRET 
 * AUS DER .env
 */

// WELCHE EVENTS VERARBEITEN WIR?
if (PHP_SAPI !== 'cli') {
    http_response_code(400);
    die( "only cli" );    
}
include('includes/application_top.php');
$dotenv = \Dotenv\Dotenv::createImmutable(main::get_secure_path()); // Pfad zur .env-Datei
$dotenv->load();

function empLog(string $msg, string $file){
    echo "\tFile ".basename($file).": ".$msg."\n";
    flush();            // sendet Buffer zum Terminal
    if (function_exists('ob_flush')) ob_flush(); // falls Output-Buffering aktiv ist
}
function processFile($file){
    $xml = file_get_contents($file);
    $testmode = (bool)\YES4Trade\Model\eBayPlattformNotification::TEST_MODUS;
    if(empty($xml)){
        if(!$testmode){
            unlink($file);
        }
        empLog('empty',$file);
        return false;
    }
    preg_match('/<NotificationEventName>(.*?)<\/NotificationEventName>/', $xml, $matches);
    if(!is_countable($matches) or !isset($matches[1]) or empty($matches[1])){
        if(!$testmode){
            unlink($file);
        }
        empLog('no NotificationEventName',$file);
        return false;
    }

    preg_match('/<RecipientUserID>(.*?)<\/RecipientUserID>/', $xml, $matches);
    if(!is_countable($matches) or !isset($matches[1]) or empty($matches[1])){
        if(!$testmode){
            unlink($file);
        }
        empLog("No RecipientUserID",$file);
        return false;
    }
    $rec = $matches[1];
    $url = yes_query("SELECT soap_users.url FROM soap_users WHERE ebay_userid=:id",[
            'id'=>$rec
        ],true
    );

    if($url === false){
        if(!$testmode){
            copy($file, $file.'-INVALID');
            unlink($file);
        }
        throw new Exception(sprintf(
            "Invalid/Unknown seller %s in %s (-INVALID file extension added)",
            $rec,
            basename($file)
        ));
        return false;
    }
    if($url['url'] == 'http://localhost/yes/'){
        copy($file,$file.'-LOCALDEV');
        unlink($file);
        yes_mail_debug($xml,false,'eBay Notification for '.$rec);
        return false;
    }
    $url['url'] = str_replace('http://','https://',$url['url']);

    $xml = preg_replace(
        '#<Description[^>]*>.*?</Description>#si',
        '<Description>[removed]</Description>',
        $xml
    );
    $xml = preg_replace(
        '#<TermsAndConditions[^>]*>.*?</TermsAndConditions>#si',
        '<TermsAndConditions>[removed]</TermsAndConditions>',
        $xml
    );
    


    $signature = hash_hmac('sha256', $xml, $_ENV['YES2YES_SECRET']);
    try{
        $client = new \GuzzleHttp\Client();
    }catch(Exception $e){
        if(!$testmode){
            copy($file, $file.'-INVALID');
            unlink($file);
        }
        throw new Exception("Guzzle Init Request failed (-INVALID file extension added) ".substr($e->getMessage(),0,120));
        return false;
    }
    try{
        $response = $client->request('POST',$url['url'].'emp.php',[
            'headers'=>[
                'X-YES-AUTH'=>$signature,
                'Content-Type'=>'application/xml'
            ],
            'body'=>$xml
        ]);
        $code = $response->getStatusCode(); // 200
        $reason = $response->getReasonPhrase();
        if($code !== 200){
            if(!$testmode){
                unlink($file);
            }
            empLog(sprintf("%s responsed with Status %d (%s)\n%s",
                $url['url'],$code, $reason, print_r($response,true)
            ), $file);
            return false;
        }
        empLog(sprintf("POST XML Success. Sent to %s",$url['url']),$file);

        if(!$testmode){
            unlink($file);
        }
        //echo $response->getBody();
        return true;
    }catch(Exception $e){
        if(!$testmode){
            copy($file, $file.'-INVALID');
            unlink($file);
        }
        throw new Exception("POST XML failed (-INVALID file extension added) ".substr($e->getMessage(),0,120));
        return false;
    }
}

$dir = main::get_secure_path().'eBayMessages';
$files = [];
$iterator = new FilesystemIterator($dir, FilesystemIterator::SKIP_DOTS);
foreach ($iterator as $fileinfo) {
    if ($fileinfo->isFile() and substr($fileinfo->getFilename(),-3) == 'xml') {
        $files[] = [
            'name' => $fileinfo->getFilename(),
            'path' => $fileinfo->getPathname(),
            'mtime' => $fileinfo->getMTime(),  // oder getCTime()
        ];
    }
}

// Sortieren nach Änderungsdatum (neueste zuerst)
usort($files, fn($a, $b) => $b['mtime'] <=> $a['mtime']);
$files = array_reverse($files);
$files_processed = 0;
foreach($files as $file){
    $files_processed++;
    if(!processFile($file['path'])){
    }
}
printf("\n\n%s - %d Files processed\n",basename(__FILE__),$files_processed);
