"use strict";

$(function () {
  sticky.init();
  mobNav.init();
  slideMenu.init();
  openDisclaimer.init();
  imageSwap.init();
  $('#share-via-email').on('click', function (e) {
    e.preventDefault(); // Verhindert, dass der Link standardmäßig funktioniert
    // Aktuelle URL der Seite

    var currentUrl = window.location.href; // Betreff und Body der E-Mail

    var emailSubject = "Ein tolles Produkt bei just neo!";
    var emailBody = "Schau dir dieses Produkt an: " + currentUrl; // Mailto-Link erstellen

    var mailtoLink = "mailto:?subject=" + encodeURIComponent(emailSubject) + "&body=" + encodeURIComponent(emailBody); // Mailto-Link ausführen, um das E-Mail-Programm zu öffnen

    window.location.href = mailtoLink;
  }); //SLICK

  $('.responsive').slick({
    dots: true,
    infinite: false,
    speed: 300,
    slidesToShow: 4,
    slidesToScroll: 4,
    responsive: [{
      breakpoint: 1024,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 3,
        infinite: true,
        arrows: true,
        dots: true
      }
    }, {
      breakpoint: 600,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 2
      }
    }, {
      breakpoint: 480,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1
      }
    }]
  });
  $('.single-item').slick({
    dots: true,
    autoplay: true,
    autoplaySpeed: 4000,
    fade: true
  });
  $('.center').slick({
    centerMode: true,
    centerPadding: '0px',
    slidesToShow: 4,
    autoplay: true,
    autoplaySpeed: 3000,
    responsive: [{
      breakpoint: 1024,
      settings: {
        arrows: false,
        centerMode: true,
        centerPadding: '40px',
        slidesToShow: 3
      }
    }, {
      breakpoint: 768,
      settings: {
        arrows: false,
        centerMode: true,
        centerPadding: '40px',
        slidesToShow: 1
      }
    }]
  });
});
var sticky = {
  init: function init() {
    if ($(window).scrollTop() > 50) {
      sticky.is_true();
    } else {
      sticky.is_false();
    }

    $(window).scroll(function () {
      if ($(window).scrollTop() > 50) {
        sticky.is_true();
      } else {
        sticky.is_false();
      }
    });
  },
  is_true: function is_true() {
    $('.head-search').css({
      'top': '0'
    });
  },
  is_false: function is_false() {
    $('.head-search').css({
      'top': '50px'
    });
  }
};
var mobNav = {
  init: function init() {
    var $trigger = $('#mob-nav-switch');
    var $target = $('.func-mobile-nav'); // Hamburger Menu    

    $trigger.on('click', function () {
      if (!$trigger.hasClass('open')) {
        $trigger.addClass('open');
        $trigger.find('i').removeClass('fa-bars');
        $trigger.find('i').addClass('fa-xmark');
        $target.stop(true, true).slideDown();
      } else {
        $trigger.removeClass('open');
        $trigger.find('i').addClass('fa-bars');
        $trigger.find('i').removeClass('fa-xmark');
        $target.stop(true, true).slideUp();
      }
    });
    $.each($target.children('li'), function (e) {
      var $t = $(this);

      if ($t.children('ul').length > 0) {
        $t.addClass('has-children');
        $t.on('click', function (e) {
          e.preventDefault();

          if (!$t.hasClass('has-children-open')) {
            $t.children('ul').slideDown();
            $t.addClass('has-children-open');
          } else {
            $t.children('ul').slideUp();
            $t.removeClass('has-children-open');
          }
        });
      }
    });
  }
};
var slideMenu = {
  init: function init() {
    $('.main-nav > li > a').on('click', function (e) {
      var $submenu = $(this).siblings('ul');
      e.preventDefault();

      if ($submenu.length) {
        $submenu.slideToggle(); // Animiert das Ein- und Ausklappen
      }
    });
    $('.main-nav li > a').not('.main-nav > li > a').on('click', function () {
      $(this).siblings('ul').slideUp();
    });
  }
};
var openDisclaimer = {
  init: function init() {
    var $tgt = $('.etc');
    $('.btn-show-etc').on('click', function (e) {
      e.preventDefault();

      if (!$tgt.hasClass('open')) {
        $tgt.addClass('open');
        $(this).find('i').removeClass('fa-chevron-down');
        $(this).find('i').addClass('fa-chevron-up');
      } else {
        $tgt.removeClass('open');
        $(this).find('i').removeClass('fa-chevron-up');
        $(this).find('i').addClass('fa-chevron-down');
      }
    });
  }
};
var imageSwap = {
  init: function init() {
    $('.small-image').hover(function () {
      var newSrc = $(this).attr('data-src');
      $('#main-image').attr('src', newSrc);
      $('#main-image').parent('a').attr('href', newSrc);
    });
  }
};