let openFatty = {
    init: function () {
        let timeout;

        // Öffnen des Mega Menüs, wenn über das Dropdown gefahren wird
        $('.dropdown').on('mouseenter', function () {
            clearTimeout(timeout); // Timeout zurücksetzen, falls es vorher gesetzt wurde
            $('.fatty').stop(true, true).fadeIn(300);
        });

        // Schließen des Mega Menüs, wenn die Maus den gesamten Bereich verlässt
        $('.dropdown, .fatty').on('mouseleave', function (e) {
            // Überprüfen, ob die Maus den Bereich verlassen hat (auf keinen Fall innerhalb von .dropdown oder .fatty)
            if (!$(e.relatedTarget).closest('.dropdown, .fatty').length) {
                // Timeout für den Versatz von 500ms einfügen
                timeout = setTimeout(function () {
                    $('.fatty').stop(true, true).fadeOut(200);
                }, 500);
            }
        });

        // Verhindern, dass das Menü beim Verlassen der Fatty-Box sofort verschwindet
        $('.fatty').on('mouseenter', function () {
            clearTimeout(timeout); // Timeout zurücksetzen, wenn die Maus ins Menü geht
        });
    }
};
let scrollMenu = {
    init:function(){
        $(window).scroll(function(){
            var scrollPos = $(document).scrollTop();
            if (scrollPos> 80){
                $('.main-menu').addClass('fixed');   
                $('.fatty').addClass('fixed');  
                $('#contHolder').addClass('fixedFix');           
            }else{
                $('.main-menu').removeClass('fixed');                
                $('.fatty').removeClass('fixed');    
                $('#contHolder').removeClass('fixedFix');                       
            }
        });
    }
}
// Objekt für den Slider
const sliderMain = {
    // Standard-Einstellungen
    baseSetup: {
        sliderHeight: "500px",
        sliderInterval: 8000,
        kenBurnsDuration: "16s",
        backgroundSize: "cover",
        slideTransitionDuration: 1000 // Dauer des Slide-Wechsels in ms
    },

    // Initialisierung
    init: function (opt) {
        // Merge Benutzeroptionen mit Standard-Einstellungen
        this.settings = $.extend({}, this.baseSetup, opt);

        // Setze CSS-Variablen
        document.documentElement.style.setProperty('--slider-height', this.settings.sliderHeight);
        document.documentElement.style.setProperty('--ken-burns-duration', this.settings.kenBurnsDuration);

        // Elemente auswählen
        this.slides = $('.main-slider .slide');
        this.thumbs = $('.main-slider-navigation .slider-thumb');
        this.currentSlide = 0;
        this.interval = null;

        // Initialisiere den ersten Slide
        this.showSlide(this.currentSlide);

        // Starte den automatischen Slide-Wechsel
        this.resetTimer();

        // Event-Listener für die Navigation
        this.thumbs.on('click', (e) => {
            const index = $(e.currentTarget).data('index');
            this.showSlide(index);
        });
    },

    // Zeige einen bestimmten Slide
    showSlide: function (index) {
        const nextSlide = $(this.slides[index]);
        const nextBg = nextSlide.find('.slide-background');
    
        // Hintergrund-Eigenschaften auslesen
        const nextBgImage = nextBg.css('background-image');
        const nextBgPosition = nextBg.css('background-position');
        const nextBgSize = nextBg.css('background-size');
    
        // Setze den Hintergrund von .main-slider passend zum neuen Slide
        $('.main-slider').css({
            'background-image': nextBgImage,
            'background-position': nextBgPosition,
            'background-size': nextBgSize
        });
    
        // Verstecke den aktuellen Slide
        $(this.slides[this.currentSlide]).removeClass('active');
        $(this.thumbs[this.currentSlide]).removeClass('active');
    
        setTimeout(() => {
            // Zeige den neuen Slide
            nextSlide.addClass('active');
            nextBg.addClass('ken-burns'); // Ken-Burns aktivieren
            $(this.thumbs[index]).addClass('active');
    
            this.currentSlide = index;
    
            // Timer zurücksetzen
            this.resetTimer();
        }, this.settings.slideTransitionDuration);
    },

    // Timer zurücksetzen
    resetTimer: function () {
        clearInterval(this.interval);
        this.interval = setInterval(() => {
            const nextSlide = (this.currentSlide + 1) % this.slides.length;
            this.showSlide(nextSlide);
        }, this.settings.sliderInterval);
    }
};

//Dyn Modal  Funktion

var dynModal = {
    init:function(){
        $('.modal-call').each(function(){
            let $t = $(this);
            $t.on('click',function(e){
                e.preventDefault();

                let $tgt = $('#modal-cnt');
                let $t = $(this);
                let cnt = $t.attr('data-modalcnt');
                let size = $t.attr('data-modalsize');
                let title = $t.attr('data-modaltitle');
                $tgt.find('.modal-dialog').removeClass('modal-lg').addClass('modal-'+size);
                $tgt.find('.modal-title').html(title);
                $tgt.find('.modal-body').html(cnt);
                $tgt.modal('show');
            })       
        })
    }
}

  let mobNav = {
    init:function(){
    let $trigger = $('#mob-nav-switch');    
    let $target = $('.func-mobile-nav');
    // Hamburger Menu    
    $trigger.on('click',function(){
        if(!$trigger.hasClass('open')){
            $trigger.addClass('open')
            $trigger.find('i').removeClass('fa-bars');
            $trigger.find('i').addClass('fa-xmark');
            $target.stop(true,true).slideDown();
        }else{
            $trigger.removeClass('open')
            $trigger.find('i').addClass('fa-bars');
            $trigger.find('i').removeClass('fa-xmark');
            $target.stop(true,true).slideUp();
        }
    })
}
};


var priceModal = {
    init:function(){
        $('.view_price_not_allowed').on('click', function(e) {
            e.preventDefault(); // verhindert, dass der <a>-Link ausgelöst wird
            e.stopPropagation(); // verhindert, dass das Event zum <a> weiterreicht
        
            // Modal anzeigen (für Bootstrap-Modal):
            $('#modal-price-info').modal('show');
        
            // Falls du kein Bootstrap verwendest, kannst du alternativ so etwas machen:
            // $('#modal-price-info').fadeIn();
        });
    }
}

// Initialisierung der Funktionen
$(function(){
    openFatty.init();
    scrollMenu.init();
    priceModal.init();
    mobNav.init();
    dynModal.init();
    sliderMain.init({
        sliderHeight: "600px",
        sliderInterval: 10000,
        kenBurnsDuration: "16s",
        backgroundSize: "cover"
    });
    $('.responsive').slick({
        dots: true,
        infinite: false,
        speed: 300,
        slidesToShow: 4,
        slidesToScroll: 4,
        arrows:false,
        responsive: [
          {
            breakpoint: 1024,
            settings: {
              slidesToShow: 3,
              slidesToScroll: 3,
              infinite: true,
              arrows:false,
              dots: true
            }
          },
          {
            breakpoint: 600,
            settings: {
              slidesToShow: 2,
              slidesToScroll: 2
            }
          },
          {
            breakpoint: 480,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1
            }
          }
        ]
      });
})

