<?php
/**

GEPRUEFT+OPTIMIERT - Keine Sicherheitsluecken

**/
$main = new \main();
global $xtPrice, $current_category_id;
require_once(DIR_FS_INC.'yes_get_subcategories.inc.php');
$box_smarty = new yesSmarty;
$box_content = '';

$box_smarty->assign('language', $_SESSION['language']);
// set cache ID
$current_category_id = xtc_db_input($current_category_id);

$languages_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
$box_smarty->assign('tpl_path', 'templates/'.CURRENT_TEMPLATE.'/');
// include needed functions
require_once (DIR_FS_INC.'xtc_row_number_format.inc.php');
//fsk18 lock
$fsk_lock = '';
if ($_SESSION['customers_status']['customers_fsk18_display'] == '0') {
        $fsk_lock = ' and p.products_fsk18!=1';
}
$parameters = [
    'language_id'=>$languages_id
];
if ($current_category_id > 0) {
    $in_categories = yes_get_subcategories($current_category_id,true);
    $in_categories[] = $current_category_id;
    $parameters['in_categories'] = implode(',',$in_categories);
    $best_sellers_query_raw = "select distinct
        p.products_id,
        p.products_price,
        p.products_tax_class_id,
        p.products_image,
        pd.products_name from ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_DESCRIPTION." pd, ".TABLE_PRODUCTS_TO_CATEGORIES." p2c, ".TABLE_CATEGORIES." c
        where p.products_status = '1'
        and c.categories_status = '1'
        and p.products_ordered > 0
        and p.products_id = pd.products_id
        and pd.language_id =:language_id
        and p.products_id = p2c.products_id
        ".$fsk_lock."
        and p2c.categories_id = c.categories_id and c.categories_id IN(:in_categories) 
        order by p.products_ordered desc limit ".MAX_DISPLAY_BESTSELLERS;

} else {
    $best_sellers_query_raw = "select distinct
        p.products_id,
        p.products_image,
        p.products_price,
        p.products_tax_class_id,
        pd.products_name from ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_DESCRIPTION." pd
        where p.products_status = '1'
        and p.products_ordered > 0
        and p.products_id = pd.products_id ".$fsk_lock."
        and pd.language_id =:language_id
        order by p.products_ordered desc limit ".MAX_DISPLAY_BESTSELLERS;
}
$key = 'BOX-'.basename(__FILE__).'-fsk'.$_SESSION['customers_status']['customers_fsk18_display'].'-'.md5(serialize($parameters));
$CachedString = $InstanceCache->getItem($key);
if (!$CachedString->isHit()) {
    $best_sellers_query = yes_query($best_sellers_query_raw, 
        $parameters
    );
    $CachedString->set($best_sellers_query)->expiresAfter(YES_CACHE_LIFETIME_LONG)->addTag('shop');//box-*
    $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
    $best_sellers_query = $CachedString->get();
}
if (is_countable($best_sellers_query) and sizeOf($best_sellers_query) >= MIN_DISPLAY_BESTSELLERS) {
    $rows = 0;
    $box_content = array ();
    foreach($best_sellers_query as $best_sellers) {
        $rows ++;
        $image = '';
        if ($best_sellers['products_image']){
            $image = DIR_WS_INFO_IMAGES.$best_sellers['products_image'];
        }
        $tax_info = $main->getTaxInfo(xtc_get_tax_rate($best_sellers['products_tax_class_id']));
        $product = new product($best_sellers['products_id']);
        $box_content[] = array ('ID' => xtc_row_number_format($rows), 
            'NAME' => $best_sellers['products_name'], 
            'IMAGE' => $image, 
            'PRICE' => $xtPrice->xtcGetPrice($best_sellers['products_id'], $format = true, 1, $best_sellers['products_tax_class_id'], $best_sellers['products_price']), 
            'PRODUCTS_TAX_INFO'=>$tax_info,
            'SHIPPING_LINK'=>$main->getShippingLink($best_sellers['products_id']),
            'LINK' => xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id='.$best_sellers['products_id']),
            'DATA'=>$product->buildDataArray($product->data)
        );

    }
    $box_smarty->assign('box_content', $box_content);
}
$box_best_sellers = $box_smarty->fetch(CURRENT_TEMPLATE.'/boxes/box_best_sellers.html');
$smarty->assign('box_BESTSELLERS', $box_best_sellers);

